/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.uclapl;

import edu.ucla.uclapl.Alphabet;
import java.util.Arrays;

public class UpdatableIntTrie {
    static int numberOfSegments = Alphabet.size;
    int maxGramSize = 0;
    int[] unigram = null;
    int[][] bigram = null;
    int[][][] trigram = null;
    int[][][][] tetragram = null;
    public boolean[][] bigramNonzero = null;

    UpdatableIntTrie(int m) {
        this.maxGramSize = m;
        if (this.maxGramSize >= 1) {
            this.unigram = new int[numberOfSegments];
        }
        if (this.maxGramSize >= 2) {
            this.bigram = new int[numberOfSegments][numberOfSegments];
            this.bigramNonzero = new boolean[numberOfSegments][numberOfSegments];
        }
        if (this.maxGramSize >= 3) {
            this.trigram = new int[numberOfSegments][numberOfSegments][numberOfSegments];
        }
        if (this.maxGramSize >= 4) {
            this.tetragram = new int[numberOfSegments][numberOfSegments][numberOfSegments][numberOfSegments];
        }
    }

    public void incrementTimestamp() {
    }

    public void incrementSubsequences(int[] config, int start, int end) {
        this.incrementSubsequences(config, start, end, 1);
    }

    public void incrementSubsequences(int[] config, int start, int end, int count) {
        int i;
        int configLength = config.length;
        if (start < 0 || start > end || end > configLength) {
            System.out.println("Incorrect bounds for incrementSubsequences()");
            System.exit(1);
        }
        if (this.maxGramSize >= 1) {
            for (i = 0; i < end; ++i) {
                int n = config[i];
                this.unigram[n] = this.unigram[n] + count;
            }
        }
        if (this.maxGramSize >= 2) {
            for (i = 0; i < end - 1; ++i) {
                int[] nArray = this.bigram[config[i]];
                int n = config[i + 1];
                nArray[n] = nArray[n] + count;
                this.bigramNonzero[config[i]][config[i + 1]] = true;
            }
        }
        if (this.maxGramSize >= 3) {
            for (i = 0; i < end - 2; ++i) {
                int[] nArray = this.trigram[config[i]][config[i + 1]];
                int n = config[i + 2];
                nArray[n] = nArray[n] + count;
            }
        }
        if (this.maxGramSize >= 4) {
            for (i = 0; i < end - 3; ++i) {
                int[] nArray = this.tetragram[config[i]][config[i + 1]][config[i + 2]];
                int n = config[i + 3];
                nArray[n] = nArray[n] + count;
            }
        }
    }

    public void incrementSequence(int[] config, int start, int end) {
        System.out.println("Error: not yet implemented");
        System.exit(1);
    }

    public int count(int[] config, int start, int end) {
        int configLength = config.length;
        if (start < 0 || start > end || end > configLength || end - start > this.maxGramSize) {
            System.out.println("Incorrect bounds for count(): start=" + start + ", end=" + end);
            System.exit(1);
        }
        if (end - start == 1) {
            return this.unigram[config[0]];
        }
        if (end - start == 2) {
            return this.bigram[config[0]][config[1]];
        }
        if (end - start == 3) {
            return this.trigram[config[0]][config[1]][config[2]];
        }
        if (end - start == 4) {
            return this.tetragram[config[0]][config[1]][config[2]][config[3]];
        }
        return 0;
    }

    public int count(int[] config, int start, int end, boolean[] terminals) {
        int configLength = config.length;
        if (start < 0 || start > end || end > configLength || end - start > this.maxGramSize) {
            System.out.println("Incorrect bounds for count(): start=" + start + ", end=" + end);
            System.exit(1);
        }
        int[] after = null;
        int count = 0;
        if (end - start == 0) {
            return count;
        }
        if (end - start == 1) {
            after = this.bigram[config[0]];
        } else if (end - start == 2) {
            after = this.trigram[config[0]][config[1]];
        } else if (end - start == 3) {
            after = this.tetragram[config[0]][config[1]][config[2]];
        }
        for (int i = 0; i < numberOfSegments; ++i) {
            if (!terminals[i]) continue;
            count += after[i];
        }
        return count;
    }

    public int count3(boolean[] segments1, boolean[] segments2, boolean[] segments3) {
        int count = 0;
        for (int i = numberOfSegments - 1; i >= 0; --i) {
            if (!segments1[i]) continue;
            for (int j = numberOfSegments - 1; j >= 0; --j) {
                if (!segments2[j] || !this.bigramNonzero[i][j]) continue;
                for (int k = numberOfSegments - 1; k >= 0; --k) {
                    if (!segments3[k] || !this.bigramNonzero[j][k]) continue;
                    count += this.trigram[i][j][k];
                }
            }
        }
        return count;
    }

    public int count4(boolean[] segments1, boolean[] segments2, boolean[] segments3, boolean[] segments4) {
        int count = 0;
        for (int i = numberOfSegments - 1; i >= 0; --i) {
            if (!segments1[i]) continue;
            for (int j = numberOfSegments - 1; j >= 0; --j) {
                if (!segments2[j] || !this.bigramNonzero[i][j]) continue;
                for (int k = numberOfSegments - 1; k >= 0; --k) {
                    if (!segments3[k] || !this.bigramNonzero[j][k]) continue;
                    for (int l = numberOfSegments - 1; l >= 0; --l) {
                        if (!segments4[l] || !this.bigramNonzero[k][l]) continue;
                        count += this.tetragram[i][j][k][l];
                    }
                }
            }
        }
        return count;
    }

    public void prune() {
        int j;
        int i;
        if (this.maxGramSize >= 1) {
            Arrays.fill(this.unigram, 0);
        }
        if (this.maxGramSize >= 2) {
            for (i = 0; i < numberOfSegments; ++i) {
                Arrays.fill(this.bigram[i], 0);
                Arrays.fill(this.bigramNonzero[i], false);
            }
        }
        if (this.maxGramSize >= 3) {
            for (i = 0; i < numberOfSegments; ++i) {
                for (j = 0; j < numberOfSegments; ++j) {
                    Arrays.fill(this.trigram[i][j], 0);
                }
            }
        }
        if (this.maxGramSize >= 4) {
            for (i = 0; i < numberOfSegments; ++i) {
                for (j = 0; j < numberOfSegments; ++j) {
                    for (int k = 0; k < numberOfSegments; ++k) {
                        Arrays.fill(this.tetragram[i][j][k], 0);
                    }
                }
            }
        }
    }

    public String toString() {
        int i;
        if (this.maxGramSize >= 1) {
            System.out.println("unigrams:");
            System.out.println(cern.colt.Arrays.toString((int[])this.unigram));
        }
        if (this.maxGramSize >= 2) {
            System.out.println("bigrams:");
            for (i = 0; i < numberOfSegments; ++i) {
                System.out.println(i + " : " + cern.colt.Arrays.toString((int[])this.bigram[i]));
            }
        }
        if (this.maxGramSize >= 3) {
            System.out.println("trigrams:");
            for (i = 0; i < numberOfSegments; ++i) {
                for (int j = 0; j < numberOfSegments; ++j) {
                    System.out.println("(" + i + "," + j + ") : " + cern.colt.Arrays.toString((int[])this.trigram[i][j]));
                }
            }
        }
        System.out.println("Error: not yet implemented");
        return null;
    }

    public static void main(String[] args) throws Exception {
        numberOfSegments = 6;
        UpdatableIntTrie gramCount = new UpdatableIntTrie(3);
        gramCount.incrementTimestamp();
        int[] word1 = new int[]{0, 1, 2, 3, 4, 5, 0};
        int[] word2 = new int[]{0, 5, 4, 3, 2, 1, 0};
        gramCount.incrementSubsequences(word1, 0, word1.length);
        gramCount.incrementSubsequences(word1, 0, word1.length);
        gramCount.incrementSubsequences(word2, 0, word2.length);
        gramCount.toString();
        int[] prob1 = new int[]{2, 3, 4};
        int[] prob2 = new int[]{3, 2, 4};
        System.out.println("count of prob1: " + gramCount.count(prob1, 0, prob1.length));
        System.out.println("count of prob2: " + gramCount.count(prob2, 0, prob2.length));
    }
}

