/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.uclapl;

import cern.colt.Arrays;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import cern.colt.map.OpenIntObjectHashMap;
import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.jet.random.engine.MersenneTwister;
import com.infomata.data.CSVFormat;
import com.infomata.data.DataFile;
import com.infomata.data.DataFormat;
import com.infomata.data.DataRow;
import com.infomata.data.TabFormat;
import edu.ucla.uclapl.Alphabet;
import edu.ucla.uclapl.ArrayPrinter;
import edu.ucla.uclapl.BreadthFirstSelection5;
import edu.ucla.uclapl.CommandLineOptions;
import edu.ucla.uclapl.ConfigurationComparator;
import edu.ucla.uclapl.Corpus;
import edu.ucla.uclapl.ImprovedIterativeScaling;
import edu.ucla.uclapl.MapNaturalClassesToSegments;
import edu.ucla.uclapl.Projection;
import edu.ucla.uclapl.RandomField;
import edu.ucla.uclapl.RandomFieldFeature;
import edu.ucla.uclapl.RandomSelection;
import edu.ucla.uclapl.Segment;
import edu.ucla.uclapl.StringKernel;
import edu.ucla.uclapl.TierFeature;
import jas.hist.DataSource;
import jas.hist.HistogramUpdate;
import jas.hist.JASHist;
import jas.hist.Rebinnable1DHistogramData;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Observable;
import java.util.TreeSet;
import javax.swing.JFrame;
import pal.math.ConjugateGradientSearch;
import pal.math.MultivariateFunction;

public class UCLAPhonotacticLearner
extends JFrame {
    private static String DIRECTORY = "";
    private static String TIERS = null;
    private static String PHONEMES = null;
    private static String NATURAL_CLASSES = null;
    private static String CORPUS = null;
    private static String CONSTRAINT_LIST = null;
    private static String CONSTRAINT_ORDER = null;
    private static String CONSTRAINTS_AND_WEIGHTS = null;
    private static String CONSTRAINTS = null;
    private static String WEIGHTS = null;
    private static String TEST_WORDS = null;
    private static String OUTPUTDIR = null;
    public static int MAXIMUM_FIELD_SIZE = 0;
    public static double OE_THRESHOLD = 1.0;
    public static int[] MAXIMUM_GRAM_SIZE = null;
    public static int TARGET_SAMPLE_SIZE = 4000;
    public static String SAMPLE_TYPE = "sequential";
    public static boolean PRINT_SAMPLES = false;
    public static int SAMPLE_DIAMETER = 1;
    public static int MAXIMUM_PATH_LENGTH = 8;
    public static String WEIGHTING_ALGORITHM = "ImprovedIterativeScaling";
    public static int WEIGHTING_ITERATION = 10000;
    public static boolean TRAIN_WITH_SAMPLING = false;
    public static boolean SELECT_WITH_SAMPLING = true;
    public static boolean BUILD_EXPECTATION_GRAPH = true;
    public static boolean TRACK_CORPUS_PROB = false;
    public static DoubleArrayList corpusNegLogProb = null;
    public static DoubleArrayList objectiveCost = null;
    public static boolean PROB_MAX = false;
    public static boolean POISSON_LENGTH_SMOOTHING = true;
    public static String REGULARIZER = "gaussian";
    public static double SIGMA2 = 1.0;
    public static double ALPHA = 1.0;
    public static double SMOOTH = 0.5;
    public static int METROPOLIS_ITERATION = 100;
    public static double[] ACCURACY_SCHEDULE = new double[]{0.01, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
    public static double TOLX = Double.MIN_VALUE;
    public static RandomField RF = null;
    public static Alphabet sigma = null;
    public static String[] tiers = null;
    public static boolean COMPLEMENT_NATURAL_CLASSES = false;
    public static LinkedList naturalClasses = null;
    public static IntArrayList minimalNaturalClasses = null;
    public static int[][] naturalClassSizes = null;
    public static int[][] naturalClassesByProjection = null;
    public static int[] trigramNaturalClasses = null;
    public static boolean[] trigramNaturalClassesBool = null;
    public static boolean[] complementNaturalClassesBool = null;
    public static Projection[] projections = null;
    public static boolean DEFAULT_PROJECTION = true;
    public static OpenIntObjectHashMap classesToSegments = null;
    public static OpenIntObjectHashMap classesToBooleanVectors = null;
    public static int[][] classesToSegmentIndexations = null;
    public static IntArrayList[] segmentsToClasses = null;
    public static Corpus corpus = null;
    public static Corpus sample = null;
    public static Corpus testWords = null;
    public static boolean[] bannedUnigrams = null;
    public static boolean[][] bannedBigrams = null;
    public static boolean[][][] bannedTrigrams = null;
    public static double[][] segmentSimilarityMatrix = null;
    public static RandomFieldFeature[] constraintList = null;
    public static DoubleMatrix1D constraintOrder = null;
    public static int MAXIMUM_NUMBER_OF_VIOLATIONS = 50;
    public static int MAXIMUM_WORD_LENGTH = 50;
    private static CommandLineOptions opt = null;
    public static ConfigurationComparator cc = null;
    public static boolean LOWER_CONFIDENCE_LIMIT = true;
    public static double LCL_ALPHA = 0.975;
    public static boolean GUI = false;
    public static ChangingDataSource sampleProbStarData;
    public static ChangingDataSource sampleProbStarShortData;
    public static ChangingDataSource acceptanceData;
    public static JASHist sampleProbStarPlot;
    public static JASHist sampleProbStarShortPlot;
    public static JASHist acceptancePlot;
    public static MersenneTwister mt;

    public UCLAPhonotacticLearner() {
        super("UCLA Phonotactic Learner");
        sampleProbStarData = new ChangingDataSource("sample prob star", new String[]{"prob star", "number of samples"});
        sampleProbStarShortData = new ChangingDataSource("sample prob star one sample", new String[]{"prob star", "number of samples"});
        acceptanceData = new ChangingDataSource("acceptance rate", new String[]{"rate", null});
        sampleProbStarPlot = new JASHist();
        sampleProbStarShortPlot = new JASHist();
        acceptancePlot = new JASHist();
        sampleProbStarPlot.addData((DataSource)sampleProbStarData).show(true);
        sampleProbStarShortPlot.addData((DataSource)sampleProbStarShortData).show(true);
        acceptancePlot.addData((DataSource)acceptanceData).show(true);
        this.getContentPane().setLayout(new FlowLayout());
        this.getContentPane().add((Component)sampleProbStarPlot);
        this.getContentPane().add((Component)sampleProbStarShortPlot);
        this.getContentPane().add((Component)acceptancePlot);
        this.setSize(750, 500);
        this.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int i;
        int i2;
        cc = new ConfigurationComparator();
        opt = new CommandLineOptions(args);
        opt.addOption("dir", true, "directory containing tier, phoneme, natural class, etc. files");
        opt.addOption("tiers", true, "file containing feature tiers");
        opt.addOption("phonemes", true, "file containing phonemes with features");
        opt.addOption("naturalClasses", true, "file containing pre-compiled natural classes");
        opt.addOption("complementClasses", false, "if set, build the complement natural class [^C] for every class [C]");
        opt.addOption("trigramNaturalClasses", true, "file containing list of trigram natural classes");
        opt.addOption("projections", true, "file containing list of projections (= autosegmental `tiers'");
        opt.addOption("prespecifiedConstraints", false, "if set, looks for prespecified constraints in file P.con for every projection P");
        opt.addOption("corpus", true, "training corpus");
        opt.addOption("constraintList", true, "file containing a list of constraint from which selection should draw");
        opt.addOption("constraintOrder", true, "file containing a number (one per constraint in constraintList) that determines\norder of evaluation during selection; lower-valued constraints are evaluated first");
        opt.addOption("constraintsAndWeights", true, "file containing list of preselectec constraints with their weights");
        opt.addOption("constraints", true, "file containing list of preselected constraints");
        opt.addOption("weights", true, "file containing list of preoptimized weights");
        opt.addOption("printConstraints", false, "print constraints, weights, and segments in classes banned by the constraints");
        opt.addOption("select", false, "select constraints to add to the random field");
        opt.addOption("selectAtRandom", false, "select constraints at random to add to the field");
        opt.addOption("train", false, "train the weights of a random field on a corpus");
        opt.addOption("test", true, "compute the predicted probability of each item in a test list");
        opt.addOption("stringKernel", false, "compute summed similarity of test words to corpus words with the string kernel");
        opt.addOption("sample", false, "generate a random sample from the current field");
        opt.addOption("printObservedExpected", false, "print O and E values after training has terminated");
        opt.addOption("maximumGramSize", true, "maximum size (number of feature matrices) in constraints (default=3); file containing one value per projection");
        opt.addOption("maximumFieldSize", true, "maximum number of features that can be induced by feature selection");
        opt.addOption("oeThreshold", true, "upper bound on O/E values of selected constraints (default=1.0)");
        opt.addOption("sampleSize", true, "specify the target sample size for random sampling");
        opt.addOption("sampleType", true, "specify the type of samples to be created (sequential (default) | graphical)");
        opt.addOption("sampleDiameter", true, "number of segment substitutions that defines the `neighborhood' of a sample");
        opt.addOption("sampleFile", true, "specify a file containing all of the samples to be used; only for small simulations");
        opt.addOption("printSamples", false, "if set, print samples created during feature discovery");
        opt.addOption("weighting", true, "algorithm that assigns weights during feature discovery: ConjugateGradient | ImprovedIterativeScaling (the default) | ObservedOverExpectedAtDiscovery");
        opt.addOption("weightWithSampling", false, "if set, training is done by sampling; otherwise, training is done with an expectation graph");
        opt.addOption("noGraph", false, "if set, no expectation graph is constructed");
        opt.addOption("maximumPathLength", true, "maximum length of a path explored in the expectation graph (default = 10)");
        opt.addOption("weightingIteration", true, "maximum number of times that an (iterative) weighting method is applied during an instance of weight training (default=100)");
        opt.addOption("metropolisIteration", true, "number of metropolis-sampler iterations before reset (new random seed; default is 100)");
        opt.addOption("regularizer", true, "form of the regularizer: gaussian (default) | exponential)");
        opt.addOption("sigma2", true, "sigma^2 for Gaussian regularizer (default is 1.0)");
        opt.addOption("alpha", true, "alpha parameter for exponential regularizer (default is 1.0)");
        opt.addOption("smooth", true, "value added to the numerator in calculation of O/E (default is .5)");
        opt.addOption("mikheev", true, "use lower confidence limit stats to adjust O/E (default alpha level is .975)");
        opt.addOption("accuracySchedule", true, "accuracy schedule (list of criterion O/E values) for feature selection");
        opt.addOption("storeCorpus", false, "keep the corpus in memory");
        opt.addOption("trackCorpusProb", false, "calculate the probability of the training data after each constraint is selected");
        opt.addOption("probMax", false, "final grammar contains only the constraints (in order of selection) that maximizes the probability of the corpus");
        opt.addOption("printGraph", false, "print the expectation graph to the screen after learning or training");
        opt.addOption("gui", false, "display histograms in a window");
        opt.addOption("tolx", true, "tolerance for each parameter in conjugate gradient search");
        opt.addOption("noDefaultProjection", false, "if set, no default (segmental) projection is created");
        opt.addOption("help", false, "help information");
        opt.addOption("outputdir", true, "full path of directory which to write output files");
        OUTPUTDIR = opt.isSet("outputdir") ? opt.getOption("outputdir") : null;
        if (opt.isSet("help")) {
            System.out.println("Usage: java UCLAPhonotacticLearner [options]");
            System.out.println();
            System.out.println("Options");
            System.out.println(opt);
            System.exit(0);
        }
        if (opt.isSet("gui")) {
            GUI = true;
            new UCLAPhonotacticLearner();
        }
        if (opt.isSet("trackCorpusProb")) {
            corpusNegLogProb = new DoubleArrayList();
            objectiveCost = new DoubleArrayList();
            TRACK_CORPUS_PROB = true;
        }
        if (opt.isSet("probMax")) {
            if (!opt.isSet("storeCorpus") || !opt.isSet("trackCorpusProb")) {
                System.out.println("Error: cannot use -probMax without -storeCorpus and -trackCorpusProb");
                System.exit(1);
            }
            PROB_MAX = true;
        }
        DIRECTORY = opt.isSet("dir") ? opt.getOption("dir") + File.separator : "";
        if (opt.isSet("tiers")) {
            System.out.println("\nReading the feature tiers ...");
            TIERS = opt.getOption("tiers");
            tiers = UCLAPhonotacticLearner.readTiers(DIRECTORY + TIERS);
            System.out.println("done");
        }
        if (opt.isSet("phonemes")) {
            System.out.println("\nReading the phonemes ...");
            PHONEMES = opt.getOption("phonemes");
            sigma = UCLAPhonotacticLearner.readSigma(DIRECTORY + PHONEMES);
            System.out.println("done");
        }
        COMPLEMENT_NATURAL_CLASSES = opt.isSet("complementClasses");
        if (opt.isSet("naturalClasses")) {
            System.out.println("\nReading the natural classes ...");
            NATURAL_CLASSES = opt.getOption("naturalClasses");
            naturalClasses = UCLAPhonotacticLearner.readNaturalClasses(DIRECTORY + NATURAL_CLASSES);
            System.out.println("\nMapping natural classes to the segments they contain ...");
            classesToSegments = new OpenIntObjectHashMap();
            classesToBooleanVectors = new OpenIntObjectHashMap();
            MapNaturalClassesToSegments.makeMap(naturalClasses, Alphabet.segments, Alphabet.features, classesToSegments, classesToBooleanVectors);
            System.out.println("\nIdentifying minimal natural classes (i.e., classes that contain exactly one segment)");
            minimalNaturalClasses = new IntArrayList();
            int i3 = 0;
            while (true) {
                if (i3 >= Alphabet.segments.length) break;
                for (int j = 0; j < naturalClasses.size(); ++j) {
                    boolean[] segs = (boolean[])classesToBooleanVectors.get(j);
                    if (!segs[i3] || UCLAPhonotacticLearner.cardinality(segs) > 1) continue;
                    minimalNaturalClasses.add(j);
                }
                ++i3;
            }
            minimalNaturalClasses.trimToSize();
            System.out.println("minimals:");
            for (i3 = 0; i3 < minimalNaturalClasses.size(); ++i3) {
                System.out.println(Arrays.toString((Object[])UCLAPhonotacticLearner.naturalClassToString((String[])naturalClasses.get(minimalNaturalClasses.get(i3)))));
            }
            if (COMPLEMENT_NATURAL_CLASSES) {
                MapNaturalClassesToSegments.makeComplementMap(naturalClasses, Alphabet.segments, Alphabet.features, classesToSegments, classesToBooleanVectors);
            }
            complementNaturalClassesBool = new boolean[naturalClasses.size()];
            for (i3 = 0; i3 < naturalClasses.size(); ++i3) {
                if (!UCLAPhonotacticLearner.naturalClassToString((String[])naturalClasses.get(i3))[0].startsWith("^")) continue;
                UCLAPhonotacticLearner.complementNaturalClassesBool[i3] = true;
            }
            System.out.println("done");
            System.out.println("\nMapping segments to the natural classes that contain them ...");
            segmentsToClasses = new IntArrayList[Alphabet.segments.length];
            boolean[] classes = null;
            for (i2 = naturalClasses.size() - 1; i2 >= 0; --i2) {
                classes = (boolean[])classesToBooleanVectors.get(i2);
                for (int j = Alphabet.segments.length - 1; j >= 0; --j) {
                    if (!classes[j]) continue;
                    if (segmentsToClasses[j] == null) {
                        UCLAPhonotacticLearner.segmentsToClasses[j] = new IntArrayList();
                    }
                    segmentsToClasses[j].add(i2);
                }
            }
            System.out.println("done");
            System.out.println("\nMapping natural classes to slice/row/column indexations ...");
            classesToSegmentIndexations = new int[naturalClasses.size()][];
            for (i2 = naturalClasses.size() - 1; i2 >= 0; --i2) {
                boolean[] segments = (boolean[])classesToBooleanVectors.get(i2);
                UCLAPhonotacticLearner.classesToSegmentIndexations[i2] = new int[UCLAPhonotacticLearner.cardinality(segments)];
                int index = 0;
                for (int seg = segments.length - 1; seg >= 0; --seg) {
                    if (!segments[seg]) continue;
                    UCLAPhonotacticLearner.classesToSegmentIndexations[i2][index] = seg;
                    ++index;
                }
            }
        }
        if (opt.isSet("trigramNaturalClasses")) {
            System.out.println("\nReading trigram natural classes ...");
            String TRIGRAM_NATURAL_CLASSES = opt.getOption("trigramNaturalClasses");
            if (TRIGRAM_NATURAL_CLASSES.equals("all")) {
                trigramNaturalClasses = new int[naturalClasses.size()];
                for (i2 = 0; i2 < trigramNaturalClasses.length; ++i2) {
                    UCLAPhonotacticLearner.trigramNaturalClasses[i2] = i2;
                }
            } else {
                trigramNaturalClasses = UCLAPhonotacticLearner.readTrigramNaturalClasses(DIRECTORY + TRIGRAM_NATURAL_CLASSES);
            }
            trigramNaturalClassesBool = new boolean[naturalClasses.size()];
            for (i2 = 0; i2 < trigramNaturalClasses.length; ++i2) {
                UCLAPhonotacticLearner.trigramNaturalClassesBool[UCLAPhonotacticLearner.trigramNaturalClasses[i2]] = true;
            }
            System.out.println("done");
        }
        DEFAULT_PROJECTION = !opt.isSet("noDefaultProjection");
        System.out.println("default projection? " + DEFAULT_PROJECTION);
        if (opt.isSet("projections")) {
            UCLAPhonotacticLearner.readProjections(DIRECTORY + opt.getOption("projections"));
        } else {
            UCLAPhonotacticLearner.readProjections(null);
        }
        if (opt.isSet("phonemes") && opt.isSet("naturalClasses")) {
            int proj;
            System.out.println("\nDetermining the size of each natural class on each projection\n(ignore sizes for [+word_boundary] class) ...");
            naturalClassSizes = new int[projections.length][naturalClasses.size()];
            for (proj = 0; proj < projections.length; ++proj) {
                Projection projection = projections[proj];
                System.out.println("Projection: " + projection.name);
                int maximumSize = 0;
                for (i = 0; i < naturalClasses.size(); ++i) {
                    if (!projection.naturalClasses[i]) continue;
                    boolean[] segments = (boolean[])classesToBooleanVectors.get(i);
                    segments = projection.filterSegments(segments);
                    UCLAPhonotacticLearner.naturalClassSizes[projection.index][i] = UCLAPhonotacticLearner.cardinality(segments);
                    maximumSize = maximumSize >= naturalClassSizes[projection.index][i] ? maximumSize : naturalClassSizes[projection.index][i];
                    System.out.println("\t" + Arrays.toString((Object[])UCLAPhonotacticLearner.naturalClassToString((String[])naturalClasses.get(i))) + "\t" + naturalClassSizes[projection.index][i]);
                }
                UCLAPhonotacticLearner.naturalClassSizes[projection.index][0] = maximumSize;
            }
            System.out.println("done");
            System.out.println("\nOrdering natural classes by (descending) size on each projection");
            naturalClassesByProjection = new int[projections.length][naturalClasses.size()];
            for (proj = 0; proj < projections.length; ++proj) {
                Projection projection = projections[proj];
                System.out.println("Projection: " + projection.name);
                java.util.Arrays.fill(naturalClassesByProjection[projection.index], -1);
                int index = 0;
                UCLAPhonotacticLearner.naturalClassesByProjection[projection.index][index++] = 0;
                for (i = Alphabet.segments.length; i >= 0; --i) {
                    for (int j = 1; j < naturalClasses.size(); ++j) {
                        if (!projection.naturalClasses[j] || naturalClassSizes[projection.index][j] != i) continue;
                        UCLAPhonotacticLearner.naturalClassesByProjection[projection.index][index++] = j;
                    }
                }
                System.out.println(Arrays.toString((int[])naturalClassesByProjection[projection.index]));
            }
            System.out.println("\nDetermining the simplified representations of segments on projections ...");
            for (proj = 0; proj < projections.length; ++proj) {
                projections[proj].makeSegmentRepresentation();
                System.out.println("Segment representations on projection " + UCLAPhonotacticLearner.projections[proj].name);
                System.out.println(Arrays.toString((int[])UCLAPhonotacticLearner.projections[proj].segmentRep));
            }
            System.out.println("done");
        }
        if (opt.isSet("prespecifiedConstraints")) {
            Projection P = null;
            for (int i4 = 0; i4 < projections.length; ++i4) {
                P = projections[i4];
                try {
                    P.con = UCLAPhonotacticLearner.readConstraints(DIRECTORY + P.name + ".con", false);
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        if (opt.isSet("maximumGramSize")) {
            MAXIMUM_GRAM_SIZE = UCLAPhonotacticLearner.readInts(DIRECTORY + opt.getOption("maximumGramSize"));
        } else {
            MAXIMUM_GRAM_SIZE = new int[projections.length];
            java.util.Arrays.fill(MAXIMUM_GRAM_SIZE, 3);
        }
        if (opt.isSet("maximumFieldSize")) {
            MAXIMUM_FIELD_SIZE = Integer.parseInt(opt.getOption("maximumFieldSize"));
        }
        if (opt.isSet("oeThreshold")) {
            OE_THRESHOLD = Double.parseDouble(opt.getOption("oeThreshold"));
        }
        if (opt.isSet("sampleSize")) {
            TARGET_SAMPLE_SIZE = Integer.parseInt(opt.getOption("sampleSize"));
        }
        if (opt.isSet("sampleType")) {
            SAMPLE_TYPE = opt.getOption("sampleType");
        }
        if (opt.isSet("sampleDiameter")) {
            SAMPLE_DIAMETER = Integer.parseInt(opt.getOption("sampleDiameter"));
        }
        if (opt.isSet("corpus")) {
            System.out.println("\nReading the corpus ...");
            CORPUS = opt.getOption("corpus");
            corpus = UCLAPhonotacticLearner.readCorpusOrSample(DIRECTORY + CORPUS, opt.isSet("storeCorpus"));
            System.out.println("done");
        }
        if (opt.isSet("maximumPathLength")) {
            MAXIMUM_PATH_LENGTH = Integer.parseInt(opt.getOption("maximumPathLength"));
        } else if (corpus != null) {
            MAXIMUM_PATH_LENGTH = UCLAPhonotacticLearner.corpus.maximumNonzeroLength;
        }
        if (opt.isSet("sampleFile")) {
            System.out.println("\nReading the sample ...");
            sample = UCLAPhonotacticLearner.readCorpusOrSample(DIRECTORY + opt.getOption("sampleFile"), true);
            System.out.println("done");
        }
        PRINT_SAMPLES = opt.isSet("printSamples");
        if (opt.isSet("weighting")) {
            WEIGHTING_ALGORITHM = opt.getOption("weighting");
        }
        TRAIN_WITH_SAMPLING = opt.isSet("weightWithSampling");
        BUILD_EXPECTATION_GRAPH = !opt.isSet("noGraph");
        if (opt.isSet("weightingIteration")) {
            WEIGHTING_ITERATION = Integer.parseInt(opt.getOption("weightingIteration"));
        }
        if (opt.isSet("metropolisIteration")) {
            METROPOLIS_ITERATION = Integer.parseInt(opt.getOption("metropolisIteration"));
        }
        if (opt.isSet("tolx")) {
            TOLX = Double.parseDouble(opt.getOption("tolx"));
        }
        if (opt.isSet("regularizer")) {
            REGULARIZER = opt.getOption("regularizer");
        }
        if (opt.isSet("sigma2")) {
            SIGMA2 = Double.parseDouble(opt.getOption("sigma2"));
        }
        if (opt.isSet("alpha")) {
            ALPHA = Double.parseDouble(opt.getOption("alpha"));
        }
        if (opt.isSet("smooth")) {
            SMOOTH = Double.parseDouble(opt.getOption("smooth"));
            LOWER_CONFIDENCE_LIMIT = false;
        }
        if (opt.isSet("mikheev")) {
            LCL_ALPHA = Double.parseDouble(opt.getOption("mikheev"));
            LOWER_CONFIDENCE_LIMIT = true;
        }
        if (opt.isSet("accuracySchedule")) {
            ACCURACY_SCHEDULE = UCLAPhonotacticLearner.readDoubles(DIRECTORY + opt.getOption("accuracySchedule"));
        }
        if (opt.isSet("constraintList")) {
            System.out.println("\nReading list of constraints from which to select ...");
            CONSTRAINT_LIST = opt.getOption("constraintList");
            constraintList = UCLAPhonotacticLearner.readConstraints(DIRECTORY + CONSTRAINT_LIST, false);
            System.out.println("done");
        }
        if (opt.isSet("constraintOrder")) {
            System.out.println("\nReading order of constraints in constraintList ...");
            CONSTRAINT_ORDER = opt.getOption("constraintOrder");
            constraintOrder = UCLAPhonotacticLearner.readDoubles(DIRECTORY + CONSTRAINT_ORDER, constraintList.length);
            System.out.println("number of constraints: " + constraintList.length);
            System.out.println("number of elts in constraint order: " + constraintOrder.size());
            System.out.println("done");
        }
        if (opt.isSet("constraintsAndWeights")) {
            System.out.println("\nReading the constraints and weights ...");
            RF = new RandomField();
            RF.setSigma(sigma);
            RF.setCorpus(corpus);
            CONSTRAINTS_AND_WEIGHTS = opt.getOption("constraintsAndWeights");
            RF.setEval(UCLAPhonotacticLearner.readConstraints(DIRECTORY + CONSTRAINTS_AND_WEIGHTS, true));
            RF.setLambda(UCLAPhonotacticLearner.readDoubles(DIRECTORY + CONSTRAINTS_AND_WEIGHTS, UCLAPhonotacticLearner.RF.Eval.length));
            System.out.println("done");
        }
        if (opt.isSet("constraints")) {
            System.out.println("\nReading the constraints ...");
            RF = new RandomField();
            RF.setSigma(sigma);
            RF.setCorpus(corpus);
            CONSTRAINTS = opt.getOption("constraints");
            RF.setEval(UCLAPhonotacticLearner.readConstraints(DIRECTORY + CONSTRAINTS, false));
            System.out.println("done");
        }
        if (opt.isSet("weights")) {
            System.out.println("\nReading the weights ...");
            WEIGHTS = opt.getOption("weights");
            RF.setLambda(UCLAPhonotacticLearner.readDoubles(DIRECTORY + WEIGHTS, UCLAPhonotacticLearner.RF.Eval.length));
            System.out.println("done");
        }
        if (opt.isSet("printConstraints")) {
            System.out.println();
            int len = UCLAPhonotacticLearner.RF.lambda.size();
            for (int i5 = 0; i5 < len; ++i5) {
                System.out.println(i5 + "\t" + UCLAPhonotacticLearner.RF.Eval[i5] + "\t" + UCLAPhonotacticLearner.RF.lambda.get(i5));
            }
        }
        if (opt.isSet("train")) {
            System.out.println("\nTraining the weights of the random field ...");
            UCLAPhonotacticLearner.train();
            UCLAPhonotacticLearner.printField(RF);
            System.out.println("done");
        }
        if (opt.isSet("printObservedExpected")) {
            System.out.println(RF.getEmpiricalCounts());
            RF.resetSample();
            RF.getExpectedCounts();
        }
        if (opt.isSet("select")) {
            System.out.println("\nRunning iterative feature selection ...");
            if (RF == null) {
                RF = new RandomField();
                RF.setSigma(sigma);
                RF.setCorpus(corpus);
            }
            if (opt.isSet("selectAtRandom")) {
                RandomSelection RAND = new RandomSelection();
                RandomSelection.select(RF);
            } else {
                BreadthFirstSelection5 BFS = new BreadthFirstSelection5();
                BreadthFirstSelection5.select(RF);
            }
            UCLAPhonotacticLearner.train();
            System.out.println("done");
        }
        if (TRACK_CORPUS_PROB) {
            System.out.println("corpus probability and objective cost");
            System.out.println("corpus, objective");
            for (int i6 = 0; i6 < corpusNegLogProb.size(); ++i6) {
                System.out.println(corpusNegLogProb.get(i6) + ", " + objectiveCost.get(i6));
            }
        }
        if (opt.isSet("test")) {
            System.out.println("\nTesting on a word list ...");
            TEST_WORDS = opt.getOption("test");
            UCLAPhonotacticLearner.test(DIRECTORY + TEST_WORDS);
        }
        if (opt.isSet("sample")) {
            System.out.println("\nGenerating a random sample with the current field ...");
            Corpus samples = RF.getRandomSample(true);
            System.out.println("total number of samples: " + samples.size);
            TreeSet sampleTypes = new TreeSet(cc);
            sampleTypes.addAll(java.util.Arrays.asList(samples.data));
            System.out.println("number of distinct samples: " + sampleTypes.size());
            Iterator i7 = sampleTypes.iterator();
            while (i7.hasNext()) {
                System.out.print(UCLAPhonotacticLearner.printConfiguration((int[])i7.next()) + ", ");
            }
            System.out.println();
            DataFile write = DataFile.createWriter((String)"8859_2", (boolean)false);
            write.setDataFormat((DataFormat)new CSVFormat());
            try {
                if (OUTPUTDIR != null) {
                    write.open(new File(OUTPUTDIR + "sampleSalad.txt"));
                } else {
                    write.open(new File(DIRECTORY + "sampleSalad.txt"));
                }
                for (i = 0; i < samples.data.length; ++i) {
                    DataRow row = write.next();
                    row.add(UCLAPhonotacticLearner.printConfiguration(samples.data[i]));
                }
            }
            finally {
                write.close();
            }
        }
        if (opt.isSet("stringKernel")) {
            StringKernel sk = new StringKernel();
            double[] scores = new double[UCLAPhonotacticLearner.testWords.data.length];
            for (int i8 = 0; i8 < UCLAPhonotacticLearner.testWords.data.length; ++i8) {
                int[] config = UCLAPhonotacticLearner.testWords.data[i8];
                double summedSimilarity = 0.0;
                for (int j = 0; j < UCLAPhonotacticLearner.corpus.data.length; ++j) {
                    summedSimilarity += StringKernel.k_normalized(config, UCLAPhonotacticLearner.corpus.data[i8], new double[]{0.0, 0.0, 1.0});
                }
                scores[i8] = summedSimilarity;
                System.out.println(scores[i8]);
            }
        }
        if (opt.isSet("printGraph") && RF != null && UCLAPhonotacticLearner.RF.G != null) {
            System.out.println();
            System.out.println("expectation graph:");
            System.out.println(UCLAPhonotacticLearner.RF.G);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printField(RandomField RF) throws Exception {
        DataFile write = DataFile.createWriter((String)"8859_2", (boolean)false);
        write.setDataFormat((DataFormat)new TabFormat());
        try {
            if (OUTPUTDIR != null) {
                write.open(new File(OUTPUTDIR + "grammar.txt"));
            } else {
                write.open(new File(DIRECTORY + "grammar.txt"));
            }
            int len = RF.lambda.size();
            for (int i = 0; i < len; ++i) {
                DataRow row = write.next();
                row.add(RF.Eval[i].toString());
                row.add(RF.lambda.get(i));
            }
        }
        finally {
            write.close();
        }
    }

    public static String[] readTiers(String tierFile) throws IOException {
        LinkedList<String> tiers_temp = new LinkedList<String>();
        StreamTokenizer t = new StreamTokenizer(new FileReader(tierFile));
        t.ordinaryChar(95);
        t.wordChars(95, 95);
        t.slashSlashComments(true);
        t.slashStarComments(true);
        t.nextToken();
        if (!t.sval.equals("Tiers")) {
            System.out.println("Error: tier file does not begin with \"Tiers\"");
            System.exit(0);
        }
        t.nextToken();
        while (t.ttype != -1) {
            tiers_temp.addLast(t.sval);
            t.nextToken();
        }
        tiers = new String[tiers_temp.size()];
        for (int i = 0; i < tiers_temp.size(); ++i) {
            UCLAPhonotacticLearner.tiers[i] = (String)tiers_temp.get(i);
        }
        tiers_temp = null;
        System.out.println(ArrayPrinter.print(tiers));
        return tiers;
    }

    public static Alphabet readSigma(String filename) throws IOException {
        int i;
        StreamTokenizer t = new StreamTokenizer(new FileReader(filename));
        t.ordinaryChar(44);
        t.whitespaceChars(44, 44);
        t.ordinaryChar(43);
        t.wordChars(43, 43);
        t.ordinaryChar(45);
        t.wordChars(45, 45);
        t.ordinaryChar(123);
        t.wordChars(123, 123);
        t.ordinaryChar(125);
        t.wordChars(125, 125);
        t.ordinaryChar(48);
        t.wordChars(48, 48);
        t.ordinaryChar(49);
        t.wordChars(49, 49);
        t.ordinaryChar(95);
        t.wordChars(95, 95);
        t.ordinaryChar(35);
        t.wordChars(35, 35);
        t.slashSlashComments(true);
        t.slashStarComments(true);
        t.nextToken();
        if (!t.sval.equals("Segments")) {
            System.out.println("Error: segment file does not begin with \"Segments\"");
            System.exit(0);
        }
        Object label = null;
        Object[] features = new String[tiers.length];
        String segment = null;
        LinkedList<Segment> segments_temp = new LinkedList<Segment>();
        t.nextToken();
        while (t.ttype != -1) {
            segment = new String(t.sval);
            t.nextToken();
            if (!t.sval.equals("{")) {
                System.out.println("Error reading segment file");
                System.exit(0);
            }
            java.util.Arrays.fill(features, ".");
            t.nextToken();
            while (!t.sval.equals("}")) {
                String currentValue = t.sval.substring(0, 1);
                String currentTier = t.sval.substring(1, t.sval.length());
                for (i = 0; i < tiers.length; ++i) {
                    if (!tiers[i].startsWith(currentTier)) continue;
                    features[i] = new String(currentValue);
                    break;
                }
                t.nextToken();
            }
            segments_temp.add(new Segment(segment, (String[])features.clone()));
            t.nextToken();
        }
        String[] segs = new String[segments_temp.size()];
        String[][] ftrs = new String[segments_temp.size()][tiers.length];
        for (i = 0; i < segments_temp.size(); ++i) {
            segs[i] = ((Segment)segments_temp.get((int)i)).segment;
            ftrs[i] = ((Segment)segments_temp.get((int)i)).feature;
            System.out.println(i + "\t" + segs[i] + "\t" + ArrayPrinter.printSpecifiedFeatures(ftrs[i], tiers));
        }
        segments_temp = null;
        System.out.println("number of segments: " + segs.length);
        return new Alphabet(segs, ftrs);
    }

    public static LinkedList readNaturalClasses(String filename) throws Exception {
        StreamTokenizer t = new StreamTokenizer(new FileReader(filename));
        t.ordinaryChar(44);
        t.whitespaceChars(44, 44);
        t.ordinaryChar(58);
        t.wordChars(58, 58);
        t.ordinaryChar(35);
        t.wordChars(35, 35);
        t.ordinaryChar(43);
        t.wordChars(43, 43);
        t.ordinaryChar(45);
        t.wordChars(45, 45);
        t.ordinaryChars(48, 57);
        t.wordChars(48, 57);
        t.ordinaryChar(95);
        t.wordChars(95, 95);
        t.ordinaryChar(35);
        t.wordChars(35, 35);
        t.eolIsSignificant(true);
        t.slashSlashComments(true);
        t.slashStarComments(true);
        int NATURAL_CLASSES_COUNT = 0;
        Object[] new_class = null;
        LinkedList<Object[]> classes = new LinkedList<Object[]>();
        t.nextToken();
        while (t.ttype != -1) {
            if (t.ttype != 10 && t.ttype != -1 && t.sval.endsWith(":")) {
                new_class = new String[tiers.length];
                java.util.Arrays.fill(new_class, ".");
                t.nextToken();
                while (t.ttype != 10 && t.ttype != -1) {
                    String val = t.sval.substring(0, 1);
                    String tier = t.sval.substring(1);
                    for (int i = tiers.length - 1; i >= 0; --i) {
                        if (!tier.equals(tiers[i])) continue;
                        new_class[i] = val;
                        break;
                    }
                    t.nextToken();
                }
                classes.addLast(new_class);
                System.out.println(NATURAL_CLASSES_COUNT++ + "\t" + ArrayPrinter.printSpecifiedFeatures((String[])new_class, tiers));
            }
            t.nextToken();
        }
        System.out.println("number of natural classes: " + classes.size());
        return classes;
    }

    public static int[] readTrigramNaturalClasses(String filename) throws Exception {
        StreamTokenizer t = new StreamTokenizer(new FileReader(filename));
        t.ordinaryChar(44);
        t.whitespaceChars(44, 44);
        t.ordinaryChar(58);
        t.wordChars(58, 58);
        t.ordinaryChar(35);
        t.wordChars(35, 35);
        t.ordinaryChar(43);
        t.wordChars(43, 43);
        t.ordinaryChar(45);
        t.wordChars(45, 45);
        t.ordinaryChars(48, 57);
        t.wordChars(48, 57);
        t.ordinaryChar(95);
        t.wordChars(95, 95);
        t.eolIsSignificant(false);
        t.slashSlashComments(true);
        t.slashStarComments(true);
        LinkedList<String[]> tmp = new LinkedList<String[]>();
        t.nextToken();
        while (t.ttype != -1) {
            System.out.println(t.sval);
            tmp.add(UCLAPhonotacticLearner.makeNaturalClass(new String[]{t.sval}));
            t.nextToken();
        }
        int[] trigramNaturalClasses = new int[tmp.size()];
        for (int i = 0; i < tmp.size(); ++i) {
            Object[] trigramClass = (String[])tmp.get(i);
            boolean found = false;
            for (int j = 0; j < naturalClasses.size(); ++j) {
                Object[] naturalClass = (String[])naturalClasses.get(j);
                if (!java.util.Arrays.equals(trigramClass, naturalClass)) continue;
                trigramNaturalClasses[i] = j;
                found = true;
                break;
            }
            if (!found) {
                System.out.println("Unrecognized natural class: " + Arrays.toString((Object[])((String[])tmp.get(i))));
            }
            System.out.println(Arrays.toString((Object[])((String[])tmp.get(i))) + " : " + trigramNaturalClasses[i]);
        }
        return trigramNaturalClasses;
    }

    public static void readProjections(String filename) throws IOException {
        int numberOfFeatures = tiers.length;
        int numberOfSegments = Alphabet.segments.length;
        int numberOfClasses = naturalClasses.size();
        LinkedList<boolean[]> segs_ = new LinkedList<boolean[]>();
        LinkedList<boolean[]> classes_ = new LinkedList<boolean[]>();
        LinkedList<String> names_ = new LinkedList<String>();
        boolean[] segs = null;
        boolean[] classes = null;
        if (filename != null) {
            StreamTokenizer t = new StreamTokenizer(new FileReader(filename));
            t.ordinaryChar(44);
            t.whitespaceChars(44, 44);
            t.ordinaryChar(58);
            t.wordChars(58, 58);
            t.ordinaryChar(35);
            t.wordChars(35, 35);
            t.ordinaryChar(43);
            t.wordChars(43, 43);
            t.ordinaryChar(45);
            t.wordChars(45, 45);
            t.ordinaryChars(48, 57);
            t.wordChars(48, 57);
            t.ordinaryChar(95);
            t.wordChars(95, 95);
            t.eolIsSignificant(true);
            t.slashSlashComments(true);
            t.slashStarComments(true);
            Object[] class__ = null;
            Object[] defining__ = null;
            boolean[] ftrs__ = null;
            Object segs__ = null;
            String ftr = null;
            t.nextToken();
            while (t.ttype != -1) {
                if (t.ttype != 10 && t.ttype != -1) {
                    int i;
                    names_.addLast(t.sval);
                    class__ = new String[tiers.length];
                    java.util.Arrays.fill(class__, ".");
                    defining__ = new String[tiers.length];
                    java.util.Arrays.fill(defining__, ".");
                    t.nextToken();
                    while (t.ttype != 10 && t.ttype != -1 && !t.sval.equals(":")) {
                        String val = t.sval.substring(0, 1);
                        String tier = t.sval.substring(1);
                        for (int i2 = tiers.length - 1; i2 >= 0; --i2) {
                            if (!tier.equals(tiers[i2])) continue;
                            defining__[i2] = val;
                            break;
                        }
                        t.nextToken();
                    }
                    boolean[] visible = MapNaturalClassesToSegments.map((String[])defining__, Alphabet.segments, Alphabet.features);
                    visible[0] = true;
                    segs_.addLast(visible);
                    ftrs__ = new boolean[numberOfFeatures];
                    t.nextToken();
                    while (t.ttype != 10 && t.ttype != -1) {
                        ftr = t.sval;
                        for (int i3 = tiers.length - 1; i3 >= 0; --i3) {
                            if (!tiers[i3].equals(ftr)) continue;
                            ftrs__[i3] = true;
                            break;
                        }
                        t.nextToken();
                    }
                    classes = new boolean[numberOfClasses];
                    classes[0] = true;
                    block5: for (i = numberOfClasses - 1; i >= 0; --i) {
                        class__ = (String[])naturalClasses.get(i);
                        for (int j = numberOfFeatures - 1; j >= 0; --j) {
                            if (!ftrs__[j] && !((String)class__[j]).equals(".")) continue block5;
                        }
                        classes[i] = true;
                    }
                    for (i = numberOfClasses - 1; i >= 0; --i) {
                        class__ = (String[])naturalClasses.get(i);
                        if (!java.util.Arrays.equals(class__, defining__)) continue;
                        classes[i] = true;
                        break;
                    }
                    classes_.addLast(classes);
                }
                t.nextToken();
            }
        }
        if (DEFAULT_PROJECTION) {
            int i;
            segs = new boolean[numberOfSegments];
            for (i = segs.length - 1; i >= 0; --i) {
                segs[i] = true;
            }
            segs[0] = true;
            classes = new boolean[numberOfClasses];
            for (i = classes.length - 1; i >= 0; --i) {
                classes[i] = true;
            }
            segs_.addLast(segs);
            classes_.addLast(classes);
            names_.addLast("default");
        }
        projections = new Projection[segs_.size()];
        for (int i = 0; i < segs_.size(); ++i) {
            int j;
            UCLAPhonotacticLearner.projections[i] = new Projection((String)names_.get(i), i, (boolean[])segs_.get(i), (boolean[])classes_.get(i));
            System.out.println("Projection " + i + " is " + UCLAPhonotacticLearner.projections[i].name);
            System.out.print("\tvisible segments: ");
            for (j = 0; j < UCLAPhonotacticLearner.projections[i].visible.length; ++j) {
                if (!UCLAPhonotacticLearner.projections[i].visible[j]) continue;
                System.out.print(Alphabet.segments[j] + ", ");
            }
            System.out.println();
            System.out.println("\tactive natural classes: ");
            for (j = 0; j < naturalClasses.size(); ++j) {
                if (!UCLAPhonotacticLearner.projections[i].naturalClasses[j]) continue;
                System.out.println("\t\t" + ArrayPrinter.printSpecifiedFeatures((String[])naturalClasses.get(j), tiers));
            }
        }
    }

    public static Corpus readCorpusOrSample(String filename, boolean keepCorpusItems) throws IOException {
        int i;
        Corpus corpus = new Corpus();
        int[] empiricalLengthDistribution = new int[MAXIMUM_WORD_LENGTH];
        int N = 0;
        int maximumNonzeroLength = 0;
        LinkedList<int[]> corpus_temp = null;
        if (keepCorpusItems) {
            corpus_temp = new LinkedList<int[]>();
        }
        String wordform = null;
        String[] segs = null;
        IntArrayList word = new IntArrayList();
        int count = 0;
        int[] word_ = null;
        int[] word__ = null;
        DataFile read = DataFile.createReader((String)"8859_1");
        read.setDataFormat((DataFormat)new TabFormat());
        read.open(new File(filename));
        DataRow row = read.next();
        while (row != null) {
            wordform = row.getString(0);
            segs = wordform.split(" ");
            if (row.size() == 1) {
                count = 1;
            } else {
                int x = 1;
                try {
                    x = Integer.parseInt(row.getString(1));
                }
                catch (Exception e) {
                    // empty catch block
                }
                count = x;
            }
            word.clear();
            word.add(0);
            if (!wordform.equals("")) {
                for (i = 0; i < segs.length; ++i) {
                    if (segs[i].equals(" ") || segs[i].equals("#")) continue;
                    int seg = -1;
                    int j = 0;
                    while (true) {
                        if (j >= Alphabet.segments.length) break;
                        if (segs[i].equals(Alphabet.segments[j])) {
                            seg = j;
                            break;
                        }
                        ++j;
                    }
                    if (seg == -1) {
                        System.out.println("Error: unknown segment in corpus: [" + segs[i] + "]");
                        System.exit(1);
                    }
                    word.add(seg);
                }
            }
            word.add(0);
            word.trimToSize();
            word_ = word.elements();
            int n = word_.length - 2;
            empiricalLengthDistribution[n] = empiricalLengthDistribution[n] + count;
            N += count;
            if (word_.length - 2 > maximumNonzeroLength) {
                maximumNonzeroLength = word_.length - 2;
            }
            for (int proj = 0; proj < projections.length; ++proj) {
                word__ = projections[proj].projectTrim(word_);
                corpus.gramCounts[proj].incrementSubsequences(word__, 0, word__.length, count);
            }
            if (keepCorpusItems) {
                word__ = new int[word_.length];
                System.arraycopy(word_, 0, word__, 0, word__.length);
                corpus_temp.add(word__);
            }
            row = read.next();
        }
        read.close();
        if (keepCorpusItems) {
            int[][] corpus_ = new int[corpus_temp.size()][];
            for (i = 0; i < corpus_temp.size(); ++i) {
                corpus_[i] = (int[])corpus_temp.get(i);
            }
            corpus.data = corpus_;
        }
        corpus.lengthDistrib = empiricalLengthDistribution;
        corpus.size = N;
        corpus.maximumNonzeroLength = maximumNonzeroLength;
        System.out.println("size of corpus: " + N);
        System.out.println("empirical length distribution: " + ArrayPrinter.print(empiricalLengthDistribution));
        System.out.println("maximum nonzero length: " + maximumNonzeroLength);
        System.out.println("done");
        return corpus;
    }

    public static RandomFieldFeature[] readConstraints(String filename, boolean skipWeight) throws IOException {
        int i;
        StreamTokenizer t = new StreamTokenizer(new FileReader(filename));
        t.ordinaryChar(42);
        t.whitespaceChars(42, 42);
        t.ordinaryChar(91);
        t.whitespaceChars(91, 91);
        t.ordinaryChar(93);
        t.whitespaceChars(93, 93);
        t.ordinaryChar(40);
        t.whitespaceChars(40, 40);
        t.ordinaryChar(41);
        t.whitespaceChars(41, 41);
        t.ordinaryChar(44);
        t.wordChars(44, 44);
        t.ordinaryChar(43);
        t.wordChars(43, 43);
        t.ordinaryChar(45);
        t.wordChars(45, 45);
        t.ordinaryChar(95);
        t.wordChars(95, 95);
        t.ordinaryChar(61);
        t.wordChars(61, 61);
        t.ordinaryChar(94);
        t.wordChars(94, 94);
        t.eolIsSignificant(true);
        t.slashSlashComments(true);
        t.slashStarComments(true);
        LinkedList<TierFeature> constraintList = new LinkedList<TierFeature>();
        LinkedList<Object> classList = new LinkedList<Object>();
        Object[] currentClass = null;
        String projection = null;
        int proj = 0;
        t.nextToken();
        while (t.ttype != -1) {
            classList.clear();
            while (t.ttype != 10 && t.sval.indexOf("tier=") == -1) {
                classList.add(t.sval.split(","));
                t.nextToken();
            }
            projection = t.sval;
            int offset = projection.indexOf("=") + 1;
            projection = projection.substring(offset, projection.length());
            for (proj = projections.length - 1; proj > 0 && !UCLAPhonotacticLearner.projections[proj].name.equals(projection); --proj) {
            }
            t.nextToken();
            if (skipWeight) {
                t.nextToken();
            }
            block3: for (i = 0; i < classList.size(); ++i) {
                currentClass = UCLAPhonotacticLearner.makeNaturalClass((String[])classList.get(i));
                System.out.println(Arrays.toString((Object[])((String[])classList.get(i))) + "-> " + Arrays.toString((Object[])currentClass));
                for (int j = naturalClasses.size() - 1; j >= 0; --j) {
                    if (!java.util.Arrays.equals((String[])naturalClasses.get(j), currentClass)) continue;
                    classList.set(i, new Integer(j));
                    continue block3;
                }
            }
            if (classList.size() != 0) {
                System.out.println(classList);
                int[] index = new int[classList.size()];
                for (int i2 = 0; i2 < classList.size(); ++i2) {
                    index[i2] = (Integer)classList.get(i2);
                }
                constraintList.add(new TierFeature(index, proj));
                System.out.println((TierFeature)constraintList.getLast());
            }
            t.nextToken();
        }
        RandomFieldFeature[] eval = new RandomFieldFeature[constraintList.size()];
        System.arraycopy(constraintList.toArray(), 0, eval, 0, eval.length);
        for (i = 0; i < eval.length; ++i) {
            System.out.println(eval[i]);
        }
        System.out.println("number of constraints: " + eval.length);
        return eval;
    }

    public static int[] readInts(String filename) throws Exception {
        StreamTokenizer t = new StreamTokenizer(new FileReader(filename));
        t.parseNumbers();
        IntArrayList list = new IntArrayList();
        t.nextToken();
        while (t.ttype != -1) {
            list.add((int)t.nval);
            t.nextToken();
        }
        list.trimToSize();
        return list.elements();
    }

    public static double[] readDoubles(String filename) throws Exception {
        StreamTokenizer t = new StreamTokenizer(new FileReader(filename));
        t.parseNumbers();
        DoubleArrayList list = new DoubleArrayList();
        t.nextToken();
        while (t.ttype != -1) {
            list.add(t.nval);
            t.nextToken();
        }
        list.trimToSize();
        return list.elements();
    }

    public static DoubleMatrix1D readDoubles(String filename, int N) throws Exception {
        StreamTokenizer t = new StreamTokenizer(new FileReader(filename));
        t.parseNumbers();
        DoubleMatrix1D lambda = DoubleFactory1D.dense.make(N);
        int i = 0;
        t.nextToken();
        while (t.ttype != -1) {
            if (t.ttype == -2) {
                System.out.println(i + "\t" + t.nval);
                lambda.set(i++, t.nval);
            }
            t.nextToken();
        }
        System.out.println("number of weights: " + i);
        return lambda;
    }

    public static void train() {
        if (UCLAPhonotacticLearner.RF.Eval == null) {
            return;
        }
        if (WEIGHTING_ALGORITHM.equals("ConjugateGradient")) {
            UCLAPhonotacticLearner.RF.lambda.assign(1.0);
            RF.resetSample();
            ConjugateGradientSearch cg = new ConjugateGradientSearch(2);
            cg.defaultStep = 0.25;
            cg.maxFun = 500;
            cg.numFuncStops = 500;
            cg.prin = 2;
            cg.optimize((MultivariateFunction)RF, UCLAPhonotacticLearner.RF.lambda.toArray(), Double.MIN_VALUE, TOLX, null);
        } else if (WEIGHTING_ALGORITHM.equals("ImprovedIterativeScaling")) {
            UCLAPhonotacticLearner.RF.lambda.assign(1.0);
            RF.resetSample();
            ImprovedIterativeScaling iis = new ImprovedIterativeScaling();
            iis.optimize(RF, UCLAPhonotacticLearner.RF.lambda, 1.0E-10, 1);
        } else if (WEIGHTING_ALGORITHM.equals("GridSearch")) {
            UCLAPhonotacticLearner.RF.lambda.assign(0.0);
            RF.resetSample();
            double[] gradient = new double[UCLAPhonotacticLearner.RF.lambda.size()];
            int maxIterations = 100;
            double[] stepSize = new double[]{0.1, 0.01, 0.001};
            for (int i = 0; i < stepSize.length; ++i) {
                for (int j = maxIterations - 1; j >= 0; --j) {
                    RF.computeGradient(UCLAPhonotacticLearner.RF.lambda.toArray(), gradient);
                    for (int k = UCLAPhonotacticLearner.RF.lambda.size() - 1; k >= 0; --k) {
                        if (gradient[k] > 0.1) {
                            UCLAPhonotacticLearner.RF.lambda.set(k, UCLAPhonotacticLearner.RF.lambda.get(k) - stepSize[i]);
                        }
                        if (!(gradient[k] < -0.1)) continue;
                        UCLAPhonotacticLearner.RF.lambda.set(k, UCLAPhonotacticLearner.RF.lambda.get(k) + stepSize[i]);
                    }
                }
            }
        } else if (WEIGHTING_ALGORITHM.equals("ObservedOverExpectedAtDiscovery")) {
            System.out.println("Error: Cannot use weighting method `ObservedOverExpectedAtDiscover' without specifying -select on the command line");
            System.exit(1);
        }
        DoubleMatrix1D O = RF.getEmpiricalCounts();
        DoubleMatrix1D E = RF.getExpectedCounts();
        System.out.println("Observed: " + O);
        System.out.println("Expected: " + E);
        RF.printConstraintsWithWeights();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void test(String filename) throws Exception {
        int[] config = null;
        LinkedList<int[]> testWords = new LinkedList<int[]>();
        LinkedList<String> annotations = new LinkedList<String>();
        DataFile read = DataFile.createReader((String)"8859_1");
        read.setDataFormat((DataFormat)new TabFormat());
        read.open(new File(filename));
        DataRow row = read.next();
        while (row != null) {
            int i;
            IntArrayList word = new IntArrayList();
            word.add(0);
            String[] segs = row.getString(0).split(" ");
            String annotation = new String();
            if (row.size() > 1) {
                annotation = row.getString(1);
                for (i = 2; i < row.size(); ++i) {
                    annotation = annotation + "\t" + row.getString(i);
                }
            }
            annotations.add(annotation);
            if (!segs[0].equals("NULL")) {
                for (i = 0; i < segs.length; ++i) {
                    int seg = -1;
                    int j = 0;
                    while (true) {
                        if (j >= Alphabet.segments.length) break;
                        if (segs[i].equals(Alphabet.segments[j])) {
                            seg = j;
                            break;
                        }
                        ++j;
                    }
                    if (seg == -1) {
                        System.out.println("Error: unknown segment in corpus: [" + segs[i] + "]");
                        System.exit(1);
                    }
                    word.add(seg);
                }
            }
            word.add(0);
            word.trimToSize();
            testWords.addLast(word.elements());
            row = read.next();
        }
        read.close();
        System.out.println("number of test words: " + testWords.size());
        DataFile write = DataFile.createWriter((String)"8859_2", (boolean)false);
        write.setDataFormat((DataFormat)new TabFormat());
        try {
            int i;
            if (OUTPUTDIR != null) {
                write.open(new File(OUTPUTDIR + "blickTestResults.txt"));
            } else {
                write.open(new File(DIRECTORY + "blickTestResults.txt"));
            }
            DataRow row2 = write.next();
            row2.add("word");
            row2.add("score");
            for (i = 0; i < UCLAPhonotacticLearner.RF.lambda.size(); ++i) {
                row2.add(((TierFeature)UCLAPhonotacticLearner.RF.Eval[i]).classesToString());
            }
            row2.add("annotation");
            row2 = write.next();
            row2.add("word");
            row2.add("score");
            for (i = 0; i < UCLAPhonotacticLearner.RF.lambda.size(); ++i) {
                row2.add(((TierFeature)UCLAPhonotacticLearner.RF.Eval[i]).projection.toString());
            }
            row2.add("annotation");
            row2 = write.next();
            row2.add("word");
            row2.add("score");
            for (i = 0; i < UCLAPhonotacticLearner.RF.lambda.size(); ++i) {
                row2.add(UCLAPhonotacticLearner.RF.lambda.get(i));
            }
            row2.add("annotation");
            for (i = 0; i < testWords.size(); ++i) {
                config = (int[])testWords.get(i);
                double[] scores = RF.scores(config).toArray();
                double scoresDotWeights = RF.scoresDotWeights(config);
                String annotation = (String)annotations.get(i);
                row2 = write.next();
                row2.add(UCLAPhonotacticLearner.printConfiguration(config));
                row2.add(scoresDotWeights);
                for (int k = 0; k < scores.length; ++k) {
                    row2.add(scores[k]);
                }
                row2.add(annotation);
            }
        }
        finally {
            write.close();
        }
        UCLAPhonotacticLearner.printField(RF);
    }

    public static int specifiedFeatures(String[] features) {
        int specified = 0;
        for (int i = features.length - 1; i >= 0; --i) {
            if (features[i].equals(".")) continue;
            ++specified;
        }
        return specified;
    }

    public static String[] makeNaturalClass(String[] features) {
        Object[] naturalClass = new String[tiers.length];
        java.util.Arrays.fill(naturalClass, ".");
        String val = null;
        String tier = null;
        block0: for (int i = features.length - 1; i >= 0; --i) {
            val = features[i].substring(0, 1);
            tier = features[i].substring(1);
            if (val.equals("^")) {
                val = features[i].substring(0, 2);
                tier = features[i].substring(2);
            }
            for (int j = tiers.length - 1; j >= 0; --j) {
                if (!tiers[j].equals(tier)) continue;
                naturalClass[j] = val;
                continue block0;
            }
        }
        return naturalClass;
    }

    public static String[] naturalClassToString(String[] values) {
        StringBuffer rep = new StringBuffer();
        boolean firstFeatureFlag = true;
        for (int i = 0; i < values.length; ++i) {
            if (values[i].equals(".")) continue;
            if (firstFeatureFlag) {
                firstFeatureFlag = false;
            } else {
                rep.append(",");
            }
            rep.append(values[i] + tiers[i]);
        }
        return rep.toString().split(",");
    }

    public static String printConfiguration(int[] config) {
        int seg = -1;
        StringBuffer rep = new StringBuffer();
        for (int i = 1; i < config.length && (seg = config[i]) != 0 && seg != -1; ++i) {
            rep.append(Alphabet.segments[seg] + " ");
        }
        return rep.toString();
    }

    public static String printConfigurationSlow(int[] config) {
        for (int i = 0; i < config.length; ++i) {
            System.out.print(Alphabet.segments[config[i]] + " ");
        }
        System.out.println();
        return "";
    }

    public static int cardinality(boolean[] b) {
        int card = 0;
        for (int i = b.length - 1; i >= 0; --i) {
            if (!b[i]) continue;
            ++card;
        }
        return card;
    }

    public static String[] booleanToSegments(boolean[] classbool) {
        StringBuffer rep = new StringBuffer();
        for (int i = 0; i < classbool.length; ++i) {
            if (!classbool[i]) continue;
            rep.append(Alphabet.segments[i] + ",");
        }
        return rep.toString().split(",");
    }

    static {
        mt = new MersenneTwister(new Date());
    }

    class ChangingDataSource
    extends Observable
    implements Rebinnable1DHistogramData {
        private String title;
        private String[] axisLabels;
        private double[] data;

        ChangingDataSource(String t, String[] l) {
            this.title = t;
            this.axisLabels = l;
            this.data = new double[1];
        }

        public void update(double[] newData) {
            int flags = 6;
            HistogramUpdate hu = new HistogramUpdate(flags, true);
            this.data = newData;
            this.setChanged();
            this.notifyObservers(hu);
        }

        public double[][] rebin(int rBins, double rMin, double rMax, boolean wantErrors, boolean hurry) {
            double[][] result = new double[][]{this.data};
            return result;
        }

        public String getTitle() {
            return this.title;
        }

        public String[] getAxisLabels() {
            return this.axisLabels;
        }

        public double getMin() {
            return 0.0;
        }

        public double getMax() {
            return this.data.length;
        }

        public boolean isRebinnable() {
            return false;
        }

        public int getBins() {
            return this.data.length;
        }

        public int getAxisType() {
            return 1;
        }
    }
}

