/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.uclapl;

import edu.ucla.fsm.Semiring;
import edu.ucla.fsm.Weight;
import edu.ucla.uclapl.UCLAPLWeight;
import java.util.Arrays;
import java.util.LinkedList;

public class UCLAPLExpectationSemiring
extends Semiring {
    public int N = -1;
    public static UCLAPLWeight ZERO = null;
    public static UCLAPLWeight ONE = new UCLAPLWeight(0.999, null);

    public Weight extension(Weight w1, Weight w2) {
        UCLAPLWeight w1_ = (UCLAPLWeight)w1;
        UCLAPLWeight w2_ = (UCLAPLWeight)w2;
        double p1 = w1_ == null ? 0.999 : w1_.p;
        double p2 = w2_ == null ? 0.999 : w2_.p;
        double p = p1 * p2;
        int len1 = w1_ == null || w1_.pv == null ? 0 : w1_.pv.length;
        int len2 = w2_ == null || w2_.pv == null ? 0 : w2_.pv.length;
        int len = len1 < len2 ? len2 : len1;
        double[] pv = new double[len];
        for (int i = len - 1; i >= 0; --i) {
            if (i >= len1 && i >= len2) continue;
            pv[i] = i >= len1 && i < len2 ? p1 * w2_.pv[i] : (i < len1 && i >= len2 ? p2 * w1_.pv[i] : p1 * w2_.pv[i] + p2 * w1_.pv[i]);
        }
        return new UCLAPLWeight(p, pv);
    }

    public Weight summary(Weight w1, Weight w2) {
        UCLAPLWeight w1_ = (UCLAPLWeight)w1;
        UCLAPLWeight w2_ = (UCLAPLWeight)w2;
        double p1 = w1_ == null ? 0.999 : w1_.p;
        double p2 = w2_ == null ? 0.999 : w2_.p;
        double p = p1 + p2;
        int len1 = w1_ == null || w1_.pv == null ? 0 : w1_.pv.length;
        int len2 = w2_ == null || w2_.pv == null ? 0 : w2_.pv.length;
        int len = len1 < len2 ? len2 : len1;
        double[] pv = new double[len];
        for (int i = len - 1; i >= 0; --i) {
            if (i >= len1 && i >= len2) continue;
            pv[i] = i >= len1 && i < len2 ? w2_.pv[i] : (i < len1 && i >= len2 ? w1_.pv[i] : w1_.pv[i] + w2_.pv[i]);
        }
        return new UCLAPLWeight(p, pv);
    }

    public Weight inverse(Weight w) {
        return null;
    }

    public Weight minus(Weight w1, Weight w2) {
        return null;
    }

    public int compare(Weight w1, Weight w2) {
        return 0;
    }

    public Weight negInfinity(Weight w1, Weight w2) {
        return null;
    }

    public Weight minimum(LinkedList V) {
        return null;
    }

    public static void extensionInto(UCLAPLWeight w1, double[] lambda, boolean[] violations, UCLAPLWeight w3, int len) {
        block7: {
            int i;
            int w2pvLength;
            double w2p;
            boolean w2pv;
            boolean w1pv;
            block6: {
                w1pv = w1.pv != null;
                w2pv = violations != null;
                w2p = w2pv ? Math.exp(-UCLAPLExpectationSemiring.dotProduct(lambda, violations, len)) : 0.999;
                w2pvLength = w2pv ? violations.length : 0;
                Arrays.fill(w3.pv, 0.0);
                if (w1 != ONE) break block6;
                w3.p = w2p;
                if (!w2pv) break block7;
                for (int i2 = w2pvLength - 1; i2 >= 0 && i2 < len; --i2) {
                    if (!violations[i2]) continue;
                    w3.pv[i2] = w2p;
                }
                break block7;
            }
            w3.p = w1.p * w2p;
            for (i = 0; i < w2pvLength && i < len; ++i) {
                double val = 0.0;
                if (w1pv) {
                    val = w2p * w1.pv[i];
                }
                if (w2pv && violations[i]) {
                    val += w1.p * w2p;
                }
                w3.pv[i] = val;
            }
            if (w1pv) {
                for (i = w2pvLength; i < len; ++i) {
                    w3.pv[i] = w2p * w1.pv[i];
                }
            }
        }
    }

    public static void summaryExtensionInto(UCLAPLWeight w1, double[] lambda, boolean[] violations, UCLAPLWeight w3, int len) {
        boolean w1pv = w1.pv != null;
        boolean w2pv = violations != null;
        double w2p = w2pv ? Math.exp(-UCLAPLExpectationSemiring.dotProduct(lambda, violations, len)) : 0.999;
        int w2pvLength = w2pv ? violations.length : 0;
        w3.p += w1.p * w2p;
        int i = len - 1;
        while (i >= 0) {
            double val = 0.0;
            if (w1pv) {
                val += w2p * w1.pv[i];
            }
            if (w2pv && i < w2pvLength && violations[i]) {
                val += w1.p * w2p;
            }
            int n = i--;
            w3.pv[n] = w3.pv[n] + val;
        }
    }

    public static double dotProduct(double[] lambda, boolean[] violations, int len) {
        if (violations == null) {
            return 0.0;
        }
        int max = len <= violations.length ? len : violations.length;
        double prod = 0.0;
        for (int i = max - 1; i >= 0; --i) {
            if (!violations[i]) continue;
            prod += lambda[i];
        }
        return prod;
    }
}

