/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.uclapl;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.jet.math.Functions;
import edu.ucla.fsm.BooleanArrayWeight;
import edu.ucla.fsm.DagBestPath;
import edu.ucla.fsm.FSM;
import edu.ucla.fsm.IntersectWithSigmaN;
import edu.ucla.fsm.Semiring;
import edu.ucla.fsm.Transition;
import edu.ucla.uclapl.ConstraintCompiler3;
import edu.ucla.uclapl.ExpectationGraphBuilder;
import edu.ucla.uclapl.Projection;
import edu.ucla.uclapl.UCLAPLExpectationSemiring;
import edu.ucla.uclapl.UCLAPLWeight;

public class TrellisBestPath6 {
    static UCLAPLExpectationSemiring SR = new UCLAPLExpectationSemiring();
    static Functions functions = Functions.functions;
    static boolean verbose = false;

    public static DoubleMatrix1D apply(FSM A, double[] lambda, int numberOfConstraints, int[] myLengthDistrib) {
        int sampleSize = 0;
        DoubleMatrix1D E = DoubleFactory1D.dense.make(numberOfConstraints);
        DoubleMatrix1D E_k = DoubleFactory1D.dense.make(numberOfConstraints);
        UCLAPLWeight W_k = null;
        FSM G = null;
        for (int k = 0; k < myLengthDistrib.length; ++k) {
            if (myLengthDistrib[k] == 0) continue;
            sampleSize += myLengthDistrib[k];
            G = IntersectWithSigmaN.apply((FSM)A, (int)(k + 2));
            for (Transition t : G.transitions) {
                t.weight = new UCLAPLWeight(lambda, t.weight == null ? null : ((BooleanArrayWeight)t.weight).value, numberOfConstraints);
            }
            W_k = (UCLAPLWeight)DagBestPath.bp((FSM)G, (Semiring)SR);
            E_k.assign(W_k.pv);
            E_k.assign(Functions.div((double)W_k.p));
            E_k.assign(Functions.mult((double)myLengthDistrib[k]));
            E.assign(E_k, Functions.plus);
        }
        if (verbose) {
            System.out.println("TrellisBestPath6: E = " + E);
            System.out.println("TrellisBestPath6: sampleSize = " + sampleSize);
        }
        E.assign(Functions.div((double)sampleSize));
        return E;
    }

    public static void main(String[] args) throws Exception {
        double[] lambda = new double[]{1.0};
        int[] lengthDistrib = new int[]{0, 10, 10, 10, 0, 0, 0, 0, 0, 0};
        Projection p = new Projection("test", 1, new boolean[]{true, true, true, true, false}, null);
        boolean[][] classes = new boolean[][]{{false, true, true, false, false}, {false, false, true, false, false}, {false, true, false, false, false}};
        FSM C0 = ExpectationGraphBuilder.initialGraph(5);
        FSM C1 = ConstraintCompiler3.compile(classes, 5, p);
        FSM C2 = ExpectationGraphBuilder.intersect(C0, C1, 0);
        C2.renumberStates();
        System.out.println(C2);
        DoubleMatrix1D E = TrellisBestPath6.apply(C2, lambda, 1, lengthDistrib);
        System.out.println(E);
        DoubleMatrix1D E2 = DoubleFactory1D.dense.make(1);
        DoubleMatrix1D E2_k = DoubleFactory1D.dense.make(1);
        UCLAPLWeight W_k = null;
        for (int k = 0; k < lengthDistrib.length; ++k) {
            if (lengthDistrib[k] == 0) continue;
            FSM C3 = IntersectWithSigmaN.apply((FSM)C2, (int)(k + 2));
            for (Transition t : C3.transitions) {
                t.weight = new UCLAPLWeight(lambda, t.weight == null ? null : ((BooleanArrayWeight)t.weight).value, 1);
            }
            W_k = (UCLAPLWeight)DagBestPath.bp((FSM)C3, (Semiring)SR);
            E2_k.assign(W_k.pv);
            E2_k.assign(Functions.div((double)W_k.p));
            E2_k.assign(Functions.mult((double)lengthDistrib[k]));
            E2.assign(E2_k, Functions.plus);
        }
        System.out.println(E2);
    }
}

