/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.uclapl;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.jet.math.Functions;
import edu.ucla.fsm.BooleanArrayWeight;
import edu.ucla.fsm.DagBestPath;
import edu.ucla.fsm.FSM;
import edu.ucla.fsm.IntersectWithSigmaN;
import edu.ucla.fsm.Semiring;
import edu.ucla.fsm.State;
import edu.ucla.fsm.Transition;
import edu.ucla.fsm.Weight;
import edu.ucla.uclapl.ConstraintCompiler3;
import edu.ucla.uclapl.ExpectationGraphBuilder;
import edu.ucla.uclapl.Projection;
import edu.ucla.uclapl.RandomField;
import edu.ucla.uclapl.UCLAPLExpectationSemiring;
import edu.ucla.uclapl.UCLAPLWeight;
import edu.ucla.uclapl.UCLAPhonotacticLearner;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class TrellisBestPath5 {
    static TreeSet<State> initials = null;
    static TreeSet<State> finals = null;
    static Transition[] transitions = null;
    static UCLAPLWeight srcCost;
    static UCLAPLWeight destCost;
    static UCLAPLWeight weight_k;
    static HashSet<State> Q;
    static HashSet<State> R;
    static Weight ZERO;
    static TreeMap<State, Weight> d;
    static TreeMap<State, Weight> r;
    static TreeMap<State, Weight> tmp;
    static HashSet<State> costIsNonzero;
    static UCLAPLExpectationSemiring SR;
    static State src;
    static State dest;
    static State q;
    static Transition t;
    static DoubleMatrix1D value;
    static DoubleMatrix1D value_k;
    static int maximumPathLength;
    static int numberOfTransitions;
    static int sampleSize;
    static TreeMap<State, int[]> transitionIndex;
    static int[] index;
    static Functions functions;
    static boolean verbose;

    public static DoubleMatrix1D apply(RandomField RF, FSM A, double[] lambda, int numberOfConstraints, int[] myLengthDistrib) {
        maximumPathLength = UCLAPhonotacticLearner.MAXIMUM_PATH_LENGTH;
        initials = A.getInitials();
        finals = A.getFinals();
        transitions = RF.transitions;
        numberOfTransitions = transitions.length;
        transitionIndex = RF.transitionIndex;
        value = DoubleFactory1D.dense.make(numberOfConstraints);
        sampleSize = 0;
        UCLAPLWeight ONE = UCLAPLExpectationSemiring.ONE;
        for (State q : initials) {
            costIsNonzero.add(q);
            d.put(q, ONE);
            r.put(q, ONE);
        }
        Q.clear();
        R.clear();
        Q.addAll(initials);
        for (int k = 0; k <= maximumPathLength + 2; ++k) {
            for (State src : Q) {
                srcCost = (UCLAPLWeight)r.get(src);
                index = transitionIndex.get(src);
                if (index == null) continue;
                for (int i = index[0]; i <= index[1]; ++i) {
                    t = transitions[i];
                    dest = TrellisBestPath5.t.dest;
                    destCost = (UCLAPLWeight)d.get(dest);
                    if (destCost == null) {
                        destCost = new UCLAPLWeight(0.0, new double[numberOfConstraints + 10]);
                        d.put(dest, destCost);
                    } else if (TrellisBestPath5.destCost.pv.length < numberOfConstraints) {
                        TrellisBestPath5.destCost.pv = new double[numberOfConstraints + 10];
                    }
                    if (!costIsNonzero.contains(dest)) {
                        UCLAPLExpectationSemiring.extensionInto(srcCost, lambda, TrellisBestPath5.t.weight == null ? null : (boolean[])TrellisBestPath5.t.weight.value(), destCost, numberOfConstraints);
                        costIsNonzero.add(dest);
                    } else {
                        UCLAPLExpectationSemiring.summaryExtensionInto(srcCost, lambda, TrellisBestPath5.t.weight == null ? null : (boolean[])TrellisBestPath5.t.weight.value(), destCost, numberOfConstraints);
                    }
                    if (finals.contains(dest)) continue;
                    R.add(dest);
                }
            }
            Q.clear();
            Q.addAll(R);
            R.clear();
            if (k > 2) {
                weight_k = null;
                for (State q : finals) {
                    weight_k = weight_k == null ? (UCLAPLWeight)r.get(q) : (UCLAPLWeight)SR.summary(weight_k, r.get(q));
                }
                value_k = DoubleFactory1D.dense.make(numberOfConstraints);
                for (int i = numberOfConstraints - 1; i >= 0; --i) {
                    if (weight_k == null || TrellisBestPath5.weight_k.pv == null || TrellisBestPath5.weight_k.pv.length <= i) continue;
                    value_k.set(i, TrellisBestPath5.weight_k.pv[i]);
                }
                if (weight_k != null) {
                    value_k.assign(Functions.div((double)TrellisBestPath5.weight_k.p));
                }
                if (k - 2 >= 0) {
                    value_k.assign(Functions.mult((double)myLengthDistrib[k - 2]));
                }
                value.assign(value_k, Functions.plus);
                sampleSize += myLengthDistrib[k - 2];
            }
            tmp = r;
            r = d;
            d = tmp;
            d.clear();
            costIsNonzero.clear();
        }
        Q.clear();
        R.clear();
        initials = null;
        finals = null;
        transitions = null;
        d.clear();
        r.clear();
        costIsNonzero.clear();
        if (verbose) {
            System.out.println("TrellisBestPath5: value = " + value);
            System.out.println("TrellisBestPath5: sampleSize = " + sampleSize);
        }
        value.assign(Functions.div((double)sampleSize));
        return value;
    }

    public static void main(String[] args) throws Exception {
        double[] lambda = new double[]{1.0};
        int[] lengthDistrib = new int[]{0, 10, 10, 10, 0, 0, 0, 0, 0, 0};
        Projection p = new Projection("test", 1, new boolean[]{true, true, true, true, false}, null);
        boolean[][] classes = new boolean[][]{{false, true, true, false, false}, {false, false, true, false, false}, {false, true, false, false, false}};
        FSM C0 = ExpectationGraphBuilder.initialGraph(5);
        FSM C1 = ConstraintCompiler3.compile(classes, 5, p);
        FSM C2 = ExpectationGraphBuilder.intersect(C0, C1, 0);
        C2.renumberStates();
        System.out.println(C2);
        DoubleMatrix1D E = TrellisBestPath5.apply(null, C2, lambda, 1, lengthDistrib);
        System.out.println(E);
        DoubleMatrix1D E2 = DoubleFactory1D.dense.make(1);
        DoubleMatrix1D E2_k = DoubleFactory1D.dense.make(1);
        UCLAPLWeight W_k = null;
        for (int k = 0; k < lengthDistrib.length; ++k) {
            if (lengthDistrib[k] == 0) continue;
            FSM C3 = IntersectWithSigmaN.apply((FSM)C2, (int)(k + 2));
            for (Transition t : C3.transitions) {
                t.weight = new UCLAPLWeight(lambda, t.weight == null ? null : ((BooleanArrayWeight)t.weight).value, 1);
            }
            W_k = (UCLAPLWeight)DagBestPath.bp((FSM)C3, (Semiring)SR);
            E2_k.assign(W_k.pv);
            E2_k.assign(Functions.div((double)W_k.p));
            E2_k.assign(Functions.mult((double)lengthDistrib[k]));
            E2.assign(E2_k, Functions.plus);
        }
        System.out.println(E2);
    }

    static {
        destCost = null;
        weight_k = null;
        Q = new HashSet();
        R = new HashSet();
        ZERO = null;
        d = new TreeMap();
        r = new TreeMap();
        tmp = null;
        costIsNonzero = new HashSet();
        SR = new UCLAPLExpectationSemiring();
        q = null;
        t = null;
        value = null;
        value_k = null;
        maximumPathLength = 10;
        numberOfTransitions = 0;
        sampleSize = 0;
        transitionIndex = null;
        index = null;
        functions = Functions.functions;
        verbose = false;
    }
}

