/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.uclapl;

import edu.ucla.fsm.FSM;
import edu.ucla.fsm.State;
import edu.ucla.fsm.Transition;
import edu.ucla.fsm.Weight;
import edu.ucla.uclapl.ConstraintCompiler3;
import edu.ucla.uclapl.ExpectationGraphBuilder;
import edu.ucla.uclapl.Projection;
import edu.ucla.uclapl.UCLAPLExpectationSemiring;
import edu.ucla.uclapl.UCLAPLWeight;
import edu.ucla.uclapl.UCLAPhonotacticLearner;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class TrellisBestPath4 {
    static TreeSet<State> initials = null;
    static TreeSet<State> finals = null;
    static TreeSet<Transition> transitions = null;
    static UCLAPLWeight srcCost;
    static UCLAPLWeight destCost;
    static HashSet<State> Q;
    static HashSet<State> R;
    static Weight ZERO;
    static TreeMap<State, Weight> d;
    static TreeMap<State, Weight> r;
    static TreeMap<State, Weight> tmp;
    static HashSet<State> costIsNonzero;
    static State src;
    static State dest;
    static int maximumPathLength;
    static int numberOfTransitions;
    static boolean verbose;

    public static UCLAPLWeight apply(FSM A, double[] lambda, int numberOfConstraints) {
        maximumPathLength = UCLAPhonotacticLearner.MAXIMUM_PATH_LENGTH;
        initials = A.getInitials();
        finals = A.getFinals();
        transitions = A.getTransitions();
        numberOfTransitions = transitions.size();
        UCLAPLWeight ONE = UCLAPLExpectationSemiring.ONE;
        for (State q : initials) {
            costIsNonzero.add(q);
            d.put(q, ONE);
            r.put(q, ONE);
        }
        Q.clear();
        R.clear();
        Q.addAll(initials);
        for (int k = 0; k < maximumPathLength + 2; ++k) {
            for (State src : Q) {
                srcCost = (UCLAPLWeight)r.get(src);
                for (Transition t : transitions) {
                    if (!t.src.equals((Object)src)) continue;
                    dest = t.dest;
                    destCost = (UCLAPLWeight)d.get(dest);
                    if (destCost == null) {
                        destCost = new UCLAPLWeight(0.0, new double[numberOfConstraints + 10]);
                        d.put(dest, destCost);
                    } else if (TrellisBestPath4.destCost.pv.length < numberOfConstraints) {
                        TrellisBestPath4.destCost.pv = new double[numberOfConstraints + 10];
                    }
                    if (!costIsNonzero.contains(dest)) {
                        UCLAPLExpectationSemiring.extensionInto(srcCost, lambda, t.weight == null ? null : (boolean[])t.weight.value(), destCost, numberOfConstraints);
                        costIsNonzero.add(dest);
                    } else {
                        UCLAPLExpectationSemiring.summaryExtensionInto(srcCost, lambda, t.weight == null ? null : (boolean[])t.weight.value(), destCost, numberOfConstraints);
                    }
                    if (finals.contains(dest)) continue;
                    R.add(dest);
                }
            }
            Q.clear();
            Q.addAll(R);
            R.clear();
            tmp = (TreeMap)r.clone();
            r = d;
            d = tmp;
            costIsNonzero.clear();
            for (State q : finals) {
                d.put(q, r.get(q));
                costIsNonzero.add(q);
            }
            if (verbose) {
                System.out.println("sum over paths of length " + (k + 1));
                System.out.println((Object)((UCLAPLWeight)r.get(finals.iterator().next())));
            }
            if (k >= 3) continue;
            for (State q : finals) {
                d.put(q, ZERO);
                costIsNonzero.remove(q);
            }
        }
        Q.clear();
        R.clear();
        UCLAPLWeight w = null;
        for (State q : finals) {
            w = (UCLAPLWeight)d.get(q);
        }
        initials = null;
        finals = null;
        transitions = null;
        d.clear();
        r.clear();
        costIsNonzero.clear();
        return w;
    }

    public static void main(String[] args) throws Exception {
        Projection p = new Projection("test", 1, new boolean[]{true, true, true, true, false}, null);
        boolean[][] classes = new boolean[][]{{false, true, true, false, false}, {false, false, true, false, false}, {false, true, false, false, false}};
        FSM C0 = ExpectationGraphBuilder.initialGraph(5);
        FSM C1 = ConstraintCompiler3.compile(classes, 5, p);
        FSM C2 = ExpectationGraphBuilder.intersect(C0, C1, 0);
        C2.renumberStates();
        UCLAPLWeight w = TrellisBestPath4.apply(C2, new double[]{1.0}, 1);
        System.out.println((Object)w);
    }

    static {
        destCost = null;
        Q = new HashSet();
        R = new HashSet();
        ZERO = null;
        d = new TreeMap();
        r = new TreeMap();
        tmp = null;
        costIsNonzero = new HashSet();
        maximumPathLength = 10;
        numberOfTransitions = 0;
        verbose = true;
    }
}

