/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.uclapl;

public class StringKernel {
    static double lambda = 0.5;

    public static double kprime_i(int[] s, int[] t, int i) {
        int min;
        if (i == 0) {
            return 1.0;
        }
        int n = min = s.length <= t.length ? s.length : t.length;
        if (min < i) {
            return 0.0;
        }
        int[] s_ = new int[s.length - 1];
        System.arraycopy(s, 0, s_, 0, s_.length);
        int x = s[s.length - 1];
        double sum = 0.0;
        for (int j = t.length - 1; j >= 0; --j) {
            if (t[j] != x) continue;
            int[] t_ = new int[j];
            System.arraycopy(t, 0, t_, 0, t_.length);
            sum += StringKernel.kprime_i(s_, t_, i - 1) * Math.pow(lambda, t.length - (j + 1) + 2);
        }
        return lambda * StringKernel.kprime_i(s_, t, i) + sum;
    }

    public static double k_n(int[] s, int[] t, int n) {
        int min;
        int n2 = min = s.length <= t.length ? s.length : t.length;
        if (min < n) {
            return 0.0;
        }
        int[] s_ = new int[s.length - 1];
        System.arraycopy(s, 0, s_, 0, s_.length);
        int x = s[s.length - 1];
        double sum = 0.0;
        for (int j = t.length - 1; j >= 0; --j) {
            if (t[j] != x) continue;
            int[] t_ = new int[j];
            System.arraycopy(t, 0, t_, 0, t_.length);
            sum += StringKernel.kprime_i(s_, t_, n - 1) * Math.pow(lambda, 2.0);
        }
        return StringKernel.k_n(s_, t, n) + sum;
    }

    public static double k(int[] s, int[] t, double[] c) {
        double k = 0.0;
        for (int n = 1; n < c.length; ++n) {
            k += c[n] * StringKernel.k_n(s, t, n);
        }
        return k;
    }

    public static double k_normalized(int[] s, int[] t, double[] c) {
        return StringKernel.k(s, t, c) / Math.pow(StringKernel.k(s, s, c) + StringKernel.k(t, t, c), 0.5);
    }

    public static void main(String[] args) throws Exception {
        StringKernel.test();
        System.exit(1);
    }

    public static void test() {
        int[] s1 = new int[]{1, 2, 3};
        int[] s2 = new int[]{1, 2, 4};
        System.out.println(StringKernel.k(s1, s2, new double[]{0.0, 0.0, 1.0}));
        System.out.println(Math.pow(lambda, 4.0));
    }
}

