/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.uclapl;

import cern.colt.bitvector.BitVector;
import cern.colt.map.OpenIntObjectHashMap;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.jet.math.Functions;

public class SimilarityCalculator {
    private static int numberOfNaturalClasses = -1;
    private static OpenIntObjectHashMap classesToBooleanVectors_;
    private static Functions func;

    public static double[][] makeSimilarityMatrix(int numberOfSegments, OpenIntObjectHashMap classesToBooleanVectors) {
        classesToBooleanVectors_ = classesToBooleanVectors;
        numberOfNaturalClasses = classesToBooleanVectors_.size();
        BitVector bits_i = new BitVector(numberOfSegments);
        BitVector bits_j = new BitVector(numberOfSegments);
        BitVector bits_ij = new BitVector(numberOfSegments);
        DoubleMatrix2D similarityMatrix = DoubleFactory2D.dense.make(numberOfSegments, numberOfSegments);
        for (int i = 1; i < numberOfSegments; ++i) {
            for (int j = i; j < numberOfSegments; ++j) {
                if (j == i) {
                    similarityMatrix.set(i, j, 1.0);
                } else {
                    bits_i.clear();
                    bits_i.set(i);
                    bits_j.clear();
                    bits_j.set(j);
                    bits_ij.clear();
                    bits_ij.set(i);
                    bits_ij.set(j);
                    similarityMatrix.set(i, j, SimilarityCalculator.numberOfClassesContaining(bits_ij) / (SimilarityCalculator.numberOfClassesContaining(bits_i) + SimilarityCalculator.numberOfClassesContaining(bits_j)));
                }
                similarityMatrix.set(j, i, similarityMatrix.get(i, j));
            }
        }
        similarityMatrix.viewRow(0).assign(0.0);
        similarityMatrix.viewColumn(0).assign(0.0);
        similarityMatrix.set(0, 0, 1.0);
        return similarityMatrix.toArray();
    }

    private static double numberOfClassesContaining(BitVector segments) {
        boolean[] naturalClass = null;
        double n = 0.0;
        for (int i = 0; i < numberOfNaturalClasses; ++i) {
            naturalClass = (boolean[])classesToBooleanVectors_.get(i);
            if (!SimilarityCalculator.subsetOf(segments, naturalClass)) continue;
            n += 1.0;
        }
        return n;
    }

    private static boolean subsetOf(BitVector S, boolean[] G) {
        for (int i = 0; i < S.size(); ++i) {
            if (!S.get(i) || G[i]) continue;
            return false;
        }
        return true;
    }

    static {
        func = Functions.functions;
    }
}

