/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.uclapl;

import cern.colt.map.OpenIntObjectHashMap;
import edu.ucla.uclapl.ArrayPrinter;
import edu.ucla.uclapl.UCLAPhonotacticLearner;
import java.util.Arrays;
import java.util.LinkedList;

public class MapNaturalClassesToSegments {
    public static void makeMap(LinkedList naturalClasses, String[] segments, String[][] features, OpenIntObjectHashMap classesToSegments, OpenIntObjectHashMap classesToBooleanVectors) {
        int i;
        String[] naturalClass = null;
        LinkedList<String> segmentList = new LinkedList<String>();
        String seg = null;
        String[] ftrs = null;
        String[] segmentArray = null;
        boolean[] segmentVector = null;
        for (i = 0; i < naturalClasses.size(); ++i) {
            naturalClass = (String[])naturalClasses.get(i);
            segmentList.clear();
            segmentVector = new boolean[segments.length];
            for (int j = 0; j < segments.length; ++j) {
                seg = segments[j];
                ftrs = features[j];
                if (!MapNaturalClassesToSegments.subsumes(naturalClass, ftrs)) continue;
                segmentList.add(seg);
                segmentVector[j] = true;
            }
            segmentArray = new String[segmentList.size()];
            for (int k = segmentList.size() - 1; k >= 0; --k) {
                segmentArray[k] = (String)segmentList.get(k);
            }
            classesToSegments.put(i, (Object)segmentArray);
            classesToBooleanVectors.put(i, (Object)segmentVector);
        }
        for (i = 0; i < naturalClasses.size(); ++i) {
            naturalClass = (String[])naturalClasses.get(i);
            segmentArray = (String[])classesToSegments.get(i);
            segmentVector = (boolean[])classesToBooleanVectors.get(i);
            System.out.println("size of the natural class: " + MapNaturalClassesToSegments.size(segmentVector));
            System.out.print(ArrayPrinter.printSpecifiedFeatures(naturalClass, UCLAPhonotacticLearner.tiers));
            System.out.println(" -> " + ArrayPrinter.print(segmentArray) + " (" + cern.colt.Arrays.toString((boolean[])segmentVector) + ")");
        }
    }

    public static void makeComplementMap(LinkedList naturalClasses, String[] segments, String[][] features, OpenIntObjectHashMap classesToSegments, OpenIntObjectHashMap classesToBooleanVectors) {
        int i;
        LinkedList<String[]> complementNaturalClasses = new LinkedList<String[]>();
        String[] naturalClass = null;
        String[] complementClass = null;
        LinkedList<String> segmentList = new LinkedList<String>();
        String seg = null;
        String[] ftrs = null;
        int offset = naturalClasses.size();
        int index = 0;
        Object[] segmentArray = null;
        boolean[] segmentVector = null;
        block0: for (i = 0; i < naturalClasses.size(); ++i) {
            int j;
            naturalClass = (String[])naturalClasses.get(i);
            if (!naturalClass[0].equals(".")) continue;
            complementClass = new String[naturalClass.length];
            System.arraycopy(naturalClass, 0, complementClass, 0, naturalClass.length);
            for (j = 0; j < naturalClass.length; ++j) {
                if (naturalClass[j].equals(".")) continue;
                complementClass[j] = "^" + complementClass[j];
                break;
            }
            segmentList.clear();
            segmentVector = new boolean[segments.length];
            for (j = 0; j < segments.length; ++j) {
                seg = segments[j];
                ftrs = features[j];
                if (MapNaturalClassesToSegments.subsumes(naturalClass, ftrs) || seg.equals("#")) continue;
                segmentList.add(seg);
                segmentVector[j] = true;
            }
            if (segmentList.size() == 0) continue;
            segmentArray = new String[segmentList.size()];
            for (int k = segmentList.size() - 1; k >= 0; --k) {
                segmentArray[k] = (String)segmentList.get(k);
            }
            for (j = 0; j < naturalClasses.size(); ++j) {
                Object[] segmentArray2 = (String[])classesToSegments.get(j);
                if (Arrays.equals(segmentArray, segmentArray2)) continue block0;
            }
            complementNaturalClasses.add(complementClass);
            classesToSegments.put(offset + index, (Object)segmentArray);
            classesToBooleanVectors.put(offset + index, (Object)segmentVector);
            ++index;
        }
        System.out.println("number of complement natural classes: " + complementNaturalClasses.size());
        naturalClasses.addAll(complementNaturalClasses);
        for (i = offset; i < naturalClasses.size(); ++i) {
            naturalClass = (String[])naturalClasses.get(i);
            segmentArray = (String[])classesToSegments.get(i);
            segmentVector = (boolean[])classesToBooleanVectors.get(i);
            System.out.println("size of the natural class: " + MapNaturalClassesToSegments.size(segmentVector));
            System.out.print(ArrayPrinter.printSpecifiedFeatures(naturalClass, UCLAPhonotacticLearner.tiers));
            System.out.println(" -> " + ArrayPrinter.print((String[])segmentArray) + " (" + cern.colt.Arrays.toString((boolean[])segmentVector) + ")");
        }
    }

    public static boolean[] map(String[] naturalClass, String[] segments, String[][] features) {
        boolean[] segmentVector = new boolean[segments.length];
        for (int i = features.length - 1; i >= 0; --i) {
            if (!MapNaturalClassesToSegments.subsumes(naturalClass, features[i])) continue;
            segmentVector[i] = true;
        }
        return segmentVector;
    }

    private static boolean subsumes(String[] x, String[] y) {
        if ((x[0].equals("+") || y[0].equals("+")) && !x[0].equals(y[0])) {
            return false;
        }
        if (x[0].equals("+") && y[0].equals("+")) {
            return true;
        }
        for (int i = 1; i < x.length; ++i) {
            if (x[i].equals(".") || x[i].equals(y[i])) continue;
            return false;
        }
        return true;
    }

    private static int size(boolean[] array) {
        int size = 0;
        for (int i = array.length - 1; i >= 0; --i) {
            if (!array[i]) continue;
            ++size;
        }
        return size;
    }
}

