/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.uclapl;

import cern.jet.stat.Probability;
import edu.ucla.uclapl.UCLAPhonotacticLearner;

public class LowerConfidenceLimit {
    static double ALPHA = 0.9;
    static double OBSERVED_SMOOTH = UCLAPhonotacticLearner.SMOOTH;

    public static double valueOf(double observed, int corpus_size, double expected, int sample_size) {
        double O = observed + OBSERVED_SMOOTH;
        double E = expected * (double)corpus_size / (double)sample_size;
        if (O >= E || E == 0.0) {
            return 1.0;
        }
        double p_star = O / E;
        return p_star;
    }

    public static double valueOf(double observed, int corpus_size, double expected, int sample_size, double scope) {
        System.out.println(observed + ", " + corpus_size + ", " + expected + ", " + sample_size + ", " + scope);
        double O = observed + OBSERVED_SMOOTH;
        double E = expected * (double)corpus_size / (double)sample_size;
        if (O >= E || E == 0.0) {
            return 1.0;
        }
        double p_star = O / E;
        int n = (int)Math.floor(scope);
        double pi_L = Math.pow(p_star * (1.0 - p_star) / (double)n, 0.5);
        pi_L *= Probability.studentTInverse((double)ALPHA, (int)(n - 1));
        pi_L = p_star - pi_L;
        return pi_L;
    }

    public static void main(String[] args) throws Exception {
        double observed = Double.valueOf(args[0]);
        int corpus_size = Integer.valueOf(args[1]);
        double expected = Double.valueOf(args[2]);
        int sample_size = Integer.valueOf(args[3]);
        double scope = Double.valueOf(args[4]);
        System.out.println(LowerConfidenceLimit.valueOf(observed, corpus_size, expected, sample_size, scope));
    }
}

