/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.uclapl;

import cern.colt.matrix.DoubleMatrix1D;
import edu.ucla.uclapl.RandomField;
import java.util.Arrays;

public class GradientDescent {
    static int dim = 0;
    static int maxIterations = 1;
    static double stepSizeInit = 1.0;
    static double eta = 0.1;
    static double val = 0.0;
    static double[] stepSize = null;
    static double[] weights = null;
    static double[] gradient = null;
    static double[] oldGradient = null;
    static boolean converged = false;
    static double[] cumulativeGradient = null;

    public static void optimize(RandomField RF, DoubleMatrix1D lambda, double tol) {
        weights = lambda.toArray();
        dim = weights.length;
        double[] stepSize = new double[dim];
        Arrays.fill(stepSize, stepSizeInit);
        oldGradient = new double[dim];
        gradient = new double[dim];
        boolean reps = false;
        for (int iter = maxIterations - 1; iter >= 0; --iter) {
            RF.computeGradient(weights, gradient);
            for (int k = 0; k < dim; ++k) {
                int n = k;
                double d = weights[n] = weights[n] - eta * gradient[k];
                val = d;
                if (val < RF.getLowerBound(k)) {
                    GradientDescent.weights[k] = RF.getLowerBound(k);
                    continue;
                }
                if (!(val > RF.getUpperBound(k))) continue;
                GradientDescent.weights[k] = RF.getUpperBound(k);
            }
        }
        RF.lambda.assign(weights);
    }
}

