/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.uclapl;

import cern.colt.matrix.DoubleMatrix1D;
import cern.jet.math.Functions;
import edu.ucla.uclapl.Regularizer;

public class GaussianRegularizer
implements Regularizer {
    private static final double PI = Math.PI;
    public double MU = 0.0;
    public double SIGMA2 = 1.0;
    private double SIGMA = 1.0;
    public static Functions functions = Functions.functions;

    GaussianRegularizer(double mu, double sigma2) {
        this.MU = mu;
        this.SIGMA2 = sigma2;
        this.SIGMA = Math.pow(this.SIGMA2, -2.0);
        System.out.println("Gaussian regularizer: mu=" + mu + " sigma^2=" + sigma2);
    }

    @Override
    public double logValue(DoubleMatrix1D lambda) {
        double logVal = 0.0;
        double c = Math.log(1.0 / (Math.pow(Math.PI * 2, -2.0) * this.SIGMA));
        for (int i = 0; i < lambda.size(); ++i) {
            logVal += c - Math.pow(lambda.get(i) - this.MU, 2.0) / (2.0 * this.SIGMA2);
        }
        return logVal;
    }

    @Override
    public DoubleMatrix1D grad(DoubleMatrix1D lambda) {
        DoubleMatrix1D reg = lambda.copy();
        reg.assign(Functions.minus((double)this.MU));
        reg.assign(Functions.div((double)this.SIGMA2));
        return reg;
    }
}

