/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.uclapl;

import edu.ucla.fsm.FSM;
import edu.ucla.fsm.State;
import edu.ucla.fsm.Transition;
import edu.ucla.uclapl.Projection;
import edu.ucla.uclapl.UCLAPhonotacticLearner;
import java.util.Arrays;
import java.util.TreeMap;
import java.util.TreeSet;

public class FlatMsgFSM
extends FSM {
    static TreeMap<State, State> states = new TreeMap();
    public double[] O = null;
    public double[] E = null;

    public FlatMsgFSM() {
    }

    public FlatMsgFSM(Projection projection, int numberOfNaturalClasses) {
        int i;
        System.out.println("Making msg graph for projection " + projection.name);
        states.clear();
        this.initials = new TreeSet();
        this.finals = null;
        this.transitions = new TreeSet();
        State q = null;
        State r = null;
        Object segments_ = null;
        boolean[] segments1 = null;
        boolean[] segments2 = null;
        this.O = new double[numberOfNaturalClasses];
        this.E = new double[numberOfNaturalClasses];
        int[] classSize = UCLAPhonotacticLearner.naturalClassSizes[projection.index];
        block0: for (i = 0; i < UCLAPhonotacticLearner.minimalNaturalClasses.size(); ++i) {
            int tmp = UCLAPhonotacticLearner.minimalNaturalClasses.get(i);
            segments1 = (boolean[])UCLAPhonotacticLearner.classesToBooleanVectors.get(tmp);
            for (int j = 0; j < segments1.length; ++j) {
                if (!segments1[j] || !projection.visible[j]) continue;
                q = FlatMsgFSM.intern(new State(tmp));
                this.initials.add(q);
                continue block0;
            }
        }
        for (i = 1; i < numberOfNaturalClasses; ++i) {
            if (!projection.naturalClasses[i] || UCLAPhonotacticLearner.minimalNaturalClasses.contains(i)) continue;
            r = FlatMsgFSM.intern(new State(i));
            segments1 = (boolean[])UCLAPhonotacticLearner.classesToBooleanVectors.get(i);
            for (State q1 : this.initials) {
                int tmp = q1.id();
                segments2 = (boolean[])UCLAPhonotacticLearner.classesToBooleanVectors.get(tmp);
                if (!FlatMsgFSM.subsumes(segments1, segments2, projection)) continue;
                this.transitions.add(new Transition(q1, null, null, null, r));
            }
        }
        System.out.println("digraph G");
        System.out.println("{");
        System.out.println("node [shape = circle]");
        for (Transition t : this.transitions) {
            System.out.println(t);
        }
        System.out.println("}");
        System.out.println("number of transitions: " + this.transitions.size());
    }

    public void reset() {
        Arrays.fill(this.O, 0.0);
        Arrays.fill(this.E, 0.0);
    }

    public void pass() {
        for (Transition t : this.transitions) {
            int n = t.dest.id();
            this.O[n] = this.O[n] + this.O[t.src.id()];
            int n2 = t.dest.id();
            this.E[n2] = this.E[n2] + this.E[t.src.id()];
        }
    }

    private static int size(boolean[] segments, Projection projection) {
        int size = 0;
        for (int i = segments.length - 1; i >= 0; --i) {
            if (!projection.visible[i] || !segments[i]) continue;
            ++size;
        }
        return size;
    }

    private static boolean subsumes(boolean[] segments1, boolean[] segments2, Projection projection) {
        for (int i = segments1.length - 1; i >= 0; --i) {
            if (!projection.visible[i] || !segments2[i] || segments1[i]) continue;
            return false;
        }
        return true;
    }

    private static void mask(boolean[] segments2, boolean[] segments1, Projection projection) {
        for (int i = segments2.length - 1; i >= 0; --i) {
            if (!projection.visible[i] || !segments2[i]) continue;
            segments1[i] = false;
        }
    }

    private static State intern(State q) {
        if (states.containsKey(q)) {
            return states.get(q);
        }
        states.put(q, q);
        return q;
    }
}

