/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.uclapl;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.jet.math.Functions;
import edu.ucla.uclapl.Regularizer;

public class ExponentialRegularizer
implements Regularizer {
    private double ALPHA = 1.0;
    public static Functions functions = Functions.functions;

    ExponentialRegularizer(double alpha) {
        this.ALPHA = alpha;
        System.out.println("Exponential regularizer: alpha=" + alpha);
    }

    @Override
    public double logValue(DoubleMatrix1D lambda) {
        double logVal = 0.0;
        double logAlpha = Math.log(this.ALPHA);
        for (int i = 0; i < lambda.size(); ++i) {
            logVal += logAlpha - this.ALPHA * lambda.get(i);
        }
        return logVal;
    }

    @Override
    public DoubleMatrix1D grad(DoubleMatrix1D lambda) {
        DoubleMatrix1D reg = DoubleFactory1D.dense.make(lambda.size());
        reg.assign(-this.ALPHA);
        return reg;
    }
}

