/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.uclapl;

import cern.colt.Arrays;
import edu.ucla.fsm.BooleanArrayWeight;
import edu.ucla.fsm.FSM;
import edu.ucla.fsm.IntegerLabel;
import edu.ucla.fsm.Label;
import edu.ucla.fsm.State;
import edu.ucla.fsm.Transition;
import edu.ucla.fsm.Weight;
import edu.ucla.uclapl.ExpectationGraphBuilder;
import edu.ucla.uclapl.History;
import edu.ucla.uclapl.Projection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.TreeSet;

public class ConstraintCompiler3 {
    static TreeMap<State, State> states = new TreeMap();
    static int M = 0;
    static int N = 0;
    static boolean[][] c = null;
    static boolean[] star = new boolean[]{true};
    static boolean[] visible = null;
    static TreeSet<State> initials = null;
    static TreeSet<State> finals = null;
    static TreeSet<Transition> transitions = null;
    static int verbosity = 0;

    public static FSM compile(boolean[][] classes, int numberOfSegments, Projection projection) {
        M = classes.length;
        N = numberOfSegments;
        c = classes;
        visible = projection.visible;
        states.clear();
        initials = new TreeSet();
        finals = new TreeSet();
        transitions = new TreeSet();
        ConstraintCompiler3.build();
        FSM C = new FSM(initials, finals, transitions);
        C.prune();
        if (verbosity > 5) {
            System.out.println();
            System.out.println("compiled constraint:");
            System.out.println(C);
        }
        return C;
    }

    private static void build() {
        if (verbosity > 5) {
            System.out.println("build()");
        }
        Object v = null;
        int stateCounter = 0;
        State q0 = ConstraintCompiler3.intern(new State(stateCounter));
        State qf = ConstraintCompiler3.intern(new State(++stateCounter));
        State q = null;
        State r = null;
        History history = null;
        initials.add(q0);
        finals.add(qf);
        q = ConstraintCompiler3.intern(new State(++stateCounter));
        history = new History();
        history = ConstraintCompiler3.delta(history, ConstraintCompiler3.codeword(0));
        System.out.println();
        HashMap<State, History> M1 = new HashMap<State, History>();
        M1.put(q, history);
        HashMap<History, State> M2 = new HashMap<History, State>();
        M2.put(history, q);
        transitions.add(new Transition(q0, (Label)new IntegerLabel(0), null, null, q));
        LinkedList<State> S = new LinkedList<State>();
        S.add(q);
        HashSet<State> P = new HashSet<State>();
        while (!S.isEmpty()) {
            q = (State)S.remove(0);
            P.add(q);
            for (int j = 0; j < N; ++j) {
                if (!visible[j]) continue;
                v = ConstraintCompiler3.violates((History)M1.get(q), j) ? star : null;
                if (j == 0) {
                    r = qf;
                } else {
                    history = ConstraintCompiler3.delta((History)M1.get(q), ConstraintCompiler3.codeword(j));
                    if (M2.containsKey(history)) {
                        r = (State)M2.get(history);
                    } else {
                        r = ConstraintCompiler3.intern(new State(++stateCounter));
                        M2.put(history, r);
                        M1.put(r, history);
                    }
                }
                transitions.add(new Transition(q, (Label)new IntegerLabel(j), null, (Weight)new BooleanArrayWeight(v), r));
                if (P.contains(r) || S.contains(r) || r == qf) continue;
                S.add(r);
            }
        }
        for (State q1 : P) {
            if (q1.equals((Object)q0) || q1.equals((Object)qf)) continue;
            for (int j = 0; j < N; ++j) {
                if (visible[j]) continue;
                transitions.add(new Transition(q1, (Label)new IntegerLabel(j), null, null, q1));
            }
        }
    }

    private static boolean violates(History history, int j) {
        int[] h = history.value;
        if (M > 1 && (h == null || h.length < M - 1)) {
            return false;
        }
        if (!c[M - 1][j]) {
            return false;
        }
        for (int i = 0; i < M - 1; ++i) {
            if (ConstraintCompiler3.bit(h[i], i) != 0) continue;
            return false;
        }
        return true;
    }

    private static int[] push(int[] h, int w) {
        if (h == null) {
            return new int[]{w};
        }
        int hlen = h.length;
        int glen = hlen + 1;
        if (glen > M - 1) {
            --glen;
        }
        int[] g = new int[glen];
        int hindex = hlen < M - 1 ? 0 : 1;
        int gindex = 0;
        while (gindex < glen - 1) {
            g[gindex++] = h[hindex++];
        }
        g[glen - 1] = w;
        return g;
    }

    private static History delta(History h, int w) {
        int k;
        int[] g = ConstraintCompiler3.push(h.value, w);
        int len = g.length;
        if (verbosity > 5) {
            System.out.println("(" + h + "," + w + ") -> " + Arrays.toString((int[])g));
        }
        int m = 0;
        block0: for (k = 0; k < len; ++k) {
            m = 0;
            for (int l = k; l < len; ++l) {
                if (ConstraintCompiler3.bit(g[l], m) == 0) {
                    continue block0;
                }
                ++m;
            }
        }
        History history = null;
        if (k == len) {
            history = new History();
        } else {
            int[] g_ = new int[len - k];
            System.arraycopy(g, k, g_, 0, len - k);
            history = new History(g_);
        }
        if (verbosity > 5) {
            System.out.println("(" + h + "," + w + ") -> " + history);
        }
        return history;
    }

    private static int codeword(int j) {
        int w = 0;
        for (int i = M - 2; i >= 0; --i) {
            w *= 10;
            if (!c[i][j]) continue;
            ++w;
        }
        return w;
    }

    private static int bit(int w, int i) {
        String tmp = String.valueOf(w);
        int len = tmp.length();
        if (len < i + 1) {
            return 0;
        }
        String val = tmp.substring(len - (i + 1), len - i);
        return val.equals("0") ? 0 : 1;
    }

    private static State intern(State q) {
        if (states.containsKey(q)) {
            return states.get(q);
        }
        states.put(q, q);
        return q;
    }

    public static void main(String[] args) throws Exception {
        int test = 0;
        if (args.length > 0) {
            test = Integer.parseInt(args[0]);
        }
        Projection p = new Projection("test", 1, new boolean[]{true, true, true, true, false}, null);
        boolean[][] classes = new boolean[3][];
        if (test == 0) {
            classes[0] = new boolean[]{false, true, true, false, false};
            classes[1] = new boolean[]{false, false, true, true, false};
            classes[2] = new boolean[]{true, false, false, false, false};
        }
        if (test == 1) {
            classes[0] = new boolean[]{true, false, false, false, false};
            classes[1] = new boolean[]{false, false, true, true, false};
            classes[2] = new boolean[]{false, true, false, true, false};
        }
        if (test == 2) {
            classes[0] = new boolean[]{false, true, true, false, false};
            classes[1] = new boolean[]{false, false, true, false, false};
            classes[2] = new boolean[]{false, true, false, false, false};
        }
        if (test == 3) {
            classes[0] = new boolean[]{true, false, false, false, false};
            classes[1] = new boolean[]{false, true, true, true, true};
            classes[2] = new boolean[]{true, false, false, false, false};
        }
        if (test == 4) {
            classes[0] = new boolean[]{false, true, true, false, false};
            classes[1] = new boolean[]{false, false, true, true, false};
            classes[2] = new boolean[]{false, true, false, true, false};
        }
        if (test == 5) {
            classes = new boolean[][]{{false, true, false, true, false}};
        }
        if (test == 6) {
            classes = new boolean[][]{{true, true, true, false, false}, {false, false, true, true, false}};
        }
        FSM C0 = ExpectationGraphBuilder.initialGraph(5);
        FSM C1 = ConstraintCompiler3.compile(classes, 5, p);
        System.out.println(C1);
        FSM C2 = ExpectationGraphBuilder.intersect(C0, C1, 0);
        C2.renumberStates();
        System.out.println(C2);
    }
}

