/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.uclapl;

import java.util.HashMap;
import java.util.LinkedList;

public class CommandLineOptions {
    HashMap options = new HashMap();
    HashMap optionDescriptions = new HashMap();
    LinkedList keys = new LinkedList();
    String[] arguments;

    CommandLineOptions(String[] args) {
        this.arguments = args;
    }

    public void addOption(String longName, boolean requiresArgument, String description) {
        String dashLongName = "-" + longName;
        for (int i = 0; i < this.arguments.length; ++i) {
            if (!this.arguments[i].equals(dashLongName)) continue;
            if (!requiresArgument) {
                this.options.put(longName, new Integer(-1));
                continue;
            }
            if (i + 1 < this.arguments.length) {
                this.options.put(longName, this.arguments[i + 1]);
                continue;
            }
            System.err.println("Error: No argument after option " + dashLongName);
        }
        this.keys.addLast(dashLongName);
        this.optionDescriptions.put(dashLongName, description);
    }

    public void addOption(String shortName, String longName, boolean requiresArgument, String description) {
        String dashShortName = "-" + shortName;
        String dashLongName = "-" + longName;
        for (int i = 0; i < this.arguments.length; ++i) {
            if (!this.arguments[i].equals(dashShortName) && !this.arguments[i].equals(dashLongName)) continue;
            if (!requiresArgument) {
                this.options.put(longName, new Integer(-1));
                continue;
            }
            if (i + 1 < this.arguments.length) {
                this.options.put(longName, this.arguments[i + 1]);
                continue;
            }
            System.err.println("Error: No argument after option " + dashLongName);
        }
        String dashCombinedName = "-" + shortName + "[" + longName.substring(longName.indexOf(shortName) + 1, longName.length()) + "]";
        this.keys.addLast(dashCombinedName);
        this.optionDescriptions.put(dashCombinedName, description);
    }

    public boolean isSet(String name) {
        return this.options.containsKey(name);
    }

    public String getOption(String name) {
        if (!this.isSet(name)) {
            return "";
        }
        return (String)this.options.get(name);
    }

    public String toString() {
        String rep = "";
        for (int i = 0; i < this.keys.size(); ++i) {
            rep = rep + " " + (String)this.keys.get(i) + "\t" + this.optionDescriptions.get((String)this.keys.get(i)) + "\n";
        }
        return rep;
    }
}

