/*
 * Decompiled with CFR 0.152.
 */
public class UpdatableIntTrie_stable {
    int maxGramSize = 0;
    int timestamp = 0;
    Node rt = null;

    UpdatableIntTrie_stable(int m) {
        this.maxGramSize = m;
        this.timestamp = 0;
        this.rt = new Node(-1);
    }

    public void incrementTimestamp() {
        ++this.timestamp;
    }

    public void incrementSubsequences(int[] config, int start, int end) {
        int configLength = config.length;
        if (start < 0 || start > end || end > configLength) {
            System.out.println("Incorrect bounds for incrementSubsequences()");
            System.exit(1);
        }
        Node current = null;
        for (int i = 0; i < end; ++i) {
            current = this.rt;
            for (int j = i; j < i + this.maxGramSize && j < end; ++j) {
                current = this.getNode(current, config[j], true);
                if (current.timestamp == this.timestamp) {
                    ++current.count;
                    continue;
                }
                current.count = 1;
                current.timestamp = this.timestamp;
            }
        }
    }

    public void incrementSequence(int[] config, int start, int end) {
        int configLength = config.length;
        if (start < 0 || start > end || end > configLength) {
            System.out.println("Incorrect bounds for incrementSubsequences()");
            System.exit(1);
        }
        Node current = this.rt;
        for (int i = 0; i < end; ++i) {
            current = this.getNode(current, config[i], true);
            if (i != end - 1) continue;
            if (current.timestamp == this.timestamp) {
                ++current.count;
                continue;
            }
            current.count = 1;
            current.timestamp = this.timestamp;
        }
    }

    public int count(int[] config, int start, int end) {
        int configLength = config.length;
        if (start < 0 || start > end || end > configLength || end - start > this.maxGramSize) {
            System.out.println("Incorrect bounds for count(): start=" + start + ", end=" + end);
            System.exit(1);
        }
        Node current = this.rt;
        for (int i = start; i < end; ++i) {
            if ((current = this.getNode(current, config[i], false)) != null) continue;
            return 0;
        }
        return current.timestamp == this.timestamp ? current.count : 0;
    }

    public int count(int[] config, int start, int end, boolean[] terminals) {
        int configLength = config.length;
        if (start < 0 || start > end || end > configLength || end - start > this.maxGramSize) {
            System.out.println("Incorrect bounds for count(): start=" + start + ", end=" + end);
            System.exit(1);
        }
        Node current = this.rt;
        for (int i = start; i < end; ++i) {
            if ((current = this.getNode(current, config[i], false)) != null) continue;
            return 0;
        }
        int count = 0;
        current = current.dtr;
        while (current != null) {
            if (terminals[current.key] && current.timestamp == this.timestamp) {
                count += current.count;
            }
            current = current.sib;
        }
        return count;
    }

    public Node getNode(Node mtr, int key, boolean addFlag) {
        Node previous = null;
        Node current = null;
        current = mtr.dtr;
        while (current != null) {
            if (current.key == key) {
                return current;
            }
            if (current.key > key) break;
            previous = current;
            current = current.sib;
        }
        if (addFlag) {
            current = new Node(key);
            if (previous == null) {
                current.sib = mtr.dtr;
                mtr.dtr = current;
            } else {
                current.sib = previous.sib;
                previous.sib = current;
            }
            return current;
        }
        return null;
    }

    public void prune() {
        this.prune(this.rt);
    }

    private void prune(Node mtr) {
        Node previous = null;
        Node current = mtr.dtr;
        while (current != null) {
            if (current.timestamp != this.timestamp) {
                if (previous == null) {
                    mtr.dtr = current.sib;
                    current = null;
                    current = mtr.dtr;
                } else {
                    previous.sib = current.sib;
                    current = null;
                    current = previous.sib;
                }
            } else {
                this.prune(current);
            }
            previous = current;
        }
    }

    public String toString() {
        this.rt.toString(0);
        return "";
    }

    public static void main(String[] args) throws Exception {
        UpdatableIntTrie_stable gramCount = new UpdatableIntTrie_stable(3);
        gramCount.incrementTimestamp();
        int[] word1 = new int[]{0, 1, 2, 3, 4, 5, 0};
        int[] word2 = new int[]{0, 5, 4, 3, 2, 1, 0};
        gramCount.incrementSubsequences(word1, 0, word1.length);
        gramCount.incrementSubsequences(word1, 0, word1.length);
        gramCount.incrementSubsequences(word2, 0, word2.length);
        gramCount.toString();
        int[] prob1 = new int[]{2, 3, 4};
        int[] prob2 = new int[]{3, 2, 4};
        System.out.println("count of prob1: " + gramCount.count(prob1, 0, prob1.length));
        System.out.println("count of prob2: " + gramCount.count(prob2, 0, prob2.length));
    }

    class Node {
        int key = 0;
        int count = 0;
        int timestamp = 0;
        Node sib = null;
        Node dtr = null;

        Node(int k) {
            this.key = k;
            this.count = 0;
            this.timestamp = 0;
            this.sib = null;
            this.dtr = null;
        }

        public String toString() {
            return new String(this.key + ", " + this.count + " (at=" + this.timestamp + ")");
        }

        public String toString(int depth) {
            for (int i = 0; i < depth; ++i) {
                System.out.print("\t");
            }
            System.out.println(this.key + ", " + this.count + " (at=" + this.timestamp + ")");
            if (this.dtr != null) {
                this.dtr.toString(depth + 1);
            }
            if (this.sib != null) {
                this.sib.toString(depth);
            }
            return "";
        }
    }
}

