/*
 * Decompiled with CFR 0.152.
 */
import cern.colt.bitvector.BitVector;
import edu.ucla.fsm.Weight;
import java.util.Arrays;

public class UCLAPLWeight
extends Weight {
    public static int numberOfConstraints;
    double p = 0.0;
    double[] pv = null;

    UCLAPLWeight(double p_, BitVector v, int len) {
        this.p = p_;
        this.pv = new double[len];
        for (int i = len - 1; i >= 0; --i) {
            if (!v.get(i)) continue;
            this.pv[i] = this.p;
        }
    }

    UCLAPLWeight(double p_, boolean[] v, int len) {
        this.p = p_;
        if (v != null) {
            this.pv = new double[len];
            for (int i = len - 1; i >= 0; --i) {
                if (v.length <= i || !v[i]) continue;
                this.pv[i] = this.p;
            }
        } else {
            this.pv = null;
        }
    }

    UCLAPLWeight(double p_, double[] pv_) {
        this.p = p_;
        this.pv = pv_;
    }

    public Object value() {
        return null;
    }

    public int compareTo(Object o) {
        return 0;
    }

    public UCLAPLWeight copy() {
        UCLAPLWeight w = new UCLAPLWeight(this.p, new double[this.pv.length]);
        System.arraycopy(this.pv, 0, w.pv, 0, this.pv.length);
        return w;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof UCLAPLWeight)) {
            return false;
        }
        UCLAPLWeight w = (UCLAPLWeight)((Object)o);
        if (w.p != this.p) {
            return false;
        }
        return Arrays.equals(this.pv, w.pv);
    }

    public int hashCode() {
        int hash = 7;
        hash = (int)((double)hash + 7.0 * Math.floor(this.p));
        if (this.pv != null) {
            for (int i = this.pv.length - 1; i >= 0; --i) {
                hash = (int)((double)hash + 7.0 * Math.floor(this.pv[i]));
            }
        }
        return hash;
    }

    public String toString() {
        StringBuffer rep = new StringBuffer();
        rep.append("(");
        rep.append(this.p);
        rep.append(", ");
        if (this.pv != null) {
            rep.append(cern.colt.Arrays.toString((double[])this.pv));
        } else {
            rep.append(this.pv);
        }
        rep.append(")");
        return rep.toString();
    }
}

