/*
 * Decompiled with CFR 0.152.
 */
import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import java.util.Arrays;

public class TierFeature
extends RandomFieldFeature {
    public static int[] unigramSeg = new int[1];
    public static int[] bigramSegs = new int[2];
    public static int[] trigramSegs = new int[3];
    public static int[] tetragramSegs = new int[4];
    public int gramSize;
    public int[] naturalClassIndex;
    public Projection projection;
    public String[][] naturalClass;
    public boolean[][] segments;
    public DoubleMatrix1D conditionalScore;
    public DoubleMatrix1D conditionalScoreWordBoundary;

    TierFeature() {
    }

    TierFeature(int[] index, Projection proj) {
        this.naturalClassIndex = index;
        this.gramSize = this.naturalClassIndex.length;
        this.projection = proj;
        this.naturalClass = new String[this.gramSize][];
        this.segments = new boolean[this.gramSize][];
        this.sizeOfStructuralDescription = 0;
        this.generality = 0.0;
        StringBuffer hashRep = new StringBuffer();
        for (int i = this.gramSize - 1; i >= 0; --i) {
            this.naturalClass[i] = (String[])UCLAPhonotacticLearner.naturalClasses.get(index[i]);
            this.segments[i] = (boolean[])UCLAPhonotacticLearner.classesToBooleanVectors.get(index[i]);
            this.sizeOfStructuralDescription += UCLAPhonotacticLearner.specifiedFeatures(this.naturalClass[i]);
            hashRep.append(this.naturalClassIndex[i]);
            hashRep.append(",");
        }
        hashRep.append(this.projection.index);
        this.hashRepresentation = hashRep.toString();
        this.generality = TierFeature.generality(index, proj.index);
    }

    TierFeature(int[] index, int projectionIndex) {
        this(index, UCLAPhonotacticLearner.projections[projectionIndex]);
    }

    @Override
    public double evaluate(int[] config) {
        return TierFeature.evaluate(config, this.segments, this.gramSize, this.projection);
    }

    public static double evaluate(int[] config, boolean[][] segments, int gramSize, Projection proj) {
        if (gramSize == 1) {
            return TierFeature.evaluateUnigram(config, segments, proj);
        }
        if (gramSize == 2) {
            return TierFeature.evaluateBigram(config, segments, proj);
        }
        if (gramSize == 3) {
            return TierFeature.evaluateTrigram(config, segments, proj);
        }
        if (gramSize == 4) {
            return TierFeature.evaluateTetragram(config, segments, proj);
        }
        System.out.println("Gram size too big; failed at evaluate()");
        System.exit(1);
        return -1.0;
    }

    private static double evaluateUnigram(int[] config, boolean[][] segments, Projection proj) {
        double score = 0.0;
        int max = config.length;
        int currentSegment = -1;
        for (int i = 0; i < max && (currentSegment = config[i]) != -1; ++i) {
            if (!proj.visible[currentSegment] || !segments[0][currentSegment]) continue;
            score += 1.0;
        }
        return score;
    }

    private static double evaluateBigram(int[] config, boolean[][] segments, Projection proj) {
        double score = 0.0;
        int max = config.length;
        int currentSegment = -1;
        boolean seenLeftContext = false;
        for (int i = 0; i < max && (currentSegment = config[i]) != -1; ++i) {
            if (!proj.visible[currentSegment]) continue;
            if (seenLeftContext && segments[1][currentSegment]) {
                score += 1.0;
            }
            seenLeftContext = segments[0][currentSegment];
        }
        return score;
    }

    private static double evaluateTrigram(int[] config, boolean[][] segments, Projection proj) {
        double score = 0.0;
        int max = config.length;
        int currentSegment = -1;
        boolean seenLeftContext = false;
        boolean seenMedialContext = false;
        for (int i = 0; i < max && (currentSegment = config[i]) != -1; ++i) {
            if (!proj.visible[currentSegment]) continue;
            if (seenMedialContext && segments[2][currentSegment]) {
                score += 1.0;
            }
            seenMedialContext = seenLeftContext && segments[1][currentSegment];
            try {
                if (segments[0][currentSegment]) {
                    seenLeftContext = true;
                    continue;
                }
                seenLeftContext = false;
                continue;
            }
            catch (Exception e) {
                System.out.println(UCLAPhonotacticLearner.printConfiguration(config));
            }
        }
        return score;
    }

    private static double evaluateTetragram(int[] config, boolean[][] segments, Projection proj) {
        double score = 0.0;
        int max = config.length;
        int currentSegment = -1;
        boolean seenContext0 = false;
        boolean seenContext1 = false;
        boolean seenContext2 = false;
        for (int i = 0; i < max && (currentSegment = config[i]) != -1; ++i) {
            if (!proj.visible[currentSegment]) continue;
            if (seenContext2 && segments[3][currentSegment]) {
                score += 1.0;
            }
            seenContext2 = seenContext1 && segments[2][currentSegment];
            seenContext1 = seenContext0 && segments[1][currentSegment];
            try {
                if (segments[0][currentSegment]) {
                    seenContext0 = true;
                    continue;
                }
                seenContext0 = false;
                continue;
            }
            catch (Exception e) {
                System.out.println(UCLAPhonotacticLearner.printConfiguration(config));
            }
        }
        return score;
    }

    public static double evaluate(Corpus corp, boolean[][] segments, int gramSize, Projection proj) {
        if (corp.gramCounts != null) {
            switch (gramSize) {
                case 1: {
                    return TierFeature.evaluateUnigram(corp.gramCounts[proj.index], segments, proj.index);
                }
                case 2: {
                    return TierFeature.evaluateBigram(corp.gramCounts[proj.index], segments, proj.index);
                }
                case 3: {
                    return TierFeature.evaluateTrigram(corp.gramCounts[proj.index], segments, proj.index);
                }
                case 4: {
                    return TierFeature.evaluateTetragram(corp.gramCounts[proj.index], segments, proj.index);
                }
            }
            System.out.println("Grams sizes > 4 not supported");
        }
        int[][] configs = corp.data;
        double score = 0.0;
        for (int i = configs.length - 1; i >= 0; --i) {
            score += TierFeature.evaluate(configs[i], segments, gramSize, proj);
        }
        return score;
    }

    public static double evaluateUnigram(UpdatableIntTrie gramCounts, boolean[][] segments, int projIndex) {
        double score = 0.0;
        int n0 = segments[0].length;
        for (int i = n0 - 1; i >= 0; --i) {
            if (!segments[0][i]) continue;
            TierFeature.unigramSeg[0] = i;
            score += (double)gramCounts.count(unigramSeg, 0, 1);
        }
        return score;
    }

    public static double evaluateBigram(UpdatableIntTrie gramCounts, boolean[][] segments, int projIndex) {
        double score = 0.0;
        int n0 = segments[0].length;
        for (int i = n0 - 1; i >= 0; --i) {
            if (!segments[0][i]) continue;
            TierFeature.bigramSegs[0] = i;
            score += (double)gramCounts.count(bigramSegs, 0, 1, segments[1]);
        }
        return score;
    }

    public static double evaluateTrigram(UpdatableIntTrie gramCounts, boolean[][] segments, int projIndex) {
        return gramCounts.count3(segments[0], segments[1], segments[2]);
    }

    public static double evaluateTetragram(UpdatableIntTrie gramCounts, boolean[][] segments, int projIndex) {
        return gramCounts.count4(segments[0], segments[1], segments[2], segments[3]);
    }

    @Override
    public double evaluate(Corpus corp) {
        return TierFeature.evaluate(corp, this.segments, this.gramSize, this.projection);
    }

    public static double evaluate(int[] index, Projection proj, Corpus corp) {
        return TierFeature.evaluate(index, index.length, proj, corp);
    }

    public static double evaluate(int[] index, int size, Projection proj, Corpus corp) {
        int gramSize = size <= index.length ? size : index.length;
        boolean[][] segments = new boolean[gramSize][];
        for (int i = gramSize - 1; i >= 0; --i) {
            segments[i] = (boolean[])UCLAPhonotacticLearner.classesToBooleanVectors.get(index[i]);
        }
        return TierFeature.evaluate(corp, (boolean[][])segments, gramSize, proj);
    }

    @Override
    public DoubleMatrix1D conditionalScore(int[] leftContext) {
        int[] subLeftContext;
        int[] nArray = subLeftContext = this.projection.name.equals("default") ? leftContext : this.projection.projectTrim(leftContext);
        if (subLeftContext.length < this.gramSize) {
            return null;
        }
        int max = subLeftContext.length - 1;
        for (int i = this.gramSize - 2; i >= 0; --i) {
            if (this.segments[i][subLeftContext[max - (this.gramSize - 2 - i)]]) continue;
            return null;
        }
        if (this.conditionalScore != null) {
            return this.conditionalScore;
        }
        int numberOfSegments = Alphabet.segments.length;
        double[] conditionalScore_ = new double[numberOfSegments];
        for (int i = numberOfSegments - 1; i >= 0; --i) {
            conditionalScore_[i] = this.segments[this.gramSize - 1][i] ? 1.0 : 0.0;
        }
        this.conditionalScore = DoubleFactory1D.dense.make(conditionalScore_);
        return this.conditionalScore;
    }

    @Override
    public DoubleMatrix1D conditionalScoreWordFinal(int[] leftContext) {
        if (!this.segments[this.segments.length - 1][0]) {
            return this.conditionalScore(leftContext);
        }
        int[] subLeftContext = this.projection.name.equals("default") ? leftContext : this.projection.projectTrim(leftContext);
        int max = leftContext.length - 1;
        for (int i = this.gramSize - 3; i >= 0; --i) {
            if (this.segments[i][leftContext[max - (this.gramSize - 3 - i)]]) continue;
            return null;
        }
        if (this.conditionalScoreWordBoundary != null) {
            return this.conditionalScoreWordBoundary;
        }
        int numberOfSegments = Alphabet.segments.length;
        double[] conditionalScoreWordBoundary_ = new double[numberOfSegments];
        for (int i = numberOfSegments - 1; i >= 0; --i) {
            conditionalScoreWordBoundary_[i] = this.segments[this.gramSize - 2][i] ? 1.0 : 0.0;
        }
        this.conditionalScoreWordBoundary = DoubleFactory1D.dense.make(conditionalScoreWordBoundary_);
        return this.conditionalScoreWordFinal;
    }

    public FeatureRep toFeatureRep() {
        return new FeatureRep(this.naturalClassIndex, this.projection);
    }

    public static TierFeature stringToFeature(String s) {
        String rep = s.replaceAll("\\[", "");
        String[] classes = rep.split("]");
        int[] classIndexes = new int[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            boolean foundMatch = false;
            Object[] specs = classes[i].split(",");
            specs = UCLAPhonotacticLearner.makeNaturalClass((String[])specs);
            for (int j = 0; j < UCLAPhonotacticLearner.naturalClasses.size(); ++j) {
                if (!Arrays.equals(specs, (String[])UCLAPhonotacticLearner.naturalClasses.get(j))) continue;
                classIndexes[i] = j;
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            System.out.println("Couldn't find class matching String[]");
            System.exit(1);
        }
        return new TierFeature(classIndexes, 0);
    }

    public static double generality(int[] naturalClassIndex, int projectionIndex) {
        int size = naturalClassIndex.length;
        switch (size) {
            case 0: {
                System.out.println("Error: Constraint contains no natural classes");
                System.exit(1);
                break;
            }
            case 1: {
                return (double)(UCLAPhonotacticLearner.naturalClassSizes[projectionIndex][naturalClassIndex[0]] + Alphabet.segments.length * 2) / 3.0;
            }
            case 2: {
                return (double)(UCLAPhonotacticLearner.naturalClassSizes[projectionIndex][naturalClassIndex[0]] + UCLAPhonotacticLearner.naturalClassSizes[projectionIndex][naturalClassIndex[1]] + Alphabet.segments.length) / 3.0;
            }
            default: {
                int gen = 0;
                for (int i = gen - 1; i >= 0; --i) {
                    gen += UCLAPhonotacticLearner.naturalClassSizes[projectionIndex][naturalClassIndex[i]];
                }
                return (double)gen / (double)size;
            }
        }
        return Double.NEGATIVE_INFINITY;
    }

    public String toString() {
        StringBuffer rep = new StringBuffer();
        rep.append(this.classesToString());
        rep.append("\t(tier=");
        rep.append(this.projection);
        rep.append(")");
        return rep.toString();
    }

    public String classesToString() {
        StringBuffer rep = new StringBuffer();
        rep.append("*");
        if (this.naturalClass != null) {
            for (int i = 0; i < this.gramSize; ++i) {
                rep.append(ArrayPrinter.printSpecifiedFeatures(this.naturalClass[i], UCLAPhonotacticLearner.tiers));
            }
        }
        return rep.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof TierFeature)) {
            return false;
        }
        TierFeature C = (TierFeature)o;
        if (C.gramSize != this.gramSize) {
            return false;
        }
        if (C.projection != this.projection) {
            return false;
        }
        if (this.naturalClassIndex != null) {
            for (int i = this.gramSize - 1; i >= 0; --i) {
                if (C.naturalClassIndex[i] == this.naturalClassIndex[i]) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        if (this.naturalClassIndex != null) {
            for (int i = this.gramSize - 1; i >= 0; --i) {
                hash += 31 * this.naturalClassIndex[i];
            }
        }
        return hash += 31 * this.projection.index;
    }
}

