/*
 * Decompiled with CFR 0.152.
 */
import cern.colt.Timer;
import cern.jet.random.EmpiricalWalker;
import cern.jet.random.Poisson;
import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import java.util.Arrays;
import java.util.Date;

public class SequentialSampler
extends Sampler {
    public static int ITERATIONS_FROM_SEED = UCLAPhonotacticLearner.METROPOLIS_ITERATION;
    public static int IDENTICAL_SAMPLE_TOLERANCE = 10;
    public static int BURN_IN = 1000;
    public static int[] sample = new int[UCLAPhonotacticLearner.MAXIMUM_WORD_LENGTH];
    private static int currentConfigurationLength = 0;
    private static int indexOfChangedSegment = 0;
    private static int oldValueOfChangedSegment = 0;
    private int maximum_segment_index = 0;
    private double currentSampleScore = -1.0;
    public static double T = 1.0;
    public static MersenneTwister mt = null;
    public static Uniform uniform = null;
    public static EmpiricalWalker empirical = null;
    public static Poisson poisson = null;
    private static Timer totalTimer = new Timer();
    private static Timer metropolisSampleTimer = new Timer();
    private static Timer getNeighborTimer = new Timer();
    private static Timer randomSeedTimer = new Timer();
    private static Timer[] timers = new Timer[]{totalTimer, metropolisSampleTimer, getNeighborTimer, randomSeedTimer};

    SequentialSampler() {
        mt = new MersenneTwister(new Date());
        uniform = new Uniform(0.0, 1.0, (RandomEngine)mt);
        empirical = new EmpiricalWalker(new double[]{1.0}, 0, (RandomEngine)mt);
        poisson = new Poisson(1.0, (RandomEngine)mt);
        this.maximum_segment_index = Alphabet.features.length - 1;
    }

    @Override
    public void reset(int length) {
        iterations = 0.0;
        metrop_iterations = 0.0;
        identical_samples = 0.0;
        this.currentSampleScore = -1.0;
        currentConfigurationLength = length;
        this.randomSeed();
        this.burn();
        acceptances = 0.0;
    }

    public void randomSeed() {
        Arrays.fill(sample, -1);
        SequentialSampler.sample[0] = 0;
        for (int i = 1; i <= currentConfigurationLength; ++i) {
            SequentialSampler.sample[i] = uniform.nextIntFromTo(1, this.maximum_segment_index);
        }
        SequentialSampler.sample[SequentialSampler.currentConfigurationLength + 1] = 0;
    }

    public void burn() {
        for (int i = 0; i < BURN_IN; ++i) {
            this.metropolisSample();
            if (this.currentSampleScore == 0.0) break;
        }
    }

    @Override
    public int[] nextSample() {
        double acceptances_temp = acceptances;
        if (identical_samples > (double)IDENTICAL_SAMPLE_TOLERANCE || iterations % (double)ITERATIONS_FROM_SEED == 0.0) {
            this.currentSampleScore = -1.0;
            this.randomSeed();
            this.burn();
        }
        acceptances = acceptances_temp;
        this.metropolisSample();
        iterations += 1.0;
        return sample;
    }

    public void metropolisSample() {
        double energy_old = 0.0;
        double energy_new = 0.0;
        metropolisSampleTimer.start();
        energy_old = this.currentSampleScore < 0.0 ? rf.scoresDotWeights(sample) : this.currentSampleScore;
        if (energy_old < 0.0) {
            energy_old = -energy_old;
        }
        this.getNeighbor();
        energy_new = rf.scoresDotWeights(sample);
        if (energy_new < 0.0) {
            energy_new = -energy_new;
        }
        metropolisSampleTimer.stop();
        boolean accept = false;
        if (energy_new <= energy_old) {
            accept = true;
        } else if (uniform.nextDoubleFromTo(0.0, 1.0) <= Math.exp((energy_old - energy_new) / T)) {
            accept = true;
        }
        metrop_iterations += 1.0;
        if (accept) {
            identical_samples = 0.0;
            acceptances += 1.0;
            this.currentSampleScore = energy_new;
        } else {
            SequentialSampler.sample[SequentialSampler.indexOfChangedSegment] = oldValueOfChangedSegment;
            identical_samples += 1.0;
            this.currentSampleScore = energy_old;
        }
    }

    public void getNeighbor() {
        getNeighborTimer.start();
        indexOfChangedSegment = uniform.nextIntFromTo(1, currentConfigurationLength);
        oldValueOfChangedSegment = sample[indexOfChangedSegment];
        SequentialSampler.sample[SequentialSampler.indexOfChangedSegment] = uniform.nextIntFromTo(1, this.maximum_segment_index);
        getNeighborTimer.stop();
    }

    @Override
    public double getCurrentSampleScore() {
        return this.currentSampleScore;
    }

    @Override
    public void resetTimers() {
        for (int t = 0; t < timers.length; ++t) {
            timers[t].reset();
        }
    }

    @Override
    public void reportTiming() {
        System.out.println("total time: " + totalTimer.elapsedTime());
        System.out.println("metropolis sampling: " + metropolisSampleTimer.elapsedTime());
        System.out.println("neighbor selection: " + getNeighborTimer.elapsedTime());
        System.out.println("random seed selection: " + randomSeedTimer.elapsedTime());
    }
}

