/*
 * Decompiled with CFR 0.152.
 */
import cern.colt.Arrays;
import cern.colt.Timer;
import cern.colt.function.DoubleDoubleFunction;
import cern.colt.list.DoubleArrayList;
import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.jet.math.Functions;
import cern.jet.math.PlusMult;
import cern.jet.random.Poisson;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import edu.ucla.fsm.FSM;
import hep.aida.IHistogram1D;
import hep.aida.ref.Histogram1D;
import java.util.Date;
import java.util.LinkedList;
import pal.math.MFWithGradient;
import pal.math.OrthogonalHints;

public class RandomField
implements MFWithGradient {
    int SCALE = 1;
    int SAMPLES = 1;
    int MAXIMUM_SAMPLE_LENGTH = 10;
    static int numberOfSegments = Alphabet.size;
    RandomFieldFeature[] Eval = null;
    DoubleMatrix1D lambda = null;
    DoubleMatrix1D lambda_old = null;
    DoubleArrayList constraintCosts = null;
    FSM G = null;
    Alphabet sigma = null;
    Corpus corpus = null;
    Corpus sample = null;
    UpdatableIntTrie[] sampleGramCounts = null;
    DoubleMatrix1D empiricalCounts = null;
    DoubleMatrix1D expectedCounts = null;
    Regularizer regularizer = null;
    Sampler sampler = null;
    MersenneTwister mersenneTwister = null;
    Poisson poisson = null;
    double INITIAL_WEIGHT = 1.0;
    double WEIGHT_LOWER_BOUND = 1.0E-6;
    double WEIGHT_UPPER_BOUND = 20.0;
    Functions functions = Functions.functions;
    Timer timer = null;
    Timer conditionalProbTimer_generalCase = null;
    Timer conditionalProbTimer_specialCase = null;
    public IHistogram1D sampleProbStarHistogram = new Histogram1D("prob star histogram", 25, 0.0, 10.0);
    public IHistogram1D sampleProbStarShortHistogram = new Histogram1D("prob star histogram for one sample", 25, 0.0, 10.0);
    public IHistogram1D acceptanceHistogram = new Histogram1D("acceptance histogram", 25, 0.0, 1.0);
    static boolean verbose = false;

    RandomField() {
        if (UCLAPhonotacticLearner.BUILD_EXPECTATION_GRAPH) {
            this.G = ExpectationGraphBuilder.initialGraph(numberOfSegments);
        }
        this.regularizer = UCLAPhonotacticLearner.REGULARIZER.equals("exponential") ? new ExponentialRegularizer(UCLAPhonotacticLearner.ALPHA) : new GaussianRegularizer(0.0, UCLAPhonotacticLearner.SIGMA2);
        this.sampler = UCLAPhonotacticLearner.SAMPLE_TYPE.equals("graphical") ? new GraphSampler() : new SequentialSampler2();
        Sampler.rf = this;
        this.mersenneTwister = new MersenneTwister(new Date());
        this.poisson = new Poisson(1.0, (RandomEngine)this.mersenneTwister);
        this.timer = new Timer();
    }

    public void setEval(RandomFieldFeature[] e) {
        for (int i = 0; i < e.length; ++i) {
            this.addConstraint(e[i]);
        }
        this.lambda = DoubleFactory1D.dense.make(this.Eval.length);
        this.lambda.assign(this.INITIAL_WEIGHT);
    }

    public void setLambda(DoubleMatrix1D l) {
        this.lambda = l;
    }

    public void setSigma(Alphabet a) {
        this.sigma = a;
    }

    public void setCorpus(Corpus c) {
        this.corpus = c;
    }

    public void addConstraint(RandomFieldFeature C, double initialWeight) {
        if (this.Eval == null) {
            this.Eval = new RandomFieldFeature[]{C};
            this.lambda = DoubleFactory1D.dense.make(1);
            this.lambda.set(0, initialWeight);
        } else {
            int K_new = this.Eval.length + 1;
            RandomFieldFeature[] Eval_new = new RandomFieldFeature[K_new];
            System.arraycopy(this.Eval, 0, Eval_new, 0, K_new - 1);
            Eval_new[K_new - 1] = C;
            this.Eval = Eval_new;
            DoubleMatrix1D lambda_new = DoubleFactory1D.dense.make(K_new);
            lambda_new.viewPart(0, K_new - 1).assign(this.lambda);
            lambda_new.set(K_new - 1, initialWeight);
            this.lambda = lambda_new;
        }
        if (this.G != null) {
            TierFeature C_ = (TierFeature)C;
            System.out.println("Compiling new constraint " + C_ + " ...");
            FSM C__ = ConstraintCompiler3.compile(C_.segments, numberOfSegments, C_.projection);
            System.out.println("Intersecting the new constraint with the grammar ...");
            this.G = ExpectationGraphBuilder.intersect(this.G, C__, this.lambda.size() - 1);
            System.out.println("expectation graph size: " + this.G.numberOfStates() + " states, " + this.G.getTransitions().size() + " transitions");
        }
    }

    public void addConstraint(RandomFieldFeature C) {
        this.addConstraint(C, this.INITIAL_WEIGHT);
    }

    public void removeLastConstraint() {
        int K_new = this.Eval.length - 1;
        RandomFieldFeature[] Eval_new = new RandomFieldFeature[K_new];
        System.arraycopy(this.Eval, 0, Eval_new, 0, K_new);
        this.Eval = Eval_new;
        DoubleMatrix1D lambda_new = DoubleFactory1D.dense.make(K_new);
        lambda_new.assign(this.lambda.viewPart(0, K_new));
        this.lambda = lambda_new;
    }

    public void resetSample() {
        this.sample = UCLAPhonotacticLearner.sample != null ? UCLAPhonotacticLearner.sample : null;
    }

    public void resetWeights() {
        this.lambda_old = this.lambda.copy();
        this.lambda.assign(this.INITIAL_WEIGHT);
    }

    public DoubleMatrix1D scores(int[] config) {
        if (this.Eval == null) {
            return null;
        }
        int len = this.lambda.size();
        double[] scores = new double[len];
        for (int k = len - 1; k >= 0; --k) {
            scores[k] = this.Eval[k].evaluate(config);
        }
        return DoubleFactory1D.dense.make(scores);
    }

    public double scoresDotWeights(int[] config) {
        if (this.Eval == null) {
            return 1.0;
        }
        int len = this.lambda.size();
        double score = 0.0;
        for (int k = len - 1; k >= 0; --k) {
            score += this.Eval[k].evaluate(config) * this.lambda.get(k);
        }
        return score;
    }

    public double probStar(int[] config) {
        return Math.exp(-this.scoresDotWeights(config));
    }

    public DoubleMatrix1D probStar(int[][] configs) {
        int length = configs.length;
        double[] probStars = new double[length];
        for (int i = length - 1; i >= 0; --i) {
            probStars[i] = this.probStar(configs[i]);
        }
        return DoubleFactory1D.dense.make(probStars);
    }

    public double[] conditionalProb(int[] config, int length, int index) {
        int k;
        int[] nArray;
        if (this.Eval == null || this.Eval.length == 0) {
            return new double[Alphabet.segments.length];
        }
        if (index == 1) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = config[index - 2];
            nArray = nArray3;
            nArray3[1] = config[index - 1];
        }
        int[] leftContext = nArray;
        DoubleMatrix1D conditionalProb = DoubleFactory1D.dense.make(Alphabet.segments.length);
        DoubleMatrix1D conditionalScore_k = null;
        if (index < length) {
            for (k = 0; k < this.Eval.length; ++k) {
                conditionalScore_k = this.Eval[k].conditionalScore(leftContext);
                if (conditionalScore_k == null) continue;
                conditionalProb.assign(conditionalScore_k, (DoubleDoubleFunction)PlusMult.plusMult((double)this.lambda.get(k)));
            }
        }
        if (index == length) {
            for (k = 0; k < this.Eval.length; ++k) {
                conditionalScore_k = this.Eval[k].conditionalScoreWordFinal(leftContext);
                if (conditionalScore_k == null) continue;
                conditionalProb.assign(conditionalScore_k, (DoubleDoubleFunction)PlusMult.plusMult((double)this.lambda.get(k)));
            }
        }
        conditionalProb.assign(Functions.exp);
        conditionalProb.set(0, 0.0);
        return conditionalProb.toArray();
    }

    public double grammarCost() {
        if (this.G == null) {
            System.out.println("Error: cannot compute grammar cost without expectation graph");
            System.exit(1);
        }
        double value = 0.0;
        double ln2 = Math.log(2.0);
        int cardCon = this.lambda.size();
        value += 2.0 * Math.log(cardCon) / ln2 + 1.0;
        for (int i = 0; i < cardCon; ++i) {
            value += this.constraintCosts.get(i);
        }
        System.out.print("graph cost = " + value);
        System.out.println(", weight cost = " + (value += this.regularizer.logValue(this.lambda) / ln2));
        return value;
    }

    public double negLogProb(Corpus corp) {
        if (this.G == null) {
            System.out.println("Error: cannot track corpus probability without expectation graph");
            System.exit(1);
        }
        double value = 0.0;
        double ln2 = Math.log(2.0);
        double pstar = 0.0;
        UCLAPLWeight W = null;
        double Z = 0.0;
        for (int i = corp.data.length - 1; i >= 0; --i) {
            pstar += -this.scoresDotWeights(corp.data[i]);
        }
        W = TrellisBestPath4.apply(this.G, this.lambda.toArray(), this.lambda.size());
        Z = W.p;
        value -= pstar - (double)this.corpus.data.length * Math.log(Z);
        System.out.println("data cost = " + (value /= ln2));
        return value;
    }

    public double objective(Corpus corp) {
        return this.negLogProb(corp) + this.grammarCost();
    }

    public DoubleMatrix1D getEmpiricalCounts() {
        int len = this.lambda.size();
        this.empiricalCounts = DoubleFactory1D.dense.make(len);
        for (int k = len - 1; k >= 0; --k) {
            this.empiricalCounts.set(k, this.Eval[k].evaluate(this.corpus));
        }
        this.empiricalCounts.assign(Functions.mult((double)this.SCALE));
        return this.empiricalCounts;
    }

    public DoubleMatrix1D getExpectedCounts() {
        if (!UCLAPhonotacticLearner.TRAIN_WITH_SAMPLING) {
            return this.getExpectedCountsWithGraph();
        }
        return this.getExpectedCountsWithSample();
    }

    public DoubleMatrix1D getExpectedCountsWithSample() {
        int len = this.lambda.size();
        int sample_size = 0;
        int samples_at_length = 0;
        DoubleMatrix1D expectedCounts = DoubleFactory1D.dense.make(len);
        DoubleMatrix1D scores = null;
        double scoresDotWeights = 0.0;
        double score = 0.0;
        int[] myLengthDistrib = this.getLengthDistribPoisson(this.corpus.lengthDistrib, UCLAPhonotacticLearner.TARGET_SAMPLE_SIZE);
        this.sampleProbStarShortHistogram.reset();
        for (int length = myLengthDistrib.length - 1; length >= 0; --length) {
            if (length > this.MAXIMUM_SAMPLE_LENGTH) continue;
            System.out.print(length + " ");
            samples_at_length = this.SAMPLES * myLengthDistrib[length];
            this.sampler.reset(length);
            for (int i = samples_at_length - 1; i >= 0; --i) {
                int[] config = this.sampler.nextSample();
                scores = this.scores(config);
                if (scores.cardinality() > 0) {
                    expectedCounts.assign(scores, Functions.plus);
                }
                scoresDotWeights = scores.zDotProduct(this.lambda);
                this.sampleProbStarHistogram.fill(-scoresDotWeights);
                this.sampleProbStarShortHistogram.fill(-scoresDotWeights);
            }
            sample_size += samples_at_length;
            if (!UCLAPhonotacticLearner.GUI) continue;
            UCLAPhonotacticLearner.sampleProbStarData.update(this.toBinHeights(this.sampleProbStarHistogram));
            UCLAPhonotacticLearner.sampleProbStarShortData.update(this.toBinHeights(this.sampleProbStarShortHistogram));
            this.acceptanceHistogram.fill(Sampler.acceptances / Sampler.metrop_iterations);
            UCLAPhonotacticLearner.acceptanceData.update(this.toBinHeights(this.acceptanceHistogram));
        }
        System.out.println();
        expectedCounts.assign(Functions.mult((double)(this.SCALE * this.corpus.size)));
        expectedCounts.assign(Functions.div((double)sample_size));
        return expectedCounts;
    }

    public DoubleMatrix1D getExpectedCountsWithGraph() {
        int len = this.lambda.size();
        UCLAPLWeight w = TrellisBestPath4.apply(this.G, this.lambda.toArray(), len);
        DoubleMatrix1D E = DoubleFactory1D.dense.make(len);
        for (int i = len - 1; i >= 0; --i) {
            E.set(i, w.pv[i]);
        }
        E.assign(Functions.div((double)w.p));
        E.assign(Functions.mult((double)(this.SCALE * this.corpus.size)));
        return E;
    }

    public Corpus getRandomSample() {
        return this.getRandomSample(false);
    }

    public Corpus getRandomSample(boolean keepSampleItems) {
        int i;
        this.timer.reset();
        if (this.sample != null) {
            return this.sample;
        }
        this.sample = new Corpus();
        int sample_size = 0;
        int samples_at_length = 0;
        if (this.sampleGramCounts == null) {
            this.sampleGramCounts = this.sample.gramCounts;
        } else {
            this.sample.gramCounts = null;
            this.sample.gramCounts = this.sampleGramCounts;
            for (int proj = 0; proj < UCLAPhonotacticLearner.projections.length; ++proj) {
                this.sampleGramCounts[proj].incrementTimestamp();
                this.sampleGramCounts[proj].prune();
            }
        }
        int[] myLengthDistrib = this.getLengthDistribPoisson(this.corpus.lengthDistrib, UCLAPhonotacticLearner.TARGET_SAMPLE_SIZE);
        this.timer.start();
        this.sampler.reset();
        this.sampler.resetTimers();
        int[] config = null;
        int[] configToKeep = null;
        int[][] config_ = new int[UCLAPhonotacticLearner.projections.length][UCLAPhonotacticLearner.MAXIMUM_WORD_LENGTH];
        LinkedList<int[]> sampleList = null;
        if (keepSampleItems) {
            sampleList = new LinkedList<int[]>();
        }
        for (int length = myLengthDistrib.length - 1; length > 0; --length) {
            if (length > this.MAXIMUM_SAMPLE_LENGTH) continue;
            System.out.print(length + " ");
            samples_at_length = this.SAMPLES * myLengthDistrib[length];
            if (samples_at_length > 0) {
                this.sampler.reset(length);
            }
            for (i = samples_at_length - 1; i >= 0; --i) {
                config = this.sampler.nextSample();
                for (int proj = UCLAPhonotacticLearner.projections.length - 1; proj >= 0; --proj) {
                    int projectedLength = UCLAPhonotacticLearner.projections[proj].projectInto(config, config_[proj]);
                    this.sample.gramCounts[proj].incrementSubsequences(config_[proj], 0, projectedLength);
                }
                if (UCLAPhonotacticLearner.GUI) {
                    double negScoreDotWeights = -this.sampler.getCurrentSampleScore();
                    this.sampleProbStarHistogram.fill(negScoreDotWeights);
                    this.sampleProbStarShortHistogram.fill(negScoreDotWeights);
                }
                if (!keepSampleItems) continue;
                configToKeep = new int[config.length];
                System.arraycopy(config, 0, configToKeep, 0, config.length);
                sampleList.add(configToKeep);
            }
            sample_size += samples_at_length;
            if (UCLAPhonotacticLearner.GUI) {
                UCLAPhonotacticLearner.sampleProbStarData.update(this.toBinHeights(this.sampleProbStarHistogram));
                UCLAPhonotacticLearner.sampleProbStarShortData.update(this.toBinHeights(this.sampleProbStarShortHistogram));
                this.acceptanceHistogram.fill(Sampler.acceptances / Sampler.metrop_iterations);
                UCLAPhonotacticLearner.acceptanceData.update(this.toBinHeights(this.acceptanceHistogram));
            }
            System.out.println("acceptance rate: " + Sampler.acceptances / Sampler.iterations);
        }
        this.sampler.reportTiming();
        System.out.println();
        this.timer.stop();
        if (keepSampleItems) {
            int[][] samples = new int[sampleList.size()][];
            for (i = sampleList.size() - 1; i >= 0; --i) {
                samples[i] = (int[])sampleList.get(i);
            }
            this.sample.data = samples;
            sampleList = null;
        }
        System.out.println("total number of samples: " + sample_size);
        this.sample.lengthDistrib = myLengthDistrib;
        this.sample.size = sample_size;
        System.out.println("getRandomSample() time: " + this.timer.elapsedTime());
        return this.sample;
    }

    private int[] getLengthDistrib(int[] empiricalDistrib, int maximum) {
        DoubleMatrix1D d = DoubleFactory1D.dense.make(empiricalDistrib.length);
        for (int i = empiricalDistrib.length - 1; i >= 0; --i) {
            d.set(i, (double)empiricalDistrib[i]);
        }
        DoubleMatrix1D d_ = d.copy();
        int fraction = 1;
        if (d_.zSum() > (double)maximum) {
            while (d_.zSum() > (double)maximum) {
                d_ = d.copy();
                d_.assign(Functions.div((double)(++fraction)));
            }
        } else if (d_.zSum() < (double)maximum) {
            while (d_.zSum() < (double)maximum) {
                d_ = d.copy();
                d_.assign(Functions.mult((double)(++fraction)));
            }
        }
        d_.assign(Functions.ceil);
        int[] lengthDistrib = new int[empiricalDistrib.length];
        for (int i = lengthDistrib.length - 1; i >= 0; --i) {
            lengthDistrib[i] = (int)d_.get(i);
        }
        return lengthDistrib;
    }

    private int[] getLengthDistribPoisson(int[] empiricalDistrib, int size) {
        double LAMBDA = 0.0;
        double N = 0.0;
        int maxlen = 0;
        for (int i = 0; i < empiricalDistrib.length; ++i) {
            LAMBDA += (double)(empiricalDistrib[i] * i);
            N += (double)empiricalDistrib[i];
            if (empiricalDistrib[i] <= 0) continue;
            maxlen = i;
        }
        this.poisson.setMean(LAMBDA /= N);
        int[] lengthDistrib = new int[this.MAXIMUM_SAMPLE_LENGTH + 1];
        int len = 0;
        int i = size - 1;
        while (i >= 0) {
            len = this.poisson.nextInt();
            if (len <= 0 || len > this.MAXIMUM_SAMPLE_LENGTH || len > maxlen) continue;
            int n = len;
            lengthDistrib[n] = lengthDistrib[n] + 1;
            --i;
        }
        System.out.println("length distribution: " + Arrays.toString((int[])lengthDistrib));
        return lengthDistrib;
    }

    public int getNumArguments() {
        return this.lambda.size();
    }

    public double getLowerBound(int arg) {
        return this.WEIGHT_LOWER_BOUND;
    }

    public double getUpperBound(int arg) {
        return this.WEIGHT_UPPER_BOUND;
    }

    public OrthogonalHints getOrthogonalHints() {
        return null;
    }

    public double evaluate(double[] weights) {
        return 0.0;
    }

    public double evaluate(double[] weights, double[] gradient) {
        this.computeGradient(weights, gradient);
        return this.evaluate(weights);
    }

    public void computeGradient(double[] weights, double[] gradient) {
        this.lambda.assign(weights);
        this.empiricalCounts = this.getEmpiricalCounts();
        this.expectedCounts = this.getExpectedCounts();
        DoubleMatrix1D grad = this.empiricalCounts.copy();
        grad.assign(this.expectedCounts, Functions.minus);
        DoubleMatrix1D reg = this.regularizer.grad(this.lambda);
        grad.assign(reg, Functions.plus);
        System.arraycopy(grad.toArray(), 0, gradient, 0, gradient.length);
        if (verbose) {
            System.out.println();
            System.out.println("W: " + this.lambda);
            System.out.println("O: " + this.empiricalCounts);
            System.out.println("E: " + this.expectedCounts);
            System.out.println("O-E: " + grad);
            System.out.println("reg: " + reg);
            System.out.println("gradient: " + grad);
        }
    }

    public void computeGradientNoRegularizer(double[] weights, double[] gradient) {
        this.lambda.assign(weights);
        this.empiricalCounts = this.getEmpiricalCounts();
        this.expectedCounts = this.getExpectedCounts();
        DoubleMatrix1D grad = this.empiricalCounts.copy();
        grad.assign(this.expectedCounts, Functions.minus);
        grad.assign(Functions.mult((double)-1.0));
        System.arraycopy(grad.toArray(), 0, gradient, 0, gradient.length);
    }

    public void printConstraintsWithWeights() {
        int K = this.lambda.size();
        for (int k = 0; k < K; ++k) {
            System.out.println(k + "\t" + this.Eval[k] + "\tweight=\t" + this.lambda.get(k));
        }
    }

    private double[] toBinHeights(IHistogram1D h) {
        int xBins = h.xAxis().bins();
        double[] array = new double[xBins];
        for (int j = xBins - 1; j >= 0; --j) {
            array[j] = h.binEntries(j);
        }
        return array;
    }
}

