/*
 * Decompiled with CFR 0.152.
 */
import cern.colt.bitvector.BitVector;
import java.util.Arrays;

public class Projection
extends Filter {
    public String name = null;
    public int index = 0;
    public boolean[] visible = null;
    public boolean[] naturalClasses = null;
    public int[] segmentRep = null;
    public RandomFieldFeature[] con = null;

    Projection(String n, int i, boolean[] v, boolean[] nc) {
        this.name = n;
        this.index = i;
        this.visible = v;
        this.naturalClasses = nc;
        this.segmentRep = null;
    }

    public void makeSegmentRepresentation() {
        this.segmentRep = new int[this.visible.length];
        Arrays.fill(this.segmentRep, -1);
        if (this.name.equals("default")) {
            for (int seg = 0; seg < this.visible.length; ++seg) {
                this.segmentRep[seg] = seg;
            }
            return;
        }
        BitVector unlabeledSegments = new BitVector(this.visible.length);
        unlabeledSegments.not();
        for (int seg = 0; seg < this.visible.length; ++seg) {
            if (this.visible[seg]) continue;
            unlabeledSegments.clear(seg);
        }
        BitVector unusedClasses = new BitVector(this.naturalClasses.length);
        unusedClasses.not();
        for (int c = 0; c < this.naturalClasses.length; ++c) {
            if (this.naturalClasses[c]) continue;
            unusedClasses.clear(c);
        }
        int rep = 0;
        this.segmentRep[0] = 0;
        unlabeledSegments.clear(0);
        while (unlabeledSegments.cardinality() > 0) {
            int minClass = -1;
            int minSize = Integer.MAX_VALUE;
            for (int c = 0; c < unusedClasses.size(); ++c) {
                if (!unusedClasses.get(c) || UCLAPhonotacticLearner.naturalClassSizes[this.index][c] >= minSize) continue;
                minSize = UCLAPhonotacticLearner.naturalClassSizes[this.index][c];
                minClass = c;
            }
            if (minClass == -1) {
                System.out.println("Error: couldn't complete the representation of segments on projection " + this.name);
                System.exit(1);
            }
            unusedClasses.clear(minClass);
            boolean foundRep = false;
            boolean[] segmentsInClass = (boolean[])UCLAPhonotacticLearner.classesToBooleanVectors.get(minClass);
            for (int seg = 0; seg < this.visible.length; ++seg) {
                if (!this.visible[seg] || !unlabeledSegments.get(seg) || !segmentsInClass[seg]) continue;
                if (!foundRep) {
                    rep = seg;
                    foundRep = true;
                }
                this.segmentRep[seg] = rep;
                unlabeledSegments.clear(seg);
            }
        }
    }

    public int[] project(int[] config) {
        int len = config.length;
        int[] subconfig = new int[len];
        Arrays.fill(subconfig, -1);
        int index = 0;
        int x = 0;
        for (int i = 0; i < len && (x = config[i]) != -1; ++i) {
            if (x != 0 && !this.visible[x]) continue;
            subconfig[index++] = x;
        }
        return subconfig;
    }

    public int projectInto(int[] config, int[] subconfig) {
        int len = config.length;
        int projectedLength = 0;
        int index = 0;
        int seg = 0;
        for (int i = 0; i < len && (seg = config[i]) != -1; ++i) {
            if (seg != 0 && !this.visible[seg]) continue;
            subconfig[index++] = seg;
            ++projectedLength;
        }
        return projectedLength;
    }

    public int[] projectTrim(int[] config) {
        int len = config.length;
        int[] subconfig = new int[len];
        Arrays.fill(subconfig, -1);
        int index = 0;
        int x = 0;
        for (int i = 0; i < len && (x = config[i]) != -1; ++i) {
            if (x != 0 && !this.visible[x]) continue;
            subconfig[index++] = x;
        }
        int[] trimconfig = new int[index];
        System.arraycopy(subconfig, 0, trimconfig, 0, index);
        return trimconfig;
    }

    public boolean[] filterSegments(boolean[] nc) {
        int numberOfSegments = nc.length;
        boolean[] segs = new boolean[numberOfSegments];
        System.arraycopy(nc, 0, segs, 0, numberOfSegments);
        for (int i = numberOfSegments - 1; i >= 0; --i) {
            if (!nc[i] || this.visible[i]) continue;
            segs[i] = false;
        }
        return segs;
    }

    public String toString() {
        return this.name;
    }
}

