/*
 * Decompiled with CFR 0.152.
 */
import cern.colt.map.OpenIntIntHashMap;

public class NGramCounter {
    static int SIGMA_ORDER = 100;
    int gramSize = 0;
    int stamp = 0;
    int mapsLength = 0;
    OpenIntIntHashMap[] maps = null;

    NGramCounter(int g) {
        this.gramSize = g;
        this.stamp = 0;
        this.mapsLength = UCLAPhonotacticLearner.projections.length;
        this.maps = new OpenIntIntHashMap[this.mapsLength];
        for (int i = 0; i < this.mapsLength; ++i) {
            this.maps[i] = new OpenIntIntHashMap(10000, 0.25, 0.5);
        }
    }

    public void clear() {
        for (int i = 0; i < this.mapsLength; ++i) {
            this.maps[i].clear();
        }
    }

    public void incrementSubsequences(int[] config, int start, int end, int projection) {
        int configLength = config.length;
        if (start < 0 || start > end || end > configLength) {
            System.out.println("Incorrect bounds for incrementSubsequences()");
            System.exit(1);
        }
        int rep = 0;
        int count = 0;
        for (int i = 0; i < end; ++i) {
            for (int j = i + 1; j <= i + this.gramSize && j < end; ++j) {
                rep = this.intRep(config, i, j);
                if (!this.maps[projection].containsKey(rep)) {
                    this.maps[projection].put(rep, 1);
                    continue;
                }
                count = this.maps[projection].get(rep);
                this.maps[projection].put(rep, count + 1);
            }
        }
    }

    public int count(int[] segs, int start, int end, int projection) {
        int rep = this.intRep(segs, start, end);
        if (!this.maps[projection].containsKey(rep)) {
            return 0;
        }
        return this.maps[projection].get(rep);
    }

    private int intRep(int[] config, int start, int end) {
        int rep = 0;
        for (int i = start; i < end; ++i) {
            rep *= SIGMA_ORDER;
            rep += config[i] + 1;
        }
        return rep;
    }
}

