/*
 * Decompiled with CFR 0.152.
 */
import org.apache.commons.math.distribution.TDistributionImpl;

public class LowerConfidenceLimitTable {
    static int Omax = 0;
    static int Emax = 0;
    static double alpha = 0.0;
    static double pstar = 0.0;
    static double tinv = 0.0;
    static double pi = 0.0;
    static TDistributionImpl tdist = new TDistributionImpl(1.0);

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Usage: java LowerConfidenceLimitTable Omax Emax alpha, where Omax is the maximum observed, Emax is the maximum expected, and alpha is the confidence level");
            System.exit(0);
        }
        Omax = Integer.parseInt(args[0]);
        Emax = Integer.parseInt(args[1]);
        alpha = Double.parseDouble(args[2]);
        for (int observed = 0; observed <= Omax; ++observed) {
            for (int expected = 0; expected <= Emax; ++expected) {
                if (expected < 2 || expected < observed) {
                    System.out.print((double)Double.MAX_VALUE);
                } else {
                    pstar = ((double)observed + 0.5) / ((double)expected + 1.0);
                    tdist.setDegreesOfFreedom((double)(expected - 1));
                    try {
                        tinv = tdist.inverseCumulativeProbability((1.0 - alpha) / 2.0);
                    }
                    catch (Exception e) {
                        System.out.println("Error: failed to calculate tinv");
                        System.exit(1);
                    }
                    pi = pstar - tinv * Math.pow(pstar * (1.0 - pstar) / (double)expected, 0.5);
                    System.out.print(pi);
                }
                System.out.print("\t");
            }
            System.out.println();
        }
    }
}

