/*
 * Decompiled with CFR 0.152.
 */
import cern.jet.random.EmpiricalWalker;
import cern.jet.random.Poisson;
import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import edu.ucla.fsm.BooleanArrayWeight;
import edu.ucla.fsm.DagBestPath;
import edu.ucla.fsm.FSM;
import edu.ucla.fsm.IntegerLabel;
import edu.ucla.fsm.IntersectWithSigmaN;
import edu.ucla.fsm.RealSemiring;
import edu.ucla.fsm.RealWeight;
import edu.ucla.fsm.Semiring;
import edu.ucla.fsm.State;
import edu.ucla.fsm.Transition;
import edu.ucla.fsm.Weight;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.TreeMap;

public class GraphSampler
extends Sampler {
    private static MersenneTwister mt = null;
    private static Uniform uniform = null;
    private static EmpiricalWalker empirical = null;
    private static Poisson poisson = null;
    public static int[] sample = new int[UCLAPhonotacticLearner.MAXIMUM_WORD_LENGTH];
    public static int[] cand = new int[UCLAPhonotacticLearner.MAXIMUM_WORD_LENGTH];
    private int currentConfigurationLength = -1;
    private double currentSampleScore = 1.0;
    private static FSM A = null;
    private State q0 = null;
    private int[] I = null;
    private double[][] T = null;
    private boolean verbose = false;

    GraphSampler() {
        mt = new MersenneTwister(new Date());
        uniform = new Uniform(0.0, 1.0, (RandomEngine)mt);
        empirical = new EmpiricalWalker(new double[]{1.0}, 0, (RandomEngine)mt);
        poisson = new Poisson(1.0, (RandomEngine)mt);
    }

    @Override
    public void reset(int len) {
        FSM G;
        TreeMap costs = null;
        LinkedList transitions = null;
        RealWeight W2 = null;
        double w2 = 0.0;
        RealSemiring SR = new RealSemiring();
        int N = 0;
        int min = 0;
        int max = 0;
        int index = 0;
        double[] lambda = GraphSampler.rf.lambda == null ? null : GraphSampler.rf.lambda.toArray();
        this.currentConfigurationLength = len + 2;
        A = null;
        FSM fSM = GraphSampler.rf.G != null ? GraphSampler.rf.G : (G = ExpectationGraphBuilder.initialGraph(Alphabet.size));
        if (this.verbose) {
            System.out.println("renumbering ...");
        }
        G.renumberStates();
        if (this.verbose) {
            System.out.println("intersecting ...");
        }
        A = IntersectWithSigmaN.apply((FSM)G, (int)this.currentConfigurationLength);
        if (this.verbose) {
            System.out.println("renumbering ...");
        }
        A.renumberStates();
        this.q0 = (State)GraphSampler.A.initials.iterator().next();
        if (this.verbose) {
            System.out.println("weighting ...");
        }
        transitions = new LinkedList(A.getTransitions());
        for (Transition t : transitions) {
            t.weight = this.violationToProb(t.weight, lambda, SR);
        }
        if (this.verbose) {
            System.out.println("reversing ...");
        }
        A.reverse();
        if (this.verbose) {
            System.out.println("running best path ...");
        }
        DagBestPath.bp((FSM)A, (Semiring)SR);
        costs = DagBestPath.getCosts();
        if (this.verbose) {
            System.out.println("reversing ...");
        }
        A.reverse();
        if (this.verbose) {
            System.out.println("constructing transition matrix ...");
        }
        N = A.numberOfStates();
        this.I = new int[N];
        this.T = new double[N][];
        for (int i = 0; i < N; ++i) {
            State q = new State(i);
            for (min = 0; min < transitions.size() && !((Transition)transitions.get((int)min)).src.equals((Object)q); ++min) {
            }
            if (min == transitions.size()) continue;
            this.I[i] = min;
            for (max = min; max < transitions.size() && ((Transition)transitions.get((int)max)).src.equals((Object)q); ++max) {
            }
            this.T[i] = new double[max - min];
            index = 0;
            for (int j = min; j < max; ++j) {
                Transition t = (Transition)transitions.get(j);
                RealWeight W1 = (RealWeight)t.weight;
                W2 = (RealWeight)costs.get(t.dest);
                double w1 = W1 == null ? 1.0 : W1.doubleValue();
                w2 = W2 == null ? 1.0 : W2.doubleValue();
                this.T[i][index++] = W1 == null && W2 == null ? 0.9999 : w1 * w2;
            }
        }
        if (this.verbose) {
            System.out.println("done");
        }
        this.randomSeed();
    }

    public void randomSeed() {
        Transition t = null;
        State q = this.q0;
        LinkedList transitions = new LinkedList(A.getTransitions());
        Arrays.fill(sample, -1);
        for (int i = 0; i < this.currentConfigurationLength; ++i) {
            empirical.setState2(this.T[q.id()]);
            t = (Transition)transitions.get(this.I[q.id()] + empirical.nextInt());
            GraphSampler.sample[i] = ((IntegerLabel)t.input).intValue();
            q = t.dest;
        }
        GraphSampler.sample[0] = 0;
        GraphSampler.sample[this.currentConfigurationLength - 1] = 0;
        transitions = null;
    }

    @Override
    public int[] nextSample() {
        this.randomSeed();
        return sample;
    }

    @Override
    public double getCurrentSampleScore() {
        return this.currentSampleScore;
    }

    @Override
    public void resetTimers() {
    }

    @Override
    public void reportTiming() {
    }

    private RealWeight violationToProb(Weight w1, double[] lambda, RealSemiring SR) {
        boolean[] v;
        boolean[] blArray = v = w1 == null ? null : (boolean[])((BooleanArrayWeight)w1).value();
        if (v == null || lambda == null) {
            return SR.ONE;
        }
        double score = 0.0;
        int len1 = v.length;
        int len2 = lambda.length;
        int len = len1 < len2 ? len1 : len2;
        for (int i = len - 1; i >= 0; --i) {
            if (!v[i]) continue;
            score += lambda[i];
        }
        return new RealWeight(Math.exp(-score));
    }
}

