/*
 * Decompiled with CFR 0.152.
 */
public class FeatureRep {
    int[] segs = null;
    int size = 0;
    Projection projection = null;

    FeatureRep(int[] s, int sz, Projection proj) {
        this.segs = new int[sz];
        System.arraycopy(s, 0, this.segs, 0, sz);
        this.size = sz;
        this.projection = proj;
    }

    FeatureRep(int[] s, Projection proj) {
        this(s, s.length, proj);
    }

    FeatureRep(int[] s, int projectionIndex) {
        this(s, s.length, UCLAPhonotacticLearner.projections[projectionIndex]);
    }

    public int hashCode() {
        int hash = 7;
        for (int i = this.size - 1; i >= 0; --i) {
            hash += 31 * this.segs[i];
        }
        return hash += 31 * this.projection.index;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeatureRep)) {
            return false;
        }
        FeatureRep g = (FeatureRep)o;
        if (g.size != this.size) {
            return false;
        }
        for (int i = this.size - 1; i >= 0; --i) {
            if (g.segs[i] == this.segs[i]) continue;
            return false;
        }
        return g.projection == this.projection;
    }

    public String toString() {
        StringBuffer rep = new StringBuffer();
        rep.append("(");
        for (int i = 0; i < this.size; ++i) {
            rep.append(this.segs[i]);
            rep.append(",");
        }
        rep.append(")");
        rep.append("[projection=" + this.projection + "]");
        return rep.toString();
    }
}

