/*
 * Decompiled with CFR 0.152.
 */
import cern.colt.bitvector.BitVector;
import cern.colt.list.IntArrayList;
import cern.colt.map.OpenIntObjectHashMap;
import java.util.Arrays;

public class ConstraintEnumerator {
    public static double THETA = 0.0;
    public static int[] classSizes = null;
    public static int[] classComplexities = null;
    public static IntArrayList sortedClasses = null;
    public static boolean[][][] moreGeneralThan = null;
    public static boolean[][][] strictlyMoreGeneralThan = null;
    public static boolean[][] bannedBigrams = null;
    public static boolean[][][] bannedTrigrams = null;
    public static int unviolated = 0;

    private static int[] getClassComplexities(int numberOfClasses) {
        int[] cc = new int[numberOfClasses];
        for (int i = numberOfClasses - 1; i >= 0; --i) {
            cc[i] = UCLAPhonotacticLearner.specifiedFeatures((String[])UCLAPhonotacticLearner.naturalClasses.get(i));
        }
        return cc;
    }

    public static boolean[][][] moreGeneralThan(int numberOfClasses, OpenIntObjectHashMap classesToBooleanVectors) {
        moreGeneralThan = new boolean[UCLAPhonotacticLearner.projections.length][][];
        for (int i = 0; i < UCLAPhonotacticLearner.projections.length; ++i) {
            ConstraintEnumerator.moreGeneralThan[i] = ConstraintEnumerator.moreGeneralThan(numberOfClasses, classesToBooleanVectors, UCLAPhonotacticLearner.projections[i].visible, UCLAPhonotacticLearner.projections[i].naturalClasses);
        }
        strictlyMoreGeneralThan = new boolean[UCLAPhonotacticLearner.projections.length][numberOfClasses][numberOfClasses];
        for (int p = 0; p < UCLAPhonotacticLearner.projections.length; ++p) {
            for (int j = 0; j < numberOfClasses; ++j) {
                if (!UCLAPhonotacticLearner.projections[p].naturalClasses[j]) continue;
                int dom = -1;
                int minsize = Integer.MAX_VALUE;
                for (int i = 0; i < numberOfClasses; ++i) {
                    if (!UCLAPhonotacticLearner.projections[p].naturalClasses[i] || i == j || !moreGeneralThan[p][i][j] || UCLAPhonotacticLearner.naturalClassSizes[p][i] >= minsize) continue;
                    dom = i;
                    minsize = UCLAPhonotacticLearner.naturalClassSizes[p][i];
                }
                if (dom == -1) continue;
                ConstraintEnumerator.strictlyMoreGeneralThan[p][dom][j] = true;
                System.out.println("strictly more general than: " + cern.colt.Arrays.toString((Object[])UCLAPhonotacticLearner.naturalClassToString((String[])UCLAPhonotacticLearner.naturalClasses.get(dom))) + "(" + minsize + ")" + ", " + cern.colt.Arrays.toString((Object[])UCLAPhonotacticLearner.naturalClassToString((String[])UCLAPhonotacticLearner.naturalClasses.get(j))) + " (projection=" + p + ")");
            }
        }
        return moreGeneralThan;
    }

    public static boolean[][] moreGeneralThan(int numberOfClasses, OpenIntObjectHashMap classesToBooleanVectors, boolean[] visibleSegments, boolean[] visibleClasses) {
        boolean[][] moreGeneralThan = new boolean[numberOfClasses][numberOfClasses];
        for (int i = 1; i < numberOfClasses; ++i) {
            if (!visibleClasses[i]) continue;
            boolean[] segments_i = (boolean[])classesToBooleanVectors.get(i);
            for (int j = 1; j < numberOfClasses; ++j) {
                boolean[] segments_j;
                if (!visibleClasses[j] || !ConstraintEnumerator.moreGeneralThan(segments_i, segments_j = (boolean[])classesToBooleanVectors.get(j), visibleSegments)) continue;
                moreGeneralThan[i][j] = true;
            }
        }
        return moreGeneralThan;
    }

    private static boolean moreGeneralThan(boolean[] segments_i, boolean[] segments_j, boolean[] visibleSegments) {
        if (Arrays.equals(segments_i, segments_j)) {
            return true;
        }
        for (int x = 0; x < segments_j.length; ++x) {
            if (!visibleSegments[x] || !segments_j[x] || segments_i[x]) continue;
            return false;
        }
        return true;
    }

    public static int[] sortByGenerality(int numberOfClasses) {
        IntArrayList sc = new IntArrayList(numberOfClasses);
        BitVector alreadyOrdered = new BitVector(numberOfClasses);
        while (alreadyOrdered.cardinality() < numberOfClasses) {
            block1: for (int i = 0; i < numberOfClasses; ++i) {
                if (alreadyOrdered.get(i)) continue;
                for (int j = 0; j < numberOfClasses; ++j) {
                    if (!alreadyOrdered.get(j) && j != i && moreGeneralThan[0][j][i]) continue block1;
                }
                sc.add(i);
                alreadyOrdered.set(i);
            }
        }
        sc.trimToSize();
        return sc.elements();
    }

    public static int[] sortByCardinality(Projection projection) {
        int numberOfClasses = UCLAPhonotacticLearner.naturalClasses.size();
        int[] sc = new int[numberOfClasses];
        BitVector alreadyOrdered = new BitVector(numberOfClasses);
        int index = 0;
        for (int size = Alphabet.segments.length; size > 0; --size) {
            for (int j = 0; j < numberOfClasses; ++j) {
                if (alreadyOrdered.get(j) || UCLAPhonotacticLearner.naturalClassSizes[projection.index][j] != size || !projection.naturalClasses[j]) continue;
                sc[index++] = j;
            }
        }
        int[] sc_ = new int[index];
        System.arraycopy(sc, 0, sc_, 0, index);
        return sc_;
    }
}

