/*
 * Decompiled with CFR 0.152.
 */
import edu.ucla.fsm.BreadthFirstVisit;
import edu.ucla.fsm.FSM;
import edu.ucla.fsm.State;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.math.distribution.TDistributionImpl;
import pal.math.ConjugateGradientSearch;
import pal.math.MultivariateFunction;

public class BreadthFirstSelection5 {
    static TDistributionImpl tdist = new TDistributionImpl(1.0);
    static ConjugateGradientSearch conjugateGradientMinimizer = new ConjugateGradientSearch(2);
    static ImprovedIterativeScaling iis = new ImprovedIterativeScaling();
    static RandomField RF = null;
    static RandomFieldFeature[] bestFeature = null;
    static FeatureRep[] bestFeatureRep = null;
    static HashSet featuresAlreadySelected = new HashSet();
    static HashMap featuresToObservedCounts = new HashMap();
    static Corpus corpus = null;
    static Corpus sample = null;
    static int corpusSize = 0;
    static int sampleSize = 0;
    static int[] maximumGramSize = null;
    static int numberOfProjections = 0;
    static int numberOfSegments = 0;
    static int numberOfNaturalClasses = 0;
    static double[] accuracySchedule = null;
    static double maximumOEValue = 1.0;
    static int[] oeThreshold = null;
    static boolean trainWeightsAfterEachSelection = true;
    static boolean[][][] bigramBanned = null;
    static boolean[][][][] trigramBanned = null;
    static boolean[][][] moreGeneralThan = null;
    static boolean[][] tri = new boolean[3][];
    static double[][][] bigramObserved = null;
    static double[][][] bigramExpected = null;
    static boolean[][] bigramAboveCriterion = null;
    static int[] unigram = new int[1];
    static int[] bigram = new int[2];
    static int[] trigram = new int[3];
    static int[] tetragram = new int[4];
    static double accuracy = 0.0;
    static double criterion = 0.0;
    static FSM[] G = null;
    static FlatMsgFSM[] MG = null;
    static TreeMap[] D = null;
    static int evaluatedConstraintCount = 0;

    BreadthFirstSelection5() {
        maximumGramSize = UCLAPhonotacticLearner.MAXIMUM_GRAM_SIZE;
        numberOfProjections = UCLAPhonotacticLearner.projections.length;
        numberOfSegments = Alphabet.segments.length;
        numberOfNaturalClasses = UCLAPhonotacticLearner.naturalClasses.size();
        corpus = UCLAPhonotacticLearner.corpus;
        corpusSize = BreadthFirstSelection5.corpus.size;
        accuracySchedule = UCLAPhonotacticLearner.ACCURACY_SCHEDULE;
        oeThreshold = new int[numberOfProjections];
        bigramBanned = new boolean[numberOfProjections][numberOfSegments][numberOfSegments];
        trigramBanned = new boolean[numberOfProjections][numberOfSegments][numberOfSegments][numberOfSegments];
        bigramObserved = new double[numberOfProjections][numberOfNaturalClasses][numberOfNaturalClasses];
        bigramExpected = new double[numberOfProjections][numberOfNaturalClasses][numberOfNaturalClasses];
        bigramAboveCriterion = new boolean[numberOfNaturalClasses][numberOfNaturalClasses];
        moreGeneralThan = ConstraintEnumerator.moreGeneralThan(UCLAPhonotacticLearner.naturalClasses.size(), UCLAPhonotacticLearner.classesToBooleanVectors);
        G = new FSM[numberOfProjections];
        MG = new FlatMsgFSM[numberOfProjections];
        D = new TreeMap[numberOfProjections];
        for (int i = 0; i < numberOfProjections; ++i) {
            BreadthFirstSelection5.G[i] = NaturalClassGraphBuilder.build(UCLAPhonotacticLearner.naturalClasses.size(), moreGeneralThan[i], UCLAPhonotacticLearner.naturalClassSizes[i], UCLAPhonotacticLearner.projections[i].naturalClasses);
            System.out.println(G[i]);
            BreadthFirstSelection5.D[i] = BreadthFirstVisit.apply((FSM)G[i]);
            BreadthFirstSelection5.MG[i] = new FlatMsgFSM(UCLAPhonotacticLearner.projections[i], numberOfNaturalClasses);
        }
        bestFeature = new RandomFieldFeature[numberOfProjections];
        bestFeatureRep = new FeatureRep[numberOfProjections];
    }

    public static void select(RandomField RF_) {
        boolean continueSearch;
        RF = RF_;
        if (BreadthFirstSelection5.RF.Eval != null) {
            for (int i = BreadthFirstSelection5.RF.Eval.length - 1; i >= 0; --i) {
                featuresAlreadySelected.add(BreadthFirstSelection5.RF.Eval[i]);
                BreadthFirstSelection5.addFeature(BreadthFirstSelection5.RF.Eval[i]);
            }
            BreadthFirstSelection5.retrainWeights();
        }
        if (UCLAPhonotacticLearner.SELECT_WITH_SAMPLING) {
            BreadthFirstSelection5.getSample();
        }
        do {
            System.out.println("\nSelecting a new constraint");
            System.out.print("accuracy thresholds (by projection): ");
            for (int proj = 0; proj < numberOfProjections; ++proj) {
                System.out.print(accuracySchedule[oeThreshold[proj]] + ", ");
            }
            System.out.println();
            continueSearch = false;
            for (int proj = 0; proj < numberOfProjections; ++proj) {
                if (!(accuracySchedule[oeThreshold[proj]] < UCLAPhonotacticLearner.OE_THRESHOLD) || oeThreshold[proj] >= accuracySchedule.length - 1) continue;
                BreadthFirstSelection5.bestFeature[proj] = null;
                BreadthFirstSelection5.bestFeatureRep[proj] = null;
                BreadthFirstSelection5.bestFeature[proj] = BreadthFirstSelection5.select(UCLAPhonotacticLearner.projections[proj]);
                if (bestFeature[proj] != null) {
                    BreadthFirstSelection5.addFeature(bestFeature[proj]);
                    BreadthFirstSelection5.retrainWeights();
                    if (UCLAPhonotacticLearner.SELECT_WITH_SAMPLING) {
                        BreadthFirstSelection5.getSample();
                    }
                } else {
                    int n = proj;
                    oeThreshold[n] = oeThreshold[n] + 1;
                }
                continueSearch = true;
            }
        } while (continueSearch && (UCLAPhonotacticLearner.MAXIMUM_FIELD_SIZE <= 0 || BreadthFirstSelection5.RF.Eval == null || BreadthFirstSelection5.RF.Eval.length < UCLAPhonotacticLearner.MAXIMUM_FIELD_SIZE));
        if (UCLAPhonotacticLearner.PROB_MAX) {
            double logProb = 0.0;
            double minNegLogProb = Double.POSITIVE_INFINITY;
            int minNegLogProbIndex = 0;
            for (int i = 0; i < UCLAPhonotacticLearner.corpusNegLogProb.size(); ++i) {
                logProb = UCLAPhonotacticLearner.objectiveCost.get(i);
                if (!(logProb < minNegLogProb)) continue;
                minNegLogProb = logProb;
                minNegLogProbIndex = i;
            }
            RF.setLambda(BreadthFirstSelection5.RF.lambda.viewPart(0, minNegLogProbIndex + 1));
        }
    }

    public static RandomFieldFeature select(Projection proj) {
        System.out.println("Selecting a constraint on projection " + proj);
        int[] val = null;
        accuracy = accuracySchedule[oeThreshold[proj.index]];
        criterion = UCLAPhonotacticLearner.SMOOTH / accuracySchedule[oeThreshold[proj.index]] + UCLAPhonotacticLearner.SMOOTH;
        for (int i = 0; i < maximumGramSize[proj.index]; ++i) {
            System.out.println("\tSearching constraints of size " + (i + 1));
            evaluatedConstraintCount = 0;
            if (i + 1 == 2) {
                BreadthFirstSelection5.clearBigramExpected(proj.index);
            }
            if ((val = BreadthFirstSelection5.search(proj, i + 1)) == null) continue;
            BreadthFirstSelection5.bestFeatureRep[proj.index] = new FeatureRep(val, proj);
            System.out.println("\tnumber of constraints evaluated: " + evaluatedConstraintCount + " (" + (double)evaluatedConstraintCount / Math.pow(numberOfNaturalClasses, i + 1) * 100.0 + "%)");
            return new TierFeature(val, proj);
        }
        System.out.println("\tnumber of constraints evaluated: " + evaluatedConstraintCount + " (" + (double)evaluatedConstraintCount / Math.pow(numberOfNaturalClasses, maximumGramSize[proj.index]) * 100.0 + "%)");
        return null;
    }

    public static int[] search(Projection proj, int size) {
        return BreadthFirstSelection5.branchingSearch(proj, size);
    }

    private static int[] branchingSearch(Projection proj, int size) {
        int c0 = 0;
        int c1 = 0;
        int c2 = 0;
        int c3 = 0;
        double O = 0.0;
        double E = 0.0;
        int[] naturalClassesThisProjection = UCLAPhonotacticLearner.naturalClassesByProjection[proj.index];
        int[] trigramNaturalClasses = UCLAPhonotacticLearner.trigramNaturalClasses;
        int numberOfNaturalClasses = UCLAPhonotacticLearner.naturalClasses.size();
        int numberOfTrigramNaturalClasses = trigramNaturalClasses.length;
        boolean[] visibleNaturalClasses = proj.naturalClasses;
        int[] naturalClassSizesThisProjection = UCLAPhonotacticLearner.naturalClassSizes[proj.index];
        if (size == 1) {
            MG[proj.index].reset();
            for (State q : BreadthFirstSelection5.MG[proj.index].initials) {
                BreadthFirstSelection5.unigram[0] = c0 = q.id();
                BreadthFirstSelection5.MG[proj.index].O[c0] = TierFeature.evaluate(unigram, size, proj, corpus);
                BreadthFirstSelection5.MG[proj.index].E[c0] = TierFeature.evaluate(unigram, size, proj, sample) / (double)sampleSize * (double)corpusSize;
            }
            MG[proj.index].pass();
            for (int i = 0; i < numberOfNaturalClasses && (c0 = naturalClassesThisProjection[i]) != -1; ++i) {
                ++evaluatedConstraintCount;
                BreadthFirstSelection5.unigram[0] = c0;
                if (!(BreadthFirstSelection5.OE(BreadthFirstSelection5.MG[proj.index].O[c0], BreadthFirstSelection5.MG[proj.index].E[c0]) < accuracy) || !BreadthFirstSelection5.checkHeuristics(proj, unigram, size)) continue;
                return unigram;
            }
        } else {
            if (size == 2) {
                int[] best = null;
                int maximumGenerality = 0;
                int generality = 0;
                block2: for (int i = 0; i < numberOfNaturalClasses && (c0 = naturalClassesThisProjection[i]) != -1 && naturalClassSizesThisProjection[c0] >= maximumGenerality; ++i) {
                    Arrays.fill(bigramAboveCriterion[c0], false);
                    BreadthFirstSelection5.bigram[0] = c0;
                    MG[proj.index].reset();
                    for (State q : BreadthFirstSelection5.MG[proj.index].initials) {
                        BreadthFirstSelection5.bigram[1] = c1 = q.id();
                        BreadthFirstSelection5.MG[proj.index].O[c1] = TierFeature.evaluate(bigram, size, proj, corpus);
                        BreadthFirstSelection5.MG[proj.index].E[c1] = TierFeature.evaluate(bigram, size, proj, sample) / (double)sampleSize * (double)corpusSize;
                    }
                    MG[proj.index].pass();
                    BreadthFirstSelection5.bigram[1] = c1 = 0;
                    BreadthFirstSelection5.MG[proj.index].O[c1] = TierFeature.evaluate(bigram, size, proj, corpus);
                    BreadthFirstSelection5.MG[proj.index].E[c1] = TierFeature.evaluate(bigram, size, proj, sample) / (double)sampleSize * (double)corpusSize;
                    for (int j = 0; j < numberOfNaturalClasses && (c1 = naturalClassesThisProjection[j]) != -1 && naturalClassSizesThisProjection[c1] >= maximumGenerality; ++j) {
                        BreadthFirstSelection5.bigram[1] = c1;
                        ++evaluatedConstraintCount;
                        O = BreadthFirstSelection5.MG[proj.index].O[c1];
                        E = BreadthFirstSelection5.MG[proj.index].E[c1];
                        if (BreadthFirstSelection5.OE(O, E) < accuracy && BreadthFirstSelection5.checkHeuristics(proj, bigram, size)) {
                            generality = naturalClassSizesThisProjection[c0];
                            int n = generality = generality <= naturalClassSizesThisProjection[c1] ? generality : naturalClassSizesThisProjection[c1];
                            if (generality > maximumGenerality) {
                                if (best == null) {
                                    best = new int[size];
                                }
                                best[0] = c0;
                                best[1] = c1;
                                maximumGenerality = generality;
                                continue block2;
                            }
                        }
                        if (!(E > criterion)) continue;
                        BreadthFirstSelection5.bigramAboveCriterion[c0][c1] = true;
                    }
                }
                return best;
            }
            if (size == 3) {
                int[] best = null;
                int maximumGenerality = 0;
                int generality = 0;
                for (int i = 0; i < numberOfNaturalClasses && (c0 = naturalClassesThisProjection[i]) != -1 && naturalClassSizesThisProjection[c0] >= maximumGenerality; ++i) {
                    BreadthFirstSelection5.trigram[0] = c0;
                    block6: for (int j = 0; j < numberOfNaturalClasses && (c1 = naturalClassesThisProjection[j]) != -1 && naturalClassSizesThisProjection[c1] >= maximumGenerality; ++j) {
                        if (c1 == 0 || !bigramAboveCriterion[c0][c1]) continue;
                        BreadthFirstSelection5.trigram[1] = c1;
                        MG[proj.index].reset();
                        for (State q : BreadthFirstSelection5.MG[proj.index].initials) {
                            BreadthFirstSelection5.trigram[2] = c2 = q.id();
                            BreadthFirstSelection5.MG[proj.index].O[c2] = TierFeature.evaluate(trigram, size, proj, corpus);
                            BreadthFirstSelection5.MG[proj.index].E[c2] = TierFeature.evaluate(trigram, size, proj, sample) / (double)sampleSize * (double)corpusSize;
                        }
                        MG[proj.index].pass();
                        BreadthFirstSelection5.trigram[2] = c2 = 0;
                        BreadthFirstSelection5.MG[proj.index].O[c2] = TierFeature.evaluate(trigram, size, proj, corpus);
                        BreadthFirstSelection5.MG[proj.index].E[c2] = TierFeature.evaluate(trigram, size, proj, sample) / (double)sampleSize * (double)corpusSize;
                        for (int k = 0; k < numberOfNaturalClasses && (c2 = naturalClassesThisProjection[k]) != -1 && naturalClassSizesThisProjection[c2] >= maximumGenerality; ++k) {
                            if (!bigramAboveCriterion[c1][c2]) continue;
                            BreadthFirstSelection5.trigram[2] = c2;
                            if (!BreadthFirstSelection5.trigramHeuristic(trigram)) continue;
                            ++evaluatedConstraintCount;
                            if (!(BreadthFirstSelection5.OE(BreadthFirstSelection5.MG[proj.index].O[c2], BreadthFirstSelection5.MG[proj.index].E[c2]) < accuracy) || !BreadthFirstSelection5.checkHeuristics(proj, trigram, size)) continue;
                            generality = naturalClassSizesThisProjection[c0];
                            generality = generality <= naturalClassSizesThisProjection[c1] ? generality : naturalClassSizesThisProjection[c1];
                            int n = generality = generality <= naturalClassSizesThisProjection[c2] ? generality : naturalClassSizesThisProjection[c2];
                            if (generality <= maximumGenerality) continue;
                            if (best == null) {
                                best = new int[size];
                            }
                            best[0] = c0;
                            best[1] = c1;
                            best[2] = c2;
                            maximumGenerality = generality;
                            continue block6;
                        }
                    }
                }
                return best;
            }
            if (size == 4) {
                int[] best = null;
                int maximumGenerality = 0;
                int generality = 0;
                for (int i = 0; i < numberOfNaturalClasses && (c0 = naturalClassesThisProjection[i]) != -1 && naturalClassSizesThisProjection[c0] >= maximumGenerality; ++i) {
                    BreadthFirstSelection5.trigram[0] = c0;
                    BreadthFirstSelection5.tetragram[0] = c0;
                    for (int j = 0; j < numberOfNaturalClasses && (c1 = naturalClassesThisProjection[j]) != -1 && naturalClassSizesThisProjection[c1] >= maximumGenerality; ++j) {
                        if (c1 == 0) continue;
                        BreadthFirstSelection5.trigram[1] = c1;
                        BreadthFirstSelection5.tetragram[1] = c1;
                        block11: for (int k = 0; k < numberOfNaturalClasses && (c2 = naturalClassesThisProjection[k]) != -1 && naturalClassSizesThisProjection[c2] >= maximumGenerality; ++k) {
                            if (c2 == 0) continue;
                            BreadthFirstSelection5.trigram[2] = c2;
                            BreadthFirstSelection5.tetragram[2] = c2;
                            if (!BreadthFirstSelection5.trigramHeuristic(trigram)) continue;
                            MG[proj.index].reset();
                            for (State q : BreadthFirstSelection5.MG[proj.index].initials) {
                                BreadthFirstSelection5.tetragram[3] = c3 = q.id();
                                BreadthFirstSelection5.MG[proj.index].O[c3] = TierFeature.evaluate(tetragram, size, proj, corpus);
                                BreadthFirstSelection5.MG[proj.index].E[c3] = TierFeature.evaluate(tetragram, size, proj, sample) / (double)sampleSize * (double)corpusSize;
                            }
                            MG[proj.index].pass();
                            BreadthFirstSelection5.tetragram[3] = c3 = 0;
                            BreadthFirstSelection5.MG[proj.index].O[c3] = TierFeature.evaluate(tetragram, size, proj, corpus);
                            BreadthFirstSelection5.MG[proj.index].E[c3] = TierFeature.evaluate(tetragram, size, proj, sample) / (double)sampleSize * (double)corpusSize;
                            for (int l = 0; l < numberOfNaturalClasses && (c3 = naturalClassesThisProjection[l]) != -1 && naturalClassSizesThisProjection[c3] >= maximumGenerality; ++l) {
                                BreadthFirstSelection5.tetragram[3] = c3;
                                if (!BreadthFirstSelection5.trigramHeuristic(tetragram)) continue;
                                ++evaluatedConstraintCount;
                                if (!(BreadthFirstSelection5.OE(BreadthFirstSelection5.MG[proj.index].O[c3], BreadthFirstSelection5.MG[proj.index].E[c3]) < accuracy) || !BreadthFirstSelection5.checkHeuristics(proj, tetragram, size)) continue;
                                generality = naturalClassSizesThisProjection[c0];
                                generality = generality <= naturalClassSizesThisProjection[c1] ? generality : naturalClassSizesThisProjection[c1];
                                generality = generality <= naturalClassSizesThisProjection[c2] ? generality : naturalClassSizesThisProjection[c2];
                                int n = generality = generality <= naturalClassSizesThisProjection[c3] ? generality : naturalClassSizesThisProjection[c3];
                                if (generality <= maximumGenerality) continue;
                                if (best == null) {
                                    best = new int[size];
                                }
                                best[0] = c0;
                                best[1] = c1;
                                best[2] = c2;
                                best[3] = c3;
                                maximumGenerality = generality;
                                continue block11;
                            }
                        }
                    }
                }
                return best;
            }
        }
        return null;
    }

    private static int[] orderByDepth(int[] s, Projection proj) {
        int len = s.length;
        int minimumDepth = Integer.MAX_VALUE;
        int minimumDepthStateIndex = 0;
        int[] val = new int[len];
        boolean[] ordered = new boolean[len];
        for (int i = 0; i < len; ++i) {
            minimumDepth = Integer.MAX_VALUE;
            minimumDepthStateIndex = -1;
            for (int j = 0; j < len; ++j) {
                if (ordered[j] || (Integer)D[proj.index].get(s[j]) >= minimumDepth) continue;
                minimumDepth = (Integer)D[proj.index].get(s[j]);
                minimumDepthStateIndex = j;
            }
            val[i] = minimumDepthStateIndex;
            ordered[minimumDepthStateIndex] = true;
        }
        return val;
    }

    public static double OE(double observed, double expected) {
        double pstar = 0.0;
        double tinv = 0.0;
        double pi = 0.0;
        if (observed > expected) {
            return Double.MAX_VALUE;
        }
        if ((observed + UCLAPhonotacticLearner.SMOOTH) / (expected + UCLAPhonotacticLearner.SMOOTH) > accuracy) {
            return Double.MAX_VALUE;
        }
        if (UCLAPhonotacticLearner.LOWER_CONFIDENCE_LIMIT) {
            if (expected < 2.0) {
                return Double.MAX_VALUE;
            }
            pstar = (observed + 0.5) / (expected + 1.0);
            tdist.setDegreesOfFreedom(expected - 1.0);
            try {
                tinv = tdist.inverseCumulativeProbability((1.0 - UCLAPhonotacticLearner.LCL_ALPHA) / 2.0);
            }
            catch (Exception e) {
                System.out.println("Error: failed to compute inverse t");
                System.exit(1);
            }
            pi = pstar - tinv * Math.pow(pstar * (1.0 - pstar) / expected, 0.5);
            if (pi < 0.0) {
                System.out.println("* * * * pi = " + pi);
                System.exit(1);
            }
            return pi;
        }
        return expected == 0.0 ? Double.MAX_VALUE : (observed + UCLAPhonotacticLearner.SMOOTH) / (expected + UCLAPhonotacticLearner.SMOOTH);
    }

    public static boolean trigramHeuristic(int[] config) {
        int generalClassCount = 0;
        for (int i = config.length - 1; i >= 0; --i) {
            if (!UCLAPhonotacticLearner.trigramNaturalClassesBool[config[i]]) {
                ++generalClassCount;
            }
            if (generalClassCount <= 2) continue;
            return false;
        }
        return true;
    }

    public static boolean trigramHeuristic(Projection proj, int[] current, int s, int pos) {
        int generalClassCount = 0;
        for (int i = current.length - 1; i >= 0; --i) {
            if (i == pos && !UCLAPhonotacticLearner.trigramNaturalClassesBool[s]) {
                ++generalClassCount;
            }
            if (i == pos || UCLAPhonotacticLearner.trigramNaturalClassesBool[current[i]]) continue;
            ++generalClassCount;
        }
        return generalClassCount <= 2;
    }

    public static boolean checkHeuristics(Projection proj, int[] index, int size) {
        FeatureRep CR = new FeatureRep(index, size, UCLAPhonotacticLearner.projections[proj.index]);
        if (featuresAlreadySelected.contains(CR) || !BreadthFirstSelection5.effective(CR) || BreadthFirstSelection5.blockedByMoreGeneralConstraint(CR)) {
            return false;
        }
        return BreadthFirstSelection5.complementHeuristic(index, size);
    }

    public static boolean complementHeuristic(int[] index, int size) {
        int complementClassCount = 0;
        for (int i = 0; i < size; ++i) {
            if (!UCLAPhonotacticLearner.complementNaturalClassesBool[index[i]] || ++complementClassCount <= 1) continue;
            return false;
        }
        return true;
    }

    public static boolean effective(FeatureRep rep) {
        if (rep.size == 1) {
            return true;
        }
        if (rep.size == 2) {
            boolean[] segments0 = (boolean[])UCLAPhonotacticLearner.classesToBooleanVectors.get(rep.segs[0]);
            boolean[] segments1 = (boolean[])UCLAPhonotacticLearner.classesToBooleanVectors.get(rep.segs[1]);
            for (int i = segments0.length - 1; i >= 0; --i) {
                if (!segments0[i]) continue;
                for (int j = segments1.length - 1; j >= 0; --j) {
                    if (!segments1[j] || bigramBanned[rep.projection.index][i][j]) continue;
                    return true;
                }
            }
        } else if (rep.size == 3) {
            boolean[] segments0 = (boolean[])UCLAPhonotacticLearner.classesToBooleanVectors.get(rep.segs[0]);
            boolean[] segments1 = (boolean[])UCLAPhonotacticLearner.classesToBooleanVectors.get(rep.segs[1]);
            boolean[] segments2 = (boolean[])UCLAPhonotacticLearner.classesToBooleanVectors.get(rep.segs[2]);
            for (int i = segments0.length - 1; i >= 0; --i) {
                if (!segments0[i]) continue;
                for (int j = segments1.length - 1; j >= 0; --j) {
                    if (!segments1[j] || bigramBanned[rep.projection.index][i][j]) continue;
                    for (int k = segments2.length - 1; k >= 0; --k) {
                        if (!segments2[k] || bigramBanned[rep.projection.index][j][k] || trigramBanned[rep.projection.index][i][j][k]) continue;
                        return true;
                    }
                }
            }
        } else if (rep.size == 4) {
            int[] prefix = new int[rep.size - 1];
            for (int i = 0; i < prefix.length; ++i) {
                prefix[i] = rep.segs[i];
            }
            if (!BreadthFirstSelection5.effective(new FeatureRep(prefix, rep.projection))) {
                return false;
            }
            int[] suffix = new int[rep.size - 1];
            for (int i = 0; i < suffix.length; ++i) {
                suffix[i] = rep.segs[i + 1];
            }
            return BreadthFirstSelection5.effective(new FeatureRep(suffix, rep.projection));
        }
        return false;
    }

    private static void updateBannedGrams(FeatureRep rep) {
        block7: {
            block6: {
                if (rep.size == 1) {
                    return;
                }
                if (rep.size != 2) break block6;
                boolean[] segments1 = (boolean[])UCLAPhonotacticLearner.classesToBooleanVectors.get(rep.segs[0]);
                boolean[] segments2 = (boolean[])UCLAPhonotacticLearner.classesToBooleanVectors.get(rep.segs[1]);
                for (int i = segments1.length - 1; i >= 0; --i) {
                    if (!segments1[i]) continue;
                    for (int j = segments2.length - 1; j >= 0; --j) {
                        if (!segments2[j]) continue;
                        BreadthFirstSelection5.bigramBanned[rep.projection.index][i][j] = true;
                    }
                }
                break block7;
            }
            if (rep.size != 3) break block7;
            boolean[] segments1 = (boolean[])UCLAPhonotacticLearner.classesToBooleanVectors.get(rep.segs[0]);
            boolean[] segments2 = (boolean[])UCLAPhonotacticLearner.classesToBooleanVectors.get(rep.segs[1]);
            boolean[] segments3 = (boolean[])UCLAPhonotacticLearner.classesToBooleanVectors.get(rep.segs[2]);
            for (int i = segments1.length - 1; i >= 0; --i) {
                if (!segments1[i]) continue;
                for (int j = segments2.length - 1; j >= 0; --j) {
                    if (!segments2[j]) continue;
                    for (int k = segments3.length - 1; k >= 0; --k) {
                        if (!segments3[k]) continue;
                        BreadthFirstSelection5.trigramBanned[rep.projection.index][i][j][k] = true;
                    }
                }
            }
        }
    }

    private static boolean blockedByMoreGeneralConstraint(FeatureRep g) {
        double observed = -1.0;
        observed = TierFeature.evaluate(g.segs, g.projection, corpus);
        Map.Entry entry2 = null;
        FeatureRep g_ = null;
        Double observed_ = null;
        for (Map.Entry entry2 : featuresToObservedCounts.entrySet()) {
            observed_ = (Double)entry2.getValue();
            if (observed_ != observed || !BreadthFirstSelection5.moreGeneralThan(g_ = (FeatureRep)entry2.getKey(), g, g.projection.index)) continue;
            return true;
        }
        return false;
    }

    private static boolean moreGeneralThan(FeatureRep g1, FeatureRep g2, int projectionIndex) {
        if (g1.segs[0] == -1 || g2.segs[0] == -1) {
            return false;
        }
        if (g1.projection != g2.projection) {
            return false;
        }
        FeatureRep general = g1.size <= g2.size ? g1 : g2;
        FeatureRep special = general == g1 ? g2 : g1;
        int generalSize = general.size;
        int specialSize = special.size;
        if (generalSize == specialSize) {
            for (int i = generalSize - 1; i >= 0; --i) {
                if (general.segs[i] == special.segs[i] || moreGeneralThan[projectionIndex][general.segs[i]][special.segs[i]]) continue;
                return false;
            }
            return true;
        }
        if (generalSize < specialSize) {
            block1: for (int i = 0; i < specialSize - generalSize + 1; ++i) {
                for (int j = 0; j < generalSize; ++j) {
                    if (general.segs[j] != special.segs[i + j] && !moreGeneralThan[projectionIndex][general.segs[j]][special.segs[i + j]]) continue block1;
                }
                return true;
            }
        }
        return false;
    }

    private static void getSample() {
        RF.resetSample();
        sample = RF.getRandomSample(UCLAPhonotacticLearner.PRINT_SAMPLES);
        sampleSize = BreadthFirstSelection5.sample.size;
        if (UCLAPhonotacticLearner.PRINT_SAMPLES) {
            System.out.println(sample);
        }
    }

    private static void addFeature(RandomFieldFeature C) {
        double observed = 0.0;
        double expected = 0.0;
        FeatureRep CR = RandomFieldFeature.featureToRep(C);
        observed = C.evaluate(corpus);
        if (observed == 0.0) {
            BreadthFirstSelection5.updateBannedGrams(CR);
        }
        if (sample != null) {
            expected = C.evaluate(sample);
            expected /= (double)sampleSize;
            expected *= (double)corpusSize;
        }
        if (!featuresAlreadySelected.contains(C)) {
            RF.addConstraint(C);
        }
        featuresAlreadySelected.add(C);
        featuresToObservedCounts.put(CR, new Double(observed));
        System.out.println("new constraint:\t" + C + "\tO = " + observed + "\tE = " + expected);
        System.out.println();
    }

    private static void retrainWeights() {
        if (trainWeightsAfterEachSelection) {
            BreadthFirstSelection5.train(RF, Double.MIN_VALUE, Double.MIN_VALUE, 0, false);
        }
        System.out.println("\nCurrent random field:");
        RF.printConstraintsWithWeights();
    }

    private static void train(RandomField RF, double tolfx, double tolx, int prin, boolean finalTraining) {
        if (RF.Eval == null) {
            return;
        }
        if (UCLAPhonotacticLearner.WEIGHTING_ALGORITHM.equals("ConjugateGradient")) {
            RF.resetWeights();
            RF.resetSample();
            BreadthFirstSelection5.conjugateGradientMinimizer.prin = prin;
            BreadthFirstSelection5.conjugateGradientMinimizer.maxFun = UCLAPhonotacticLearner.WEIGHTING_ITERATION;
            conjugateGradientMinimizer.optimize((MultivariateFunction)RF, RF.lambda.toArray(), tolfx, tolx, null);
        } else if (UCLAPhonotacticLearner.WEIGHTING_ALGORITHM.equals("ImprovedIterativeScaling")) {
            RF.lambda.assign(0.0);
            RF.resetSample();
            iis.optimize(RF, RF.lambda, 1.0E-10, 1);
        } else if (UCLAPhonotacticLearner.WEIGHTING_ALGORITHM.equals("ObservedOverExpectedAtDiscovery") && !finalTraining) {
            int newConstraintIndex = RF.Eval.length - 1;
            double observed = RF.Eval[newConstraintIndex].evaluate(corpus);
            double expected = RF.Eval[newConstraintIndex].evaluate(RF.sample);
            RF.lambda.set(RF.lambda.size() - 1, BreadthFirstSelection5.OE(observed, expected));
        } else if (UCLAPhonotacticLearner.WEIGHTING_ALGORITHM.equals("GradientDescent")) {
            RF.resetSample();
            GradientDescent.optimize(RF, RF.lambda, 1.0);
        }
        if (UCLAPhonotacticLearner.TRACK_CORPUS_PROB && !finalTraining) {
            UCLAPhonotacticLearner.corpusNegLogProb.add(RF.negLogProb(corpus));
            UCLAPhonotacticLearner.objectiveCost.add(RF.objective(corpus));
        }
        for (int i = RF.lambda.size() - 1; i >= 0; --i) {
            if (!(RF.lambda_old.get(i) < 1.0E-4)) continue;
            RF.lambda.set(i, RF.getLowerBound(i));
        }
        RF.resetSample();
    }

    private static void clearBigramExpected(int projectionIndex) {
        for (int j = numberOfNaturalClasses - 1; j >= 0; --j) {
            Arrays.fill(bigramExpected[projectionIndex][j], 0.0);
        }
    }

    private static double expectedCount(Projection proj, int[] classes, int size) {
        boolean[][] segs = new boolean[size][];
        for (int i = 0; i < size; ++i) {
            segs[i] = (boolean[])UCLAPhonotacticLearner.classesToBooleanVectors.get(classes[i]);
        }
        if (size == 3) {
            return TierFeature.evaluateTrigram(BreadthFirstSelection5.sample.gramCounts[proj.index], (boolean[][])segs, proj.index);
        }
        System.exit(1);
        return -1.0;
    }

    private static double expectedCountTrigram(Projection proj, int c0, int c1, int c2) {
        BreadthFirstSelection5.tri[0] = (boolean[])UCLAPhonotacticLearner.classesToBooleanVectors.get(c0);
        BreadthFirstSelection5.tri[1] = (boolean[])UCLAPhonotacticLearner.classesToBooleanVectors.get(c1);
        BreadthFirstSelection5.tri[2] = (boolean[])UCLAPhonotacticLearner.classesToBooleanVectors.get(c2);
        return TierFeature.evaluateTrigram(BreadthFirstSelection5.sample.gramCounts[proj.index], tri, proj.index);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            System.exit(1);
        }
        double pstar = 0.0;
        double tinv = 0.0;
        double pi = 0.0;
        double observed = Double.parseDouble(args[0]);
        double expected = Double.parseDouble(args[1]);
        double alpha = Double.parseDouble(args[2]);
        pstar = (observed + 0.5) / (expected + 1.0);
        tdist.setDegreesOfFreedom(expected - 1.0);
        try {
            tinv = tdist.inverseCumulativeProbability((1.0 - alpha) / 2.0);
        }
        catch (Exception e) {
            System.out.println("Error: failed to compute inverse t");
            System.exit(1);
        }
        pi = pstar - tinv * Math.pow(pstar * (1.0 - pstar) / expected, 0.5);
        System.out.println(pi);
        System.exit(1);
    }
}

