/*
 * Decompiled with CFR 0.152.
 */
import cern.colt.Arrays;

public class ArraySequenceIterator {
    private int[][] A = null;
    private int I = 0;
    private int[] J = null;
    private int[] index = null;
    public int[] value = null;

    ArraySequenceIterator() {
    }

    ArraySequenceIterator(int[][] a) {
        this.setState(a);
    }

    public void setState(int[][] a) {
        int i;
        this.A = a;
        this.I = this.A.length;
        this.J = new int[this.I];
        for (i = this.I - 1; i >= 0; --i) {
            this.J[i] = this.A[i].length;
            if (this.J[i] != 0) continue;
            this.index = null;
            this.value = null;
            return;
        }
        this.index = new int[this.I];
        this.value = new int[this.I];
        for (i = this.I - 1; i >= 0; --i) {
            this.value[i] = this.A[i][this.index[i]];
        }
    }

    public void reset() {
        if (this.index == null) {
            this.index = new int[this.I];
        } else {
            for (int i = this.I - 1; i >= 0; --i) {
                this.index[i] = 0;
            }
        }
    }

    public int[] next() {
        this.increment(this.I - 1);
        if (this.index == null || this.value == null) {
            this.value = null;
        } else {
            for (int i = this.I - 1; i >= 0; --i) {
                this.value[i] = this.A[i][this.index[i]];
            }
        }
        return this.value;
    }

    private void increment(int pos) {
        if (pos < 0 || this.index == null) {
            this.index = null;
        } else {
            int n = pos;
            this.index[n] = this.index[n] + 1;
            if (this.index[pos] >= this.J[pos]) {
                this.index[pos] = 0;
                this.increment(pos - 1);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        int[] testarray = new int[]{0, 1, 2, 3, 4};
        ArraySequenceIterator asi = new ArraySequenceIterator(new int[][]{testarray, testarray, testarray});
        int[] val = null;
        while ((val = asi.next()) != null) {
            System.out.println(Arrays.toString((int[])val));
        }
    }
}

