VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   4770
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   4680
   LinkTopic       =   "Form1"
   ScaleHeight     =   4770
   ScaleWidth      =   4680
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox txtNumberOfStems 
      Alignment       =   2  'Center
      Height          =   285
      Left            =   1800
      TabIndex        =   1
      Text            =   "3000"
      Top             =   3240
      Width           =   1455
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Create pseudo-data"
      Height          =   1215
      Left            =   1440
      TabIndex        =   0
      Top             =   840
      Width           =   2295
   End
   Begin VB.Label Label1 
      Caption         =   "Make this many stems:"
      Height          =   255
      Left            =   1680
      TabIndex        =   2
      Top             =   3000
      Width           =   1695
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'Make a set of words, for phonotactic learning, that reflect the vowel-ordering principles of Khalkha, as set up by Svantesson et al.


Option Explicit

    'Vowel Inventory
        Dim mVowel(8) As String
        Dim mGoodVowelStrings() As String
        Dim mNumberOfGoodVowelStrings As Long


Private Sub Command1_Click()


    Static ButtonStatus As Boolean
    
    Dim NumberOfStems As Long
    Dim MyStem As String, MyGloss As String, i As Long
    Dim SyllableCount As Long, MyVowel1 As String, MyVowel2 As String, MyVowel3 As String
    
    If ButtonStatus = True Then
        Close
        End
    End If
    Let ButtonStatus = True
    
    Call DefineVowelInventory
    
    Open App.Path + "/PseudoKhalkha.txt" For Output As #2
    
    
    Let NumberOfStems = Val(txtNumberOfStems.Text)
    
    For i = 1 To NumberOfStems
        Let SyllableCount = Int(3 * Rnd) + 1
        'Make the first CVC sequence:
            Let MyStem = RandomConsonant()
            Let MyVowel1 = RandomInitialVowel()
            Let MyStem = MyStem + " " + MyVowel1
            Let MyStem = MyStem + " " + RandomConsonant()
        If SyllableCount > 1 Then
            Let MyVowel2 = RandomSecondVowel(MyVowel1)
            Let MyStem = MyStem + " " + MyVowel2
            Let MyStem = MyStem + " " + RandomConsonant()
        End If
        If SyllableCount > 2 Then
            Let MyVowel3 = RandomThirdVowel(MyVowel1, MyVowel2)
            Let MyStem = MyStem + " " + MyVowel3
            Let MyStem = MyStem + " " + RandomConsonant()
        End If
        Call PrintParadigm(MyStem, "", "")
    Next i
    Close #2
    
    Call CreateTestingData
    
    Let Command1.Caption = "Done.  Click again to exit."
    
End Sub

Sub DefineVowelInventory()
    Let mVowel(1) = "i"
    Let mVowel(2) = "e"
    Let mVowel(3) = "a"
    Let mVowel(4) = "o"
    Let mVowel(5) = "u"
    Let mVowel(6) = "U"
    Let mVowel(7) = "O"
    Let mVowel(8) = "I"
End Sub

Sub PrintParadigm(Stem As String, StemType As String, MyGloss As String)

        Dim MyVowelString As String, i As Long
        
        Print #2, Stem
        
        Let MyVowelString = FormVowelString(Stem)
        'Find the right answer.
            For i = 1 To mNumberOfGoodVowelStrings
                If MyVowelString = mGoodVowelStrings(i) Then
                    Exit Sub
                End If
            Next i
            Let mNumberOfGoodVowelStrings = mNumberOfGoodVowelStrings + 1
            ReDim Preserve mGoodVowelStrings(mNumberOfGoodVowelStrings)
            Let mGoodVowelStrings(mNumberOfGoodVowelStrings) = MyVowelString
        
        
        'If StemType = "back" Then
        '    Print #2, "m a " + Stem; Chr(9); MyGloss + " " + "1pers."
       '     Print #2, "p l u m a " + Stem; Chr(9); MyGloss + " " + "1pers. 1plur."
       '     Print #2, Stem + " n o" + Chr(9); MyGloss + " " + "2pers."
       '     Print #2, Stem + " n o z u" + Chr(9); MyGloss + " " + "2pers. 2plur."
       ' Else
       '     Print #2, "m ae " + Stem; Chr(9); MyGloss + " " + "1pers."
       '     Print #2, "p l i m ae " + Stem; Chr(9); MyGloss + " " + "1pers. 1plur."
       '     Print #2, Stem + " n e" + Chr(9); MyGloss + " " + "2pers."
       '     Print #2, Stem + " n e z i" + Chr(9); MyGloss + " " + "2pers. 2plur."
       ' End If
       ' Print #2,

End Sub

Function RandomConsonant() As String

    Dim MyRandom As Single
    
    Let MyRandom = 9 * Rnd
    
    If MyRandom > 8 Then
        Let RandomConsonant = "p"
    ElseIf MyRandom > 7 Then
        Let RandomConsonant = "t"
    ElseIf MyRandom > 6 Then
        Let RandomConsonant = "k"
    ElseIf MyRandom > 5 Then
        Let RandomConsonant = "m"
    ElseIf MyRandom > 4 Then
        Let RandomConsonant = "n"
    ElseIf MyRandom > 3 Then
        Let RandomConsonant = "N"
    ElseIf MyRandom > 2 Then
        Let RandomConsonant = "r"
    ElseIf MyRandom > 1 Then
        Let RandomConsonant = "w"
    Else
        Let RandomConsonant = "y"
    End If
    
End Function

Function RandomInitialVowel() As String

    'Any vowel but [I]
    
    Dim MyRandom As Single
        
    Let MyRandom = 7 * Rnd
 
    If MyRandom > 6 Then
        Let RandomInitialVowel = mVowel(7)
    ElseIf MyRandom > 5 Then
        Let RandomInitialVowel = mVowel(6)
    ElseIf MyRandom > 4 Then
        Let RandomInitialVowel = mVowel(5)
    ElseIf MyRandom > 3 Then
        Let RandomInitialVowel = mVowel(4)
    ElseIf MyRandom > 2 Then
        Let RandomInitialVowel = mVowel(3)
    ElseIf MyRandom > 1 Then
        Let RandomInitialVowel = mVowel(2)
    Else
        Let RandomInitialVowel = mVowel(1)
    End If
    
End Function

Function RandomSecondVowel(MyPredecessor As String) As String

    Dim MyRand As Single
    
    Let MyRand = Rnd()
    
    Select Case MyPredecessor
        Case "i", "u", "e"
            If MyRand > 0.667 Then
                Let RandomSecondVowel = "u"
            ElseIf MyRand > 0.333 Then
                Let RandomSecondVowel = "e"
            Else
                Let RandomSecondVowel = "i"
            End If
        Case "o"
            If MyRand > 0.75 Then
                Let RandomSecondVowel = "u"
            ElseIf MyRand > 0.5 Then
                Let RandomSecondVowel = "e"
            ElseIf MyRand > 0.25 Then
                Let RandomSecondVowel = "o"
            Else
                Let RandomSecondVowel = "i"
            End If
        Case "U", "a"
            If MyRand > 0.667 Then
                Let RandomSecondVowel = "I"
            ElseIf MyRand > 0.333 Then
                Let RandomSecondVowel = "U"
            Else
                Let RandomSecondVowel = "a"
            End If
        Case "O"
            If MyRand > 0.667 Then
                Let RandomSecondVowel = "I"
            ElseIf MyRand > 0.333 Then
                Let RandomSecondVowel = "U"
            Else
                Let RandomSecondVowel = "O"
            End If
        Case "I"
            If MyRand > 0.667 Then
                Let RandomSecondVowel = "I"
            ElseIf MyRand > 0.333 Then
                Let RandomSecondVowel = "U"
            Else
                Let RandomSecondVowel = "a"
            End If
    End Select
    
End Function

Function RandomThirdVowel(Vowel1 As String, Vowel2 As String)

    Select Case Vowel2
        Case "i", "I"
            Let RandomThirdVowel = RandomSecondVowel(Vowel1)
        Case Else
            Let RandomThirdVowel = RandomSecondVowel(Vowel2)
    End Select
    
End Function

Sub CreateTestingData()

    Dim v1 As Long, v2 As Long, v3 As Long
    
    Open App.Path + "/KhalkhaTestingData.txt" For Output As #2
    
    For v1 = 1 To 8
        Print #2, "p "; mVowel(v1); " p";
                If IsGoodVowelString(mVowel(v1)) Then
                    Print #2, Chr(9); "good"
                Else
                    Print #2,
                End If
    Next v1
    
    For v1 = 1 To 8
        For v2 = 1 To 8
            Print #2, "p "; mVowel(v1); " p "; mVowel(v2); " p";
                If IsGoodVowelString(mVowel(v1) + mVowel(v2)) Then
                    Print #2, Chr(9); "good"
                Else
                    Print #2,
                End If
        Next v2
    Next v1
    
    For v1 = 1 To 8
        For v2 = 1 To 8
            For v3 = 1 To 8
                Print #2, "p "; mVowel(v1); " p "; mVowel(v2); " p " + mVowel(v3) + " p";
                If IsGoodVowelString(mVowel(v1) + mVowel(v2) + mVowel(v3)) Then
                    Print #2, Chr(9); "good"
                Else
                    Print #2,
                End If
            Next v3
        Next v2
    Next v1
    
    Close #2
    
    
End Sub

Function IsGoodVowelString(MyVowelString As String) As Boolean

    Dim i
    For i = 1 To mNumberOfGoodVowelStrings
        If MyVowelString = mGoodVowelStrings(i) Then
            Let IsGoodVowelString = True
            Exit Function
        End If
    Next i
End Function

Function FormVowelString(MyWord As String) As String
    Dim Buffer As String, MySegment, i As Long, v As Long
    For i = 1 To Len(MyWord)
        For v = 1 To 8
            If Mid(MyWord, i, 1) = mVowel(v) Then
                Let Buffer = Buffer + Mid(MyWord, i, 1)
            End If
        Next v
    Next i
    Let FormVowelString = Buffer
    
End Function

Function Gloss() As String

    Static GlossIndex
    Dim ListOfGlosses(30) As String
    
    Let ListOfGlosses(1) = "stemGoat"
    Let ListOfGlosses(2) = "stemSheep"
    Let ListOfGlosses(3) = "stemCow"
    Let ListOfGlosses(4) = "stemPig"
    Let ListOfGlosses(5) = "stemDuck"
    Let ListOfGlosses(6) = "stemChicken"
    Let ListOfGlosses(7) = "stemFrog"
    Let ListOfGlosses(8) = "stemHorse"
    Let ListOfGlosses(9) = "stemFish"
    Let ListOfGlosses(10) = "stemTurtle"
    Let ListOfGlosses(11) = "stemDove"
    Let ListOfGlosses(12) = "stemEagle"
    Let ListOfGlosses(13) = "stemRabbit"
    Let ListOfGlosses(14) = "stemFox"
    Let ListOfGlosses(15) = "stemBear"
    Let ListOfGlosses(16) = "stemSalmon"
    Let ListOfGlosses(17) = "stemDog"
    Let ListOfGlosses(18) = "stemWolf"
    Let ListOfGlosses(19) = "stemLoom"
    Let ListOfGlosses(20) = "stemHearth"
    Let ListOfGlosses(21) = "stemCup"
    Let ListOfGlosses(22) = "stemFire"
    Let ListOfGlosses(23) = "stemTable"
    Let ListOfGlosses(24) = "stemThreshold"
    Let ListOfGlosses(25) = "stemRoof"
    Let ListOfGlosses(26) = "stemStool"
    Let ListOfGlosses(27) = "stemWashtub"
    Let ListOfGlosses(28) = "stemBed"
    Let ListOfGlosses(29) = "stemHoe"
    Let ListOfGlosses(30) = "stemPlow"
    
    Let GlossIndex = GlossIndex + 1
    Let Gloss = ListOfGlosses(GlossIndex)
    
End Function

