VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   3045
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   4680
   LinkTopic       =   "Form1"
   ScaleHeight     =   3045
   ScaleWidth      =   4680
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton Command1 
      Caption         =   "Create pseudo-data"
      Height          =   1215
      Left            =   1440
      TabIndex        =   0
      Top             =   840
      Width           =   2295
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'Make a set of words, for phonotactic learning, that reflect the vowel-ordering principles of Khalkha, as set up by Svantesson et al.


Option Explicit

    'Vowel Inventory
        Dim mVowel(8) As String
        Dim mGoodVowelStrings() As String
        Dim mNumberOfGoodVowelStrings As Long


Private Sub Command1_Click()


    Static ButtonStatus As Boolean
    
    Dim NumberOfStems As Long
    Dim MyStem As String, MyGloss As String, i As Long
    Dim SyllableCount As Long, MyVowel As String
    
    If ButtonStatus = True Then
        Close
        End
    End If
    Let ButtonStatus = True
    
    Call DefineVowelInventory
    
    Open App.Path + "/PseudoKhalkha.txt" For Output As #2
    
    For i = 1 To 7
        Let MyVowel = mVowel(i)
        Let MyStem = RandomConsonant() + " " + MyVowel + " " + RandomConsonant()
        Let MyGloss = Gloss
        Call PrintParadigm(MyStem, mVowel(i), MyGloss)
    Next i
    
    Close #2
    
    Let Command1.Caption = "Done.  Click again to exit."
    
End Sub

Sub DefineVowelInventory()
    Let mVowel(1) = "i"
    Let mVowel(2) = "e"
    Let mVowel(3) = "a"
    Let mVowel(4) = "o"
    Let mVowel(5) = "u"
    Let mVowel(6) = "U"
    Let mVowel(7) = "O"
    Let mVowel(8) = "I"
End Sub

Sub PrintParadigm(Stem As String, StemType As String, MyGloss As String)

        Dim MyVowelString As String, i As Long
        Dim My1Sg As String, My2Sg As String, My3Sg As String
        Dim MyDative As String, MyAccusative As String
        Dim MyDative1Sg As String, MyDative2Sg As String, MyDative3Sg As String
        Dim MyAccusive1Sg As String, MyAccusive2Sg As String, MyAccusive3Sg As String
        
        'Case alone:
        Let MyDative = Phonology(Stem, "dative")
        Print #2, MyDative; Chr(9); MyGloss; " dative"
        Let MyAccusative = Phonology(Stem, "accusative")
        Print #2, MyAccusative; Chr(9); MyGloss; " accusative"
        
        'Possessor alone:
        Let My1Sg = Phonology(Stem, "1sg")
        Print #2, My1Sg; Chr(9); MyGloss; " 1sg"
        Let My2Sg = Phonology(Stem, "2sg")
        Print #2, My2Sg; Chr(9); MyGloss; " 2sg"
        Let My3Sg = Phonology(Stem, "3sg")
        Print #2, My3Sg; Chr(9); MyGloss; " 3sg"
        
        'Possessed datives:
        Let MyDative1Sg = Phonology(MyDative, "1sg")
        Print #2, MyDative1Sg; Chr(9); MyGloss; " dative 1sg"
        Let MyDative2Sg = Phonology(MyDative, "2sg")
        Print #2, MyDative2Sg; Chr(9); MyGloss; " dative 2sg"
        Let MyDative3Sg = Phonology(MyDative, "3sg")
        Print #2, MyDative3Sg; Chr(9); MyGloss; " dative 3sg"
        
        'Possessed accusatives:
        Let MyAccusive1Sg = Phonology(MyAccusative, "1sg")
        Print #2, MyAccusive1Sg; Chr(9); MyGloss; " accusative 1sg"
        Let MyAccusive2Sg = Phonology(MyAccusative, "2sg")
        Print #2, MyAccusive2Sg; Chr(9); MyGloss; " accusative 2sg"
        Let MyAccusive3Sg = Phonology(MyAccusative, "3sg")
        Print #2, MyAccusive3Sg; Chr(9); MyGloss; " accusative 3sg"
        

End Sub

Function Phonology(MyStem As String, MyEnding As String)

    Dim MyConsonant As String, MyVowel As String, LastVowelInBase As String
    
    Select Case MyEnding
        Case "dative"
            Let MyConsonant = "d"
            Let MyVowel = HarmonicVowel(MyStem, "i")
        Case "accusative"
            Let MyConsonant = "k"
            Let MyVowel = HarmonicVowel(MyStem, "u")
        Case "1sg"
            Let MyConsonant = "m"
            Let MyVowel = HarmonicVowel(MyStem, "i")
        Case "2sg"
            Let MyConsonant = "t"
            Let MyVowel = HarmonicVowel(MyStem, "e")
        Case "3sg"
            Let MyConsonant = "s"
            Let MyVowel = HarmonicVowel(MyStem, "u")
    End Select
            
    Let Phonology = MyStem + " " + MyConsonant + " " + MyVowel
    

End Function

Function HarmonicVowel(MyStem As String, MyUnderlyingVowel As String)

    Dim MyVowelProjection As String
    
    'Find the vowel sequence.
        Let MyVowelProjection = VowelProjection(MyStem)
        
    'Just go with a list of vowel projections
        Select Case MyUnderlyingVowel
            Case "e"
                Select Case MyVowelProjection
                    Case "i", "ii"
                        Let HarmonicVowel = "e"
                    Case "e", "ei"
                        Let HarmonicVowel = "e"
                    Case "u", "ui"
                        Let HarmonicVowel = "e"
                    Case "U", "Ui"
                        Let HarmonicVowel = "a"
                    Case "o", "oi"
                        Let HarmonicVowel = "o"
                    Case "O", "Oi"
                        Let HarmonicVowel = "O"
                    Case "iu", "eu", "uu", "ou"
                        Let HarmonicVowel = "e"
                    Case "a", "UU", "OU", "aU", "ai"
                        Let HarmonicVowel = "a"
                End Select
            Case "i"
                Let HarmonicVowel = "i"
            Case "u"
                Select Case MyVowelProjection
                    Case "i", "ii"
                        Let HarmonicVowel = "u"
                    Case "e", "ei"
                        Let HarmonicVowel = "u"
                    Case "u", "ui"
                        Let HarmonicVowel = "u"
                    Case "U", "Ui", "O", "Oi"
                        Let HarmonicVowel = "U"
                    Case "o", "oi"
                        Let HarmonicVowel = "u"
                    Case "O", "Oi"
                        Let HarmonicVowel = "U"
                    Case "iu", "eu", "uu", "ou"
                        Let HarmonicVowel = "u"
                    Case "a", "UU", "OU", "aU", "ai"
                        Let HarmonicVowel = "U"
                End Select
        End Select
        
        

End Function

Function VowelProjection(MyStem As String) As String

    Dim i As Long, j As Long, Buffer As String
    For i = 1 To Len(MyStem)
        For j = 1 To 7
            If Mid(MyStem, i, 1) = mVowel(j) Then
                Let Buffer = Buffer + Mid(MyStem, i, 1)
                Exit For
            End If
        Next j
    Next i
    Let VowelProjection = Buffer
    

End Function

Function RandomConsonant() As String

    Dim MyRandom As Single
    
    Let MyRandom = 9 * Rnd
    
    If MyRandom > 8 Then
        Let RandomConsonant = "p"
    ElseIf MyRandom > 7 Then
        Let RandomConsonant = "t"
    ElseIf MyRandom > 6 Then
        Let RandomConsonant = "k"
    ElseIf MyRandom > 5 Then
        Let RandomConsonant = "m"
    ElseIf MyRandom > 4 Then
        Let RandomConsonant = "n"
    ElseIf MyRandom > 3 Then
        Let RandomConsonant = "ng"
    ElseIf MyRandom > 2 Then
        Let RandomConsonant = "r"
    ElseIf MyRandom > 1 Then
        Let RandomConsonant = "w"
    Else
        Let RandomConsonant = "j"
    End If
    
End Function

Function RandomInitialVowel() As String

    'Any vowel but [I]
    
    Dim MyRandom As Single
        
    Let MyRandom = 7 * Rnd
 
    If MyRandom > 6 Then
        Let RandomInitialVowel = mVowel(7)
    ElseIf MyRandom > 5 Then
        Let RandomInitialVowel = mVowel(6)
    ElseIf MyRandom > 4 Then
        Let RandomInitialVowel = mVowel(5)
    ElseIf MyRandom > 3 Then
        Let RandomInitialVowel = mVowel(4)
    ElseIf MyRandom > 2 Then
        Let RandomInitialVowel = mVowel(3)
    ElseIf MyRandom > 1 Then
        Let RandomInitialVowel = mVowel(2)
    Else
        Let RandomInitialVowel = mVowel(1)
    End If
    
End Function

Function RandomSecondVowel(MyPredecessor As String) As String

    Dim MyRand As Single
    
    Let MyRand = Rnd()
    
    Select Case MyPredecessor
        Case "i", "u", "e"
            If MyRand > 0.667 Then
                Let RandomSecondVowel = "u"
            ElseIf MyRand > 0.333 Then
                Let RandomSecondVowel = "e"
            Else
                Let RandomSecondVowel = "i"
            End If
        Case "o"
            If MyRand > 0.75 Then
                Let RandomSecondVowel = "u"
            ElseIf MyRand > 0.5 Then
                Let RandomSecondVowel = "e"
            ElseIf MyRand > 0.25 Then
                Let RandomSecondVowel = "o"
            Else
                Let RandomSecondVowel = "i"
            End If
        Case "U", "a"
            If MyRand > 0.667 Then
                Let RandomSecondVowel = "I"
            ElseIf MyRand > 0.333 Then
                Let RandomSecondVowel = "U"
            Else
                Let RandomSecondVowel = "a"
            End If
        Case "O"
            If MyRand > 0.667 Then
                Let RandomSecondVowel = "I"
            ElseIf MyRand > 0.333 Then
                Let RandomSecondVowel = "U"
            Else
                Let RandomSecondVowel = "O"
            End If
        Case "I"
            If MyRand > 0.667 Then
                Let RandomSecondVowel = "I"
            ElseIf MyRand > 0.333 Then
                Let RandomSecondVowel = "U"
            Else
                Let RandomSecondVowel = "a"
            End If
    End Select
    
End Function

Function RandomThirdVowel(Vowel1 As String, Vowel2 As String)

    Select Case Vowel2
        Case "i", "I"
            Let RandomThirdVowel = RandomSecondVowel(Vowel1)
        Case Else
            Let RandomThirdVowel = RandomSecondVowel(Vowel2)
    End Select
    
End Function

Sub CreateTestingData()

    Dim v1 As Long, v2 As Long, v3 As Long
    
    Open App.Path + "/KhalkhaTestingData.txt" For Output As #2
    
    For v1 = 1 To 8
        Print #2, "p "; mVowel(v1); " p";
                If IsGoodVowelString(mVowel(v1)) Then
                    Print #2, Chr(9); "good"
                Else
                    Print #2,
                End If
    Next v1
    
    For v1 = 1 To 8
        For v2 = 1 To 8
            Print #2, "p "; mVowel(v1); " p "; mVowel(v2); " p";
                If IsGoodVowelString(mVowel(v1) + mVowel(v2)) Then
                    Print #2, Chr(9); "good"
                Else
                    Print #2,
                End If
        Next v2
    Next v1
    
    For v1 = 1 To 8
        For v2 = 1 To 8
            For v3 = 1 To 8
                Print #2, "p "; mVowel(v1); " p "; mVowel(v2); " p " + mVowel(v3) + " p";
                If IsGoodVowelString(mVowel(v1) + mVowel(v2) + mVowel(v3)) Then
                    Print #2, Chr(9); "good"
                Else
                    Print #2,
                End If
            Next v3
        Next v2
    Next v1
    
    Close #2
    
    
End Sub

Function IsGoodVowelString(MyVowelString As String) As Boolean

    Dim i
    For i = 1 To mNumberOfGoodVowelStrings
        If MyVowelString = mGoodVowelStrings(i) Then
            Let IsGoodVowelString = True
            Exit Function
        End If
    Next i
End Function

Function FormVowelString(MyWord As String) As String
    Dim Buffer As String, MySegment, i As Long, v As Long
    For i = 1 To Len(MyWord)
        For v = 1 To 8
            If Mid(MyWord, i, 1) = mVowel(v) Then
                Let Buffer = Buffer + Mid(MyWord, i, 1)
            End If
        Next v
    Next i
    Let FormVowelString = Buffer
    
End Function

Function Gloss() As String

    Static GlossIndex
    Dim ListOfGlosses(30) As String
    
    Let ListOfGlosses(1) = "stemGoat"
    Let ListOfGlosses(2) = "stemSheep"
    Let ListOfGlosses(3) = "stemCow"
    Let ListOfGlosses(4) = "stemPig"
    Let ListOfGlosses(5) = "stemDuck"
    Let ListOfGlosses(6) = "stemChicken"
    Let ListOfGlosses(7) = "stemFrog"
    Let ListOfGlosses(8) = "stemHorse"
    Let ListOfGlosses(9) = "stemFish"
    Let ListOfGlosses(10) = "stemTurtle"
    Let ListOfGlosses(11) = "stemDove"
    Let ListOfGlosses(12) = "stemEagle"
    Let ListOfGlosses(13) = "stemRabbit"
    Let ListOfGlosses(14) = "stemFox"
    Let ListOfGlosses(15) = "stemBear"
    Let ListOfGlosses(16) = "stemSalmon"
    Let ListOfGlosses(17) = "stemDog"
    Let ListOfGlosses(18) = "stemWolf"
    Let ListOfGlosses(19) = "stemLoom"
    Let ListOfGlosses(20) = "stemHearth"
    Let ListOfGlosses(21) = "stemCup"
    Let ListOfGlosses(22) = "stemFire"
    Let ListOfGlosses(23) = "stemTable"
    Let ListOfGlosses(24) = "stemThreshold"
    Let ListOfGlosses(25) = "stemRoof"
    Let ListOfGlosses(26) = "stemStool"
    Let ListOfGlosses(27) = "stemWashtub"
    Let ListOfGlosses(28) = "stemBed"
    Let ListOfGlosses(29) = "stemHoe"
    Let ListOfGlosses(30) = "stemPlow"
    
    Let GlossIndex = GlossIndex + 1
    Let Gloss = ListOfGlosses(GlossIndex)
    
End Function

