/*
 * Decompiled with CFR 0.152.
 */
package PLUI;

import PLUI.LearnerThread;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

class SaveOutput
extends PrintStream {
    static OutputStream logfile;
    static PrintStream oldStdout;
    static PrintStream oldStderr;
    static LearnerThread workerThread;

    SaveOutput(PrintStream ps) {
        super(ps);
    }

    public static void start(String f, LearnerThread thread) throws IOException {
        workerThread = thread;
        oldStdout = System.out;
        oldStderr = System.err;
        logfile = new PrintStream(new BufferedOutputStream(new FileOutputStream(f)));
        System.setOut(new SaveOutput(System.out));
        System.setErr(new SaveOutput(System.err));
    }

    public static void stop() {
        workerThread = null;
        System.setOut(oldStdout);
        System.setErr(oldStderr);
        try {
            logfile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void write(int b) {
        try {
            logfile.write(b);
            if (workerThread != null) {
                workerThread.publicPublish(Integer.toString(b));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setError();
        }
        super.write(b);
    }

    public void write(byte[] buf, int off, int len) {
        try {
            logfile.write(buf, off, len);
            if (workerThread != null) {
                workerThread.publicPublish(new String(buf, off, len));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setError();
        }
        super.write(buf, off, len);
    }
}

