/*
 * Decompiled with CFR 0.152.
 */
package PLUI;

import PLUI.GettingStartedDlg;
import PLUI.PLData;
import PLUI.PLUIDataItem;
import PLUI.WorkingDlg;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;

public class PLUIMainFrame
extends JFrame {
    GettingStartedDlg gsdlg = new GettingStartedDlg((Frame)this, false);
    static final String ManualFilename = "Manual.pdf";
    public static final String InitFilename = "PLsettings.ini";
    private JButton ButtonChangeAccuracySchedule;
    private JButton ButtonChangeConstraintsFile;
    private JButton ButtonChangeFeatFile;
    private JButton ButtonChangeFileLoc;
    private JButton ButtonChangeNGramLimitsFile;
    private JButton ButtonChangeTestFile;
    private JButton ButtonChangeTiersFile;
    private JButton ButtonChangeTrainingFile;
    private JButton ButtonGo;
    private JButton ButtonViewAccuracySchedule;
    private JButton ButtonViewConstraintsFile;
    private JButton ButtonViewFeatFile;
    private JButton ButtonViewNGramLimitsFile;
    private JButton ButtonViewTestFile;
    private JButton ButtonViewTiersFile;
    private JButton ButtonViewTrainingFile;
    private JCheckBox CheckAllowComplements;
    private JPanel CommandsPanel;
    private JRadioButton RadioReweightExisting;
    private JRadioButton RadioStartNew;
    private JRadioButton RadioStartWithGrammar;
    private JRadioButton RadioTestExisting;
    private ButtonGroup TaskButtonGroup;
    private JPanel TaskPanel;
    private JTextField TextAccuracySchedule;
    private JTextField TextConstraintsFile;
    private JTextField TextFeatFile;
    private JTextField TextFilesLoc;
    private JTextField TextLearningSampleSize;
    private JTextField TextMaxConstraints;
    private JTextField TextMaxGramSize;
    private JTextField TextMaxOE;
    private JTextField TextMaxPathLength;
    private JTextField TextNGramLimitsFile;
    private JTextField TextSigma2;
    private JTextField TextSmoothing;
    private JTextField TextTestFile;
    private JTextField TextTiersFile;
    private JTextField TextTrainingFile;
    private JButton jButtonGettingStarted;
    private JButton jButtonHelp;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JFileChooser dirChooser;
    private JFileChooser javaExecChooser;
    private PLData data;
    private LinkedHashSet fileIndex;
    private JSeparator jSeparator1;

    public PLUIMainFrame() {
        this.initComponents();
        this.dirChooser = new JFileChooser();
        this.dirChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        this.javaExecChooser = new JFileChooser();
        this.javaExecChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        this.fileIndex = new LinkedHashSet();
        this.fileIndex.add(new PLUIDataItem(0, this.TextFeatFile, this.ButtonChangeFeatFile, this.ButtonViewFeatFile));
        this.fileIndex.add(new PLUIDataItem(1, this.TextTestFile, this.ButtonChangeTestFile, this.ButtonViewTestFile));
        this.fileIndex.add(new PLUIDataItem(2, this.TextTrainingFile, this.ButtonChangeTrainingFile, this.ButtonViewTrainingFile));
        this.fileIndex.add(new PLUIDataItem(3, this.TextNGramLimitsFile, this.ButtonChangeNGramLimitsFile, this.ButtonViewNGramLimitsFile));
        this.fileIndex.add(new PLUIDataItem(4, this.TextAccuracySchedule, this.ButtonChangeAccuracySchedule, this.ButtonViewAccuracySchedule));
        this.fileIndex.add(new PLUIDataItem(5, this.TextConstraintsFile, this.ButtonChangeConstraintsFile, this.ButtonViewConstraintsFile));
        this.fileIndex.add(new PLUIDataItem(6, this.TextTiersFile, this.ButtonChangeTiersFile, this.ButtonViewTiersFile));
        this.data = new PLData(this);
        this.data.ReadSettingsFromFile();
        this.DisplaySettingsToGui();
    }

    private void initComponents() {
        this.TaskButtonGroup = new ButtonGroup();
        this.CommandsPanel = new JPanel();
        this.ButtonGo = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonGettingStarted = new JButton();
        this.jLabel10 = new JLabel();
        this.TextFilesLoc = new JTextField();
        this.ButtonChangeFileLoc = new JButton();
        this.TaskPanel = new JPanel();
        this.RadioStartNew = new JRadioButton();
        this.RadioTestExisting = new JRadioButton();
        this.RadioStartWithGrammar = new JRadioButton();
        this.RadioReweightExisting = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.jLabel9 = new JLabel();
        this.ButtonChangeNGramLimitsFile = new JButton();
        this.ButtonViewNGramLimitsFile = new JButton();
        this.TextNGramLimitsFile = new JTextField();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.ButtonChangeAccuracySchedule = new JButton();
        this.ButtonChangeConstraintsFile = new JButton();
        this.ButtonViewAccuracySchedule = new JButton();
        this.ButtonViewConstraintsFile = new JButton();
        this.TextAccuracySchedule = new JTextField();
        this.TextConstraintsFile = new JTextField();
        this.jLabel17 = new JLabel();
        this.jPanel2 = new JPanel();
        this.TextFeatFile = new JTextField();
        this.TextTiersFile = new JTextField();
        this.TextTrainingFile = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jLabel11 = new JLabel();
        this.ButtonViewFeatFile = new JButton();
        this.ButtonViewTiersFile = new JButton();
        this.ButtonViewTrainingFile = new JButton();
        this.ButtonChangeTrainingFile = new JButton();
        this.ButtonChangeTiersFile = new JButton();
        this.ButtonChangeFeatFile = new JButton();
        this.jLabel16 = new JLabel();
        this.jLabel12 = new JLabel();
        this.TextTestFile = new JTextField();
        this.ButtonViewTestFile = new JButton();
        this.ButtonChangeTestFile = new JButton();
        this.jPanel4 = new JPanel();
        this.jLabel3 = new JLabel();
        this.TextMaxConstraints = new JTextField();
        this.jLabel7 = new JLabel();
        this.TextMaxGramSize = new JTextField();
        this.jLabel8 = new JLabel();
        this.TextMaxOE = new JTextField();
        this.CheckAllowComplements = new JCheckBox();
        this.jLabel18 = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.TextSigma2 = new JTextField();
        this.TextLearningSampleSize = new JTextField();
        this.TextSmoothing = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel19 = new JLabel();
        this.TextMaxPathLength = new JTextField();
        this.jSeparator3 = new JSeparator();
        this.setDefaultCloseOperation(3);
        this.setTitle("UCLA Phonotactic Learner");
        this.setCursor(new Cursor(0));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PLUIMainFrame.this.formWindowClosing(evt);
            }
        });
        this.ButtonGo.setFont(new Font("MS Sans Serif", 0, 20));
        this.ButtonGo.setText("Go");
        this.ButtonGo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PLUIMainFrame.this.ButtonGoActionPerformed(evt);
            }
        });
        this.jButtonHelp.setFont(new Font("MS Sans Serif", 0, 18));
        this.jButtonHelp.setText("View Manual (pdf)");
        this.jButtonHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PLUIMainFrame.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonGettingStarted.setFont(new Font("SansSerif", 0, 18));
        this.jButtonGettingStarted.setText("Getting Started");
        this.jButtonGettingStarted.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PLUIMainFrame.this.jButtonGettingStartedActionPerformed(evt);
            }
        });
        this.jLabel10.setFont(new Font("Tahoma", 1, 11));
        this.jLabel10.setLabelFor(this.TextFilesLoc);
        this.jLabel10.setText("Working Folder:");
        this.ButtonChangeFileLoc.setText("Change");
        this.ButtonChangeFileLoc.setMargin(new Insets(0, 5, 0, 5));
        this.ButtonChangeFileLoc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PLUIMainFrame.this.ButtonChangeFileLocActionPerformed(evt);
            }
        });
        this.TaskPanel.setBorder(BorderFactory.createTitledBorder(null, "Choose a Task", 0, 0, new Font("Tahoma", 0, 11), SystemColor.windowText));
        this.TaskButtonGroup.add(this.RadioStartNew);
        this.RadioStartNew.setSelected(true);
        this.RadioStartNew.setText("Start from scratch - discover all new constraints");
        this.RadioStartNew.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.RadioStartNew.setMargin(new Insets(0, 0, 0, 0));
        this.RadioStartNew.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                PLUIMainFrame.this.RadioStartNewItemStateChanged(evt);
            }
        });
        this.TaskButtonGroup.add(this.RadioTestExisting);
        this.RadioTestExisting.setText("Test an existing grammar with the test data");
        this.RadioTestExisting.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.RadioTestExisting.setMargin(new Insets(0, 0, 0, 0));
        this.RadioTestExisting.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                PLUIMainFrame.this.RadioTestExistingItemStateChanged(evt);
            }
        });
        this.TaskButtonGroup.add(this.RadioStartWithGrammar);
        this.RadioStartWithGrammar.setText("Add more constraints to an existing grammar");
        this.RadioStartWithGrammar.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.RadioStartWithGrammar.setMargin(new Insets(0, 0, 0, 0));
        this.RadioStartWithGrammar.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                PLUIMainFrame.this.RadioStartWithGrammarItemStateChanged(evt);
            }
        });
        this.TaskButtonGroup.add(this.RadioReweightExisting);
        this.RadioReweightExisting.setText("Reweight the constraints of an existing grammar");
        this.RadioReweightExisting.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.RadioReweightExisting.setMargin(new Insets(0, 0, 0, 0));
        this.RadioReweightExisting.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                PLUIMainFrame.this.RadioReweightExistingItemStateChanged(evt);
            }
        });
        GroupLayout TaskPanelLayout = new GroupLayout((Container)this.TaskPanel);
        this.TaskPanel.setLayout((LayoutManager)TaskPanelLayout);
        TaskPanelLayout.setHorizontalGroup((GroupLayout.Group)TaskPanelLayout.createParallelGroup(1).add((GroupLayout.Group)TaskPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)TaskPanelLayout.createParallelGroup(1).add((Component)this.RadioStartNew).add((Component)this.RadioTestExisting).add((Component)this.RadioStartWithGrammar).add((Component)this.RadioReweightExisting)).addContainerGap(-1, Short.MAX_VALUE)));
        TaskPanelLayout.setVerticalGroup((GroupLayout.Group)TaskPanelLayout.createParallelGroup(1).add((GroupLayout.Group)TaskPanelLayout.createSequentialGroup().add((Component)this.RadioStartNew, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.RadioTestExisting).addPreferredGap(0).add((Component)this.RadioStartWithGrammar).addPreferredGap(0).add((Component)this.RadioReweightExisting).addContainerGap()));
        GroupLayout CommandsPanelLayout = new GroupLayout((Container)this.CommandsPanel);
        this.CommandsPanel.setLayout((LayoutManager)CommandsPanelLayout);
        CommandsPanelLayout.setHorizontalGroup((GroupLayout.Group)CommandsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)CommandsPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)CommandsPanelLayout.createParallelGroup(2, false).add(1, (GroupLayout.Group)CommandsPanelLayout.createSequentialGroup().add((Component)this.jLabel10).addPreferredGap(0).add((Component)this.TextFilesLoc).addPreferredGap(0).add((Component)this.ButtonChangeFileLoc).addPreferredGap(0)).add(1, (GroupLayout.Group)CommandsPanelLayout.createSequentialGroup().add((GroupLayout.Group)CommandsPanelLayout.createParallelGroup(2, false).add(1, (Component)this.ButtonGo, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jButtonGettingStarted, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jButtonHelp, -1, 236, Short.MAX_VALUE)).add(123, 123, 123).add((Component)this.TaskPanel, -2, -1, -2))).addContainerGap(159, Short.MAX_VALUE)));
        CommandsPanelLayout.setVerticalGroup((GroupLayout.Group)CommandsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)CommandsPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)CommandsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)CommandsPanelLayout.createSequentialGroup().add((Component)this.ButtonGo, -2, 35, -2).addPreferredGap(0).add((Component)this.jButtonGettingStarted, -2, 35, -2).addPreferredGap(0).add((Component)this.jButtonHelp, -2, 35, -2)).add((Component)this.TaskPanel, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)CommandsPanelLayout.createParallelGroup(3).add((Component)this.jLabel10).add((Component)this.TextFilesLoc, -2, -1, -2).add((Component)this.ButtonChangeFileLoc)).add(405, 405, 405)));
        this.jLabel9.setFont(new Font("MS Sans Serif", 0, 24));
        this.jLabel9.setText("Advanced Files");
        this.ButtonChangeNGramLimitsFile.setText("Change");
        this.ButtonChangeNGramLimitsFile.setMargin(new Insets(0, 5, 0, 5));
        this.ButtonChangeNGramLimitsFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PLUIMainFrame.this.ButtonChangeActionPerformed(evt);
            }
        });
        this.ButtonViewNGramLimitsFile.setText("View");
        this.ButtonViewNGramLimitsFile.setMargin(new Insets(0, 5, 0, 5));
        this.ButtonViewNGramLimitsFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PLUIMainFrame.this.ButtonViewActionPerformed(evt);
            }
        });
        this.jLabel13.setLabelFor(this.TextNGramLimitsFile);
        this.jLabel13.setText("Limitations on n-gram constraints:");
        this.jLabel14.setLabelFor(this.TextConstraintsFile);
        this.jLabel14.setText("<html>Start the grammar already including these constraints:</html>");
        this.ButtonChangeAccuracySchedule.setText("Change");
        this.ButtonChangeAccuracySchedule.setMargin(new Insets(0, 5, 0, 5));
        this.ButtonChangeAccuracySchedule.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PLUIMainFrame.this.ButtonChangeActionPerformed(evt);
            }
        });
        this.ButtonChangeConstraintsFile.setText("Change");
        this.ButtonChangeConstraintsFile.setMargin(new Insets(0, 5, 0, 5));
        this.ButtonChangeConstraintsFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PLUIMainFrame.this.ButtonChangeActionPerformed(evt);
            }
        });
        this.ButtonViewAccuracySchedule.setText("View");
        this.ButtonViewAccuracySchedule.setMargin(new Insets(0, 5, 0, 5));
        this.ButtonViewAccuracySchedule.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PLUIMainFrame.this.ButtonViewActionPerformed(evt);
            }
        });
        this.ButtonViewConstraintsFile.setText("View");
        this.ButtonViewConstraintsFile.setMargin(new Insets(0, 5, 0, 5));
        this.ButtonViewConstraintsFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PLUIMainFrame.this.ButtonViewActionPerformed(evt);
            }
        });
        this.TextConstraintsFile.setEnabled(false);
        this.jLabel17.setLabelFor(this.TextAccuracySchedule);
        this.jLabel17.setText("Accuracy schedule:");
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jLabel17).add((Component)this.jLabel13).add((Component)this.jLabel14, -2, 135, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.TextConstraintsFile, -1, 172, Short.MAX_VALUE).add((Component)this.TextAccuracySchedule, -1, 172, Short.MAX_VALUE).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.TextNGramLimitsFile, -1, 172, Short.MAX_VALUE).addPreferredGap(0))).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.ButtonViewConstraintsFile).add((Component)this.ButtonViewAccuracySchedule).add((Component)this.ButtonViewNGramLimitsFile)).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.ButtonChangeNGramLimitsFile).add((Component)this.ButtonChangeAccuracySchedule).add((Component)this.ButtonChangeConstraintsFile))).add((Component)this.jLabel9)).addContainerGap()));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jLabel9).add(9, 9, 9).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabel13).add((Component)this.TextNGramLimitsFile, -2, -1, -2).add((Component)this.ButtonViewNGramLimitsFile).add((Component)this.ButtonChangeNGramLimitsFile)).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.TextAccuracySchedule, -2, -1, -2).add((Component)this.jLabel17).add((Component)this.ButtonViewAccuracySchedule).add((Component)this.ButtonChangeAccuracySchedule)).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.TextConstraintsFile, -2, -1, -2).add((Component)this.ButtonViewConstraintsFile).add((Component)this.ButtonChangeConstraintsFile).add((Component)this.jLabel14, -2, 55, -2)).addContainerGap()));
        jPanel3Layout.linkSize(new Component[]{this.TextAccuracySchedule, this.TextConstraintsFile, this.TextNGramLimitsFile}, 2);
        this.jLabel1.setLabelFor(this.TextTrainingFile);
        this.jLabel1.setText("Learning data:");
        this.jLabel15.setLabelFor(this.TextTiersFile);
        this.jLabel15.setText("Projected tiers:");
        this.jLabel11.setLabelFor(this.TextFeatFile);
        this.jLabel11.setText("Features chart:");
        this.ButtonViewFeatFile.setText("View");
        this.ButtonViewFeatFile.setMargin(new Insets(0, 5, 0, 5));
        this.ButtonViewFeatFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PLUIMainFrame.this.ButtonViewActionPerformed(evt);
            }
        });
        this.ButtonViewTiersFile.setText("View");
        this.ButtonViewTiersFile.setMargin(new Insets(0, 5, 0, 5));
        this.ButtonViewTiersFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PLUIMainFrame.this.ButtonViewActionPerformed(evt);
            }
        });
        this.ButtonViewTrainingFile.setText("View");
        this.ButtonViewTrainingFile.setMargin(new Insets(0, 5, 0, 5));
        this.ButtonViewTrainingFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PLUIMainFrame.this.ButtonViewActionPerformed(evt);
            }
        });
        this.ButtonChangeTrainingFile.setText("Change");
        this.ButtonChangeTrainingFile.setMargin(new Insets(0, 5, 0, 5));
        this.ButtonChangeTrainingFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PLUIMainFrame.this.ButtonChangeActionPerformed(evt);
            }
        });
        this.ButtonChangeTiersFile.setText("Change");
        this.ButtonChangeTiersFile.setMargin(new Insets(0, 5, 0, 5));
        this.ButtonChangeTiersFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PLUIMainFrame.this.ButtonChangeActionPerformed(evt);
            }
        });
        this.ButtonChangeFeatFile.setText("Change");
        this.ButtonChangeFeatFile.setMargin(new Insets(0, 5, 0, 5));
        this.ButtonChangeFeatFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PLUIMainFrame.this.ButtonChangeActionPerformed(evt);
            }
        });
        this.jLabel16.setFont(new Font("MS Sans Serif", 0, 24));
        this.jLabel16.setText("Basic Input Files");
        this.jLabel12.setLabelFor(this.TextTestFile);
        this.jLabel12.setText("Testing data:");
        this.ButtonViewTestFile.setText("View");
        this.ButtonViewTestFile.setMargin(new Insets(0, 5, 0, 5));
        this.ButtonViewTestFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PLUIMainFrame.this.ButtonViewActionPerformed(evt);
            }
        });
        this.ButtonChangeTestFile.setText("Change");
        this.ButtonChangeTestFile.setMargin(new Insets(0, 5, 0, 5));
        this.ButtonChangeTestFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PLUIMainFrame.this.ButtonChangeActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jLabel11).add((Component)this.jLabel1).add((Component)this.jLabel12).add((Component)this.jLabel15)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.TextTiersFile, -1, 232, Short.MAX_VALUE).add((Component)this.TextFeatFile, -1, 232, Short.MAX_VALUE).add(2, (Component)this.TextTrainingFile, -1, 232, Short.MAX_VALUE).add(2, (Component)this.TextTestFile, -1, 232, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.ButtonViewTestFile).add((Component)this.ButtonViewTrainingFile).add((Component)this.ButtonViewTiersFile).add((Component)this.ButtonViewFeatFile)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.ButtonChangeTestFile).add((Component)this.ButtonChangeTrainingFile).add((Component)this.ButtonChangeTiersFile).add((Component)this.ButtonChangeFeatFile))).add((Component)this.jLabel16)).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jLabel16).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.TextFeatFile, -2, -1, -2).add((Component)this.jLabel11).add((Component)this.ButtonViewFeatFile).add((Component)this.ButtonChangeFeatFile)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel15).add((Component)this.ButtonViewTiersFile).add((Component)this.ButtonChangeTiersFile).add((Component)this.TextTiersFile, -2, -1, -2)).add(32, 32, 32).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel12).add((Component)this.TextTestFile, -2, -1, -2).add((Component)this.ButtonViewTestFile).add((Component)this.ButtonChangeTestFile))).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add(90, 90, 90).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.TextTrainingFile, -2, -1, -2).add((Component)this.ButtonViewTrainingFile).add((Component)this.ButtonChangeTrainingFile)))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel3.setText("Maximum number of constraints to discover:");
        this.TextMaxConstraints.setHorizontalAlignment(4);
        this.TextMaxConstraints.setText("30");
        this.jLabel7.setText("Maximum gram size (specify 1, 2, 3, or 4):");
        this.TextMaxGramSize.setHorizontalAlignment(4);
        this.TextMaxGramSize.setText("3");
        this.jLabel8.setText("<html>Maximum OE for constraints (supplements accuracy schedule):</html>");
        this.jLabel8.setOpaque(true);
        this.jLabel8.setPreferredSize(new Dimension(50, 15));
        this.TextMaxOE.setHorizontalAlignment(4);
        this.TextMaxOE.setText(".3");
        this.CheckAllowComplements.setText("Allow complement natural classes");
        this.CheckAllowComplements.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.CheckAllowComplements.setMargin(new Insets(0, 0, 0, 0));
        this.jLabel18.setFont(new Font("MS Sans Serif", 0, 24));
        this.jLabel18.setText("Basic Parameters");
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.jLabel18).add(166, 166, 166)).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.CheckAllowComplements).add(160, 160, 160)).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((Component)this.jLabel7).add((Component)this.jLabel8, -2, 213, -2).add((Component)this.jLabel3)).addPreferredGap(0, 70, Short.MAX_VALUE).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1, false).add((Component)this.TextMaxConstraints).add((Component)this.TextMaxOE).add((Component)this.TextMaxGramSize, -2, 54, -2)))).addContainerGap()));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.jLabel18).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.TextMaxConstraints, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.jLabel7).add((Component)this.TextMaxGramSize, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.jLabel8, -2, 32, -2).add((Component)this.TextMaxOE, -2, -1, -2)).addPreferredGap(0).add((Component)this.CheckAllowComplements).addContainerGap(3, Short.MAX_VALUE)));
        this.jLabel2.setFont(new Font("MS Sans Serif", 0, 24));
        this.jLabel2.setText("Advanced Parameters");
        this.jLabel4.setText("<html>Sigma2 (higher=more importance for exceptionless constraints):</html>");
        this.TextSigma2.setHorizontalAlignment(4);
        this.TextLearningSampleSize.setHorizontalAlignment(4);
        this.TextSmoothing.setHorizontalAlignment(4);
        this.jLabel5.setText("Target size of learning samples (larger = slower):");
        this.jLabel6.setText("Smoothing:");
        this.jLabel19.setText("<html>Maximum length of machines used to generate E value:</html>");
        this.TextMaxPathLength.setHorizontalAlignment(4);
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel2).add(87, 87, 87)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabel19, -1, 275, Short.MAX_VALUE).add((Component)this.jLabel5, -1, 275, Short.MAX_VALUE).add((Component)this.jLabel4, 0, 0, Short.MAX_VALUE).add((Component)this.jLabel6)).addPreferredGap(0, 12, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2, false).add((Component)this.TextMaxPathLength).add((Component)this.TextLearningSampleSize).add((Component)this.TextSigma2).add((Component)this.TextSmoothing, -1, 24, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.TextSmoothing, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel4, -2, 29, -2).add((Component)this.TextSigma2, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel5).add((Component)this.TextLearningSampleSize, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.TextMaxPathLength, -2, -1, -2).add((Component)this.jLabel19, -2, 36, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.CommandsPanel, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0, 17, Short.MAX_VALUE).add((Component)this.jPanel4, -2, -1, -2)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel3, -2, -1, -2).add(16, 16, 16).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jSeparator3, -1, 805, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jSeparator2, -1, 805, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.CommandsPanel, -2, 176, -2).addPreferredGap(0).add((Component)this.jSeparator2, -2, 2, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel4, -2, 147, -2).add((Component)this.jPanel2, -2, -1, -2)).add(14, 14, 14).add((Component)this.jSeparator3, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -2, -1, -2).add((Component)this.jPanel3, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void RadioReweightExistingItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.TextConstraintsFile.setEnabled(true);
            this.TextMaxConstraints.setEnabled(false);
            this.TextMaxGramSize.setEnabled(true);
            this.TextMaxOE.setEnabled(true);
            this.TextTrainingFile.setEnabled(true);
            this.TextNGramLimitsFile.setEnabled(true);
            this.TextAccuracySchedule.setEnabled(true);
        }
    }

    private void RadioStartWithGrammarItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.TextConstraintsFile.setEnabled(true);
            this.TextMaxConstraints.setEnabled(true);
            this.TextMaxGramSize.setEnabled(true);
            this.TextMaxOE.setEnabled(true);
            this.TextTrainingFile.setEnabled(true);
            this.TextNGramLimitsFile.setEnabled(true);
            this.TextAccuracySchedule.setEnabled(true);
        }
    }

    private void RadioTestExistingItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.TextConstraintsFile.setEnabled(true);
            this.TextMaxConstraints.setEnabled(false);
            this.TextMaxGramSize.setEnabled(false);
            this.TextMaxOE.setEnabled(false);
            this.TextTrainingFile.setEnabled(false);
            this.TextNGramLimitsFile.setEnabled(false);
            this.TextAccuracySchedule.setEnabled(false);
        }
    }

    private void RadioStartNewItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.TextConstraintsFile.setEnabled(false);
            this.TextMaxConstraints.setEnabled(true);
            this.TextMaxGramSize.setEnabled(true);
            this.TextMaxOE.setEnabled(true);
            this.TextTrainingFile.setEnabled(true);
            this.TextNGramLimitsFile.setEnabled(true);
            this.TextAccuracySchedule.setEnabled(true);
        }
    }

    private void jButtonGettingStartedActionPerformed(ActionEvent evt) {
        this.gsdlg.setVisible(true);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.GetSettingsFromGUI();
        this.data.WriteSettingsToFile();
        this.data.WriteFilesLocToFile();
    }

    private boolean GetSettingsFromGUI() {
        this.data.ClearChangedFlag();
        this.data.SetFilesLoc(this.TextFilesLoc.getText());
        if (this.RadioStartWithGrammar.isSelected()) {
            this.data.SetTask(1);
        } else if (this.RadioTestExisting.isSelected()) {
            this.data.SetTask(2);
        } else if (this.RadioReweightExisting.isSelected()) {
            this.data.SetTask(3);
        } else {
            this.data.SetTask(0);
        }
        this.data.SetMaxConstraints(this.TextMaxConstraints.getText());
        this.data.SetSigma2(this.TextSigma2.getText());
        this.data.SetLearningSampleSize(this.TextLearningSampleSize.getText());
        this.data.SetMaxGramSize(this.TextMaxGramSize.getText());
        this.data.SetMaxOE(this.TextMaxOE.getText());
        this.data.SetSmoothing(this.TextSmoothing.getText());
        this.data.SetMaxPath(this.TextMaxPathLength.getText());
        this.data.SetAllowComplements(this.CheckAllowComplements.getSelectedObjects() != null);
        for (PLUIDataItem item : this.fileIndex) {
            this.data.SetFile(item.id, item.text.getText());
        }
        return this.data.GetChangedFlag();
    }

    private void DisplaySettingsToGui() {
        this.TextFilesLoc.setText(this.data.GetFileLoc());
        this.RadioStartNew.setSelected(false);
        this.RadioStartWithGrammar.setSelected(false);
        this.RadioTestExisting.setSelected(false);
        this.RadioReweightExisting.setSelected(false);
        switch (this.data.GetTask()) {
            case 1: {
                this.RadioStartWithGrammar.doClick();
                break;
            }
            case 2: {
                this.RadioTestExisting.doClick();
                break;
            }
            case 3: {
                this.RadioReweightExisting.doClick();
                break;
            }
            default: {
                this.RadioStartNew.doClick();
            }
        }
        this.TextMaxConstraints.setText(this.data.GetMaxConstraints());
        this.TextSigma2.setText(this.data.GetSigma2());
        this.TextLearningSampleSize.setText(this.data.GetLearningSampleSize());
        this.TextMaxGramSize.setText(this.data.GetMaxGramSize());
        this.TextMaxOE.setText(this.data.GetMaxOE());
        this.TextSmoothing.setText(this.data.GetSmoothing());
        this.TextMaxPathLength.setText(this.data.GetMaxPath());
        this.CheckAllowComplements.setSelected(this.data.GetAllowComplements());
        for (PLUIDataItem item : this.fileIndex) {
            item.text.setText(this.data.GetFile(item.id));
        }
    }

    public PLUIDataItem FindChangeButton(Object o) {
        for (PLUIDataItem item : this.fileIndex) {
            if (o != item.change) continue;
            return item;
        }
        return null;
    }

    public PLUIDataItem FindViewButton(Object o) {
        for (PLUIDataItem item : this.fileIndex) {
            if (o != item.view) continue;
            return item;
        }
        return null;
    }

    private void ButtonViewActionPerformed(ActionEvent evt) {
        PLUIDataItem item = this.FindViewButton(evt.getSource());
        String f = this.TextFilesLoc.getText().trim() + File.separator + item.text.getText().trim();
        String os = System.getProperty("os.name");
        try {
            if (os.regionMatches(true, 0, "win", 0, 3)) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + f);
            } else if (os.regionMatches(true, 0, "mac", 0, 3)) {
                Runtime.getRuntime().exec("open " + f);
            } else {
                JOptionPane.showMessageDialog(this, "Cannot launch the manual.  Please view " + f + ".");
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Error launching " + f + " : " + ex.getMessage());
        }
    }

    private void ButtonChangeActionPerformed(ActionEvent evt) {
        PLUIDataItem item = this.FindChangeButton(evt.getSource());
        String dir = this.TextFilesLoc.getText().trim();
        item.fc.setCurrentDirectory(new File(dir));
        File f = new File(dir + File.separator + item.text.getText().trim());
        if (f.isFile()) {
            item.fc.setSelectedFile(f);
        }
        item.fc.setFileSelectionMode(0);
        if (item.fc.showOpenDialog(this) == 0) {
            item.text.setText(item.fc.getSelectedFile().getName());
        }
    }

    private void ButtonChangeFileLocActionPerformed(ActionEvent evt) {
        this.GetSettingsFromGUI();
        this.data.WriteSettingsToFile();
        File d = new File(this.TextFilesLoc.getText().trim());
        if (d.isDirectory()) {
            this.dirChooser.setSelectedFile(d);
        }
        this.dirChooser.setFileSelectionMode(1);
        if (this.dirChooser.showOpenDialog(this) == 0) {
            String dir = this.dirChooser.getSelectedFile().getPath();
            if (new File(dir).isDirectory()) {
                this.data.SetFilesLoc(dir);
                this.data.WriteFilesLocToFile();
                this.data.ReadSettingsFromFile();
                this.DisplaySettingsToGui();
            } else {
                JOptionPane.showMessageDialog(this, "The working folder you specified does not exist.  Please enter the correct folder.");
            }
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        String os = System.getProperty("os.name");
        try {
            if (os.regionMatches(true, 0, "win", 0, 3)) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler Manual.pdf");
            } else if (os.regionMatches(true, 0, "mac", 0, 3)) {
                Runtime.getRuntime().exec("open Manual.pdf");
            } else {
                JOptionPane.showMessageDialog(this, "Cannot launch the manual.  Please view Manual.pdf.");
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Error launching Manual.pdf : " + ex.getMessage());
        }
    }

    private void ButtonGoActionPerformed(ActionEvent evt) {
        File d = new File(this.TextFilesLoc.getText().trim());
        if (!d.isDirectory()) {
            JOptionPane.showMessageDialog(this, "The working folder you specified does not exist.  Please enter the correct folder.");
            return;
        }
        if (this.GetSettingsFromGUI()) {
            this.data.WriteSettingsToFile();
        }
        WorkingDlg wd = new WorkingDlg((Frame)this, true, this.data);
        boolean result = false;
        try {
            result = this.data.Execute(wd);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Execution Error", 0);
        }
        if (result) {
            wd.setVisible(true);
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new PLUIMainFrame().setVisible(true);
            }
        });
    }
}

