/*
 * Decompiled with CFR 0.152.
 */
package inputoutput;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class StringTable {
    public String[][] data;

    public StringTable() {
        this.init();
    }

    public StringTable(String[][] dat) {
        this.data = dat;
    }

    public void init() {
        this.data = new String[0][0];
    }

    public void add(String[] line) {
        String[][] newdata = new String[this.data.length + 1][];
        for (int i = 0; i < this.data.length; ++i) {
            newdata[i] = this.data[i];
        }
        newdata[this.data.length] = line;
        this.data = newdata;
    }

    public void append(StringTable alt) {
        int i;
        String[][] newData = new String[alt.data.length + this.data.length][];
        for (i = 0; i < this.data.length; ++i) {
            newData[i] = this.data[i];
        }
        for (i = 0; i < alt.data.length; ++i) {
            newData[i + this.data.length] = alt.data[i];
        }
        this.data = newData;
    }

    public String[] takeRowFrom(int row, int from, int fillUpLength) {
        if (fillUpLength == 0) {
            fillUpLength = this.data[row].length - from;
        }
        String[] ret = new String[fillUpLength];
        for (int i = 0; i < fillUpLength; ++i) {
            ret[i] = i + from < this.data[row].length ? this.data[row][i + from] : "";
        }
        return ret;
    }

    public String[] takeRowFrom(int row, int from) {
        return this.takeRowFrom(row, from, 0);
    }

    public String[] takeColumnFrom(int col, int from) {
        return this.takeColumnFrom(col, from, 0);
    }

    public String[] takeColumnFrom(int col, int from, int fillUpTo) {
        if (fillUpTo == 0) {
            fillUpTo = this.data.length - from;
        }
        String[] ret = new String[fillUpTo];
        for (int i = 0; i < fillUpTo; ++i) {
            ret[i] = i + from < this.data.length && col < this.data[i + from].length ? this.data[i + from][col] : "";
        }
        return ret;
    }

    public String take(int row, int col) {
        return this.data[row][col];
    }

    public int rowCount() {
        return this.data.length;
    }

    public String[] getRow(int i) {
        return this.data[i];
    }

    public void fromFile(File f, String separator) {
        try {
            FileInputStream fstream = new FileInputStream(f);
            this.fromFile(fstream, separator);
        }
        catch (IOException e) {
            System.err.println("Error opening file " + f.toString() + ": " + e.getMessage());
        }
    }

    public void fromFile(InputStream fstream, String separator) {
        try {
            String line;
            InputStreamReader isr = new InputStreamReader(fstream, "UTF8");
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                this.add(line.split(separator));
            }
            br.close();
        }
        catch (Exception e) {
            System.err.println("File input error: " + e.toString());
        }
    }

    public String toString() {
        StringBuffer report = new StringBuffer();
        for (int i = 0; i < this.data.length; ++i) {
            report.append(StringTable.implode(this.data[i], ", ") + "\n");
        }
        return report.toString();
    }

    public StringTable copy() {
        String[][] newdata = new String[this.data.length][];
        for (int i = 0; i < this.data.length; ++i) {
            newdata[i] = new String[this.data[i].length];
            for (int j = 0; j < this.data[i].length; ++j) {
                newdata[i][j] = this.data[i][j];
            }
        }
        StringTable tab = new StringTable();
        tab.data = newdata;
        return tab;
    }

    public static double[] StringListToFloatList(String[] lijst) {
        double[] ret = new double[lijst.length];
        for (int i = 0; i < lijst.length; ++i) {
            String subj = lijst[i].trim();
            ret[i] = subj.length() == 0 ? 0.0 : (double)Float.parseFloat(subj);
        }
        return ret;
    }

    public static int[] StringListToIntList(String[] lijst) {
        int[] ret = new int[lijst.length];
        for (int i = 0; i < lijst.length; ++i) {
            String subj = lijst[i].trim();
            ret[i] = subj.length() == 0 ? 0 : Integer.parseInt(subj);
        }
        return ret;
    }

    public static String[] BooleanListToStringList(boolean[] lijst) {
        String[] ret = new String[lijst.length];
        for (int i = 0; i < lijst.length; ++i) {
            ret[i] = lijst[i] ? "1" : "0";
        }
        return ret;
    }

    public static String implode(String[] ary, String delim) {
        String out = "";
        for (int i = 0; i < ary.length; ++i) {
            if (i != 0) {
                out = out + delim;
            }
            out = out + ary[i];
        }
        return out;
    }

    public static String multiply(String content, int times) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < times; ++i) {
            out.append(content);
        }
        return out.toString();
    }

    static String[] removeTrailing(String[] stringList, char c) {
        String[] newList = new String[stringList.length];
        for (int i = 0; i < stringList.length; ++i) {
            newList[i] = StringTable.removeTrailing(stringList[i], c);
        }
        return newList;
    }

    public static String removePrefixSuffix(String subj, char pref, char suff) {
        subj = subj.trim();
        int start = 0;
        int end = subj.length();
        if (subj.charAt(0) == pref) {
            ++start;
        }
        if (subj.charAt(end - 1) == suff) {
            --end;
        }
        return subj.substring(start, end);
    }

    static String removeTrailing(String s, char c) {
        String item = s.trim();
        if (StringTable.endsWith(item, c)) {
            item = item.substring(0, item.length() - 1);
        }
        return item;
    }

    public static boolean endsWith(String s, char c) {
        String trimmed = s.trim();
        return trimmed.length() > 0 && trimmed.charAt(trimmed.length() - 1) == c;
    }

    public static boolean beginsWith(String s, char c) {
        String trimmed = s.trim();
        return trimmed.length() > 0 && trimmed.charAt(0) == c;
    }
}

