/*
 * Decompiled with CFR 0.152.
 */
package gui;

import communication.ResourceProvider;
import featurefunctions.ComplexSymbol;
import featurefunctions.Diacritic;
import featurefunctions.Symbol;
import gui.ComplexSymbolModel;
import gui.FeatureCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.util.Random;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SymbolFrame
extends JDialog
implements ActionListener {
    ComplexSymbol symbol;
    Symbol compiled;
    ResourceProvider res;
    JButton quitB = new JButton("Close window");
    int BIG_IPA_SIZE = 64;
    int DECOMPOSE_IPA_SIZE = 28;
    int DESCRIPTION_SIZE = 16;
    int LIST_FONT_SIZE = 16;
    ComplexSymbolModel symbolModel;
    Color[] colors;

    public SymbolFrame(Frame f, ComplexSymbol c, ResourceProvider r) {
        super(f, "Symbol information", true);
        this.res = r;
        this.symbol = c;
        this.compiled = this.symbol.compileDiacritics();
        this.buildComponents(this.getContentPane());
        this.pack();
        this.setSize(600, 500);
        this.setLocationRelativeTo(null);
    }

    public void buildComponents(Container container) {
        this.generateRandomColors();
        JPanel mainP = new JPanel(new BorderLayout());
        JLabel workL = new JLabel(this.symbol.getLabel());
        workL.setFont(this.res.getIPAFont(this.BIG_IPA_SIZE));
        Dimension d = workL.getPreferredSize();
        workL.setPreferredSize(new Dimension(d.width + 100, d.height + 100));
        workL.setBorder(BorderFactory.createEmptyBorder(30, 30, 30, 30));
        mainP.add((Component)workL, "West");
        ComplexSymbolModel symbolModel = new ComplexSymbolModel(this.compiled);
        JList<Object> featureL = new JList<Object>(symbolModel);
        Color[] colorPerItem = this.getColorPerFeature(this.compiled, this.symbol);
        featureL.setCellRenderer(new FeatureCellRenderer(colorPerItem, this.res.getIPAFont(this.LIST_FONT_SIZE)));
        JScrollPane sp = new JScrollPane(featureL);
        JPanel featureP = new JPanel(new BorderLayout());
        featureP.add((Component)sp, "Center");
        featureP.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainP.add((Component)featureP, "Center");
        JPanel buttonP = new JPanel();
        buttonP.add(this.quitB);
        this.quitB.addActionListener(this);
        JPanel decompP = this.decomposition();
        container.setLayout(new BorderLayout());
        container.add((Component)decompP, "North");
        container.add((Component)mainP, "Center");
        container.add((Component)buttonP, "South");
    }

    public JPanel decomposition() {
        JPanel panel = new JPanel();
        if (this.symbol.isBare()) {
            return panel;
        }
        panel.setLayout(new BoxLayout(panel, 2));
        int n = this.symbol.diacriticsLength();
        String[] labels = new String[n + 2];
        String[] descr = new String[n + 2];
        labels[0] = this.symbol.getLabel();
        descr[0] = "";
        labels[1] = this.symbol.getBaseLabel();
        descr[1] = "base symbol";
        for (int i = 0; i < n; ++i) {
            Diacritic d = this.symbol.getDiacritic(i);
            labels[i + 2] = d.getPrintableLabel();
            descr[i + 2] = d.getDescription();
        }
        panel.add(Box.createRigidArea(new Dimension(20, 0)));
        Font labelF = this.res.getIPAFont(this.DECOMPOSE_IPA_SIZE);
        Font descrF = this.res.getIPAFont(this.DESCRIPTION_SIZE);
        for (int i = 0; i < n + 2; ++i) {
            JLabel workL;
            if (i > 0) {
                workL = new JLabel(" + ");
                if (i == 1) {
                    workL = new JLabel(" = ");
                }
                workL.setFont(labelF);
                panel.add(workL);
            }
            JPanel workP = new JPanel();
            workP.setLayout(new BoxLayout(workP, 3));
            workL = new JLabel(labels[i]);
            workL.setFont(labelF);
            workL.setAlignmentX(0.5f);
            if (i > 1) {
                workL.setBackground(this.colors[i - 2]);
                workL.setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, this.colors[i - 2]));
                workL.setOpaque(true);
            }
            workP.add(workL);
            workL = new JLabel(descr[i]);
            workL.setFont(descrF);
            workL.setAlignmentX(0.5f);
            workP.add(workL);
            panel.add(workP);
        }
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        return panel;
    }

    public void attemptPlayBaseSound() {
        try {
            String sound = "";
            String filename = "sounds/" + sound + "a.wav";
            InputStream is = this.res.getResource(filename);
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(is);
            AudioFormat audioFormat = audioInputStream.getFormat();
            DataLine.Info dataLineInfo = new DataLine.Info(Clip.class, audioFormat);
            Clip clip = (Clip)AudioSystem.getLine(dataLineInfo);
            clip.open(audioInputStream);
            clip.start();
        }
        catch (Exception except) {
            except.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.quitB) {
            this.setVisible(false);
        }
    }

    public Color[] getColorPerFeature(Symbol compiled, ComplexSymbol original) {
        int n = compiled.getLength();
        Color[] featureColors = new Color[n];
        for (int i = 0; i < n; ++i) {
            String f = compiled.getFeature(i);
            featureColors[i] = this.getColorFor(f, original);
        }
        return featureColors;
    }

    public void generateRandomColors() {
        int n = this.symbol.diacriticsLength();
        this.colors = new Color[n];
        Random r = new Random();
        for (int i = 0; i < n; ++i) {
            this.colors[i] = new Color(r.nextInt(130) + 125, r.nextInt(130) + 125, r.nextInt(130) + 125);
        }
    }

    Color getColorFor(String f, ComplexSymbol c) {
        int m = c.diacriticsLength();
        for (int i = 0; i < m; ++i) {
            if (!c.getDiacritic(i).setsFeature(f)) continue;
            return this.colors[i];
        }
        return Color.white;
    }
}

