/*
 * Decompiled with CFR 0.152.
 */
package gui;

import communication.Reporter;
import communication.ResourceProvider;
import featurefunctions.BaseSymbolList;
import featurefunctions.Contradictions;
import featurefunctions.Misc;
import featurefunctions.Symbol;
import gui.ColorCentral;
import gui.MainScreen;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class SymbolEditTable
implements ActionListener,
MouseListener,
Reporter {
    SymbolTableModel tableModel;
    BaseSymbolList bases;
    Contradictions contradictions;
    String myName;
    String myDescription;
    ResourceProvider res;
    double magnification = 1.0;
    MainScreen mainScreen;
    JButton queryClearB = new JButton("clear");
    JButton queryInputB = new JButton("keyboard");
    JTable queryTable;
    JScrollPane querySP;
    static final String nul = SymbolEditTable.translateToProto('0');

    public SymbolEditTable(String nm, String md, MainScreen m, BaseSymbolList l, Contradictions c, ResourceProvider r) {
        this.myName = nm;
        this.myDescription = md;
        this.tableModel = new SymbolTableModel(new Symbol(), m);
        this.bases = l;
        this.mainScreen = m;
        this.contradictions = c;
        this.res = r;
    }

    public JPanel createPanel(String label) {
        JPanel queryP = new JPanel();
        queryP.setLayout(new BoxLayout(queryP, 3));
        JPanel topP = new JPanel(new FlowLayout(3));
        topP.add(new JLabel(label));
        topP.add(this.queryClearB);
        topP.add(this.queryInputB);
        this.queryTable = new JTable(this.tableModel);
        this.querySP = new JScrollPane(this.queryTable);
        queryP.add(topP);
        queryP.add(this.querySP);
        this.querySP.setPreferredSize(new Dimension(300, 200));
        this.queryTable.addMouseListener(this);
        JPanel queryButtonP = new JPanel();
        FlowLayout flowlay = new FlowLayout();
        flowlay.setAlignment(4);
        queryButtonP.setLayout(flowlay);
        this.queryClearB.addActionListener(this);
        this.queryInputB.addActionListener(this);
        this.effectResize(1.0);
        return queryP;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.queryClearB) {
            this.tableModel.cleanUp();
            this.tableModel.checkSymbol();
            this.mainScreen.symbolChanged();
        }
        if (e.getSource() == this.queryInputB) {
            Symbol symb = this.tableModel.getSymbol();
            String s = symb.toStringOnlyFeatures();
            boolean keepGoing = true;
            while (keepGoing) {
                if ((s = (String)JOptionPane.showInputDialog(this.mainScreen, "Enter the features in one line, e.g.:\n+back, -low, ahigh, Aback  (A indicates -a)", "Query Keyboard input", -1, null, null, s)) != null && s.length() > 0) {
                    symb = Symbol.parseFrom(s);
                    keepGoing = !symb.checkAgainst(this.bases.features, this);
                    if (keepGoing) continue;
                    this.tableModel.setSymbol(symb);
                    this.mainScreen.symbolChanged();
                    continue;
                }
                keepGoing = false;
            }
        }
    }

    public void setSymbol(Symbol symb) {
        this.tableModel.setSymbol(symb);
        this.mainScreen.symbolChanged();
    }

    public Symbol getSymbol() {
        return this.tableModel.getSymbol();
    }

    public void effectResize(double magnification) {
        Font ipafont = this.res.getIPAFont(MainScreen.magnify(MainScreen.DEFAULT_IPA_FONT_SIZE, magnification));
        this.makeQueryEditTable(ipafont, (int)Math.round(10.0 / magnification));
        this.tableModel.fireTableDataChanged();
    }

    public void makeQueryEditTable(Font ipafont, int dropdownlistsize) {
        this.queryTable.setFont(ipafont);
        this.queryTable.setAutoResizeMode(0);
        Object[] feats = Misc.prefixNull(this.bases.getFeatures());
        Object[] values = SymbolEditTable.possibleValues();
        TableColumn col = this.queryTable.getColumnModel().getColumn(0);
        col.setPreferredWidth(75);
        col.setCellEditor(new MyComboBoxEditor(values, ipafont, dropdownlistsize));
        col.setCellRenderer(new MyComboBoxRenderer(values, ipafont));
        col = this.queryTable.getColumnModel().getColumn(1);
        col.setPreferredWidth(190);
        col.setCellEditor(new MyComboBoxEditor(feats, ipafont, dropdownlistsize));
        col.setCellRenderer(new MyComboBoxRenderer(feats, ipafont));
        this.queryTable.setRowHeight(32);
        this.queryTable.setTableHeader(null);
    }

    public void markMinimality(boolean minimal) {
        if (!minimal) {
            this.querySP.getViewport().setBackground(ColorCentral.nonMinimalColor);
            this.mainScreen.messages.showMessage(this.myName + "minim", "Your selection is not minimal", ColorCentral.nonMinimalColor, "In the top left of the screen you can select a number of features\nthat will define a natural class.\nHowever, in your case you have used more features than necessary\nto define this set of sounds.\nTry taking one or more features out and see if you still get the\nsame set of sounds. Once you get a minimal specification of the sounds\nthis message and the colour will disappear.");
        } else {
            this.mainScreen.messages.removeMessage(this.myName + "minim");
            this.querySP.getViewport().setBackground(ColorCentral.minimalColor);
        }
    }

    public void checkContradictions() {
        Symbol transf = this.getSymbol();
        if (this.contradictions.findContradictions(transf).length > 0) {
            this.querySP.getViewport().setBackground(ColorCentral.contradiction);
            this.mainScreen.messages.showMessage(this.myName + "contr", this.myDescription + " contain a contradiction.", ColorCentral.contradiction, "You have selected a number of feature settings that are contradiction\nwith one another.\n\n" + this.contradictions.getReport(transf));
        } else {
            this.querySP.getViewport().setBackground(Color.white);
            this.mainScreen.messages.removeMessage(this.myName + "contr");
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public static final String[] possibleValues() {
        String[] arr = new String[]{SymbolEditTable.translateToProto('0'), SymbolEditTable.translateToProto('+'), SymbolEditTable.translateToProto('-')};
        return Misc.appendStringList(arr, SymbolEditTable.allVariables());
    }

    static final String translateToProto(char value) {
        if (Symbol.isVariable(value)) {
            return Symbol.getDisplayVariable(value);
        }
        switch (value) {
            case '0': {
                return Character.toString(' ');
            }
            case '-': {
                return Character.toString('\u2212');
            }
        }
        return Character.toString(value);
    }

    static final char translateFromProto(String value) {
        if (Symbol.isDisplayVariable(value)) {
            return Symbol.getVariableFromDisplay(value);
        }
        if (value.equals(Character.toString(' '))) {
            return '0';
        }
        if (value.charAt(0) == '\u2212') {
            return '-';
        }
        return value.charAt(0);
    }

    static final String[] allVariables() {
        String[] vars = new String[2 * Symbol.Variables.length];
        for (int i = 0; i < Symbol.Variables.length; ++i) {
            vars[2 * i] = SymbolEditTable.translateToProto(Symbol.Variables[i]);
            vars[2 * i + 1] = SymbolEditTable.translateToProto(Symbol.nonVariables[i]);
        }
        return vars;
    }

    public void report(String message) {
        JOptionPane.showMessageDialog(this.mainScreen, message, "Keyboard input", 2);
    }

    public void clearReport() {
    }

    public void putProgress(int p) {
    }

    public void taskIsDone() {
    }

    public void taskInterrupted() {
    }

    class ProtoSymbol {
        String[] features;
        String[] values;

        ProtoSymbol(Symbol symbol) {
            this.features = symbol.features;
            this.values = new String[symbol.values.length];
            for (int i = 0; i < symbol.values.length; ++i) {
                this.values[i] = SymbolEditTable.translateToProto(symbol.values[i]);
            }
        }

        public boolean nonVoid() {
            if (this.features.length == 0) {
                return false;
            }
            for (int i = 0; i < this.features.length; ++i) {
                if (this.values[i].equals(nul) || this.features[i].equals("")) continue;
                return true;
            }
            return false;
        }

        public void check() {
            for (int i = 0; i < this.values.length - 1; ++i) {
                if (!this.values[i].equals(nul)) continue;
                this.removeFeature(i);
            }
            if (this.values.length == 0 || !this.values[this.values.length - 1].equals(nul) && !this.features[this.values.length - 1].equals("")) {
                this.addFeatureValue("", SymbolEditTable.translateToProto('0'));
            }
        }

        void removeFeature(int index) {
            String[] newFeatures = new String[this.features.length - 1];
            String[] newValues = new String[this.features.length - 1];
            int t = 0;
            for (int i = 0; i < this.features.length - 1; ++i) {
                t = i < index ? i : i + 1;
                newFeatures[i] = this.features[t];
                newValues[i] = this.values[t];
            }
            this.features = newFeatures;
            this.values = newValues;
        }

        void addFeatureValue(String f, String v) {
            String[] newFeatures = new String[this.features.length + 1];
            String[] newValues = new String[this.features.length + 1];
            for (int i = 0; i < this.features.length; ++i) {
                newFeatures[i] = this.features[i];
                newValues[i] = this.values[i];
            }
            newFeatures[this.features.length] = f;
            newValues[this.features.length] = v;
            this.features = newFeatures;
            this.values = newValues;
        }

        Symbol toSymbol() {
            int i;
            Symbol symbol = new Symbol();
            symbol.features = this.features;
            symbol.values = new char[this.values.length];
            for (i = 0; i < this.values.length; ++i) {
                symbol.values[i] = SymbolEditTable.translateFromProto(this.values[i]);
            }
            for (i = 0; i < symbol.features.length; ++i) {
                while (i < symbol.features.length && symbol.features[i].equals("")) {
                    symbol.removeFeature(i);
                }
            }
            return symbol;
        }

        public String toString() {
            return this.toSymbol().toString();
        }
    }

    public class SymbolTableModel
    extends AbstractTableModel {
        MainScreen querier;
        ProtoSymbol symbol;
        private String[] columnNames = new String[]{"Value", "Feature"};

        public SymbolTableModel(Symbol s, MainScreen q) {
            this.symbol = new ProtoSymbol(s);
            this.symbol.check();
            this.querier = q;
        }

        public void cleanUp() {
            this.symbol = new ProtoSymbol(new Symbol());
            this.symbol.check();
            this.fireTableDataChanged();
        }

        public void setSymbol(Symbol symb) {
            this.symbol = new ProtoSymbol(symb);
            this.checkSymbol();
            this.fireTableDataChanged();
        }

        public String getColumnName(int col) {
            return this.columnNames[col].toString();
        }

        public int getRowCount() {
            return this.symbol.features.length;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return this.symbol.values[row];
            }
            if (col == 1) {
                return this.symbol.features[row];
            }
            return null;
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                this.symbol.values[row] = (String)value;
            }
            if (col == 1) {
                this.symbol.features[row] = (String)value;
            }
            this.checkSymbol();
            this.fireTableCellUpdated(row, col);
            this.fireTableDataChanged();
            this.querier.symbolChanged();
        }

        public void checkSymbol() {
            this.symbol.check();
            SymbolEditTable.this.checkContradictions();
        }

        public Symbol getSymbol() {
            return this.symbol.toSymbol();
        }

        public boolean nonVoid() {
            return this.symbol.nonVoid();
        }

        public String toString() {
            return this.symbol.toString();
        }
    }

    class MyComboBoxEditor
    extends DefaultCellEditor {
        public MyComboBoxEditor(Object[] items, Font f, int length) {
            super(new SizeableComboBox(items, length));
            this.getComponent().setFont(f);
        }
    }

    class SizeableComboBox
    extends JComboBox {
        public SizeableComboBox(Object[] items, int length) {
            super(items);
            this.setMaximumRowCount(length);
        }
    }

    class MyComboBoxRenderer
    extends JComboBox
    implements TableCellRenderer {
        public MyComboBoxRenderer(Object[] items, Font f) {
            super(items);
            this.setFont(f);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelectedItem(value);
            return this;
        }
    }
}

