/*
 * Decompiled with CFR 0.152.
 */
package gui;

import featurefunctions.BareFeatureList;
import featurefunctions.DetectNaturalClass;
import featurefunctions.Symbol;
import gui.MainScreen;
import gui.MessageForm;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;

public final class ShowReport
extends JDialog
implements ActionListener,
MouseListener {
    MainScreen parentForm;
    JButton quitB = new JButton("Back");
    JButton startB = new JButton("Start");
    String report = "Natural Class detector";
    Font font;
    JScrollPane scrollingArea;
    JProgressBar progressBar;
    DetectNaturalClass dnc;
    JCheckBox shortestOnlyCB;
    public SpecListModel specs;
    JList specList;
    Thread runningThing;

    public ShowReport(DetectNaturalClass detector, Font IPAFont, MainScreen p) {
        super(p, "Natural Class Specification Finder", true);
        this.setDefaultCloseOperation(2);
        this.dnc = detector;
        this.dnc.setReportReceiver(this);
        this.font = IPAFont;
        this.parentForm = p;
        this.specs = new SpecListModel(detector.base);
        this.buildComponents(this.getContentPane());
        this.pack();
        this.setSize(700, 600);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public void buildComponents(Container container) {
        JPanel progressP = new JPanel();
        progressP.setLayout(new BorderLayout());
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.progressBar.setPreferredSize(new Dimension(400, 30));
        this.shortestOnlyCB = new JCheckBox("Only look for specification with least number of features.");
        this.shortestOnlyCB.setSelected(true);
        progressP.add((Component)this.progressBar, "West");
        progressP.add((Component)this.startB, "East");
        progressP.add((Component)this.shortestOnlyCB, "South");
        progressP.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel centerP = new JPanel(new BorderLayout());
        this.specList = new JList(this.specs);
        this.specList.setFont(this.font);
        SpecListModel specListModel = this.specs;
        specListModel.getClass();
        this.specList.setCellRenderer(specListModel.new SpecListModel.SpecCellRenderer(this.font));
        this.specList.addMouseListener(this);
        JScrollPane slSP = new JScrollPane(this.specList);
        centerP.add((Component)slSP, "Center");
        JPanel bottomP = new JPanel();
        bottomP.setLayout(new BorderLayout());
        JPanel bottomRightP = new JPanel();
        this.quitB.addActionListener(this);
        this.startB.addActionListener(this);
        bottomRightP.add(this.quitB);
        bottomP.add((Component)bottomRightP, "East");
        JPanel mainP = new JPanel();
        mainP.setLayout(new BorderLayout());
        mainP.add((Component)progressP, "North");
        mainP.add((Component)centerP, "Center");
        mainP.add((Component)bottomP, "South");
        mainP.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        container.add(mainP);
        this.specList.setToolTipText("Double click on a class to select it in the main screen.");
    }

    public void setReport(String report, int p) {
        this.progressBar.setValue(p);
        this.drawAgain();
    }

    public void taskIsDone() {
        this.setControlsEnabled(true);
        this.startB.setEnabled(false);
        this.specList.repaint();
        this.drawAgain();
    }

    public void taskInterrupted() {
        this.setControlsEnabled(true);
        this.startB.setEnabled(false);
        this.progressBar.setValue(0);
        this.specList.repaint();
        this.drawAgain();
    }

    public void setControlsEnabled(boolean enab) {
        this.quitB.setEnabled(enab);
        this.shortestOnlyCB.setEnabled(enab);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.quitB) {
            this.dispose();
        }
        if (e.getSource() == this.startB) {
            if (this.runningThing == null) {
                boolean shortest = this.shortestOnlyCB.isSelected();
                this.setControlsEnabled(false);
                this.startB.setText("Stop");
                this.startB.repaint();
                this.dnc.setShortestOnly(shortest);
                this.runningThing = new Thread(this.dnc);
                this.runningThing.start();
            } else {
                this.dnc.markStopped();
                this.startB.setText("Start");
                this.startB.repaint();
                this.setControlsEnabled(true);
            }
        }
    }

    public void showMessage(String s) {
        MessageForm m = new MessageForm(s, this.font, this.parentForm);
    }

    public void drawAgain() {
        this.progressBar.repaint();
        try {
            Thread.sleep(20L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void mouseClicked(MouseEvent e) {
        int selectedItem;
        if (e.getClickCount() == 2 && (selectedItem = this.specList.getSelectionModel().getMinSelectionIndex()) > -1) {
            Symbol selected = this.specs.getAsSymbol(selectedItem);
            this.parentForm.querySET.setSymbol(selected);
            this.parentForm.transformSET.setSymbol(new Symbol());
            this.setVisible(false);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    private boolean somethingSelected() {
        return this.specList.getSelectionModel().getMinSelectionIndex() > -1;
    }

    public class SpecListModel
    extends DefaultListModel {
        BareFeatureList base;
        BareFeatureList.PartialSymbol[] specs;
        boolean[] minimal;

        public SpecListModel(BareFeatureList b) {
            this.base = b;
            this.specs = new BareFeatureList.PartialSymbol[0];
        }

        public Symbol getAsSymbol(int i) {
            return new Symbol(this.specs[i], this.base);
        }

        public String getElementAt(int index) {
            String val = this.specs[index].toStringNamed();
            return val;
        }

        public int getSize() {
            return this.specs.length;
        }

        public void add(BareFeatureList.PartialSymbol symb) {
            BareFeatureList.PartialSymbol[] newSpecs = new BareFeatureList.PartialSymbol[this.specs.length + 1];
            newSpecs[0] = symb;
            for (int i = 0; i < this.specs.length; ++i) {
                newSpecs[i + 1] = this.specs[i];
            }
            this.specs = newSpecs;
            this.reconsiderMinimality();
            this.fireIntervalAdded(this, 0, 0);
        }

        public void reconsiderMinimality() {
            int min = -1;
            for (int i = 0; i < this.specs.length; ++i) {
                if (min != -1 && this.specs[i].getLength() >= min) continue;
                min = this.specs[i].getLength();
            }
            boolean[] mins = new boolean[this.specs.length];
            for (int i = 0; i < this.specs.length; ++i) {
                mins[i] = this.specs[i].getLength() == min;
            }
            this.minimal = mins;
        }

        class SpecCellRenderer
        extends DefaultListCellRenderer {
            Color isMinimal = new Color(255, 255, 255);
            Color isNotMinimal = new Color(255, 248, 220);
            Font font;
            protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

            public SpecCellRenderer(Font f) {
                this.font = f;
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (SpecListModel.this.minimal[index]) {
                    renderer.setBackground(this.isMinimal);
                } else {
                    renderer.setBackground(this.isNotMinimal);
                }
                renderer.setText((String)value);
                renderer.setFont(this.font);
                return renderer;
            }
        }
    }
}

