/*
 * Decompiled with CFR 0.152.
 */
package gui;

import featurefunctions.BareFeatureList;
import featurefunctions.CalculateClassList;
import featurefunctions.Symbol;
import gui.MainScreen;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;

public final class ShowClassList
extends JDialog
implements ActionListener,
MouseListener {
    CalculateClassList ccl;
    BareFeatureList originalFeatures;
    MainScreen parentForm;
    JButton quitB = new JButton("Back");
    JButton csvB = new JButton("Export");
    JButton startB = new JButton("Start");
    String report = "Natural Class detector";
    Font font;
    JScrollPane scrollingArea;
    int ROWHEIGHT = 32;
    JTable specList;
    public ClassTableModel specs;
    JProgressBar progressBar;
    Thread runningThing;

    public ShowClassList(BareFeatureList b, Font IPAFont, MainScreen p) {
        super(p, "Natural Class Listing", true);
        this.setDefaultCloseOperation(2);
        this.font = IPAFont;
        this.parentForm = p;
        this.originalFeatures = b;
        this.specs = new ClassTableModel(this.originalFeatures);
        this.buildComponents(this.getContentPane());
        this.pack();
        this.setSize(700, 600);
        this.setLocationRelativeTo(null);
    }

    public void buildComponents(Container container) {
        JPanel progressP = new JPanel();
        progressP.setLayout(new BorderLayout());
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.progressBar.setPreferredSize(new Dimension(400, 30));
        progressP.add((Component)this.progressBar, "West");
        progressP.add((Component)this.startB, "East");
        progressP.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.specList = new JTable(this.specs);
        this.specList.setFont(this.font);
        this.specList.setRowHeight(this.ROWHEIGHT);
        JScrollPane slSP = new JScrollPane(this.specList);
        JPanel bottomP = new JPanel();
        bottomP.setLayout(new BorderLayout());
        JPanel bottomRightP = new JPanel();
        bottomRightP.setLayout(new FlowLayout());
        this.quitB.addActionListener(this);
        this.csvB.addActionListener(this);
        this.startB.addActionListener(this);
        bottomRightP.add(this.csvB);
        bottomRightP.add(this.quitB);
        bottomP.add((Component)bottomRightP, "East");
        JPanel mainP = new JPanel();
        mainP.setLayout(new BorderLayout());
        mainP.add((Component)progressP, "North");
        mainP.add((Component)slSP, "Center");
        mainP.add((Component)bottomP, "South");
        mainP.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        container.add(mainP);
        this.specList.addMouseListener(this);
        this.specList.setToolTipText("Double click on a class to select it in the main screen.");
    }

    public void setReport(String report, int p) {
        this.progressBar.setValue(p);
        this.drawAgain();
    }

    public void putProgress(int p) {
        this.progressBar.setValue(p);
        this.drawAgain();
    }

    public void taskIsDone() {
        this.setControlsEnabled(true);
        this.startB.setEnabled(false);
        this.drawAgain();
    }

    public void taskInterrupted() {
        this.setControlsEnabled(true);
        this.startB.setEnabled(false);
        this.progressBar.setValue(0);
        this.drawAgain();
    }

    public void setControlsEnabled(boolean enab) {
        this.quitB.setEnabled(enab);
        this.csvB.setEnabled(enab);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.quitB) {
            this.dispose();
        }
        if (e.getSource() == this.startB) {
            if (this.runningThing == null) {
                this.setControlsEnabled(false);
                this.startB.setText("Stop");
                this.startB.repaint();
                this.ccl = new CalculateClassList(this.originalFeatures);
                this.ccl.setReportReceiver(this);
                this.runningThing = new Thread(this.ccl);
                this.runningThing.start();
            } else {
                this.ccl.markStopped();
                this.startB.setText("Start");
                this.startB.repaint();
                this.setControlsEnabled(true);
            }
        }
        if (e.getSource() == this.csvB) {
            JFileChooser fc = new JFileChooser();
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Tab-separated file (.txt)", "txt");
            fc.setFileFilter(filter);
            int returnVal = fc.showSaveDialog(this);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                String output = this.specs.toTXT();
                try {
                    PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                    out.write(output);
                    out.close();
                }
                catch (IOException except) {
                    JOptionPane.showMessageDialog(this, except.getMessage(), "Error while writing to file", 0);
                }
            }
        }
    }

    public void showMessage(String s) {
        JOptionPane.showMessageDialog(this.parentForm, s);
    }

    public void drawAgain() {
        this.progressBar.repaint();
        try {
            Thread.sleep(20L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void mouseClicked(MouseEvent e) {
        int selectedItem;
        if (e.getClickCount() == 2 && (selectedItem = this.specList.getSelectionModel().getMinSelectionIndex()) > -1) {
            Symbol selected = this.specs.getSymbol(selectedItem);
            this.parentForm.querySET.setSymbol(selected);
            this.parentForm.transformSET.setSymbol(new Symbol());
            this.setVisible(false);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    private boolean somethingSelected() {
        return this.specList.getSelectionModel().getMinSelectionIndex() > -1;
    }

    public class ClassTableModel
    extends AbstractTableModel {
        BareFeatureList base;
        BareFeatureList.PartialSymbol[] specs;
        String[] readableClass;
        String[] sounds;
        String[] columnNames = new String[]{"Sounds", "Feature specification"};

        public ClassTableModel(BareFeatureList b) {
            this.base = b;
            this.specs = new BareFeatureList.PartialSymbol[0];
            this.sounds = new String[0];
            this.readableClass = new String[0];
        }

        public String getColumnName(int col) {
            return this.columnNames[col].toString();
        }

        public int getRowCount() {
            return this.specs.length;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getValueAt(int row, int col) {
            if (col == 0) {
                return this.sounds[row];
            }
            if (col == 1) {
                return this.readableClass[row];
            }
            return null;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public void setValueAt(Object value, int row, int col) {
        }

        public int getSize() {
            return this.specs.length;
        }

        public void add(BareFeatureList.PartialSymbol symb, String includedSounds) {
            int n = this.specs.length;
            BareFeatureList.PartialSymbol[] newSpecs = new BareFeatureList.PartialSymbol[this.specs.length + 1];
            String[] newSounds = new String[this.specs.length + 1];
            String[] newClass = new String[this.specs.length + 1];
            for (int i = 0; i < n; ++i) {
                newSpecs[i] = this.specs[i];
                newSounds[i] = this.sounds[i];
                newClass[i] = this.readableClass[i];
            }
            newSpecs[n] = symb;
            newSounds[n] = includedSounds;
            newClass[n] = symb.toStringNamed();
            this.specs = newSpecs;
            this.sounds = newSounds;
            this.readableClass = newClass;
            this.fireTableRowsInserted(n, n);
        }

        public Symbol getSymbol(int i) {
            return new Symbol(this.specs[i], this.base);
        }

        public String toTXT() {
            StringBuffer out = new StringBuffer();
            for (int i = 0; i < this.specs.length; ++i) {
                out.append(this.sounds[i] + "\t" + this.readableClass[i] + "\n");
            }
            return out.toString();
        }
    }
}

