/*
 * Decompiled with CFR 0.152.
 */
package gui;

import communication.ResourceProvider;
import featurefunctions.Diacritic;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;

class PhoneticListRenderer
extends DefaultListCellRenderer {
    Font font;
    static final Color shaded = new Color(0.7f, 0.7f, 0.7f);
    static final Color black = new Color(0, 0, 0);
    static final Color included = new Color(0.75f, 0.75f, 0.9f);
    static final Color notIncluded = new Color(0.98f, 0.98f, 0.98f);
    static final Color acceptDrop = new Color(0.7f, 1.0f, 0.7f);
    static final Color rejectDrop = new Color(1.0f, 0.7f, 0.7f);
    static final Color white = new Color(0.98f, 0.98f, 0.98f);
    Diacritic droppingDiacritic;
    protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

    public PhoneticListRenderer(boolean centered, int size, ResourceProvider r) {
        if (centered) {
            this.setHorizontalAlignment(0);
        }
        this.font = r.getIPAFont(size);
        this.droppingDiacritic = null;
    }

    public void setTransferringDiacritic(Diacritic d) {
        this.droppingDiacritic = d;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        Component cell = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        String text = null;
        renderer.setForeground(black);
        renderer.setBackground(included);
        if (value instanceof Diacritic) {
            text = ((Diacritic)value).getPrintableLabel();
        }
        renderer.setText(text);
        renderer.setFont(this.font);
        return renderer;
    }
}

