/*
 * Decompiled with CFR 0.152.
 */
package gui;

import communication.ResourceProvider;
import gui.ColorCentral;
import gui.Message;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;

public class MessageTable
extends AbstractListModel
implements MouseListener {
    Message[] messages = new Message[0];
    JFrame owner;
    JList myList;
    static int MESSAGE_FONT_SIZE = 14;

    MessageTable(JFrame own) {
        this.owner = own;
    }

    public void setList(JList l) {
        this.myList = l;
    }

    public int getSize() {
        return this.messages.length;
    }

    public Message getElementAt(int index) {
        return this.messages[index];
    }

    public void showMessage(String id, String header, Color color, String details) {
        for (int i = 0; i < this.messages.length; ++i) {
            if (!this.messages[i].id.equals(id)) continue;
            this.messages[i].header = header;
            this.messages[i].details = details;
            return;
        }
        this.addMessage(id, header, color, details);
    }

    private void addMessage(String id, String header, Color color, String details) {
        Message m = new Message();
        m.id = id;
        m.header = header;
        m.color = color;
        m.details = details;
        Message[] newM = new Message[this.messages.length + 1];
        for (int i = 0; i < this.messages.length; ++i) {
            newM[i] = this.messages[i];
        }
        newM[this.messages.length] = m;
        this.messages = newM;
        this.fireIntervalAdded(this, this.messages.length - 1, this.messages.length - 1);
    }

    public void removeMessage(String id) {
        int i = this.getIdIndex(id);
        if (i > -1) {
            this.removeMessage(i);
        }
    }

    private void removeMessage(int index) {
        Message[] newM = new Message[this.messages.length - 1];
        for (int i = 0; i < this.messages.length - 1; ++i) {
            newM[i] = i < index ? this.messages[i] : this.messages[i + 1];
        }
        this.messages = newM;
        this.fireIntervalRemoved(this, index, index);
    }

    private int getIdIndex(String h) {
        for (int i = 0; i < this.messages.length; ++i) {
            if (!this.messages[i].id.equals(h)) continue;
            return i;
        }
        return -1;
    }

    private void showDetails(int i) {
        JOptionPane.showMessageDialog(this.owner, this.messages[i].details, this.messages[i].header, 1, null);
    }

    public void mouseClicked(MouseEvent e) {
        int i;
        if (e.getSource() == this.myList && (i = this.myList.getSelectedIndex()) > -1) {
            this.showDetails(i);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    class MessageRenderer
    extends DefaultListCellRenderer {
        Font font;
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

        public MessageRenderer(ResourceProvider r) {
            this.font = r.getIPAFont(MESSAGE_FONT_SIZE);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Message message = (Message)value;
            JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, message.header, index, isSelected, cellHasFocus);
            renderer.setOpaque(true);
            renderer.setBackground(message.color);
            renderer.setForeground(ColorCentral.black);
            renderer.setFont(this.font);
            return renderer;
        }
    }
}

