/*
 * Decompiled with CFR 0.152.
 */
package gui;

import communication.ResourceProvider;
import featurefunctions.BareFeatureList;
import featurefunctions.BareQueryResult;
import featurefunctions.BaseSymbolList;
import featurefunctions.CompiledDiacritics;
import featurefunctions.ComplexSymbol;
import featurefunctions.Contradictions;
import featurefunctions.Dependencies;
import featurefunctions.DetectNaturalClass;
import featurefunctions.Diacritics;
import featurefunctions.FindLabels;
import featurefunctions.IPASkeleton;
import featurefunctions.Inventory;
import featurefunctions.MatchReport;
import featurefunctions.Misc;
import featurefunctions.QueryAndFeatures;
import featurefunctions.ReferentFeatureList;
import featurefunctions.Symbol;
import gui.About;
import gui.ColorCentral;
import gui.IPAChart;
import gui.InventoryEditor;
import gui.InventoryFilter;
import gui.ListenerSymbolEdit;
import gui.MessageTable;
import gui.ShowClassList;
import gui.ShowReport;
import gui.SymbolEditTable;
import gui.SymbolFrame;
import inputoutput.StringTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class MainScreen
extends JFrame
implements ActionListener,
MouseListener,
ListenerSymbolEdit {
    Inventory inventory;
    BareFeatureList features;
    BareFeatureList originalFeatures;
    Dependencies dependencies;
    Contradictions contradictions;
    Diacritics diacritics;
    BaseSymbolList bases;
    IPASkeleton skeleton;
    IPAChart ipaTable;
    ResourceProvider res;
    final JFileChooser fc;
    static int DEFAULT_IPA_FONT_SIZE = 22;
    BareFeatureList.CompiledDependencies compiledDependencies;
    BareFeatureList.CompiledContradictions compiledContradictions;
    CompiledDiacritics compiledDiacritics;
    JTabbedPane mainTP;
    JButton closeB = new JButton("Close");
    JButton detailsB = new JButton("details");
    JPanel messageP;
    JTable featureTable;
    JTable chartTable;
    Font ipafont;
    IPAChart.ChartCellRenderer chartCellRenderer;
    double magnification = 1.0;
    private static int ANTECEDENT_FONT_SIZE = 19;
    private static int ARROW_FONT_SIZE = 15;
    private static int SYMBOL_LABEL_FONT_SIZE = 32;
    private static int REFERENT_DISTANCE_SIZE = 16;
    JMenuItem newInvMI;
    JMenuItem openInvMI;
    JMenuItem inventoryEditorMI;
    JMenuItem aboutMI;
    JMenuItem helpMI;
    JMenuItem closeMI;
    JMenuItem listClassesMI;
    JMenuItem manualMI;
    JPopupMenu popup;
    JMenuItem detailsMI = new JMenuItem("What are the features of this sound?");
    JMenuItem neighbourMI = new JMenuItem("Show neighbours");
    JMenuItem diffMI = new JMenuItem("Diff");
    JMenuItem commonMI = new JMenuItem("Common");
    JMenuItem naturalMI = new JMenuItem("Find featural specifications");
    JMenuItem contradictionsMI = new JMenuItem("What is wrong with this sound?");
    JMenuItem smallFontMI = new JMenuItem("Smaller");
    JMenuItem mediumFontMI = new JMenuItem("Default");
    JMenuItem largeFontMI = new JMenuItem("Larger");
    SymbolEditTable querySET;
    SymbolEditTable transformSET;
    MessageTable messages;
    FindLabels findLabels;
    Thread runningThing;
    String password = "";

    public MainScreen(BaseSymbolList b, Diacritics ds, Dependencies d, Contradictions c, IPASkeleton s, ResourceProvider r) {
        super("Pheatures Spreadsheet");
        BareFeatureList f = new BareFeatureList();
        Inventory inv = new Inventory(ds);
        this.bases = b;
        this.diacritics = ds;
        this.dependencies = d;
        this.contradictions = c;
        this.skeleton = s;
        this.res = r;
        this.fc = new JFileChooser(".");
        this.fc.addChoosableFileFilter(new InventoryFilter());
        this.messages = new MessageTable(this);
        this.setDefaultCloseOperation(2);
        this.ipafont = this.res.getIPAFont(DEFAULT_IPA_FONT_SIZE);
        this.querySET = new SymbolEditTable("selection", "Feature selections", this, b, this.contradictions, this.res);
        this.transformSET = new SymbolEditTable("changes", "Feature changes", this, b, this.contradictions, this.res);
        this.buildComponents(this.getContentPane());
        this.installInventory(inv);
        this.pack();
        this.setSize(1100, 730);
        this.setLocationRelativeTo(null);
    }

    public void installInventory(Inventory inv) {
        BareFeatureList f;
        this.inventory = inv;
        this.features = f = this.inventory.toBareFeatureList(this.bases, this.diacritics);
        this.originalFeatures = f;
        BareFeatureList bareFeatureList = f;
        bareFeatureList.getClass();
        this.compiledDependencies = bareFeatureList.new BareFeatureList.CompiledDependencies(f, this.dependencies);
        BareFeatureList bareFeatureList2 = f;
        bareFeatureList2.getClass();
        this.compiledContradictions = bareFeatureList2.new BareFeatureList.CompiledContradictions(f, this.contradictions);
        this.compiledDiacritics = new CompiledDiacritics(f, this.diacritics);
        MainScreen.pimpFeatureTable(this.featureTable, this.features, this.magnification, this.compiledContradictions, this.res);
        this.prepareChartCellRenderer(f);
        this.querySET.tableModel.cleanUp();
        this.transformSET.tableModel.cleanUp();
    }

    public void showFeatureList(BareFeatureList f, BareQueryResult q) {
        this.features = f;
        this.featureTable.setModel(f);
        this.chartTable.setModel(this.ipaTable);
        MainScreen.pimpFeatureTable(this.featureTable, f, this.magnification, this.compiledContradictions, this.res);
        this.ipaTable.setSelections(q, f);
        this.pimpChartTable();
        this.ipaTable.fireTableDataChanged();
        f.fireTableDataChanged();
    }

    public void fireLabelUpdated(int i) {
        this.features.fireLabelUpdated(i);
        this.ipaTable.fireLabelUpdated(i);
    }

    public void buildComponents(Container container) {
        JPanel featureSelectP = new JPanel();
        featureSelectP.setLayout(new FlowLayout());
        featureSelectP.add(this.querySET.createPanel("Select some sounds by their features:"));
        featureSelectP.add(this.transformSET.createPanel("... and change them into these features:"));
        JPanel messageP = new JPanel(new BorderLayout());
        JList<Object> messageL = new JList<Object>(this.messages);
        this.messages.setList(messageL);
        messageL.addMouseListener(this.messages);
        MessageTable messageTable = this.messages;
        messageTable.getClass();
        messageL.setCellRenderer(new MessageTable.MessageRenderer(messageTable, this.res));
        JScrollPane messageSP = new JScrollPane(messageL);
        messageP.add((Component)new JLabel("Messages (click on them for details)"), "North");
        messageP.add((Component)messageSP, "Center");
        messageP.setPreferredSize(new Dimension(280, 230));
        featureSelectP.add(messageP);
        this.diffMI.addActionListener(this);
        this.commonMI.addActionListener(this);
        this.neighbourMI.addActionListener(this);
        this.naturalMI.addActionListener(this);
        JPanel bottomP = new JPanel();
        bottomP.setLayout(new BorderLayout());
        JPanel centerP = new JPanel();
        centerP.setLayout(new BorderLayout());
        this.featureTable = new JTable(this.features);
        this.chartTable = new JTable(this.ipaTable);
        this.pimpChartTable();
        this.mainTP = new JTabbedPane();
        this.mainTP.addTab("Spreadsheet", null, new JScrollPane(this.featureTable), "Show the sounds in a spreadsheet format so that you can read the feature values.");
        this.mainTP.addTab("Chart", null, new JScrollPane(this.chartTable), "Show the sounds in a chart so that you can see where they belong in the phonetic alphabet.");
        centerP.add((Component)new JScrollPane(featureSelectP), "North");
        centerP.add((Component)this.mainTP, "Center");
        container.add(centerP);
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menuBar.add(menu);
        menu.setMnemonic(70);
        this.newInvMI = new JMenuItem("New phoneme inventory");
        menu.add(this.newInvMI);
        this.newInvMI.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.openInvMI = new JMenuItem("Open phoneme inventory");
        menu.add(this.openInvMI);
        this.openInvMI.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.closeMI = new JMenuItem("Close");
        menu.add(this.closeMI);
        this.newInvMI.addActionListener(this);
        this.openInvMI.addActionListener(this);
        this.closeMI.addActionListener(this);
        menu = new JMenu("Inventory");
        menuBar.add(menu);
        menu.setMnemonic(73);
        this.inventoryEditorMI = new JMenuItem("Edit phoneme inventory");
        this.inventoryEditorMI.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.listClassesMI = new JMenuItem("List Natural Classes");
        menu.add(this.inventoryEditorMI);
        menu.add(this.listClassesMI);
        this.inventoryEditorMI.addActionListener(this);
        this.listClassesMI.addActionListener(this);
        menu = new JMenu("Font");
        menuBar.add(menu);
        menu.setMnemonic(70);
        this.smallFontMI.addActionListener(this);
        this.smallFontMI.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.mediumFontMI.addActionListener(this);
        this.mediumFontMI.setAccelerator(KeyStroke.getKeyStroke(61, 2));
        this.largeFontMI.addActionListener(this);
        this.largeFontMI.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        menu.add(this.smallFontMI);
        menu.add(this.mediumFontMI);
        menu.add(this.largeFontMI);
        menu = new JMenu("About");
        menuBar.add(menu);
        menu.setMnemonic(65);
        this.aboutMI = new JMenuItem("About this program");
        this.manualMI = new JMenuItem("User manual");
        this.helpMI = new JMenuItem("Help");
        this.aboutMI.addActionListener(this);
        this.helpMI.addActionListener(this);
        this.manualMI.addActionListener(this);
        menu.add(this.helpMI);
        menu.add(this.aboutMI);
        this.setJMenuBar(menuBar);
        this.popup = new JPopupMenu();
        this.detailsMI.addActionListener(this);
        this.contradictionsMI.addActionListener(this);
        this.popup.add(this.detailsMI);
        this.popup.add(this.contradictionsMI);
        this.popup.add(this.neighbourMI);
        this.popup.addSeparator();
        this.popup.add(this.diffMI);
        this.popup.add(this.commonMI);
        this.popup.addSeparator();
        this.popup.add(this.naturalMI);
        this.featureTable.addMouseListener(this);
        this.chartTable.addMouseListener(this);
    }

    public void prepareChartCellRenderer(BareFeatureList f) {
        this.ipaTable = new IPAChart(this.skeleton, f);
        this.renewChartCellRenderer();
    }

    public void renewChartCellRenderer() {
        IPAChart iPAChart = this.ipaTable;
        iPAChart.getClass();
        this.chartCellRenderer = iPAChart.new IPAChart.ChartCellRenderer(this.compiledContradictions, this.ipaTable, this.res, this.magnification);
        this.chartTable.setDefaultRenderer(String.class, this.chartCellRenderer);
    }

    public static void pimpFeatureTableSizes(JTable table, BareFeatureList featureList, double magnif) {
        table.setAutoResizeMode(0);
        for (int i = 0; i < table.getModel().getColumnCount(); ++i) {
            int width = 50;
            switch (i) {
                case 0: {
                    if (featureList.isTransformed()) {
                        width = 30;
                        break;
                    }
                    width = 4;
                    break;
                }
                case 1: {
                    width = 4;
                    if (featureList.isTransformed()) {
                        width = 30;
                    }
                    if (!featureList.isReferential()) break;
                    width = 40;
                    break;
                }
                case 2: {
                    width = 70;
                }
            }
            TableColumn col = table.getColumnModel().getColumn(i);
            col.setPreferredWidth(MainScreen.magnify(width, magnif));
        }
        table.setRowHeight((int)Math.round(60.0 * magnif));
        table.setShowVerticalLines(false);
    }

    public static int magnify(int quantity, double factor) {
        return (int)Math.round((double)quantity * factor);
    }

    public static void pimpFeatureTableRenderers(JTable table, BareFeatureList featureList, double magnif, BareFeatureList.CompiledContradictions contras, ResourceProvider res) {
        DefaultTableCellRenderer defaultRenderer = featureList.getRenderer(true, MainScreen.magnify(26, magnif), contras, res);
        for (int i = 0; i < table.getModel().getColumnCount(); ++i) {
            DefaultTableCellRenderer renderer = defaultRenderer;
            switch (i) {
                case 0: {
                    renderer = featureList.getRenderer(false, MainScreen.magnify(ANTECEDENT_FONT_SIZE, magnif), contras, res);
                    break;
                }
                case 1: {
                    if (featureList.isReferential()) {
                        renderer = featureList.getRenderer(false, MainScreen.magnify(REFERENT_DISTANCE_SIZE, magnif), contras, res);
                        break;
                    }
                    renderer = featureList.getRenderer(false, MainScreen.magnify(ARROW_FONT_SIZE, magnif), contras, res);
                    break;
                }
                case 2: {
                    renderer = featureList.getRenderer(false, MainScreen.magnify(SYMBOL_LABEL_FONT_SIZE, magnif), contras, res);
                }
            }
            TableColumn col = table.getColumnModel().getColumn(i);
            col.setCellRenderer(renderer);
        }
    }

    public static void pimpFeatureTable(JTable table, BareFeatureList featureList, double magnif, BareFeatureList.CompiledContradictions contras, ResourceProvider res) {
        MainScreen.pimpFeatureTableSizes(table, featureList, magnif);
        MainScreen.pimpFeatureTableRenderers(table, featureList, magnif, contras, res);
        table.setAutoCreateRowSorter(true);
        table.setCellSelectionEnabled(false);
        table.setRowSelectionAllowed(true);
    }

    public void pimpChartTable() {
        JTable table = this.chartTable;
        table.setAutoResizeMode(0);
        table.setSelectionMode(2);
        for (int i = 0; i < table.getModel().getColumnCount(); ++i) {
            TableColumn col = table.getColumnModel().getColumn(i);
            col.setPreferredWidth(MainScreen.magnify(100, this.magnification));
        }
        table.setRowHeight(MainScreen.magnify(60, this.magnification));
        table.setShowVerticalLines(false);
        table.setCellSelectionEnabled(true);
        table.setRowSelectionAllowed(false);
        table.setColumnSelectionAllowed(false);
        table.setTableHeader(null);
    }

    public void updateEnabilities(BareFeatureList.BareSymbol[] selected) {
        boolean oneSelected = selected.length == 1;
        boolean multipleSelected = selected.length > 1;
        this.neighbourMI.setEnabled(oneSelected);
        this.diffMI.setEnabled(multipleSelected);
        this.commonMI.setEnabled(multipleSelected);
        this.naturalMI.setEnabled(multipleSelected || oneSelected);
        this.detailsMI.setEnabled(!this.features.isTransformed() && oneSelected);
        if (oneSelected) {
            boolean hascontradiction = this.compiledContradictions.findContradictions(selected[0]).length > 0;
            this.contradictionsMI.setVisible(hascontradiction);
        } else {
            this.contradictionsMI.setVisible(false);
        }
    }

    public void symbolChanged() {
        Symbol select = this.querySET.getSymbol();
        Symbol transform = this.transformSET.getSymbol();
        Symbol cascaded = new Symbol();
        if (!transform.isVoid()) {
            StringBuffer report = new StringBuffer();
            for (int i = 0; i < this.dependencies.from.length; ++i) {
                MatchReport match = transform.matchByFeatures(this.dependencies.from[i]);
                if (!match.isMatch() || !match.hasAllFeatures()) continue;
                cascaded.mergeWith(this.dependencies.to[i]);
                report.append(this.dependencies.to[i].toStringBareFancy() + "\n\t(because you selected " + this.dependencies.from[i].toStringBareFancy() + ")\n\n");
            }
            if (!cascaded.isVoid()) {
                this.messages.showMessage("dependencies", "More feature changes have been filled in", ColorCentral.dependencyColor, "On the basis of the feature changes that you entered,\nI have added the following feature changes:\n\n" + report.toString());
            } else {
                this.messages.removeMessage("dependencies");
            }
        } else {
            this.messages.removeMessage("dependencies");
        }
        QueryAndFeatures res = this.originalFeatures.searchAndTransform(select, transform, cascaded);
        BareFeatureList.MinimalityReport minim = this.originalFeatures.isMinimal(res.queryResult, select, transform);
        boolean minimal = minim.featureSelectionsMinimal;
        if (minim.featureLeavingIdentity) {
            this.messages.showMessage("fire-and-rain", "You don't need all features on the left side", ColorCentral.nonMinimalColor, "The left side of your rule contains unnecessary features.\nThere is one feature that you can leave out, so that you will\nselect a larger class of sounds. But the transformation you do\nwill not change those sounds.\n\nTry taking out some features on the left hand side and see\nwhat happens.");
        } else {
            this.messages.removeMessage("fire-and-rain");
        }
        this.querySET.markMinimality(minimal);
        if (!transform.isVoid()) {
            boolean[] used = res.transformFeaturesUsed;
            if (Misc.hasAFalse(used)) {
                Symbol notUsed = res.notUsedAsSymbol(transform);
                this.messages.showMessage("change-redundancy", "Some feature changes are redundant", ColorCentral.nonMinimalColor, "You gave a number of features to change in the selected sounds.\nBut it turns out, a couple of these features are already set that way\nin all selected sounds.\nSo the following feature changes are redundant:\n\n" + notUsed.toStringBareFancy());
                this.transformSET.querySP.getViewport().setBackground(ColorCentral.nonMinimalColor);
            } else {
                this.messages.removeMessage("change-redundancy");
                this.transformSET.querySP.getViewport().setBackground(ColorCentral.minimalColor);
            }
        } else {
            this.messages.removeMessage("change-redundancy");
            this.transformSET.querySP.getViewport().setBackground(ColorCentral.minimalColor);
        }
        this.showFeatureList(res.featureList, res.queryResult);
        if (transform.nonVoid()) {
            this.findLabels = new FindLabels(this, res.featureList, res.queryResult, this.originalFeatures, this.bases, this.compiledDiacritics);
            this.runningThing = new Thread(this.findLabels);
            this.runningThing.start();
        }
        this.ipaTable.emptySelected();
    }

    public void redraw_tables() {
        MainScreen.pimpFeatureTable(this.featureTable, this.features, this.magnification, this.compiledContradictions, this.res);
        this.pimpChartTable();
        this.renewChartCellRenderer();
        this.querySET.effectResize(this.magnification);
        this.transformSET.effectResize(this.magnification);
    }

    public void actionPerformed(ActionEvent e) {
        ComplexSymbol symb;
        InventoryEditor inv;
        BareFeatureList fl;
        BareFeatureList.BareSymbol[] selected = new BareFeatureList.BareSymbol[]{};
        if (this.popup.getInvoker() == this.chartTable) {
            selected = this.getChartTableSelectedSymbols();
        }
        if (this.popup.getInvoker() == this.featureTable) {
            selected = this.getFeatureTableSelectedSymbols();
        }
        if (e.getSource() == this.neighbourMI && selected.length > 0) {
            fl = new ReferentFeatureList(selected[0], this.originalFeatures, this.bases, this.compiledDiacritics);
            if (selected[0].isUnknown()) {
                ((ReferentFeatureList)fl).addCompletedSymbol(selected[0]);
                System.out.println("Referent is unknown.");
            }
            fl.showAsFrame(this, this.res);
        }
        if (e.getSource() == this.commonMI) {
            fl = this.originalFeatures.common(selected);
            fl.showAsFrame(this, this.res);
        }
        if (e.getSource() == this.diffMI) {
            fl = this.originalFeatures.diff(selected);
            fl.showAsFrame(this, this.res);
        }
        if (e.getSource() == this.closeB || e.getSource() == this.closeMI) {
            this.dispose();
        }
        if (e.getSource() == this.newInvMI) {
            inv = new InventoryEditor(this, new Inventory(this.diacritics), this.bases, this.diacritics, this.res);
            inv.setVisible(true);
            if (inv.useSelected) {
                this.installInventory(inv.getInventory());
                this.showFeatureList(this.originalFeatures, BareQueryResult.fullFrom(this.originalFeatures));
            }
        }
        if (e.getSource() == this.openInvMI) {
            this.attemptInventoryLoad();
        }
        if (e.getSource() == this.naturalMI && selected.length > 0) {
            this.password = (String)JOptionPane.showInputDialog(this, "", "Please enter the teacher password", -1, null, null, this.password);
            if (this.password != null) {
                if (this.password.equals("Bloomfield")) {
                    BareFeatureList target = new BareFeatureList();
                    target.features = this.originalFeatures.getFeatures();
                    target.symbols = selected;
                    DetectNaturalClass dnc = new DetectNaturalClass(this.originalFeatures, target);
                    ShowReport showReport = new ShowReport(dnc, this.res.getIPAFont(22), this);
                } else {
                    JOptionPane.showMessageDialog(this, "Sorry, this functionality is restricted to teachers. \nPlease write to Bruce Hayes if you are a teacher\n and would like to know the password.");
                }
            }
        }
        if (e.getSource() == this.listClassesMI) {
            ShowClassList showReport = new ShowClassList(this.originalFeatures, this.res.getIPAFont(22), this);
            showReport.setVisible(true);
        }
        if (e.getSource() == this.detailsMI && selected.length > 0 && (symb = selected[0].origin) != null) {
            SymbolFrame fr = new SymbolFrame((Frame)this, symb, this.res);
            fr.setVisible(true);
        }
        if (e.getSource() == this.contradictionsMI && selected.length > 0) {
            String contr = this.contradictions.getReport(selected[0].toSymbol());
            JOptionPane.showMessageDialog(this, contr, "Contradiction report", 1, null);
        }
        if (e.getSource() == this.manualMI) {
            MainScreen.showPDF("manual/manual.pdf");
        }
        if (e.getSource() == this.aboutMI) {
            About about = new About((Frame)this, this.res);
            about.setVisible(true);
        }
        if (e.getSource() == this.helpMI) {
            ImageIcon icon = this.res.createImageIcon("images/explanation.png");
            JOptionPane.showMessageDialog(this, "", "Help", 1, icon);
        }
        if (e.getSource() == this.inventoryEditorMI) {
            inv = new InventoryEditor(this, this.inventory, this.bases, this.diacritics, this.res);
            inv.setVisible(true);
            if (inv.useSelected) {
                this.installInventory(inv.getInventory());
                this.showFeatureList(this.originalFeatures, BareQueryResult.fullFrom(this.originalFeatures));
            }
        }
        if (e.getSource() == this.smallFontMI) {
            this.magnification *= 0.9;
            this.redraw_tables();
        }
        if (e.getSource() == this.mediumFontMI) {
            this.magnification = 1.0;
            this.redraw_tables();
        }
        if (e.getSource() == this.largeFontMI) {
            this.magnification *= 1.1;
            this.redraw_tables();
        }
    }

    public void attemptInventoryLoad() {
        int returnVal = this.fc.showOpenDialog(this);
        if (returnVal == 0) {
            File file = this.fc.getSelectedFile();
            System.out.println("Taking inventory from " + file.toString() + ".");
            StringTable st = new StringTable();
            st.fromFile(file, "\t");
            this.inventory = new Inventory(this.diacritics);
            this.inventory = Inventory.fromTable(st, this.bases, this.diacritics);
            this.installInventory(this.inventory);
            this.symbolChanged();
        }
    }

    public BareFeatureList.BareSymbol[] getChartTableSelectedSymbols() {
        int[] selected = this.ipaTable.getSelectedIndices();
        return this.getSymbols(selected);
    }

    public BareFeatureList.BareSymbol[] getFeatureTableSelectedSymbols() {
        int[] scrambledSelections = this.featureTable.getSelectedRows();
        int[] selections = new int[scrambledSelections.length];
        for (int i = 0; i < scrambledSelections.length; ++i) {
            selections[i] = this.featureTable.convertRowIndexToModel(scrambledSelections[i]);
        }
        return this.getSymbols(selections);
    }

    public BareFeatureList.BareSymbol[] getSymbols(int[] selected) {
        BareFeatureList.BareSymbol[] symbols = new BareFeatureList.BareSymbol[selected.length];
        for (int i = 0; i < selected.length; ++i) {
            symbols[i] = this.features.getBareSymbol(selected[i]);
        }
        return symbols;
    }

    public void updateChartTableSelection(MouseEvent e) {
        int row = this.chartTable.rowAtPoint(e.getPoint());
        int col = this.chartTable.columnAtPoint(e.getPoint());
        if (row > -1 && col > -1) {
            if (e.isControlDown()) {
                this.ipaTable.toggleSelected(row, col);
            } else {
                this.ipaTable.selectOnly(row, col);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        int c;
        Point p;
        int r;
        BareFeatureList.BareSymbol selected;
        if (e.getButton() == 1 && !e.isControlDown() && e.getSource() == this.chartTable && (selected = this.ipaTable.getValueAt(r = this.chartTable.rowAtPoint(p = e.getPoint()), c = this.chartTable.columnAtPoint(p))) != null) {
            boolean hascontradiction;
            boolean bl = hascontradiction = this.compiledContradictions.findContradictions(selected).length > 0;
            if (hascontradiction) {
                String contr = this.contradictions.getReport(selected.toSymbol());
                JOptionPane.showMessageDialog(this, contr, "Contradiction report", 1, null);
            } else if (selected.isUnknown()) {
                this.displayUnknownSymbolMessage();
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (!this.maybeShowPopup(e) && e.getSource() == this.chartTable && e.getButton() == 1) {
            this.updateChartTableSelection(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    private boolean maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            if (e.getSource() == this.chartTable) {
                this.updateEnabilities(this.getChartTableSelectedSymbols());
            }
            if (e.getSource() == this.featureTable) {
                this.updateEnabilities(this.getFeatureTableSelectedSymbols());
            }
            this.popup.show(e.getComponent(), e.getX(), e.getY());
            return true;
        }
        return false;
    }

    public void displayUnknownSymbolMessage() {
        JOptionPane.showMessageDialog(this, "The program cannot find a symbol for the sound you just created.\nYou can try looking for similar sounds by right-clicking\n on the question mark and then selecting Show Neighbours.", "No symbol exists for this feature matrix", 1);
    }

    static String intListToString(int[] lijstje) {
        StringBuffer out = new StringBuffer("");
        for (int i = 0; i < lijstje.length; ++i) {
            out.append(Integer.toString(lijstje[i]) + ", ");
        }
        return out.toString();
    }

    public static void prepareCreation() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void showPDF(String pdf) {
        try {
            Process p = Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + pdf);
            try {
                p.waitFor();
            }
            catch (InterruptedException e) {
                System.out.println("Interrupted while showing manual pdf via rundll32: " + e.getMessage());
            }
        }
        catch (IOException e) {
            System.out.println("Error showing manual pdf via rundll32: " + e.getMessage());
            try {
                Process pMac = Runtime.getRuntime().exec("open " + pdf);
            }
            catch (IOException eMac) {
                System.out.println("Error showing manual pdf via Mac-open: " + eMac.getMessage());
            }
        }
    }
}

