/*
 * Decompiled with CFR 0.152.
 */
package gui;

import communication.ResourceProvider;
import featurefunctions.Contradictions;
import featurefunctions.FeatureList;
import gui.ColorCentral;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class JTableFeatures
extends DefaultTableCellRenderer {
    Font font;
    FeatureList featureList;
    Contradictions contradictions;
    static final Color shaded = new Color(0.7f, 0.7f, 0.7f);
    static final Color black = new Color(0, 0, 0);
    static final Color referentMarker = new Color(0.55f, 0.55f, 0.7f);
    static final Color defaultBackground = new Color(0.98f, 0.98f, 0.98f);

    public JTableFeatures(boolean centered, int size, FeatureList fl, Contradictions c, ResourceProvider r) {
        this.featureList = fl;
        this.contradictions = c;
        if (centered) {
            this.setHorizontalAlignment(0);
        }
        this.font = r.getIPAFont(size);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        cell.setFont(this.font);
        if (!isSelected) {
            if (this.featureList.symbols[row] == this.featureList.getReferent()) {
                cell.setBackground(referentMarker);
            } else {
                cell.setBackground(defaultBackground);
            }
        }
        if (this.featureList.getReferential()) {
            if (column > 2 && this.featureList.symbols[row].values[column - 3] == this.featureList.getReferent().values[column - 3]) {
                cell.setForeground(shaded);
            } else {
                cell.setForeground(black);
            }
        }
        if (this.featureList.getTransformed() && column == 2 && this.featureList.symbols[row].isUnknown()) {
            cell.setBackground(ColorCentral.unknown);
        }
        if (column == 2 && this.contradictions.findContradictions(this.featureList.symbols[row]).length > 0) {
            cell.setBackground(ColorCentral.contradiction);
        }
        return cell;
    }
}

