/*
 * Decompiled with CFR 0.152.
 */
package gui;

import communication.ResourceProvider;
import featurefunctions.BaseSymbolList;
import featurefunctions.ComplexSymbol;
import featurefunctions.Coordinate;
import featurefunctions.Diacritic;
import featurefunctions.DiacriticSignature;
import featurefunctions.Diacritics;
import featurefunctions.IPASkeleton;
import featurefunctions.Inventory;
import featurefunctions.SubSkeleton;
import featurefunctions.Symbol;
import gui.ColorCentral;
import inputoutput.StringTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class InventoryTableModel
extends AbstractTableModel {
    SymbolAndIncluded[] symbols;
    Diacritics diacritics;
    int[][] chartToSymbols;
    Coordinate[] symbolToChart;
    DiacriticSignature[] rowDiacritics;
    int colCount;
    int rowCount;
    String[][] labels;
    static final int ROW_HEIGHT = 50;
    static final int COLUMN_WIDTH = 55;
    static final int LABEL_COLUMN_WIDTH = 100;
    static final int LABEL_TEXT_SIZE = 12;

    public InventoryTableModel(Inventory inv, IPASkeleton skeleton, Diacritics diacs) {
        this.diacritics = diacs;
        this.fromChartToSymbols(skeleton.subSkeletons[0]);
        ComplexSymbol[] symbs = inv.getSymbols();
        for (int i = 0; i < symbs.length; ++i) {
            this.ensureIncluded(symbs[i]);
        }
    }

    public void fromChartToSymbols(SubSkeleton skeleton) {
        this.rowCount = skeleton.rowCount;
        this.colCount = skeleton.colCount;
        this.symbols = new SymbolAndIncluded[0];
        this.chartToSymbols = new int[this.rowCount][];
        this.rowDiacritics = new DiacriticSignature[this.rowCount];
        for (int i = 0; i < this.rowCount; ++i) {
            this.rowDiacritics[i] = new DiacriticSignature();
            this.chartToSymbols[i] = new int[this.colCount];
            for (int j = 0; j < this.colCount; ++j) {
                if (skeleton.isSymbol[i][j]) {
                    int index;
                    ComplexSymbol symb = skeleton.symbols[i][j];
                    this.chartToSymbols[i][j] = index = this.add(symb, false);
                    continue;
                }
                this.chartToSymbols[i][j] = -1;
            }
        }
        this.labels = skeleton.labels.data;
        this.computeFromSymbolsToChart();
    }

    private void computeFromSymbolsToChart() {
        this.symbolToChart = new Coordinate[this.symbols.length];
        for (int i = 0; i < this.rowCount; ++i) {
            for (int j = 0; j < this.colCount; ++j) {
                int index = this.chartToSymbols[i][j];
                if (index <= -1) continue;
                this.symbolToChart[index] = new Coordinate(i, j);
            }
        }
    }

    public void insertRow(int r, DiacriticSignature diacs) {
        String[][] newLabels = new String[this.rowCount + 1][];
        int[][] newChart = new int[this.rowCount + 1][];
        DiacriticSignature[] newDiacs = new DiacriticSignature[this.rowCount + 1];
        for (int i = 0; i < this.rowCount + 1; ++i) {
            if (i < r) {
                newLabels[i] = this.labels[i];
                newChart[i] = this.chartToSymbols[i];
                newDiacs[i] = this.rowDiacritics[i];
                continue;
            }
            if (i == r) {
                newLabels[i] = new String[this.colCount];
                newChart[i] = new int[this.colCount];
                for (int j = 0; j < this.colCount; ++j) {
                    newChart[i][j] = -1;
                }
                newDiacs[i] = diacs;
                continue;
            }
            newLabels[i] = this.labels[i - 1];
            newChart[i] = this.chartToSymbols[i - 1];
            newDiacs[i] = this.rowDiacritics[i - 1];
        }
        this.labels = newLabels;
        this.chartToSymbols = newChart;
        this.rowDiacritics = newDiacs;
        ++this.rowCount;
    }

    public String getColumnName(int column) {
        return "";
    }

    public int getColumnCount() {
        return this.colCount;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public Object getValueAt(int i, int j) {
        int index = this.chartToSymbols[i][j];
        if (index > -1) {
            return this.symbols[index];
        }
        if (this.labels[i][j] != null && this.labels[i][j].length() > 0) {
            return this.labels[i][j];
        }
        return null;
    }

    public ComplexSymbol getSymbol(int i) {
        return this.symbols[i].symbol;
    }

    public int getSize() {
        return this.symbols.length;
    }

    public void setAllIncluded(boolean included) {
        for (int i = 0; i < this.symbols.length; ++i) {
            this.symbols[i].included = included;
        }
        this.fireTableDataChanged();
    }

    public void toggleIncluded(int i) {
        this.symbols[i].included = !this.symbols[i].included;
        Coordinate c = this.symbolToChart[i];
        this.fireTableCellUpdated(c.i, c.j);
    }

    public int add(ComplexSymbol c, boolean incl) {
        c.compile();
        int n = this.symbols.length;
        SymbolAndIncluded[] newSymbols = new SymbolAndIncluded[n + 1];
        for (int i = 0; i < n; ++i) {
            newSymbols[i] = this.symbols[i];
        }
        newSymbols[n] = new SymbolAndIncluded(c, incl);
        this.symbols = newSymbols;
        return n;
    }

    public void includedChanged(int i) {
        Coordinate c = this.symbolToChart[i];
        this.fireTableCellUpdated(c.i, c.j);
    }

    public Inventory getIncludedInventory() {
        Inventory inv = new Inventory(this.diacritics);
        for (int i = 0; i < this.symbols.length; ++i) {
            if (!this.symbols[i].included) continue;
            inv.add(this.symbols[i].symbol);
        }
        return inv;
    }

    public String dumpForFile() {
        return this.getIncludedInventory().dumpForFile();
    }

    public void includeFromTable(StringTable tab, BaseSymbolList bases, Diacritics diacritics) {
        for (int i = 0; i < tab.rowCount(); ++i) {
            String[] row = tab.getRow(i);
            if (row.length <= 0) continue;
            ComplexSymbol symbol = ComplexSymbol.fromInventoryRow(row[0], tab.takeRowFrom(i, 1), bases, diacritics);
            this.ensureIncluded(symbol);
        }
    }

    public void putSymbol(int row, int col, ComplexSymbol symb) {
        int index;
        this.chartToSymbols[row][col] = index = this.add(symb, true);
    }

    boolean ensureIncluded(ComplexSymbol symbol) {
        int maxMatchSize = -1;
        int maxMatchIndex = -1;
        for (int i = 0; i < this.symbols.length; ++i) {
            SymbolAndIncluded c = this.symbols[i];
            if (c.symbol.equals(symbol)) {
                boolean oldIncl = c.included;
                c.included = true;
                this.includedChanged(i);
                return !oldIncl;
            }
            int m = SubSkeleton.quantifyMatch(symbol, c.symbol);
            if (m < maxMatchSize) continue;
            maxMatchIndex = i;
            maxMatchSize = m;
        }
        if (maxMatchIndex == -1) {
            System.err.println("Error! Nothing matches '" + symbol.getLabel() + "' in my chart! I have no idea where to put this symbol you just created.");
            return false;
        }
        Coordinate maxMatch = this.symbolToChart[maxMatchIndex];
        int skelRow = this.skeletonRowAbove(maxMatch.i);
        int row = this.findMatchingDiacriticRowBelow(symbol, skelRow);
        if (row == -1) {
            this.insertRow(maxMatch.i + 1, new DiacriticSignature(symbol.diacritics));
            this.putSymbol(maxMatch.i + 1, maxMatch.j, symbol);
            this.fireTableRowsInserted(skelRow + 1, skelRow + 1);
        } else {
            this.putSymbol(row, maxMatch.j, symbol);
            this.fireTableCellUpdated(row, maxMatch.j);
        }
        this.computeFromSymbolsToChart();
        return true;
    }

    public String toStringIncluded() {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < this.symbols.length; ++i) {
            if (i > 0) {
                out.append(", ");
            }
            if (!this.symbols[i].included) {
                out.append("(");
            }
            out.append(this.symbols[i].symbol.getLabel());
            if (this.symbols[i].included) continue;
            out.append(")");
        }
        return out.toString();
    }

    public String diacriticSignaturesToString() {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < this.rowCount; ++i) {
            out.append(Integer.toString(i) + ": " + this.rowDiacritics[i].toString() + "\n");
        }
        return out.toString();
    }

    public int skeletonRowAbove(int i) {
        int row;
        for (row = i; row >= 0; --row) {
            if (!this.isSkeletonRow(row)) continue;
            return row;
        }
        return row;
    }

    public boolean isSkeletonRow(int i) {
        return this.rowDiacritics[i].isEmpty();
    }

    public int findMatchingDiacriticRowBelow(ComplexSymbol s, int row) {
        ++row;
        while (row < this.rowCount && !this.isSkeletonRow(row)) {
            if (this.rowDiacritics[row].isSameAs(s.diacritics)) {
                return row;
            }
            ++row;
        }
        return -1;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < this.symbols.length; ++i) {
            if (this.symbols[i].included) {
                out.append("INCLUDED==> ");
            }
            out.append(this.symbols[i].symbol.toString() + "\n");
        }
        return out.toString();
    }

    public class IPATableRenderer
    extends DefaultTableCellRenderer {
        Font font;
        Font labelFont;
        Diacritic droppingDiacritic;
        Component niente = new RendererVanNiets();

        public IPATableRenderer(boolean centered, int size, ResourceProvider r) {
            if (centered) {
                this.setHorizontalAlignment(0);
            }
            this.font = r.getIPAFont(size);
            this.labelFont = r.getIPAFont(12);
            this.droppingDiacritic = null;
        }

        public void setTransferringDiacritic(Diacritic d) {
            this.droppingDiacritic = d;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return this.niente;
            }
            String text = "";
            SymbolAndIncluded symb = null;
            if (value instanceof SymbolAndIncluded) {
                symb = (SymbolAndIncluded)value;
                text = symb.symbol.getLabel();
            }
            if (value instanceof String) {
                String[] texts = new String[]{(String)value};
                if (column > 0) {
                    String[] t = ((String)value).split(" ");
                    texts = t;
                }
                JPanel panel = new JPanel();
                panel.setLayout(new BoxLayout(panel, 3));
                panel.setOpaque(false);
                for (int i = 0; i < texts.length; ++i) {
                    JLabel lab = new JLabel(texts[i]);
                    lab.setForeground(Color.black);
                    lab.setOpaque(false);
                    lab.setFont(this.labelFont);
                    panel.add(lab);
                }
                return panel;
            }
            JLabel renderer = (JLabel)super.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
            renderer.setOpaque(true);
            if (value instanceof SymbolAndIncluded) {
                if (!symb.included) {
                    renderer.setForeground(ColorCentral.shaded);
                    renderer.setBackground(ColorCentral.notIncluded);
                } else {
                    renderer.setForeground(ColorCentral.black);
                    if (hasFocus) {
                        renderer.setBackground(ColorCentral.included);
                    } else {
                        renderer.setBackground(ColorCentral.includedAndFocus);
                    }
                }
            }
            JTable.DropLocation dropLocation = null;
            try {
                dropLocation = table.getDropLocation();
            }
            catch (Exception e) {
                System.err.println("When opening table drop location: " + e.getMessage());
            }
            if (dropLocation != null && dropLocation.getRow() == row && dropLocation.getColumn() == column && this.droppingDiacritic != null) {
                Symbol featVals = InventoryTableModel.this.symbols[InventoryTableModel.this.chartToSymbols[row][column]].symbol.featureValues;
                boolean candrop = this.droppingDiacritic.canApplyTo(featVals);
                if (candrop) {
                    renderer.setBackground(ColorCentral.acceptDrop);
                } else {
                    renderer.setBackground(ColorCentral.rejectDrop);
                }
            }
            renderer.setFont(this.font);
            return renderer;
        }

        class RendererVanNiets
        extends JComponent {
            RendererVanNiets() {
            }

            public void paint(Graphics g) {
            }
        }
    }

    class SymbolAndIncluded {
        ComplexSymbol symbol;
        boolean included;

        SymbolAndIncluded(ComplexSymbol c, boolean i) {
            this.symbol = c;
            this.included = i;
        }
    }
}

