/*
 * Decompiled with CFR 0.152.
 */
package gui;

import communication.ResourceProvider;
import featurefunctions.BaseSymbolList;
import featurefunctions.ComplexSymbol;
import featurefunctions.Diacritic;
import featurefunctions.Diacritics;
import featurefunctions.IPASkeleton;
import featurefunctions.Inventory;
import gui.ColorCentral;
import gui.DiacriticFrame;
import gui.DiacriticsListModel;
import gui.InventoryFilter;
import gui.InventoryListHolder;
import gui.InventoryTableModel;
import gui.PhoneticListRenderer;
import gui.SymbolFrame;
import inputoutput.FileWriting;
import inputoutput.StringTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.table.TableColumn;

public final class InventoryEditor
extends JDialog
implements ActionListener,
MouseListener,
InventoryListHolder {
    File file;
    Diacritics diacritics;
    DiacriticsListModel diacriticsList;
    BaseSymbolList symbols;
    Inventory inventory;
    InventoryTableModel inventoryTable;
    Frame owner;
    JFileChooser fc;
    ResourceProvider res;
    IPASkeleton skeleton;
    boolean useSelected;
    JButton clearB = new JButton("Select none");
    JButton allB = new JButton("Select all");
    JButton useB = new JButton("Use inventory");
    JButton cancelB = new JButton("Return without using");
    JButton saveB = new JButton("Save to file");
    JButton loadB = new JButton("Load from file");
    int COMPLEX_WIDTH = 500;
    int COMPLEX_HEIGHT = 400;
    int DIACRITICS_WIDTH = 150;
    int DIACRITICS_HEIGHT = 400;
    int PHONETIC_FONT_SIZE = 26;
    JTable invT;
    JList dl;
    static int HEADER_FONT_SIZE = 20;
    static int COMMENT_FONT_SIZE = 16;
    JPopupMenu popup;
    JMenuItem detailsMI;

    public InventoryEditor(Frame ownr, Inventory inv, BaseSymbolList b, Diacritics d, ResourceProvider r) {
        super(ownr, "Pheatures Inventory Editor", true);
        this.setDefaultCloseOperation(2);
        this.res = r;
        this.owner = ownr;
        this.useSelected = false;
        this.symbols = b;
        this.diacritics = d;
        this.inventory = inv;
        this.skeleton = new IPASkeleton(this.res, b, d);
        this.skeleton.readFromFileUnified();
        this.diacriticsList = new DiacriticsListModel(this.diacritics);
        this.inventoryTable = new InventoryTableModel(this.inventory, this.skeleton, this.diacritics);
        this.buildComponents(this.getContentPane(), this.res);
        this.fc = new JFileChooser(".");
        this.fc.addChoosableFileFilter(new InventoryFilter());
        this.pack();
        this.setSize(1150, 600);
        this.setLocationRelativeTo(null);
    }

    public void buildComponents(Container container, ResourceProvider res) {
        container.setLayout(new BorderLayout());
        JPanel mainP = new JPanel(new BorderLayout());
        Font headerF = res.getIPAFont(HEADER_FONT_SIZE);
        Font commentF = res.getIPAFont(COMMENT_FONT_SIZE);
        JPanel diacP = new JPanel(new BorderLayout());
        diacP.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.invT = new JTable(this.inventoryTable);
        JScrollPane sp = new JScrollPane(this.invT);
        sp.setPreferredSize(new Dimension(this.COMPLEX_WIDTH, this.COMPLEX_HEIGHT));
        diacP.add((Component)sp, "Center");
        JPanel labP = new JPanel();
        labP.setLayout(new BoxLayout(labP, 2));
        JLabel lab = new JLabel("Phoneme workspace");
        labP.add(lab);
        lab.setFont(headerF);
        lab = new JLabel("Click on a symbol to add or remove it from the phoneme inventory.");
        lab.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        labP.add(Box.createRigidArea(new Dimension(20, 0)));
        labP.add(lab);
        lab.setFont(commentF);
        diacP.add((Component)labP, "North");
        mainP.add((Component)diacP, "Center");
        this.invT.addMouseListener(this);
        this.tweakTable();
        JPanel workP = new JPanel(new BorderLayout());
        workP.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.dl = new JList(this.diacriticsList){

            public String getToolTipText(MouseEvent evt) {
                int index = this.locationToIndex(evt.getPoint());
                Diacritic item = (Diacritic)this.getModel().getElementAt(index);
                return item.toolTip();
            }
        };
        sp = new JScrollPane(this.dl);
        sp.setPreferredSize(new Dimension(this.DIACRITICS_WIDTH, this.DIACRITICS_HEIGHT));
        labP = new JPanel();
        labP.setLayout(new BoxLayout(labP, 3));
        lab = new JLabel("Diacritics");
        labP.add(lab);
        lab.setFont(headerF);
        lab = new JLabel("To create a diacritically-marked");
        labP.add(lab);
        lab.setFont(commentF);
        lab = new JLabel("symbol, click and drag a diacritic.");
        labP.add(lab);
        lab.setFont(commentF);
        workP.add((Component)labP, "North");
        workP.add((Component)sp, "Center");
        mainP.add((Component)workP, "East");
        this.dl.setLayoutOrientation(2);
        this.dl.setCellRenderer(new PhoneticListRenderer(false, this.PHONETIC_FONT_SIZE, res));
        this.dl.setDragEnabled(true);
        this.dl.setTransferHandler(new DiacriticTransferHandler(this.diacritics));
        JPanel buttonP = new JPanel();
        buttonP.add(this.clearB);
        buttonP.add(this.allB);
        buttonP.add(this.loadB);
        buttonP.add(this.saveB);
        buttonP.add(this.cancelB);
        buttonP.add(this.useB);
        this.clearB.addActionListener(this);
        this.allB.addActionListener(this);
        this.cancelB.addActionListener(this);
        this.useB.addActionListener(this);
        this.loadB.addActionListener(this);
        this.saveB.addActionListener(this);
        container.add((Component)mainP, "Center");
        container.add((Component)buttonP, "South");
        this.popup = new JPopupMenu();
        this.detailsMI = new JMenuItem("Show details");
        this.detailsMI.addActionListener(this);
        this.popup.add(this.detailsMI);
        PopupListener popupListener = new PopupListener();
        this.invT.addMouseListener(popupListener);
        this.dl.addMouseListener(popupListener);
    }

    public void tweakTable() {
        this.invT.setDragEnabled(true);
        InventoryTableModel inventoryTableModel = this.inventoryTable;
        inventoryTableModel.getClass();
        InventoryTableModel.IPATableRenderer render = new InventoryTableModel.IPATableRenderer(inventoryTableModel, true, this.PHONETIC_FONT_SIZE, this.res);
        this.invT.setDefaultRenderer(Object.class, render);
        this.invT.setRowHeight(50);
        this.invT.setAutoResizeMode(0);
        for (int i = 0; i < this.invT.getModel().getColumnCount(); ++i) {
            TableColumn col = this.invT.getColumnModel().getColumn(i);
            if (i == 0) {
                col.setPreferredWidth(100);
                continue;
            }
            col.setPreferredWidth(55);
        }
        this.invT.setTableHeader(null);
        this.invT.setRowSelectionAllowed(false);
        this.invT.setColumnSelectionAllowed(false);
        this.invT.setCellSelectionEnabled(true);
        this.invT.setGridColor(ColorCentral.inventoryGridColor);
        this.invT.setTransferHandler(new ComplexSymbolTransfer(render, this));
    }

    public int getSelected() {
        int[] rows = this.invT.getSelectedRows();
        int[] cols = this.invT.getSelectedColumns();
        if (rows.length > 0 && cols.length > 0) {
            return this.inventoryTable.chartToSymbols[rows[0]][cols[0]];
        }
        return -1;
    }

    public int getSelectedDiacritic() {
        int[] sels = this.dl.getSelectedIndices();
        if (sels.length == 0) {
            return -1;
        }
        return sels[0];
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.allB || e.getSource() == this.clearB) {
            this.inventoryTable.setAllIncluded(e.getSource() == this.allB);
        }
        if (e.getSource() == this.useB) {
            this.useSelected = true;
            this.setVisible(false);
        }
        if (e.getSource() == this.cancelB) {
            this.useSelected = false;
            this.setVisible(false);
        }
        if (e.getSource() == this.saveB) {
            this.attemptSave();
        }
        if (e.getSource() == this.loadB) {
            this.attemptLoad();
        }
        if (e.getSource() == this.detailsMI) {
            int sel;
            if (this.popup.getInvoker() == this.dl) {
                sel = this.getSelectedDiacritic();
                Diacritic diac = this.diacritics.getDiacritic(sel);
                DiacriticFrame df = new DiacriticFrame(this.owner, diac, this.res);
                df.setVisible(true);
            }
            if (this.popup.getInvoker() == this.invT && (sel = this.getSelected()) > -1) {
                ComplexSymbol symb = this.inventoryTable.getSymbol(sel);
                SymbolFrame fr = new SymbolFrame(this.owner, symb, this.res);
                fr.setVisible(true);
            }
        }
    }

    void attemptSave() {
        int returnVal = this.fc.showSaveDialog(this);
        if (returnVal == 0) {
            File file = this.fc.getSelectedFile();
            String inventoryDump = this.inventoryTable.dumpForFile();
            FileWriting.writeToFile(file, inventoryDump);
        }
    }

    void attemptLoad() {
        int returnVal = this.fc.showOpenDialog(this);
        if (returnVal == 0) {
            File file = this.fc.getSelectedFile();
            StringTable st = new StringTable();
            st.fromFile(file, "\t");
            this.inventory = new Inventory(this.diacritics);
            this.inventoryTable = new InventoryTableModel(this.inventory, this.skeleton, this.diacritics);
            this.inventoryTable.includeFromTable(st, this.symbols, this.diacritics);
            this.invT.setModel(this.inventoryTable);
            this.tweakTable();
        }
    }

    public void mouseClicked(MouseEvent e) {
        int selectedItem;
        if (e.getSource() == this.invT && e.getButton() == 1 && (selectedItem = this.getSelected()) > -1) {
            this.inventoryTable.toggleIncluded(selectedItem);
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public Inventory getInventory() {
        return this.inventoryTable.getIncludedInventory();
    }

    public InventoryTableModel getInventoryList() {
        return this.inventoryTable;
    }

    class TransferDiacritic
    implements Transferable {
        Diacritic diacritic;
        DataFlavor[] flavors;

        TransferDiacritic(Diacritic d) {
            this.diacritic = d;
            DataFlavor[] fs = new DataFlavor[]{new DataFlavor(Diacritic.class, "Diacritic")};
            this.flavors = fs;
        }

        public Object getTransferData(DataFlavor flavor) {
            return this.diacritic;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            for (int i = 0; i < this.flavors.length; ++i) {
                if (!this.flavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }
    }

    class ComplexSymbolTransfer
    extends TransferHandler {
        private InventoryTableModel.IPATableRenderer renderer;
        private DataFlavor dataFlavor = new DataFlavor(Diacritic.class, "Diacritic");
        private JDialog frame;

        public ComplexSymbolTransfer(InventoryTableModel.IPATableRenderer r, JDialog parentFrame) {
            this.frame = parentFrame;
            this.renderer = r;
        }

        public boolean canImport(TransferHandler.TransferSupport info) {
            if (!info.isDataFlavorSupported(this.dataFlavor)) {
                return false;
            }
            try {
                Diacritic d = (Diacritic)info.getTransferable().getTransferData(this.dataFlavor);
                this.renderer.setTransferringDiacritic(d);
            }
            catch (Exception e) {
                System.err.println("Cannot get diacritic from transfer.");
            }
            return true;
        }

        protected Transferable createTransferable(JComponent c) {
            return new StringSelection("");
        }

        public int getSourceActions(JComponent c) {
            return 0;
        }

        public boolean importData(TransferHandler.TransferSupport info) {
            Diacritic diacritic;
            if (!info.isDrop()) {
                return false;
            }
            JTable list = (JTable)info.getComponent();
            JTable.DropLocation dl = (JTable.DropLocation)info.getDropLocation();
            int row = dl.getRow();
            int col = dl.getColumn();
            Transferable t = info.getTransferable();
            try {
                diacritic = (Diacritic)t.getTransferData(this.dataFlavor);
            }
            catch (Exception e) {
                return false;
            }
            int index = InventoryEditor.this.inventoryTable.chartToSymbols[row][col];
            ComplexSymbol c = InventoryEditor.this.inventoryTable.getSymbol(index);
            if (!diacritic.canApplyTo(c.featureValues)) {
                JOptionPane.showMessageDialog(this.frame, "You cannot apply the diacritic '" + diacritic.getDescription() + "' (" + diacritic.getPrintableLabel() + ") to the base " + c.getBase().getLabel() + "!\n\n" + "The reason is that the diacritic requires the base to have the following features:\n" + diacritic.getFrom().toString() + "\n" + "The base you tried to put this onto has the following mismatching feature values:\n" + diacritic.getDifferences(c.featureValues).toString(), "Cannot apply this diacritic", 0);
                return false;
            }
            ComplexSymbol newSymbol = c.copyAndDiacriticize(diacritic);
            if (!InventoryEditor.this.inventoryTable.ensureIncluded(newSymbol)) {
                JOptionPane.showMessageDialog(this.frame, "The sound you just created by dropping the diacritic onto\nthe base symbol was already present in the inventory.", "Sound is already present", 1);
            }
            return true;
        }

        protected void exportDone(JComponent c, Transferable data, int action) {
        }

        protected int getSelected(JComponent c) {
            JList list = (JList)c;
            int[] indices = list.getSelectedIndices();
            int selected = -1;
            if (indices.length > 0) {
                selected = indices[0];
            }
            return selected;
        }

        protected void importString(JComponent c, String str) {
        }
    }

    class DiacriticTransferHandler
    extends TransferHandler {
        private Diacritics diacritics;

        public DiacriticTransferHandler(Diacritics d) {
            this.diacritics = d;
        }

        public boolean canImport(TransferHandler.TransferSupport info) {
            return false;
        }

        protected Transferable createTransferable(JComponent c) {
            int sel = this.getSelected(c);
            return new TransferDiacritic(this.diacritics.getDiacritic(sel));
        }

        public int getSourceActions(JComponent c) {
            return 2;
        }

        public boolean importData(TransferHandler.TransferSupport info) {
            return false;
        }

        protected void exportDone(JComponent c, Transferable data, int action) {
        }

        protected int getSelected(JComponent c) {
            JList list = (JList)c;
            int[] indices = list.getSelectedIndices();
            int selected = -1;
            if (indices.length > 0) {
                selected = indices[0];
            }
            return selected;
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private boolean someSymbolSelected() {
            return InventoryEditor.this.getSelected() > -1;
        }

        private boolean someDiacriticSelected() {
            return InventoryEditor.this.getSelectedDiacritic() > -1;
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                if (e.getSource() == InventoryEditor.this.invT && this.someSymbolSelected()) {
                    InventoryEditor.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
                if (e.getSource() == InventoryEditor.this.dl && this.someDiacriticSelected()) {
                    InventoryEditor.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }
    }
}

