/*
 * Decompiled with CFR 0.152.
 */
package gui;

import communication.ResourceProvider;
import featurefunctions.BareFeatureList;
import featurefunctions.BareQueryResult;
import featurefunctions.IPASkeleton;
import featurefunctions.Misc;
import featurefunctions.SubSkeleton;
import gui.ColorCentral;
import gui.MainScreen;
import inputoutput.StringTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

class IPAChart
extends AbstractTableModel {
    IPASkeleton skeleton;
    BareFeatureList features;
    boolean[][] selected;
    int rowCount;
    int colCount;
    int[][] skeletonOfSymbols;
    BareQueryResult selections;
    BareFeatureList transformed;

    public IPAChart(IPASkeleton skel, BareFeatureList fs) {
        this.skeleton = skel;
        this.features = fs;
        this.selections = BareQueryResult.fullFrom(fs);
        this.compile();
        this.emptySelected();
    }

    public void emptySelected() {
        this.selected = new boolean[this.rowCount][];
        for (int i = 0; i < this.rowCount; ++i) {
            this.selected[i] = new boolean[this.colCount];
            for (int j = 0; j < this.colCount; ++j) {
                this.selected[i][j] = false;
            }
        }
    }

    boolean selectable(int i, int j) {
        int symb = this.skeletonOfSymbols[i][j];
        if (symb > -1) {
            return this.selections.mapsTo[symb] > -1;
        }
        return false;
    }

    public void addSelection(int i, int j) {
        if (this.selectable(i, j)) {
            this.selected[i][j] = true;
            this.fireTableCellUpdated(i, j);
        }
    }

    public void toggleSelected(int i, int j) {
        if (this.selectable(i, j)) {
            this.selected[i][j] = !this.selected[i][j];
            this.fireTableCellUpdated(i, j);
        }
    }

    public void selectOnly(int i, int j) {
        if (!this.selectable(i, j)) {
            i = -1;
            j = -1;
        }
        for (int x = 0; x < this.rowCount; ++x) {
            for (int y = 0; y < this.colCount; ++y) {
                boolean newSel = x == i && y == j;
                boolean updated = this.selected[x][y] != newSel;
                this.selected[x][y] = newSel;
                if (!updated) continue;
                this.fireTableCellUpdated(x, y);
            }
        }
    }

    public int[] getSelectedIndices() {
        int n = 0;
        for (int i = 0; i < this.rowCount; ++i) {
            for (int j = 0; j < this.colCount; ++j) {
                if (!this.selected[i][j] || this.skeletonOfSymbols[i][j] <= -1) continue;
                ++n;
            }
        }
        int[] sels = new int[n];
        int index = 0;
        for (int i = 0; i < this.rowCount; ++i) {
            for (int j = 0; j < this.colCount; ++j) {
                if (!this.selected[i][j] || this.skeletonOfSymbols[i][j] <= -1) continue;
                sels[index] = this.selections.mapsTo[this.skeletonOfSymbols[i][j]];
                ++index;
            }
        }
        return sels;
    }

    public String selectedToString() {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < this.rowCount; ++i) {
            for (int j = 0; j < this.colCount; ++j) {
                if (!this.selected[i][j]) continue;
                out.append(" (" + Integer.toString(i) + "," + Integer.toString(j) + ")");
            }
        }
        return out.toString();
    }

    private void compile() {
        SubSkeleton.ChartedFeatures[] symbolCatchers = new SubSkeleton.ChartedFeatures[this.skeleton.subSkeletons.length];
        for (int i = 0; i < this.skeleton.subSkeletons.length; ++i) {
            symbolCatchers[i] = this.skeleton.subSkeletons[i].mapFeaturesToSkeleton(this.features);
        }
        this.checkCoverage(symbolCatchers);
        this.skeletonOfSymbols = this.mergeCharts(symbolCatchers);
    }

    public int[][] mergeCharts(SubSkeleton.ChartedFeatures[] charts) {
        int i;
        this.rowCount = 0;
        for (i = 0; i < charts.length; ++i) {
            this.rowCount += charts[i].rowCount;
        }
        this.colCount = 0;
        for (i = 0; i < charts.length; ++i) {
            if (charts[i].colCount <= this.colCount) continue;
            this.colCount = charts[i].colCount;
        }
        int[][] chart = new int[this.rowCount][];
        int currentChart = 0;
        int rowInCurrentChart = 0;
        for (int row = 0; row < this.rowCount; ++row) {
            chart[row] = new int[this.colCount];
            while (rowInCurrentChart >= charts[currentChart].rowCount) {
                ++currentChart;
                rowInCurrentChart = 0;
            }
            for (int col = 0; col < this.colCount; ++col) {
                chart[row][col] = col >= charts[currentChart].colCount ? -1 : charts[currentChart].chart[rowInCurrentChart][col];
            }
            ++rowInCurrentChart;
        }
        return chart;
    }

    public void checkCoverage(SubSkeleton.ChartedFeatures[] charts) {
        int i;
        boolean[] covered = new boolean[this.features.symbols.length];
        for (i = 0; i < this.features.symbols.length; ++i) {
            covered[i] = false;
        }
        for (i = 0; i < charts.length; ++i) {
            covered = Misc.orList(covered, charts[i].coverage);
        }
        for (i = 0; i < covered.length; ++i) {
            if (covered[i]) continue;
            System.err.println("Error: I have not been able to put BareSymbol [" + this.features.symbols[i].getLabel() + "] in any of the IPA-subcharts.");
        }
    }

    public int getColumnCount() {
        return this.colCount;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public String getColumnName(int col) {
        return "";
    }

    public Class getColumnClass(int col) {
        return String.class;
    }

    public void fireLabelUpdated(int index) {
        this.fireTableDataChanged();
    }

    public void setSelections(BareQueryResult q, BareFeatureList transf) {
        this.selections = q;
        this.transformed = transf;
    }

    public BareFeatureList.BareSymbol getValueAt(int row, int col) {
        int sel = this.skeletonOfSymbols[row][col];
        if (sel > -1) {
            int target = this.selections.mapsTo[sel];
            if (target > -1) {
                return this.transformed.symbols[target];
            }
            return this.features.symbols[sel];
        }
        return null;
    }

    public String skeletonToString(BareFeatureList features) {
        StringTable tab = new StringTable();
        tab.data = new String[this.rowCount][];
        for (int i = 0; i < this.rowCount; ++i) {
            tab.data[i] = new String[this.colCount];
            for (int j = 0; j < this.colCount; ++j) {
                StringBuffer buf = new StringBuffer("{");
                if (this.skeletonOfSymbols[i][j] > -1) {
                    buf.append(features.symbols[this.skeletonOfSymbols[i][j]].getLabel());
                }
                buf.append("}");
                tab.data[i][j] = buf.toString();
            }
        }
        return tab.toString();
    }

    public class ChartCellRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        BareFeatureList.CompiledContradictions contradictions;
        IPAChart chart;
        int FULL_LABEL_FONT_SIZE = 32;
        int SMALL_LABEL_FONT_SIZE = 22;
        Font fullLabel;
        Font smallLabel;
        Component renderNothing = new NothingComponent();

        public ChartCellRenderer(BareFeatureList.CompiledContradictions c, IPAChart ipac, ResourceProvider r, double magnification) {
            this.contradictions = c;
            this.chart = ipac;
            this.setHorizontalAlignment(0);
            this.fullLabel = r.getIPAFont(MainScreen.magnify(this.FULL_LABEL_FONT_SIZE, magnification));
            this.smallLabel = r.getIPAFont(MainScreen.magnify(this.SMALL_LABEL_FONT_SIZE, magnification));
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel l;
            BareFeatureList.BareSymbol symbol = (BareFeatureList.BareSymbol)value;
            if (value == null) {
                return this.renderNothing;
            }
            JPanel cell = new JPanel();
            cell.setOpaque(true);
            Color textColor = Color.black;
            int thisSymbol = this.chart.skeletonOfSymbols[row][column];
            if (IPAChart.this.selected[row][column]) {
                cell.setBackground(ColorCentral.isSelected);
            } else if (thisSymbol > -1) {
                if (IPAChart.this.selections.included[thisSymbol]) {
                    cell.setBackground(ColorCentral.selectedByQueryBG);
                } else {
                    cell.setBackground(ColorCentral.notSelectedByQueryBG);
                    textColor = ColorCentral.notSelectedByQueryFG;
                }
            } else {
                cell.setBackground(Color.white);
            }
            if (symbol.isTransformed()) {
                l = new JLabel(symbol.getAntecedent());
                cell.add(l);
                l.setFont(this.smallLabel);
                l.setForeground(textColor);
                l = new JLabel("\u2192");
                cell.add(l);
                l.setFont(this.smallLabel);
                l.setForeground(textColor);
            }
            l = new JLabel(symbol.getLabel());
            l.setFont(this.fullLabel);
            l.setForeground(textColor);
            if (this.contradictions.findContradictions(symbol).length > 0) {
                l.setBackground(ColorCentral.contradiction);
                l.setText(" " + symbol.getLabel() + " ");
                l.setOpaque(true);
            } else if (symbol.isUnknown()) {
                l.setBackground(ColorCentral.unknown);
                l.setOpaque(true);
                l.setText(" " + symbol.getLabel() + " ");
            } else {
                l.setOpaque(false);
            }
            cell.add(l);
            cell.setFont(this.fullLabel);
            return cell;
        }

        class NothingComponent
        extends JComponent {
            NothingComponent() {
            }

            public void paint(Graphics g) {
            }
        }
    }
}

