/*
 * Decompiled with CFR 0.152.
 */
package gui;

import communication.ResourceProvider;
import featurefunctions.BareFeatureList;
import gui.ColorCentral;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class FeatureTableRenderer
extends DefaultTableCellRenderer {
    Font font;
    BareFeatureList featureList;
    BareFeatureList.CompiledContradictions contradictions;

    public FeatureTableRenderer(boolean centered, int size, BareFeatureList fl, BareFeatureList.CompiledContradictions c, ResourceProvider r) {
        this.featureList = fl;
        this.contradictions = c;
        if (centered) {
            this.setHorizontalAlignment(0);
        }
        this.font = r.getIPAFont(size);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        cell.setFont(this.font);
        if (this.featureList.isReferential()) {
            cell.setForeground(ColorCentral.black);
        }
        if (!isSelected) {
            if (this.featureList.isReferent(row)) {
                cell.setBackground(ColorCentral.referentMarker);
            } else {
                cell.setBackground(ColorCentral.defaultBackground);
            }
        }
        if (this.featureList.isReferential()) {
            if (column <= 2 || this.featureList.valueSameAsReferent(row, column - 3)) {
                cell.setBackground(this.featureList.getColorFor(row));
            } else {
                cell.setBackground(ColorCentral.differsFromReferent);
            }
        }
        if (this.featureList.isTransformed() && column == 2 && this.featureList.isUnknown(row)) {
            cell.setBackground(ColorCentral.unknown);
        }
        if (!this.featureList.restricted && column == 2 && this.contradictions.findContradictions(this.featureList.getBareSymbol(row)).length > 0) {
            cell.setBackground(ColorCentral.contradiction);
        }
        return cell;
    }
}

