/*
 * Decompiled with CFR 0.152.
 */
package gui;

import communication.ResourceProvider;
import featurefunctions.Diacritic;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DiacriticFrame
extends JDialog
implements ActionListener {
    Diacritic diacritic;
    ResourceProvider res;
    JButton quitB = new JButton("Close window");
    int BIG_IPA_SIZE = 64;
    int DESCRIPTION_SIZE = 42;
    int HEADER_SIZE = 21;
    int LIST_FONT_SIZE = 18;
    int FEATURE_MATRIX_SIZE = 26;

    public DiacriticFrame(Frame f, Diacritic d, ResourceProvider r) {
        super(f, "Diacritic information", true);
        this.res = r;
        this.diacritic = d;
        this.buildComponents(this.getContentPane());
        this.pack();
        this.setSize(850, 400);
        this.setLocationRelativeTo(null);
    }

    public void buildComponents(Container container) {
        Font descrF = this.res.getIPAFont(this.DESCRIPTION_SIZE);
        Font headerF = this.res.getIPAFont(this.HEADER_SIZE);
        Font plebsF = this.res.getIPAFont(this.LIST_FONT_SIZE);
        Font featureF = this.res.getIPAFont(this.FEATURE_MATRIX_SIZE);
        JPanel mainP = new JPanel(new BorderLayout());
        JLabel workL = new JLabel(this.diacritic.getPrintableLabel());
        workL.setFont(this.res.getIPAFont(this.BIG_IPA_SIZE));
        Dimension d = workL.getPreferredSize();
        workL.setPreferredSize(new Dimension(d.width + 100, d.height + 100));
        workL.setBorder(BorderFactory.createEmptyBorder(30, 30, 30, 30));
        mainP.add((Component)workL, "West");
        JPanel explanationP = new JPanel();
        explanationP.setLayout(new BoxLayout(explanationP, 3));
        JLabel lab = new JLabel(this.diacritic.getDescription());
        lab.setFont(descrF);
        explanationP.add(lab);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 2));
        lab = new JLabel("Requirements: ");
        lab.setFont(headerF);
        p.add(lab);
        lab = new JLabel("this diacritic can apply to symbols that have the following features:");
        lab.setFont(plebsF);
        p.add(lab);
        p.setAlignmentX(0.0f);
        explanationP.add(p);
        lab = new JLabel(this.diacritic.getFrom().toStringBareFancy());
        lab.setFont(featureF);
        explanationP.add(lab);
        explanationP.add(Box.createRigidArea(new Dimension(50, 50)));
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 2));
        lab = new JLabel("Changes: ");
        lab.setFont(headerF);
        p.add(lab);
        lab = new JLabel("this diacritic changes the following features:");
        lab.setFont(plebsF);
        p.add(lab);
        p.setAlignmentX(0.0f);
        explanationP.add(p);
        lab = new JLabel(this.diacritic.getTo().toStringBareFancy());
        lab.setFont(featureF);
        explanationP.add(lab);
        mainP.add((Component)explanationP, "Center");
        JPanel buttonP = new JPanel();
        buttonP.add(this.quitB);
        this.quitB.addActionListener(this);
        container.setLayout(new BorderLayout());
        container.add((Component)mainP, "Center");
        container.add((Component)buttonP, "South");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.quitB) {
            this.setVisible(false);
        }
    }
}

