/*
 * Decompiled with CFR 0.152.
 */
package featurefunctions;

import communication.Reporter;
import featurefunctions.BareFeatureList;
import featurefunctions.MatchReport;
import featurefunctions.Misc;

public class Symbol {
    public String[] features;
    public char[] values;
    public String symbol;
    public String antecedent;
    public static final String unknown = "?";
    public static final String notFoundLabel = "?";
    public static final char plus = '+';
    public static final char min = '-';
    public static final char nul = '0';
    public static final char alpha = 'a';
    public static final char nonalpha = 'A';
    public static final char beta = 'b';
    public static final char nonbeta = 'B';
    public static final char[] Variables = new char[]{'a', 'b'};
    public static final char[] nonVariables = new char[]{'A', 'B'};
    public static final char[] displayVariables = new char[]{'\u03b1', '\u03b2'};
    public static final char displayMin = '\u2212';
    public static final char displayNon = '-';
    public static final char displayNul = ' ';

    public Symbol() {
        this.features = new String[0];
        this.values = new char[0];
        this.symbol = "";
        this.antecedent = "";
    }

    public Symbol(BareFeatureList.PartialSymbol symb, BareFeatureList base) {
        this.features = new String[symb.value.length];
        this.values = new char[symb.value.length];
        for (int i = 0; i < symb.value.length; ++i) {
            this.features[i] = base.features[symb.feature[i]];
            this.values[i] = symb.value[i];
        }
        this.symbol = "";
        this.antecedent = "";
    }

    void fromInput(String[] inputLine, String[] fs) {
        this.features = fs;
        this.symbol = inputLine[0].trim();
        this.antecedent = "";
        this.values = new char[this.features.length];
        for (int i = 0; i < this.features.length; ++i) {
            this.values[i] = inputLine[i + 2].trim().charAt(0);
        }
    }

    public boolean checkAgainst(String[] chart_features, Reporter rep) {
        for (int i = 0; i < this.features.length; ++i) {
            if (Misc.indexOf(this.features[i], chart_features) != -1) continue;
            int unique = -1;
            for (int j = 0; j < chart_features.length; ++j) {
                if (!chart_features[j].trim().toLowerCase().startsWith(this.features[i].trim().toLowerCase())) continue;
                unique = unique == -1 ? j : -2;
            }
            if (unique > -1) {
                this.features[i] = chart_features[unique];
            }
            if (unique == -1) {
                rep.report("I don't know the feature '" + this.features[i] + "'");
                return false;
            }
            if (unique != -2) continue;
            StringBuffer options = new StringBuffer();
            boolean fst = true;
            for (int j = 0; j < chart_features.length; ++j) {
                if (!chart_features[j].trim().toLowerCase().startsWith(this.features[i].trim().toLowerCase())) continue;
                if (fst) {
                    fst = false;
                } else {
                    options.append(", ");
                }
                options.append(chart_features[j]);
            }
            rep.report("There are multiple feature names starting with '" + this.features[i] + "':\n" + options);
            return false;
        }
        return true;
    }

    public boolean agreesOn(Symbol alt) {
        Symbol diffs = this.getDifferences(alt);
        return diffs.isVoid();
    }

    public boolean isVoid() {
        return this.values.length == 0;
    }

    public Symbol getDifferences(Symbol alt) {
        Symbol diffs = new Symbol();
        for (int i = 0; i < alt.features.length; ++i) {
            String f = alt.features[i];
            char v = alt.values[i];
            int j = Misc.indexOf(f, this.features);
            if (j >= 0 && this.values[j] == v) continue;
            char change = j < 0 ? (char)'?' : this.values[j];
            diffs.addFeatureValue(f, change);
        }
        return diffs;
    }

    public void mergeWith(Symbol alt) {
        int i;
        String[] newFeatures = new String[this.features.length + alt.features.length];
        char[] newValues = new char[this.features.length + alt.features.length];
        for (i = 0; i < this.features.length; ++i) {
            newFeatures[i] = this.features[i];
            newValues[i] = this.values[i];
        }
        for (i = 0; i < alt.features.length; ++i) {
            newFeatures[this.features.length + i] = alt.features[i];
            newValues[this.features.length + i] = alt.values[i];
        }
        this.features = newFeatures;
        this.values = newValues;
    }

    public MatchReport matchByFeatures(Symbol alternative) {
        MatchReport match = new MatchReport();
        for (int i = 0; i < alternative.features.length; ++i) {
            String feature = alternative.features[i];
            char val = alternative.values[i];
            if (!this.hasFeature(feature)) {
                match.declareDoesntHaveFeature();
            }
            if (Symbol.isVariable(val)) {
                if (!this.hasFeature(feature) || this.featureMatchValue(feature, '0')) {
                    match.declareMisMatch();
                    continue;
                }
                int varval = Symbol.getVariableIndex(val);
                if (varval > -1) {
                    if (match.variableSettings[varval] == '0') {
                        match.variableSettings[varval] = this.getValueForFeature(feature);
                    } else if (!this.featureMatchValue(feature, match.variableSettings[varval])) {
                        match.declareMisMatch();
                    }
                }
                if ((varval = Symbol.getNonVariableIndex(val)) <= -1) continue;
                if (match.variableSettings[varval] == '0') {
                    match.variableSettings[varval] = Symbol.opposite(this.getValueForFeature(feature));
                    continue;
                }
                if (this.featureMatchValue(feature, Symbol.opposite(match.variableSettings[varval]))) continue;
                match.declareMisMatch();
                continue;
            }
            if (this.featureMatchValue(feature, val)) continue;
            match.declareMisMatch();
        }
        return match;
    }

    public boolean isUnknown() {
        return this.symbol.equals("?");
    }

    public boolean featureMatchValue(String feat, char val) {
        boolean mismatch = false;
        for (int i = 0; i < this.features.length; ++i) {
            if (!this.features[i].equals(feat) || this.values[i] == val) continue;
            mismatch = true;
        }
        return !mismatch;
    }

    public boolean nonVoid() {
        if (this.features.length == 0) {
            return false;
        }
        for (int i = 0; i < this.features.length; ++i) {
            if (this.values[i] == '0' || this.features[i].equals("")) continue;
            return true;
        }
        return false;
    }

    public int getDistanceTo(Symbol referent) {
        int distance = 0;
        for (int i = 0; i < referent.features.length; ++i) {
            if (referent.values[i] == this.values[i]) continue;
            ++distance;
        }
        return distance;
    }

    public Symbol getCopy() {
        Symbol symb = this.headerCopy();
        symb.copyFeatureValuesFrom(this);
        return symb;
    }

    public Symbol headerCopy() {
        Symbol symb = new Symbol();
        symb.symbol = this.symbol;
        symb.antecedent = this.antecedent;
        return symb;
    }

    public void copyFeatureValuesFrom(Symbol symb) {
        int len = symb.features.length;
        this.features = new String[len];
        this.values = new char[len];
        for (int i = 0; i < len; ++i) {
            this.features[i] = new String(symb.features[i]);
            this.values[i] = symb.values[i];
        }
    }

    public String getLabel() {
        return this.symbol;
    }

    public void setLabel(String l) {
        this.symbol = l;
    }

    public String getAntecedent() {
        return this.antecedent;
    }

    public void setAntecedent(String antec) {
        this.antecedent = antec;
    }

    public String getFeature(int i) {
        return this.features[i];
    }

    public char getFeatureValue(int f) {
        return this.values[f];
    }

    public int getLength() {
        return this.values.length;
    }

    public char getDisplayableFeatureValue(int f) {
        char val = this.getFeatureValue(f);
        if (val == '0') {
            return ' ';
        }
        if (val == '-') {
            return '\u2212';
        }
        return val;
    }

    public char getDisplayableFeatureValueWithNull(int f) {
        char val = this.getFeatureValue(f);
        if (val == '-') {
            return '\u2212';
        }
        return val;
    }

    int getFeatureIndex(String featureName) {
        for (int i = 0; i < this.features.length; ++i) {
            if (!this.features[i].equals(featureName)) continue;
            return i;
        }
        return -1;
    }

    boolean hasFeature(String featureName) {
        return this.getFeatureIndex(featureName) > -1;
    }

    char getValueForFeature(String featureName) {
        char val = ' ';
        int i = this.getFeatureIndex(featureName);
        if (i > -1) {
            return this.values[i];
        }
        return val;
    }

    public String toString() {
        return this.symbol + "=" + this.toStringBare();
    }

    public String toStringOnlyFeatures() {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < this.features.length; ++i) {
            if (i > 0) {
                out.append(", ");
            }
            out.append(this.values[i] + this.features[i]);
        }
        return out.toString();
    }

    public String toStringBare() {
        return "[" + this.toStringOnlyFeatures() + "]";
    }

    public String toStringBareFancy() {
        StringBuffer out = new StringBuffer();
        out.append("[");
        for (int i = 0; i < this.features.length; ++i) {
            if (i > 0) {
                out.append(", ");
            }
            if (this.values[i] == '-') {
                out.append('\u2212');
            } else if (Symbol.isVariable(this.values[i])) {
                out.append(Symbol.getDisplayVariable(this.values[i]));
            } else {
                out.append(this.values[i]);
            }
            out.append(this.features[i]);
        }
        out.append("]");
        return out.toString();
    }

    void addFeatureValue(String feature, char value) {
        int index = this.getFeatureIndex(feature);
        if (index > -1) {
            this.values[index] = value;
        } else {
            String[] newFeatures = new String[this.features.length + 1];
            char[] newValues = new char[this.features.length + 1];
            for (int i = 0; i < this.features.length; ++i) {
                newFeatures[i] = this.features[i];
                newValues[i] = this.values[i];
            }
            newFeatures[this.features.length] = feature;
            newValues[this.features.length] = value;
            this.features = newFeatures;
            this.values = newValues;
        }
    }

    Symbol restrictFeatures(int[] newFeatures) {
        Symbol symb = this.headerCopy();
        symb.features = new String[newFeatures.length];
        symb.values = new char[newFeatures.length];
        for (int i = 0; i < newFeatures.length; ++i) {
            symb.features[i] = this.features[newFeatures[i]];
            symb.values[i] = this.values[newFeatures[i]];
        }
        return symb;
    }

    public Symbol eliminateFeature(int index) {
        Symbol symb = this.getCopy();
        symb.removeFeature(index);
        return symb;
    }

    public void removeFeature(int index) {
        String[] newFeatures = new String[this.features.length - 1];
        char[] newValues = new char[this.features.length - 1];
        int t = 0;
        for (int i = 0; i < this.features.length - 1; ++i) {
            t = i < index ? i : i + 1;
            newFeatures[i] = this.features[t];
            newValues[i] = this.values[t];
        }
        this.features = newFeatures;
        this.values = newValues;
    }

    public Symbol applyTransformation(Symbol transfSymbol, MatchReport match) {
        Symbol symb = new Symbol();
        symb.symbol = this.symbol;
        symb.features = new String[this.features.length];
        symb.values = new char[this.values.length];
        for (int i = 0; i < this.features.length; ++i) {
            symb.features[i] = this.features[i];
            int value = this.values[i];
            if (transfSymbol.hasFeature(this.features[i])) {
                int target = transfSymbol.getValueForFeature(this.features[i]);
                if (Symbol.isVariable((char)target)) {
                    int toset = 48;
                    int varval = Symbol.getVariableIndex((char)target);
                    if (varval > -1) {
                        toset = match.variableSettings[varval];
                    }
                    if ((varval = Symbol.getNonVariableIndex((char)target)) > -1) {
                        toset = Symbol.opposite(match.variableSettings[varval]);
                    }
                    value = toset;
                } else {
                    value = target;
                }
            }
            symb.values[i] = value;
        }
        return symb;
    }

    public Symbol whatDoINotHave(Symbol other) {
        Symbol symb = this.headerCopy();
        for (int i = 0; i < other.features.length; ++i) {
            String feat = other.features[i];
            char val = other.values[i];
            if (this.getValueForFeature(feat) == val) continue;
            symb.addFeatureValue(feat, val);
        }
        return symb;
    }

    public static Symbol parseFrom(String query) {
        String[] fs = query.split(",");
        String[] vals = new String[fs.length + 2];
        String[] feats = new String[fs.length];
        for (int i = 0; i < fs.length; ++i) {
            String featureval = fs[i].trim();
            vals[i + 2] = featureval.substring(0, 1);
            feats[i] = featureval.substring(1, featureval.length());
        }
        vals[0] = "";
        vals[1] = "";
        Symbol querySymbol = new Symbol();
        querySymbol.fromInput(vals, feats);
        return querySymbol;
    }

    static final int getIndexIn(char[] arr, char value) {
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != value) continue;
            return i;
        }
        return -1;
    }

    static final int getVariableIndex(char value) {
        return Symbol.getIndexIn(Variables, value);
    }

    static final int getNonVariableIndex(char value) {
        return Symbol.getIndexIn(nonVariables, value);
    }

    public static final boolean isVariable(char value) {
        return Symbol.getVariableIndex(value) > -1 || Symbol.getNonVariableIndex(value) > -1;
    }

    public static final String getDisplayVariable(char value) {
        int var = Symbol.getVariableIndex(value);
        if (var > -1) {
            return Character.toString(displayVariables[var]);
        }
        var = Symbol.getNonVariableIndex(value);
        if (var > -1) {
            return Character.toString('-') + Character.toString(displayVariables[var]);
        }
        return "";
    }

    public static final boolean isDisplayVariable(String val) {
        return val.length() > 0 && Symbol.getDisplayVariableIndex(val.charAt(0)) > -1 || val.length() > 1 && val.charAt(0) == '-' && Symbol.getDisplayVariableIndex(val.charAt(1)) > -1;
    }

    public static final int getDisplayVariableIndex(char val) {
        return Symbol.getIndexIn(displayVariables, val);
    }

    public static final char getVariableFromDisplay(String value) {
        int var = Symbol.getDisplayVariableIndex(value.charAt(0));
        if (var > -1) {
            return Variables[var];
        }
        var = Symbol.getDisplayVariableIndex(value.charAt(1));
        if (value.charAt(0) == '-' && var > -1) {
            return nonVariables[var];
        }
        return '0';
    }

    static final char opposite(char value) {
        if (value == '+') {
            return '-';
        }
        if (value == '-') {
            return '+';
        }
        return value;
    }

    public boolean hasOvertContradictions() {
        for (int i = 0; i < this.features.length; ++i) {
            for (int j = i; j < this.features.length; ++j) {
                if (!this.features[i].equals(this.features[j]) || this.values[i] == this.values[j]) continue;
                return true;
            }
        }
        return false;
    }

    public String[] overtContradictionReport() {
        String[] contr = new String[]{};
        for (int i = 0; i < this.features.length; ++i) {
            for (int j = i; j < this.features.length; ++j) {
                if (!this.features[i].equals(this.features[j]) || this.values[i] == this.values[j]) continue;
                contr = Misc.suffixStringList(contr, "[" + this.fancyValue(this.values[i]) + this.features[i] + ", " + this.fancyValue(this.values[j]) + this.features[j] + "]");
            }
        }
        return contr;
    }

    public char fancyValue(char value) {
        if (value == '-') {
            return '\u2212';
        }
        return value;
    }
}

