/*
 * Decompiled with CFR 0.152.
 */
package featurefunctions;

import communication.ResourceProvider;
import featurefunctions.BareFeatureList;
import featurefunctions.BaseSymbol;
import featurefunctions.BaseSymbolList;
import featurefunctions.ComplexSymbol;
import featurefunctions.Coordinate;
import featurefunctions.Diacritic;
import featurefunctions.DiacriticSignature;
import featurefunctions.Diacritics;
import featurefunctions.Misc;
import inputoutput.StringTable;
import java.io.InputStream;

public class SubSkeleton {
    ResourceProvider res;
    Diacritics diacritics;
    public int rowCount;
    public int colCount;
    public StringTable labels;
    public boolean[][] isLabel;
    public boolean[][] isSymbol;
    public ComplexSymbol[][] symbols;
    String[] filenames;
    static String DIACRITIC_SEPARATOR = ";";

    public SubSkeleton(String f, Diacritics d, ResourceProvider r) {
        String[] fn = new String[]{f};
        this.filenames = fn;
        this.diacritics = d;
        this.res = r;
    }

    public SubSkeleton(String[] fs, Diacritics d, ResourceProvider r) {
        this.filenames = fs;
        this.diacritics = d;
        this.res = r;
    }

    public boolean[] readAndParse(BaseSymbolList baseSymbols) {
        StringTable overallBuf = new StringTable();
        for (int i = 0; i < this.filenames.length; ++i) {
            String filename = this.filenames[i];
            StringTable buff = new StringTable();
            try {
                InputStream is = this.res.getResource(filename);
                buff.fromFile(is, "\t");
            }
            catch (Exception e) {
                System.err.println(filename + " read Error: " + e.getMessage());
            }
            overallBuf.append(buff);
        }
        return this.parse(overallBuf, baseSymbols);
    }

    public boolean[] parse(StringTable buff, BaseSymbolList baseSymbols) {
        int i;
        boolean[] covered = new boolean[baseSymbols.symbols.length];
        for (i = 0; i < baseSymbols.symbols.length; ++i) {
            covered[i] = false;
        }
        this.rowCount = buff.data.length;
        this.colCount = 0;
        for (i = 0; i < this.rowCount; ++i) {
            if (buff.data[i].length <= this.colCount) continue;
            this.colCount = buff.data[i].length;
        }
        String[][] lab = new String[this.rowCount][];
        this.symbols = new ComplexSymbol[this.rowCount][];
        this.isLabel = new boolean[this.rowCount][];
        this.isSymbol = new boolean[this.rowCount][];
        for (int i2 = 0; i2 < this.rowCount; ++i2) {
            this.isLabel[i2] = new boolean[this.colCount];
            this.isSymbol[i2] = new boolean[this.colCount];
            this.symbols[i2] = new ComplexSymbol[this.colCount];
            lab[i2] = new String[this.colCount];
            String[] inputRow = buff.takeRowFrom(i2, 0, this.colCount);
            for (int j = 0; j < this.colCount; ++j) {
                String cell = inputRow[j].trim();
                if (StringTable.beginsWith(cell, '[') && StringTable.endsWith(cell, ']')) {
                    lab[i2][j] = StringTable.removePrefixSuffix(cell, '[', ']');
                    this.symbols[i2][j] = null;
                    this.isLabel[i2][j] = true;
                    this.isSymbol[i2][j] = false;
                    continue;
                }
                lab[i2][j] = null;
                this.isLabel[i2][j] = false;
                if (cell.length() > 0) {
                    ComplexSymbol symb;
                    String[] parts = cell.split(DIACRITIC_SEPARATOR);
                    int baseIndex = baseSymbols.symbolByLabel(parts[0]);
                    if (baseIndex == -1) {
                        System.err.println("Warning: cannot recognise template symbol '" + cell + "' while laying out the IPA Chart skeleton (IPASkeleton).");
                        this.isSymbol[i2][j] = false;
                        continue;
                    }
                    BaseSymbol b = baseSymbols.symbols[baseIndex];
                    Diacritic[] ds = new Diacritic[parts.length - 1];
                    for (int x = 0; x < parts.length - 1; ++x) {
                        int index = this.diacritics.getIndexByName(parts[x + 1].trim());
                        if (index > -1) {
                            ds[x] = this.diacritics.items[index];
                            continue;
                        }
                        System.err.println("Warning, cannot find what diacritic '" + parts[x + 1] + "' is supposed to be.");
                    }
                    this.symbols[i2][j] = symb = new ComplexSymbol(b, ds, this.diacritics);
                    this.isSymbol[i2][j] = true;
                    covered[baseIndex] = true;
                    continue;
                }
                this.isSymbol[i2][j] = false;
                this.symbols[i2][j] = null;
            }
        }
        this.labels = new StringTable(lab);
        return covered;
    }

    public ChartedFeatures mapFeaturesToSkeleton(BareFeatureList features) {
        int i;
        ComplexSymbol symb;
        int[][][] fullmatches = this.emptyTab();
        int[][][] surplusses = this.emptyTab();
        boolean[] coverage = new boolean[features.symbols.length];
        for (int i2 = 0; i2 < features.symbols.length; ++i2) {
            symb = features.symbols[i2].origin;
            if (symb == null) {
                System.err.println("Warning: (while laying out the IPA table) symbol " + Integer.toString(i2) + " in the feature list has no ComplexSymbol origin.");
                continue;
            }
            Coordinate coord = this.findBestLocation(symb);
            if (coord.isNotFilled()) {
                coverage[i2] = false;
                continue;
            }
            coverage[i2] = true;
            if (this.isFullMatch(symb, coord)) {
                fullmatches[coord.i][coord.j] = Misc.appendIntList(fullmatches[coord.i][coord.j], i2);
                continue;
            }
            surplusses[coord.i][coord.j] = Misc.appendIntList(surplusses[coord.i][coord.j], i2);
        }
        DiacriticSignature[][] rowDiacritics = new DiacriticSignature[this.rowCount][];
        for (int row = 0; row < this.rowCount; ++row) {
            rowDiacritics[row] = new DiacriticSignature[0];
            for (int col = 0; col < this.colCount; ++col) {
                for (i = 0; i < surplusses[row][col].length; ++i) {
                    symb = features.symbols[surplusses[row][col][i]].origin;
                    rowDiacritics[row] = this.ensureInDiacriticsSignature(symb.diacritics, rowDiacritics[row]);
                }
            }
        }
        boolean[] columnFilled = new boolean[this.colCount];
        block4: for (int i3 = 0; i3 < this.colCount; ++i3) {
            columnFilled[i3] = false;
            for (int j = 0; j < this.rowCount; ++j) {
                if (fullmatches[j][i3].length <= 0 && surplusses[j][i3].length <= 0) continue;
                columnFilled[i3] = true;
                continue block4;
            }
        }
        int[] fullMatchSize = new int[this.rowCount];
        block6: for (i = 0; i < this.rowCount; ++i) {
            fullMatchSize[i] = 0;
            for (int j = 0; j < this.colCount; ++j) {
                if (fullmatches[i][j].length <= 0) continue;
                fullMatchSize[i] = 1;
                continue block6;
            }
        }
        int[] surplussSize = new int[this.rowCount];
        for (int i4 = 0; i4 < this.rowCount; ++i4) {
            surplussSize[i4] = rowDiacritics[i4].length;
        }
        int[] rowSize = Misc.addIntLists(fullMatchSize, surplussSize);
        int cols = Misc.countTrues(columnFilled);
        int rows = Misc.sum(rowSize);
        int[][] tab = new int[rows][];
        int row = 0;
        for (int i5 = 0; i5 < this.rowCount; ++i5) {
            if (fullMatchSize[i5] > 0) {
                int[] thisRow = new int[cols];
                int col = 0;
                for (int k = 0; k < this.colCount; ++k) {
                    if (!columnFilled[k]) continue;
                    thisRow[col] = fullmatches[i5][k].length > 0 ? fullmatches[i5][k][0] : -1;
                    ++col;
                }
                tab[row] = thisRow;
                ++row;
            }
            for (int j = 0; j < rowDiacritics[i5].length; ++j) {
                int[] thisRow = new int[cols];
                DiacriticSignature thisDiacSign = rowDiacritics[i5][j];
                int col = 0;
                for (int k = 0; k < this.colCount; ++k) {
                    if (!columnFilled[k]) continue;
                    thisRow[col] = -1;
                    for (int z = 0; z < surplusses[i5][k].length; ++z) {
                        int ref = surplusses[i5][k][z];
                        symb = features.symbols[ref].origin;
                        if (!thisDiacSign.isSameAs(symb.diacritics)) continue;
                        thisRow[col] = ref;
                        break;
                    }
                    ++col;
                }
                tab[row] = thisRow;
                ++row;
            }
        }
        return new ChartedFeatures(tab, coverage, rows, cols);
    }

    public String diacriticSignaturesToString(DiacriticSignature[][] rowDiacritics) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < rowDiacritics.length; ++i) {
            out.append("ROW " + Integer.toString(i));
            out.append(" signatures:\n");
            for (int j = 0; j < rowDiacritics[i].length; ++j) {
                out.append(Integer.toString(j) + ": " + rowDiacritics[i][j].toString() + "\n");
            }
        }
        return out.toString();
    }

    public DiacriticSignature[] ensureInDiacriticsSignature(Diacritic[] diacritics, DiacriticSignature[] sign) {
        for (int i = 0; i < sign.length; ++i) {
            if (!sign[i].isSameAs(diacritics)) continue;
            return sign;
        }
        DiacriticSignature[] newSign = new DiacriticSignature[sign.length + 1];
        for (int i = 0; i < sign.length; ++i) {
            newSign[i] = sign[i];
        }
        newSign[sign.length] = new DiacriticSignature(diacritics);
        return newSign;
    }

    public Coordinate findBestLocation(ComplexSymbol symbol) {
        int maxMatchSize = -1;
        Coordinate maxMatchLocation = new Coordinate();
        for (int i = 0; i < this.rowCount; ++i) {
            for (int j = 0; j < this.colCount; ++j) {
                int m;
                if (!this.isSymbol[i][j] || (m = SubSkeleton.quantifyMatch(symbol, this.symbols[i][j])) <= maxMatchSize) continue;
                maxMatchLocation = new Coordinate(i, j);
            }
        }
        return maxMatchLocation;
    }

    public static int quantifyMatch(ComplexSymbol candidate, ComplexSymbol template) {
        if (!candidate.base.symbol.equals(template.base.symbol)) {
            return -1;
        }
        if (!Misc.isSubset(template.getDiacriticLabels(), candidate.getDiacriticLabels())) {
            return -1;
        }
        return template.diacritics.length;
    }

    public boolean isFullMatch(ComplexSymbol candidate, Coordinate coord) {
        ComplexSymbol template = this.symbols[coord.i][coord.j];
        return SubSkeleton.isFullMatch(candidate, template);
    }

    public static boolean isFullMatch(ComplexSymbol candidate, ComplexSymbol template) {
        if (!candidate.base.symbol.equals(template.base.symbol)) {
            return false;
        }
        return Misc.equalContents(candidate.getDiacriticLabels(), template.getDiacriticLabels());
    }

    public int[][][] emptyTab() {
        int[][][] tab = new int[this.rowCount][][];
        for (int i = 0; i < this.rowCount; ++i) {
            tab[i] = new int[this.colCount][];
            for (int j = 0; j < this.colCount; ++j) {
                tab[i][j] = new int[0];
            }
        }
        return tab;
    }

    public String skeletonToString() {
        StringTable tab = new StringTable();
        tab.data = new String[this.rowCount][];
        for (int i = 0; i < this.rowCount; ++i) {
            tab.data[i] = new String[this.colCount];
            for (int j = 0; j < this.colCount; ++j) {
                tab.data[i][j] = this.isSymbol[i][j] ? this.symbols[i][j].getLabel() : ".";
            }
        }
        return tab.toString();
    }

    public class ChartedFeatures {
        public int[][] chart;
        public boolean[] coverage;
        public int rowCount;
        public int colCount;

        public ChartedFeatures(int[][] ch, boolean[] cov, int r, int c) {
            this.chart = ch;
            this.coverage = cov;
            this.rowCount = r;
            this.colCount = c;
        }
    }
}

