/*
 * Decompiled with CFR 0.152.
 */
package featurefunctions;

import featurefunctions.BareFeatureList;
import featurefunctions.BaseSymbolList;
import featurefunctions.CompiledDiacritics;
import featurefunctions.FindLabels;
import java.awt.Color;

public class ReferentFeatureList
extends BareFeatureList {
    BareFeatureList.BareSymbol referent;
    BaseSymbolList bases;
    CompiledDiacritics diacritics;
    int[] distances;
    int minDist;
    Color[] shadeByDistance;

    public ReferentFeatureList(BareFeatureList.BareSymbol symb, BareFeatureList feats, BaseSymbolList b, CompiledDiacritics d) {
        this.features = feats.features;
        this.symbols = new BareFeatureList.BareSymbol[0];
        this.distances = new int[0];
        this.referent = symb;
        this.bases = b;
        this.diacritics = d;
        this.populate(symb);
        this.prepareDistanceShades();
    }

    void populate(BareFeatureList.BareSymbol target) {
        for (int j = 0; j < this.bases.symbols.length; ++j) {
            BareFeatureList.BareSymbol basis = (BareFeatureList)this.new BareFeatureList.BareSymbol(this.bases.symbols[j]);
            this.findLabelsOnTopOf(basis, target, this.bases.symbols[j].symbol, this.diacritics.allAvailable());
        }
    }

    void findLabelsOnTopOf(BareFeatureList.BareSymbol basis, BareFeatureList.BareSymbol target, String base, boolean[] usedDiacritic) {
        this.addSymbol(basis, base, usedDiacritic);
        for (int i = 0; i < this.diacritics.from.length; ++i) {
            if (!basis.matches(this.diacritics.from[i]) || !target.matches(this.diacritics.to[i]) || usedDiacritic[i]) continue;
            BareFeatureList.BareSymbol newBasis = basis.applyCopy(this.diacritics.to[i]);
            newBasis.label = basis.label + this.diacritics.getLabel(i);
            this.findLabelsOnTopOf(newBasis, target, base, this.diacritics.markUsed(i, usedDiacritic));
        }
    }

    public int addCompletedSymbol(BareFeatureList.BareSymbol symb) {
        int d = symb.getDistanceTo(this.referent);
        boolean inserted = false;
        BareFeatureList.BareSymbol[] newsymbols = new BareFeatureList.BareSymbol[this.symbols.length + 1];
        int[] newdist = new int[this.symbols.length + 1];
        int insertedAt = -1;
        int j = 0;
        for (int i = 0; i < this.symbols.length + 1; ++i) {
            if (i < this.symbols.length && this.symbols[i].label.equals(symb.label)) {
                return i;
            }
            if (!inserted && (i == this.symbols.length || i < this.symbols.length && this.distances[i] > d)) {
                newsymbols[i] = symb;
                newdist[i] = d;
                inserted = true;
                insertedAt = i;
                continue;
            }
            j = inserted ? i - 1 : i;
            newsymbols[i] = this.symbols[j];
            newdist[i] = this.distances[j];
        }
        this.symbols = newsymbols;
        this.distances = newdist;
        return insertedAt;
    }

    public int addSymbol(BareFeatureList.BareSymbol symb, String base, boolean[] usedDiacritic) {
        symb.label = FindLabels.buildSymbolFrom(base, usedDiacritic, this.diacritics);
        return this.addCompletedSymbol(symb);
    }

    public Object getValueAt(int row, int col) {
        Object value;
        BareFeatureList.BareSymbol symb = this.symbols[row];
        switch (col) {
            case 0: {
                value = "";
                break;
            }
            case 1: {
                value = "(" + Integer.toString(this.distances[row]) + ")";
                break;
            }
            case 2: {
                value = symb.label;
                break;
            }
            default: {
                value = Character.valueOf(symb.getDisplayableFeatureValueWithNull(col - 3));
            }
        }
        return value;
    }

    public BareFeatureList.BareSymbol getReferent() {
        return this.referent;
    }

    public boolean isReferential() {
        return true;
    }

    public boolean valueSameAsReferent(int row, int i) {
        return this.symbols[row].values[i] == this.referent.values[i];
    }

    public boolean isReferent(int i) {
        return this.symbols[i] == this.referent;
    }

    void prepareDistanceShades() {
        if (this.distances.length > 0) {
            int maxD = this.distances[0];
            int minD = this.distances[0];
            for (int i = 0; i < this.distances.length; ++i) {
                if (this.distances[i] > maxD) {
                    maxD = this.distances[i];
                }
                if (this.distances[i] >= minD) continue;
                minD = this.distances[i];
            }
            minD = 0;
            this.shadeByDistance = new Color[maxD - minD + 1];
            if (maxD == minD) {
                this.shadeByDistance[0] = Color.white;
            } else {
                for (int i = minD; i <= maxD; ++i) {
                    float relD = (float)(i - minD) / (float)(maxD - minD);
                    this.shadeByDistance[i - minD] = new Color(1.0f - (relD *= 0.4f), 1.0f - relD, 1.0f - relD);
                }
            }
            this.minDist = minD;
        }
    }

    public Color getColorFor(int i) {
        return this.shadeByDistance[this.distances[i] - this.minDist];
    }
}

